classdef oidConstraintKYP < oidConstraint
    properties
        phi;
    end
    methods
        function obj = oidConstraintKYP(phi)
            obj.phi = phi;
        end
        function con = constraint(obj)
            if obj.phi.M > 1
                con{1,:} = '[A,B,C,D] = obj.inputSpectrum.ss();';
                con{2,:} = 'variable Q(size(A)) symmetric;';
                con{3,:} = ['obj.inputSpectrum.KYP(A,B,C,D,Q) == '...
                    'semidefinite(size(A)+size(D));'];
                con{4,:} = 'Q == semidefinite(size(Q));';
            else
                con{1} = ['obj.inputSpectrum.params == '...
                    'semidefinite(size(obj.inputSpectrum.params));'];
            end
        end
        function display(obj)
            disp(char(obj));
        end
        function res = char(obj)
            res = ['KYP(' obj.phi.name ')'];
        end
    end
end