% Estimating Sensitivity Function
% Example from:
% Hkan Hjalmarsson, "System identification of complex and structured
% systems",
% European Journal of Control, vol. 15, no. 4, pp. 275-310, 2009.  
clc
clear all
close all
%% Constructing VrelBiss
% Help scalars/vectors/matrices
Ts        = 1;
z         = tf('z',Ts);
m         = 1000;
w         = linspace(-pi,pi,m);
dw        = w(2)-w(1);
eVec1     = exp(1i*w).';
eVec2     = exp(-1i*w).';
% True system
theta0    = [2 1]';
G0        = (theta0(1)*z+theta0(2))/z;
G0W       = freqresp(G0,w);
G0W       = squeeze(G0W);
% Desired sensitivity function
xi        = 0.025;
k1        = (1-xi)/(1+xi);
Sobj      = (z-1)/(z-k1);
SobjW     = freqresp(Sobj,w);
SobjW     = squeeze(SobjW);
% Integral
term      = abs((1-SobjW)./G0W).^2;
element11 = sum(term);
element22 = element11;
element12 = term.'*eVec1;
element21 = term.'*eVec2;
matrix    = [element11 element12; element21 element22];
VrelBiss  = real(1/(2*pi)*matrix*dw);
%% Optimal input design
le = 1;
H0 = tf(1,1,1,'variable','z^-1');
mooseBegin
    model       G0 H0 le
    application constraints    
        ellipsoid(VrelBiss, 100)
    identification constraints
        spectrum    FIR(40)
        probability 0.95
        numSamples  100
    objective   minimize(inputPower)
mooseEnd
%% Identification experiments (check of theory)
VsiBiss   = 2*mooseProblem.informationMatrix;
chi2      = chi2inv(mooseProblem.probability,length(theta0));
uFilter   = mooseProblem.spectralFactor;
uOpt      = lsim(uFilter,randn(1,mooseProblem.numSamples));
A         = [1]; 
B         = theta0';
numPoints = 0;
numExp    = 100;
thetaHat  = zeros(numExp,2);
for i = 1:numExp
    e             = sqrt(le)*randn(mooseProblem.numSamples,1);
    y             = filter(B,A,uOpt)+e;
    z             = iddata(y,uOpt);
    m             = pem(z,[0 2 0 0 0 0]);
    thetaHat(i,:) = m.b;
    if 0.5*(thetaHat(i,:)-theta0')*VsiBiss*(thetaHat(i,:)'-theta0)...
       <= le*chi2/mooseProblem.numSamples;
        numPoints = numPoints+1;
    end
end
fracFulfilled = numPoints/numExp
fracDesired   = mooseProblem.probability
%% Plots of resulting regions and estimated points
figure(1)
hold on
ellipse(VsiBiss*mooseProblem.numSamples/(2*le*chi2),theta0,'k');
ellipse(0.5*mooseProblem.accuracy*VrelBiss,theta0,'b');
plot(thetaHat(:,1),thetaHat(:,2),'ro')
title('Blue: application region. Black: identification region. Red: estimates')

















