function model(varargin)
% Parse and construct oidModel

% Get input design problem
try
    prob = evalin('caller',mooseConst.PROBLEM_NAME);
catch
    throw(MException('','MOOSE::No Moose problem defined. Run mooseBegin first'));
end

[nameModel argument] = naming(varargin);

name = 'model';
ni   = length(argument);

if ni ~= 3 && ni ~= 6 && ni ~= 10 
    throw(MException('','MOOSE::Wrong model specification')); 
end

% Get tf model
if ni == 3
    
    i  = strfind(argument{1},'(');
    j  = strfind(argument{2},'(');
    
    if isempty(i) && isempty(j)
        input = cell(1,ni);
        for index = 1:ni
            input{index} = evalin('caller',argument{index});
        end
    end
    
    if  ~isempty(i) && ~isempty(j)
        temp1 = evalin('caller',argument{1}(i+1:end-1));
        temp2 = evalin('caller',argument{2}(j+1:end-1));
        kS = strfind(temp1,'{');
        kE = strfind(temp1,'}');
        lS = strfind(temp2,'{');
        lE = strfind(temp2,'}');
        input = cell(1,ni+4);
        input{1} = evalin('caller',argument{1}(1:i-1));
        input{2} = evalin('caller',argument{2}(1:j-1));
        input{3} = evalin('caller',argument{3});
        input{4} = evalin('caller',temp1(kS(1):kE(1)));
        input{5} = evalin('caller',temp1(kS(2):kE(2)));
        input{6} = evalin('caller',temp2(lS(1):lE(1)));
        input{7} = evalin('caller',temp2(lS(2):lE(2)));
    end
    
    assignin('caller',name,oidModelTf(input{:}));
    
end

% Get ss model
if ni == 6
    
    i = strfind(argument{1},'(');
    j = strfind(argument{2},'(');
    k = strfind(argument{3},'(');
    l = strfind(argument{4},'(');
    
    if isempty(i) && isempty(j) && isempty(k) && isempty(l)
        input = cell(1,ni);
        for index = 1:ni
            input{index} = evalin('caller',argument{index});
        end
    end
      
    if  ~isempty(i) && ~isempty(j) && ~isempty(k) && ~isempty(l)
        input = cell(1,ni+4);
        input{1}  = evalin('caller',argument{1}(1:i-1));
        input{2}  = evalin('caller',argument{2}(1:j-1));
        input{3}  = evalin('caller',argument{3}(1:k-1));
        input{4}  = evalin('caller',argument{4}(1:l-1));
        input{5}  = evalin('caller',argument{5});
        input{6}  = evalin('caller',argument{6});
        input{7}  = evalin('caller',argument{1}(i+1:end-1));
        input{8}  = evalin('caller',argument{2}(j+1:end-1));
        input{9}  = evalin('caller',argument{3}(k+1:end-1));
        input{10} = evalin('caller',argument{4}(l+1:end-1));
    end
    
    assignin('caller',name,oidModelSs(input{:}));
    
end

if ni == 10
    
    i = strfind(argument{1},'(');
    j = strfind(argument{2},'(');
    k = strfind(argument{3},'(');
    l = strfind(argument{4},'(');
    
    if isempty(i) && isempty(j) && isempty(k) && isempty(l)
        input = cell(1,ni);
        for index = 1:ni
            input{index} = evalin('caller',argument{index});
        end
    end
      
    if  ~isempty(i) && ~isempty(j) && ~isempty(k) && ~isempty(l)
        input = cell(1,ni+4);
        input{1}  = evalin('caller',argument{1}(1:i-1));
        input{2}  = evalin('caller',argument{2}(1:j-1));
        input{3}  = evalin('caller',argument{3}(1:k-1));
        input{4}  = evalin('caller',argument{4}(1:l-1));
        input{5}  = evalin('caller',argument{5});
        input{6}  = evalin('caller',argument{6});
        input{7}  = evalin('caller',argument{1}(i+1:end-1));
        input{8}  = evalin('caller',argument{2}(j+1:end-1));
        input{9}  = evalin('caller',argument{3}(k+1:end-1));
        input{10} = evalin('caller',argument{4}(l+1:end-1));
        input{11}  = evalin('caller',argument{7});
        input{12}  = evalin('caller',argument{8});
        input{13}  = evalin('caller',argument{9});
        input{14}  = evalin('caller',argument{10});
    end
    
    assignin('caller',name,oidModelSs(input{:}));
    
end

evalin('caller',[mooseConst.PROBLEM_NAME '.model =' name ';']);
evalin('caller',['clear ' name]);

if ~isempty(nameModel)
    evalin('caller', [nameModel '=' mooseConst.PROBLEM_NAME '.model;']);
end
end
