function numSamples(varargin)
% Parse and construct numSamples

% Get input design problem
try
    prob = evalin('caller',mooseConst.PROBLEM_NAME);
catch
    throw(MException('','MOOSE::No Moose problem defined. Run mooseBegin first'));
end

[nameNumSamples argument] = naming(varargin);

% Get numSamples
if ~evalin('caller',['isa(' argument{1} ', ''double'');'])
    throw(MException('','MOOSE:: number of samples must be of type double'));
end
evalin('caller',[mooseConst.PROBLEM_NAME '.numSamples =' argument{1} ';']);

if ~isempty(nameNumSamples)
    evalin('caller', [nameNumSamples '=' mooseConst.PROBLEM_NAME '.numSamples;']);
    assignin('caller','nameNumSamples', nameNumSamples);
elseif isempty(str2double(argument{1}))
    assignin('caller','nameNumSamples', 'mooseProblem.numSamples');
else
    assignin('caller','nameNumSamples', argument{1});
end
end


