function spectrum(varargin)
% Parse and construct oidSpectrum

% Get input design problem
try
    prob = evalin('caller',mooseConst.PROBLEM_NAME);
catch
    throw(MException('','MOOSE::No Moose problem defined. Run mooseBegin first'));
end

[nameSpectrum,argument] = naming(varargin);


% Get spectrum type and number of coefficients
i = strfind(argument{1},'(');

if isempty(i)
    len  = 20;
    type = find(strcmpi(argument{1},mooseConst.SPECTRUM_TYPES));
    warning('MOOSE::Default number of spectral coefficients (20) used.');
elseif ~strcmp(argument{1}(end),')')
    throw(MException('','MOOSE::Wrong spectrum specification'));
else
%     len  = str2double(argument{1}(i+1:end-1));
    len = evalin('caller',argument{1}(i+1:end-1));
    type = find(strcmpi(argument{1}(1:i-1),mooseConst.SPECTRUM_TYPES));
end

if isempty(type)
    type = 1;
    warning('MOOSE::Default spectrum type FIR(20) used');
end
if ~isempty(nameSpectrum)
    name = nameSpectrum;
else
    name = 'nameSpectrum';
end
switch type
    case 1
        assignin('caller',name,oidInputSpectrumFIR(len,[],name));
    case 2
        assignin('caller',name,oidInputSpectrumAR(len,[],name));
end
evalin('caller',[mooseConst.PROBLEM_NAME '.inputSpectrum =' name ';']);
evalin('caller',[mooseConst.PROBLEM_NAME '=' mooseConst.PROBLEM_NAME '.addConstraint('...
    name '.constraints());']);

evalin('caller',['clear ' name]);

if ~isempty(nameSpectrum)
    evalin('caller', [nameSpectrum '=' mooseConst.PROBLEM_NAME '.inputSpectrum;']);
    assignin('caller','nameSpectrum', nameSpectrum);
else
    assignin('caller','nameSpectrum', 'mooseProblem.inputSpectrum');
end
end