function dG = dG(obj,n)
% Compute sensitivity dG wrt parameter n
if n > obj.n; throw(MException('','Parameter index too high')); end;

[p,m] = size(obj.G);
[F,G,H,~,Ts] = ssdata(obj.ss());
if isempty(obj.dA)
    dG = tf(ss(F,G(:,1:m),double(obj.H==oidParameter(0,n)),[],Ts) + ...
            ss(F,double(obj.G==oidParameter(0,n)),H,[],Ts) + ...
            ss(F,eye(size(F)),H,[],Ts) * ...
            ss(F,G(:,1:m),double(obj.F==oidParameter(0,n)),[],Ts));
% BEGIN QUICK FIX CUSTOM DERIVATIVES %
else
    dG = tf(ss(F,G(:,1:m),obj.dC(:,:,n),[],Ts) + ...
            ss(F,obj.dB(:,:,n),H,[],Ts) + ...
            ss(F,eye(size(F)),H,[],Ts) * ...
            ss(F,G(:,1:m),obj.dA(:,:,n),[],Ts));
% END QUICK FIX CUSTOM DERIVATIVES %
end
dG.Variable = 'z^-1';
dG = minreal(dG);