function dH = dH(obj,n)
% Compute sensitivity dH wrt parameter n
if n > obj.n; throw(MException('','Parameter index too high')); end;
[p,m] = size(obj.G);
[F,G,H,~,Ts] = ssdata(obj.ss());
if isempty(obj.dA)
dH = tf(ss(F,G(:,m+1:end),double(obj.H==oidParameter(0,n)),[],Ts) + ...
        ss(F,double(obj.K==oidParameter(0,n)),H,[],Ts) + ...
        ss(F,eye(size(F)),H,[],Ts) * ...
        ss(F,G(:,m+1:end),double(obj.F==oidParameter(0,n)),[],Ts));
% BEGIN QUICK FIX CUSTOM DERIVATIVES %
else
    dH = tf(ss(F,G(:,m+1:end),obj.dC(:,:,n),[],Ts) + ...
            ss(F,obj.dK(:,:,n),H,[],Ts) + ...
            ss(F,eye(size(F)),H,[],Ts) * ...
            ss(F,G(:,m+1:end),obj.dA(:,:,n),[],Ts));
% END QUICK FIX CUSTOM DERIVATIVES %
end
dH.Variable = 'z^-1';
dH = minreal(dH);