function [index n] = paramIndices(~,coeff,n,isMonic)
% Find parameter indices for transfer function coefficients
% If n is a scalar, it is the index of the last assigned parameter, a
% vector n contains the indices for all nonzero coefficients of coeff.

I = find(coeff);
% In monic polynomials, first coefficient is know to be 1.
if isMonic
    I = I(2:end);
end
index = zeros(size(coeff));

for i = 1:numel(I)
    % Default indices
    if numel(n) == 1
        index(I(i)) = n+i-1;
    else
        index(I(i)) = n(i);
    end
end
if numel(I)>0
    n = max([index n]) + 1; 
end
end