function mooseSetup(varargin)
% mooseSetup   Sets up (and tests the cvx distribution, not yet).
% This function is to be called any time MOOSE is installed on a new machine,
% to insure that the paths are set properly.

% File path separators
if ispc,
    fs = '\';
    ps = ';';
else
    fs = '/';
    ps = ':';
end

% Moose top directory
moosePath  = mfilename('fullpath');
temp = strfind( moosePath, fs );
moosePath( temp(end) : end ) = [];

% Moose directories
moosePaths = {'',...
              'base',...
              'helpFiles',...
              'models',...
              'spectra',...
              'keywords',...
              'keywords/helpFiles',...
              'constraints',...
              'parsers'};
          
% Running without arguments adds paths to commands to start MOOSE
% When mooseBegin is called, path needed internally are added with 'all'
% argument. These are removed by mooseEnd to avoid unintended function
% overloading with other toolboxes.
if nargin > 0 && strcmpi(varargin{1},'full')
    K = numel(moosePaths);
    kk = 1;
    adds = true;
elseif nargin > 0 && strcmpi(varargin{1},'keywords')
    K = numel(moosePaths);
    kk = K;
    adds = true;
elseif nargin > 0 && strcmpi(varargin{1},'keywords/helpFiles')
    K = numel(moosePaths);
    kk = K;
    adds = true;
elseif nargin > 0 && strcmpi(varargin{1},'constraints')
    K = numel(moosePaths);
    kk = K;
    adds = true;
elseif nargin > 0 && strcmpi(varargin{1},'rm')
    K = numel(moosePaths);
    kk = K;
    adds = false;
elseif nargin > 0 && strcmpi(varargin{1},'rmfull')
    K = numel(moosePaths);
    kk = 1;
    adds = false;
else
    K = 9;
    kk = 1;
    adds = true;
    disp( 'NOTE: The MATLAB path has been updated to point to the MOOSE toolbox.');
    disp( 'In order to use MOOSE regularly, save this new path definition.');
end
    
for k = kk:K
    if adds
        matlabpath([moosePath,fs,moosePaths{k},ps,matlabpath]);
    else
        rmpath([moosePath,fs,moosePaths{k}]);
    end
end
