classdef oidInputSpectrum < handle
    properties
        type;
        M;
        dims;
%         params;
        lowerBound = 0;
        upperBound = [];
%        maxPower = [];
        name;
    end
    properties (Abstract)
        params;
    end
    methods
        function obj = oidInputSpectrum(type,M,dims,name)
            obj.type = type;
            obj.M = M;
            obj.dims = dims;
            obj.name = name;
        end
        % Spectrum constraints, more types should be implemented, only
        % constraints constant over all frequencies in version 1.0
        function gt(objA,objB)
            if ~isnumeric(objB) || numel(objB) ~= 1
                disp('MOOSE::Only constant spectrum constraints implemented');
            else
                objA.lowerBound = objB;
            end
        end
        function ge(objA,objB)
            objA > objB;
        end
        function lt(objA,objB)
            if ~isnumeric(objB) || numel(objB) ~= 1
                disp('MOOSE::Only spectrum constraints implemented');
            else
                objA.upperBound = objB;
            end
        end
        function le(objA,objB)
            objA < objB;
        end
        function res = char(obj)
            res = [obj.name ': ' obj.type '(' num2str(obj.M) ')'];
        end
    end
    methods (Abstract)
        con = constraints(obj);
        iF = infoMatrix(obj,model); %Old, kept for compability with examples
        iF = informationMatrix(obj,model);
    end
    methods (Access = protected)
        R = acf(~,G,M);
    end
end