function iF = informationMatrix(obj,model)

% Transfer functions of system and noise filter
[G, H] = model.tf();
% Size of system (Used to determine if SISO or MIMO)
[p, m]   = size(G);
[pH, mH] = size(H);

if p == 1 && m == 1
    %% SISO system
    % Gradients of G and H
    for i = 1:model.n
        dG(i,1) = model.dG(i);
        dH(i,1) = model.dH(i);
    end
    % Constructing information matrix
    Mbar = obj.acf(minreal(dH/H));
    F0   = Mbar;
    Fmo  = obj.acf(dG/H,obj.M);

    Fm   = Fmo(1:model.n,1:model.n,:);

    F0m  = F0;
    if size(F0,1)>model.n
        F011 = F0(1:model.n,1:model.n);
        F012 = F0(1:model.n,model.n+1:end);
        F022 = F0(model.n+1:end,model.n+1:end);
        F0m  = F011-F012*inv(F022)*F012';
    end

    Fmr = Fm(:,:,1)*obj.params(1);
    for m = 2:obj.M
        Fmr = Fmr+(Fm(:,:,m)+Fm(:,:,m)')*obj.params(m);
    end
    Fmr = Fmr/model.le;
    % Information matrix
    iF  = real(F0m+Fmr);
else
    %% MIMO system
    % Noise variances
    L0     = model.le;
    L0inv  = inv(L0);
    % Help scalars/vectors/matrices
    pm     = p*m;
    pmH    = pH*mH;
    Hinv   = inv(H);
    m      = 200;
    w      = linspace(-pi,pi,m);
    dw     = w(2)-w(1);
    wflip  = linspace(pi,-pi,m); 
    % Constructing information matrix
    TaurW  = zeros(model.n, pm,      length(w));
    TaurWT = zeros(pm,      model.n, length(w));
    TaueW  = zeros(model.n, pmH,      length(w));
    TaueWT = zeros(pmH,      model.n, length(w));
    for i = 1:model.n
        FrT           = minreal((Hinv*model.dG(i)).');
        FeT           = minreal((Hinv*model.dH(i)).');
        FrTW          = freqresp(FrT,w); 
        FrTW          = squeeze(FrTW);
        FrTWT         = freqresp(FrT,wflip);
        FeTW          = freqresp(FeT,w); 
        FeTW          = squeeze(FeTW);
        FeTWT         = freqresp(FeT,wflip);
        TaurW(i,:,:)  = reshape(FrTW,  1,  pm, length(w));
        TaurWT(:,i,:) = reshape(FrTWT, pm, 1,  length(w));
        TaueW(i,:,:)  = reshape(FeTW,  1,  pmH, length(w));
        TaueWT(:,i,:) = reshape(FeTWT, pmH, 1,  length(w));   
    end
    Lkron  = kron(L0inv,L0); 
    I      = zeros(model.n,model.n); 
    kk     = 0;
    for k = 1:m
        Phir = 0.5*obj.params(:,:,1)*(exp(-1i*0*w(k))+exp(1i*0*w(k)));
        for l = 1:size(obj.params,3)-1
         Phir = Phir + obj.params(:,:,l+1)*(exp(-1i*l*w(k))+exp(1i*l*w(k)));
        end
        Pkron = kron(L0inv,Phir); 
        fun1  = TaurW(:,:,k)*Pkron*TaurWT(:,:,k);
        fun2  = TaueW(:,:,k)*Lkron*TaueWT(:,:,k);
        fun   = fun1+fun2;
        % Integral: Simpson's rule
        if     kk == 2; I = I +2/3*fun; kk = 1;
        elseif kk == 1; I = I +4/3*fun; kk = 2; 
        elseif k  == 1; I = I +1/3*fun; kk = 2; 
        elseif k  == m; I = I +1/3*fun; kk = 0; 
        end    
    end
    I = 1/(2*pi)*I*dw;
    % Information matrix
    iF = real(I);
end

end




