classdef oidConstraintMaxPower < oidConstraint
    % Max power constraint for FIR spectrum
    properties
        phi;
    end
    methods
        function obj = oidConstraintMaxPower(phi)
            obj.phi = phi;
        end
        function con = constraint(~)
                con = ['trace(obj.inputSpectrum.params(:,:,1)) <= '...
                    'obj.inputSpectrum.maxPower;'];
        end
        function display(obj)
            disp(char(obj));
        end
        function res = char(obj)
            res = ['maxPower(' obj.phi.name ') = ' num2str(obj.phi.maxPower)];
        end
    end
end