

function Gu = firreal(Ru,Ts)
% Gu = firreal(Ru,Ts)
% 
% Derives an FIR-filter with sampling time Ts from the autocorrelation
% sequence Ru.

Ru = Ru(:);
lr = length(Ru);

if lr>1
    A = [zeros(1,lr-1);eye(lr-2) zeros(lr-2,1)];
    B = [1;zeros(lr-2,1)];
    C = Ru(2:lr)';
    D = 0.5*Ru(1);
    
    R = -D-D';
    S = -B;
    T = dare(A',C',0*A,R,S);
    
    Omega = D+D'-C*T*C';
    K = -(A*T*C'-B)/Omega;
    
    Gu = ss(A,K,C,1,Ts)*sqrt(Omega);
    
else 
    Gu = tf(sqrt(Ru),1,Ts);
end






