function parameter(param,nominal)
% Parse and construct oidParamters

% Get parameter name and length
i = strfind(param,'(');
if isempty(i)
    len  = 1;
    name = param;
elseif ~strcmp(param(end),')') 
     throw(MException('','MOOSE::Wrong parameter specification'));
else
    len  = str2double(param(i+1:end-1));
    name = param(1:i-1);
end

% Check nominal values
nominal = str2num(nominal);
if numel(nominal) < len
    throw(MException('','MOOSE::Initial values do not match parameter count'));
end

% Create paramter vector 
par = oidParameter(1:len,nominal);
assignin('caller',name,par);
evalin('caller',['clear ' name]);
end