classdef oidModel
    % Parent class with basic structure for models used in the input design
    % toolbox. All functionality is implemented in the specific model type
    % classes.
    properties
        le; % Noise variance
        Ts; % Sampling time
    end
    methods (Abstract)
        % Get the parameter sensitivites for the plant and noise models wrt
        % parameter n evaluated at the true parameter values.
        dG = dG(obj,n);
        dH = dH(obj,n);
    end
    methods
        function obj = oidModel(le,Ts)
%             if nargin > 0
                obj.le = le;
                obj.Ts = Ts;
%             end
        end
    end
end