classdef oidParameter < handle
    % Parameters in a model used in the input design toolbox.
    properties
        index;
        nominalValue;
    end
    
    methods
        function obj = oidParameter(varargin)
            if nargin > 0
                if numel(varargin{1}) ~= numel(varargin{2})
                    throw(MException('',['MOOSE::oidParameter::'...
                        'Number of indices and nominal values not equal']));
                end
                obj(1,numel(varargin{1})) = oidParameter();
                for k = 1:numel(varargin{1})
                    obj(k).index = varargin{2}(k);
                    obj(k).nominalValue = varargin{1}(k);
                end
            end
        end
        
        str = char(obj);
        
        % Compare paramter indices, obj1 can be vector of paramters
        val = eq(obj1,obj2);
        val = ne(obj1,obj2);
        val = le(obj1,obj2);
        val = lt(obj1,obj2);
        val = ge(obj1,obj2);
        val = gt(obj1,obj2);
        [obj i] = sort(obj1);
    end
end