classdef oidPolynomial
    % Polynomials in backward shift operator q^-1 with coefficients theta.
    % Coefficients are objects of oidParameter. 
    
    properties
        param;
    end
    
    properties (Dependent = true, SetAccess = private)
        n;
        nominalValue
    end
    
    methods
        function obj = oidPolynomial(varargin)
            if nargin > 0
                % Make polynomial with oidParameters in constructor call
                if nargin == 1
                    if ~isa(varargin{1},'oidParameter')
                        throw(MException('',['MOOSE::oidPolynomial::'...
                            'One argument needs to be of type oidParameter']));
                    else
                        obj.param = varargin{1};
                    end
                    
                % Make polynomial with nominal values and parameter indices
                % in constructor call
                elseif nargin == 2
                    obj = oidPolynomial(oidParameter(varargin{1},varargin{2}));
                    
                % Make polynomial using parameters handles in varargin{3},
                % usefull for specifying multiple polynomials with same
                % parameters.
                elseif nargin == 3
                    p(size(varargin{1})) = oidParameter();
                    for k = 1:length(varargin{1})
                        if varargin{2}(k) == 0
                            p(k) = oidParameter(varargin{1}(k),0);
                        else
                            p(k) = varargin{3}(varargin{2}(k));
                            p(k).nominalValue = varargin{1}(k);
                        end
                    end
                    obj = oidPolynomial(p);
                else
                    throw(MException('',['MOOSE::oidPolynomial::'...
                        'Wrong number of input arguments']));
                end
            end
        end
        
        function val = get.nominalValue(obj)
            val = zeros(size(obj.param));
            for i = 1:length(obj.param);
                val(i) = obj.param(i).nominalValue;
            end
        end
        
        function n = get.n(obj)
            n = numel(unique(obj.param(obj.param ~= oidParameter(0,0))));
        end
        
        % To string conversion
        str = char(obj);
        
        % Arithmetic, !NB! Only implemented for polynomial evaluated at
        % nominal parameter values !NB!
        obj = plus(obj1,obj2);
        obj = minus(obj1,obj2);
        obj = mtimes(obj1,obj2);
        
        % Derivative wrt parameter n, evaluated at nominal parameter values
        obj = diff(obj,n);
    end
end