classdef oidTf
% Transfer function for optimal input design toolbox.
%
%     B(q^-1,theta)
% G = -------------
%     A(q^-1,theta)
%
% A and B are oidPolynomial objects.
    properties
        A; B; Ts;
    end
    
    properties (Dependent = true, SetAccess = private)
        na; nb; nk; n;
        theta0;
        theta;
    end
        
    methods
        function obj = oidTf(G,varargin)
            if nargin > 0
            if ~isa(G,'tf'); G = tf(G,'variable','z^-1'); end;
            if G.Ts == 0;
                throw(MException('','MOOSE only supports discrete time models'));
            end
            obj.Ts = G.Ts;
            
            % Construct model polynomials          
            obj.B = oidPolynomial(G.num{1},varargin{1},varargin{3});
            obj.A = oidPolynomial(G.den{1},varargin{2},varargin{3});
            end
        end
        
        function n = get.n(obj)
            n = obj.na+obj.nb;
        end
        function n = get.na(obj)
            n = obj.A.n;
        end
        function n = get.nb(obj)
            n = obj.B.n;
        end
        function n = get.nk(obj)
            n = find(obj.B.nominalValue ~= 0,1)-1;
        end
        function theta0 = get.theta0(obj)
            theta0 = zeros(size(obj.theta));
            for j = 1:numel(theta0)
                theta0(j) = obj.theta(j).nominalValue;
            end
        end        
        function theta = get.theta(obj)
            theta = unique([obj.B.param obj.A.param]);
            theta = theta(theta~=oidParameter(0,0))';
        end   
        
        G = tf(obj);
        dG = diff(obj,n);     
    end
end