classdef oidParserCVX < oidParser
    properties
        oidProblem;
    end
    methods
        function obj = oidParserCVX(oidProblem)
            obj.oidProblem = oidProblem;
        end
            
        function cvxProblem = parse(obj)
            [~,m] = size(obj.oidProblem.model.G);
            
            %Init CVX
            initCVX{1,:} = 'cvx_clear;';
            initCVX{2,:} = 'cvx_begin;';
            if obj.oidProblem.solverQuiet
                initCVX{3} = 'cvx_quiet true;';
            end
            
            %Assign spectrum variables
            spectrum{1,:} = ['variable c(size(obj.model.G,2),'...
                'size(obj.model.G,2),obj.inputSpectrum.M) hermitian;'];
            spectrum{2,:} = 'obj.inputSpectrum.params = c;';
            
            % Assign parameters
            if ~isempty(obj.oidProblem.accuracy) && ~isempty(obj.oidProblem.probability)
                param = {['K=' num2str(obj.oidProblem.accuracy*...
                    chi2inv(obj.oidProblem.probability,obj.oidProblem.model.n)) ';']};
            else
                param = [];
            end
            for j = 1:size(obj.oidProblem.parameters,2)
                tmp = obj.oidProblem.parameters{2,j};
                if ischar(tmp)
                    param = cat(1,param,{[obj.oidProblem.parameters{1,j} '=' tmp ';']});
                else
                    param = cat(1,param,{[obj.oidProblem.parameters{1,j} '='...
                        num2str(tmp) ';']});
                end
            end
      
            % Constraints
            con = [];
            for j = 1:length(obj.oidProblem.constraints)
                tmp = obj.oidProblem.constraints{j}.constraint();
                if iscell(tmp)
                    con = cat(1,con,tmp);
                else
                    con = cat(1,con,{tmp});
                end
            end
            
            % Objective
            if strcmp(obj.oidProblem.objective,'dOptimality')
                obj = 'minimize(dOptimality);';
            else
                obj = obj.oidProblem.objective;
            end
            
            % Solve
            closeCVX{1,:} = 'cvx_solver(obj.solver);';
            closeCVX{2,:} = 'cvx_end;';
            
            % Set results
            result{1,:} = 'obj.inputSpectrum.params = c;';
            result{2,:} = 'obj.optimalObjective = cvx_optval;';
            
            cvxProblem = cat(1,initCVX,spectrum,param,con,obj,closeCVX,result);
        end
    end
end           