%Get the cvx_problem from the caller, assign necessary variables and set
%constraints for the spectrum in cvx_problem.
function obj = cvxProblem(obj,model)
    try cvx_problem = evalin('caller', 'cvx_problem');
    catch throw(MException('','Need a cvx_problem in caller')); 
    end      
    [~,m] = size(model.G);
    variable spectrumCoefficients(m,m,obj.M) hermitian;
    assignin('caller','spectrumCoefficients',spectrumCoefficients)
    obj.params = spectrumCoefficients;
%% KYP Method (only positivity constraint on spectrum)
    if obj.M>1
        [Afir Bfir Cfir Dfir] = obj.ss();
        variable Qfir(size(Afir)) symmetric;
        assignin('caller','Qfir',Qfir)
        obj.KYP(Afir,Bfir,Cfir,Dfir,Qfir) == semidefinite(size(Afir)+size(Dfir));
        Qfir == semidefinite(size(Qfir));
    else
        spectrumCoefficients == semidefinite(size(spectrumCoefficients));
    end

%% Trace Method (different constraints on spectrum)
%     %Lower bound on spectrum
%     D = squeeze(obj.acf(obj.lowerBound,obj.M));
%     variable LB(obj.M,obj.M) symmetric;
%     Tk = fliplr(spdiags(fliplr(triu(ones(obj.M))),...
%         0:obj.M+1:obj.M*obj.M,obj.M,obj.M*obj.M));
%     size(c)
%     size(D)
%     size(Tk)
%     size(vec(LB))
%     c - D == Tk*vec(LB);
%     LB == semidefinite(size(LB));
%     assignin('caller','LB',LB);
%     
%     %Upper bound on spectrum
%     if ~isempty(obj.upperBound)
%         D = squeeze(obj.acf(obj.upperBound,obj.M));
%         variable UB(obj.M,obj.M) symmetric;
%         Tk = fliplr(spdiags(fliplr(triu(ones(obj.M))),...
%             0:obj.M+1:obj.M*obj.M,obj.M,obj.M*obj.M));
%         D - c == Tk*vec(UB);
%         UB == semidefinite(size(UB));
%         assignin('caller','UB',UB);
%     end
%     
%     %Max power constraint
%     if ~isempty(obj.maxPower)
%         obj.params(1) < obj.maxPower;
%     end
end