classdef oidProblem
    properties
        % Input design problem properties 
        appCost;
        inputSpectrum;
        model;
        accuracy;
        probability;
        numSamples;
        constraints;
        objective;
        parameters;
        optimalObjective;
        % Implementation properties
        solver;
        solverQuiet = false;
        solved = false;
    end
    properties (Dependent = true)
        theta0;
        informationMatrix;
        n;
        Ru;
        spectralFactor;
    end
    methods
        function obj = oidProblem(varargin)
            if nargin > 0 && isa(varargin{1},'oidProblem')
                obj.appCost = varargin{1}.appCost;
                obj.inputSpectrum = varargin{1}.inputSpectrum;
                obj.model = varargin{1}.model;
                obj.accuracy = varargin{1}.accuracy;
                obj.probability = varargin{1}.probability;
                obj.numSamples = varargin{1}.numSamples;
                obj.constraints = varargin{1}.constraints;
                obj.objective = varargin{1}.objective;
                obj.parameters = varargin{1}.parameters;
            end                
            obj.solver = 'SDPT3';
        end
        
        function obj = addConstraint(obj,con)
            obj.constraints = cat(1,obj.constraints,{con});
        end
              
        function theta0 = get.theta0(obj)
            theta0 = obj.model.theta0;
        end
        
        function Ru = get.Ru(obj)
            Ru = obj.inputSpectrum.params;
        end
        
        function optH = get.spectralFactor(obj)
            if obj.solved;
                optH = obj.inputSpectrum.spectralFactor(obj.model.Ts);
            else
                optH = [];
            end
        end
        
        function iF = get.informationMatrix(obj)
            iF = obj.inputSpectrum.informationMatrix(obj.model);
        end
        
        function n = get.n(obj)
            n = obj.model.n;
        end
        function display(obj)
            fprintf('--------------------------------------\n');
            fprintf('MOOSE Optimal Input Design Problem \n');
            fprintf('OBJECTIVE:\n')
            fprintf('\t%s\n',obj.objective);
            fprintf('INPUT SPECTRUM:\n')
            fprintf('\t%s\n',char(obj.inputSpectrum));
            fprintf('CONSTRAINTS:\n');
            for k = 1:length(obj.constraints)
                fprintf('\t%s\n',char(obj.constraints{k}));
            end
            if obj.solved
                fprintf('STATUS:\n');
                fprintf('\t%s\n', 'Solved');
                fprintf('OPTIMAL VALUE:\n');
                fprintf('\t%s\n', obj.optimalObjective);
            else
                fprintf('STATUS:\n');
                fprintf('\t%s\n', 'Unsolved');
            end                
            fprintf('--------------------------------------\n');
        end
        function disp(obj)
            obj.display();
        end
       res = solve(obj);
    end
end



















