function mooseEnd
% Avsluta problemet

try
    prob = evalin('caller',mooseConst.PROBLEM_NAME);
catch
    throw(MException('','MOOSE::No Moose problem defined. Run mooseBegin first'));
end

% Collect all names and values
parametersInWS             = evalin('caller','who');
lengthInWS                 = length(parametersInWS);
parameters                 = cell(2,lengthInWS);
for i = 1:lengthInWS
    parameters{1,i} = parametersInWS{i};
    parameters{2,i} = evalin('caller',parametersInWS{i});
end
try
    parameters{1,end+1}        = evalin('caller','nameSpectrum');
    parameters{2,end}          = 'obj.inputSpectrum';
catch
end
parameters{1,end+1}        = 'mooseProblem.inputSpectrum';
parameters{2,end}          = 'obj.inputSpectrum';
try
    parameters{1,end+1}        = evalin('caller','nameNumSamples');
    parameters{2,end}          = 'obj.numSamples';
catch
end
parameters{1,end+1}        = 'mooseProblem.numSamples';
parameters{2,end}          = 'obj.numSamples';
parameters{1,end+1}        = 'nameAccuracy';
parameters{2,end}          = 'obj.accuracy';
parameters{1,end+1}        = 'mooseProblem.accuracy';
parameters{2,end}          = 'obj.accuracy';
parameters{1,end+1}        = 'nameProbability';
parameters{2,end}          = 'obj.probability';
parameters{1,end+1}        = 'mooseProblem.probability';
parameters{2,end}          = 'obj.probability';
parameters{1,end+1}        = 'inputPower';
parameters{2,end}          = 'trace(obj.inputSpectrum.params(:,:,1))';
parameters{1,end+1}        = 'dOptimality';
parameters{2,end}          = '-(det_rootn(obj.informationMatrix*obj.numSamples))';
% Get the objective string
obj = evalin('caller', ['' mooseConst.PROBLEM_NAME '.objective;' '']);
if isempty(obj)
    throw(MException('','MOOSE::No objective defined'));
end
% Collect only names used in objective
param_string               = sensibleArguments([{obj} {parameters}]);
% Store used names in mooseProblem.parameters
for i = 1:size(param_string,2)
    if ~isempty(param_string{1,i})
        iStr = num2str(i);
        name = 'nameParameter';
        evalin('caller', [mooseConst.PROBLEM_NAME '.parameters{1,' iStr '}=' '''' param_string{1,i} '''' ';']);
        assignin('caller',name,param_string{2,i});
        evalin('caller', [mooseConst.PROBLEM_NAME '.parameters{2,' iStr '}=' name ';']);
        evalin('caller','clear name')
    end
end

prob = evalin('caller',mooseConst.PROBLEM_NAME);
% Check if all neccessary ID contraints are defined
if isempty(prob.numSamples) || isempty(prob.probability) || isempty(prob.inputSpectrum)
    throw(MException('','MOOSE:: One or more identification constraints are undefined. No proper problem statement.'));
end
res = prob.solve();

assignin('caller',mooseConst.PROBLEM_NAME,res);

% Remove paths for internal functions
mooseSetup('rm');
% Remove all names
evalin('caller','clear  nameSpectrum ');
evalin('caller','clear  nameNumSamples ');
evalin('caller','clear  nameAccuracy ');
evalin('caller','clear  nameProbability ');
evalin('caller','clear  nameParameter ');

disp(res);
end