classdef oidConstraintEllipsoid < oidConstraint
    properties
        H; %Hessian defining ellipsoid
    end
    methods
        function obj = oidConstraintEllipsoid(H)
            if isa(H,'double')
                [n m] = size(H);
                if n == m
                    obj.H = 1/2*(H+H');
                else
                    throw(MException('','Hessian must be square'));
                end
                if obj.H ~= H
                    warning('Hessian not symmetric, 1/2*(H*H'') used');
                end
            elseif isa(H,'function_handle')
                obj.H = H;
            end
                
        end
        
        function con = constraint(obj)
            theta0 = evalin('caller','obj.oidProblem.model.theta0');
            if isa(obj.H,'function_handle')
                hess = hessian(obj.H,theta0);
                obj.H = hess;
            else
                hess = obj.H;
            end
            con = ['2*obj.informationMatrix*obj.numSamples - '...
                'K*' mat2str(hess) ' == semidefinite(obj.model.n);'];
        end
        function display(obj)
            disp(char(obj));
        end
        function res = char(~)
            res = 'Ellipsoid';
        end
    end
end        