classdef oidConstraintScenarios < oidConstraint
    properties
        scenarioMatrix;
    end
    properties (Dependent = true)
        numScenarios;
    end
    methods
        function obj = oidConstraintScenarios(scenarioMatrix)
            obj.scenarioMatrix = scenarioMatrix;
        end      
        function con = constraint(obj)
            N = size(obj.scenarioMatrix,2);
            con = cell(N,1);
            for n = 1:N
                con{n} = ['(obj.theta0-'...
                    mat2str(obj.scenarioMatrix(1:end-1,n))...
                    ')''*obj.inputSpectrum.informationMatrix(obj.model)*'...
                    'obj.numSamples*'...
                    '(obj.theta0-'...
                    mat2str(obj.scenarioMatrix(1:end-1,n))...
                    ') >= K*'...
                    mat2str(obj.scenarioMatrix(end,n))...
                    ';' ];
            end
        end
        function res = get.numScenarios(obj)
            res = size(obj.scenarioMatrix,2);
        end
        function display(obj)
            disp(char(obj));
        end
        function res = char(obj)
            res = ['Scenarios (' num2str(obj.numScenarios()) ')'];
        end
    end
end        