function ellipse(A,c,a)
% FUNCTION:     ellipse
% DESCRIPTION:  Given a matrix A and a point c the function ellipse 
%               draws a ellipse centered in c. [(x+c)' * K * (x+c) = 1]
% INPUT:        1 - matrix [hessian]
%               2 - center point [estimates of true parameters]
%               3 - color 
% OUTPUT:       plot of ellipse

[Q,D] = eig(A); 
ev    = diag(D);
l     = 1./sqrt(ev);
W     = Q*1/sqrt(D);
t     = linspace(0,2*pi,100);

hold on
plot(W(1,1) .* cos(t) + W(1,2) .* sin(t) + c(1), W(2,1) .* cos(t) + ...
     W(2,2) .* sin(t) + c(2), a,'LineWidth',2)
plot(c(1),c(2),'*')

axis equal


