function objective(varargin)
% Parse and set input design objective
try
    prob = evalin('caller',mooseConst.PROBLEM_NAME);
catch
    throw(MException('','MOOSE::No Moose problem defined. Run mooseBegin first'));
end

obj = {};
if nargin > 1
    for i = nargin
        obj = [obj varargin{i}];
    end
elseif nargin == 1  
        obj = varargin{1};            
else
    throw(MException('','MOOSE::No objective stated'));
end

evalin('caller',[mooseConst.PROBLEM_NAME '.objective=''' obj ''';']);

end