function probability(varargin)
% Parse and construct probability

% Get input design problem
try
    prob = evalin('caller',mooseConst.PROBLEM_NAME);
catch
    throw(MException('','MOOSE::No Moose problem defined. Run mooseBegin first'));
end

[nameProbability,argument] = naming(varargin);

% Get probability
if ~evalin('caller',['isa(' argument{1} ', ''double'');'])
    throw(MException('','MOOSE:: probability must be of type double'));
end 
if evalin('caller',[argument{1} '>1;'])
    throw(MException('','MOOSE:: probability must be less than 1'));
end 
evalin('caller',[mooseConst.PROBLEM_NAME '.probability =' argument{1} ';']);

if ~isempty(nameProbability)
    evalin('caller', [nameProbability '=' mooseConst.PROBLEM_NAME '.probability;']);
    assignin('caller','nameProbability', nameProbability);
elseif isempty(str2double(argument{1}))
    assignin('caller','nameProbability', 'mooseProblem.probability');
else
    assignin('caller','nameProbability', argument{1});
end
end