function optH = spectralFactor(obj,Ts)
[n m p] = size(obj.params);

if p < 2
    optH = eye(size(obj.params))*tf(1,1,Ts)*sqrtm(full(obj.params));
    return
end

A = zeros(n*(p-1));
A(n+1:n*(p-1),1:n*(p-2)) = eye(n*(p-2));
B = [eye(n); zeros(n*(p-2),n)];
C = reshape(obj.params(:,:,2:end),n,m*(p-1),1);
D = 1/2*obj.params(:,:,1);

R = -D-D';
S = -B;
P = dare(A',C',0*A,R,S);
L = D+D'-C*P*C';
K = -(A*P*C'-B)*pinv(L);

% This is the theoretical spectral factor, it is not used due to numerical
% issues. An ad hoc method for cleaning up the numerics is implemented as
% optH.
% optH = tf(ss(A,K,C,eye(size(C,1)),Ts))*sqrtm(L);

optH = tf();
for i = 1:n
   [b,a] = ss2tf(A,K,C,eye(size(C,1)),i);
   b(abs(b)<1e-12) = 0;
   b = b(:,1:p);
   b = mat2cell(b,ones(1,n),p);
   optH(:,i) = tf(b,a(1:p),Ts);
end
optH = minreal(optH*sqrtm(L));

return