%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% poster.cls
%
% Document class to produce posters with KTH logo.
% 
% Mats Bengtsson, 28/5 2002
%
% Incompatible change: Added environment rutor to
% set the number of columns. Mats 29/7 2002
%
% Renamed to KTHEEposter and modified to adhere somewhat more to the
% graphical profile. Mats Bengtsson, 7/8 2006. 
%
% Renewed layout, reimplemented using tikz instead of pstricks, added
% possibility to add extra logotype. Mats Bengtsson April 2011 - July 2012
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ACCESSposter}[2012/07/31 -- ACCESS Poster]


% Default size: A0
\newcommand{\p@persize}{a0}
% Handle A1 paper as well: 
\DeclareOption{a1}{\renewcommand{\p@persize}{a1}}
\DeclareOption{A1}{\renewcommand{\p@persize}{a1}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{a0poster}}
\ProcessOptions
\LoadClass[\p@persize]{a0poster}

\RequirePackage{graphicx}
%\RequirePackage[dvips]{color}
\usepackage{fancybox}
%\RequirePackage{pstricks,pst-node}
\RequirePackage{tikz}
\RequirePackage{multicol}
\RequirePackage{calc}
\RequirePackage{ifthen}

\usetikzlibrary{shadows,calc}

\setcounter{secnumdepth}{0} % Turn off section numbers
\tikzstyle{every picture}+=[remember picture] % Make it possible to
                                % draw arrows between different frames

\newlength{\ruthjd}
\newlength{\rutbredd}
\newlength{\tmpl@ngth}

\newcommand{\extralogo}[1]{\def\extral@g@{#1}}
\extralogo{Logo/ACCESS_logo_CMYK_print}

%\newcmykcolor{KTHblue}{1 0.55 0 0}
\definecolor{KTHblue}{cmyk}{1 0.55 0 0}
%\newcmykcolor{KTHred}{0 1 0.65 0.23}
\definecolor{KTHred}{cmyk}{0 1 0.65 0.23}

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Usage: \begin{rutor}{<number of columns>} ... \end{rutor}
%
\newenvironment{rutor}[1]{
  \begin{multicols*}{#1} \raggedright}
  {\end{multicols*}}


%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Usage \begin{ruta}[<number in each column>]{<height>}{<node name>} 
% ... \end{ruta}
% 
% The sum of the height values in each column should equal the
% number of frames in the column, i.e. height=1 always works.
% The optional first argument has default value=2 and should be the
% same for all frames in the same column. Different columns could
% contain different number of frames, though.
% The node name specifies a label that can be used when drawing arrows
% between the frames using pst-node.
%
\newenvironment{ruta}[3][2]{\begin{Sbox}%
    \large % Increase default text size
    % Total height below the title,
    % paper height - margin - logo - space below logo - title:
    \setlength{\tmpl@ngth}{\paperheight-2in-\topmargin-2cm-20cm}
    \setlength{\ruthjd}{\tmpl@ngth/#1-\parskip-35.4mm}%
    \setlength{\rutbredd}{\columnwidth}
    \addtolength{\rutbredd}{-77mm}
    \global\def\name{#3}%
    \begin{minipage}[t][#2\ruthjd]{\rutbredd}}
    {\end{minipage}\end{Sbox}%
  \begin{tikzpicture}
    \node[line width=5mm,fill=white!50,
    general shadow={fill=gray},shadow xshift=10mm,
    shadow yshift=-6mm, inner sep=15mm,draw=KTHblue](\name){\TheSbox};
  \end{tikzpicture}
%    \rnode{\name}{\psframebox[linewidth=5mm,linecolor=KTHblue,framearc=.1,framesep=15mm,fillstyle=solid,fillcolor=white,shadow=true,shadowcolor=gray,shadowsize=12mm,shadowangle=-30]{\TheSbox}}
}

\newenvironment{ruta_utan_ram}[2][2]{%
  % Total height below the title,
  % paper height - margin - logo - space below logo - title:
  \setlength{\tmpl@ngth}{\paperheight-2in-\topmargin-2cm-20cm}
  \setlength{\ruthjd}{(\tmpl@ngth-#1\parskip)/#1-40.2mm}%
  \setlength{\rutbredd}{\columnwidth}
  \addtolength{\rutbredd}{-57mm}
  \vskip 20mm\hspace{20mm}\begin{minipage}[t][#2\ruthjd]{\rutbredd}}
  {\end{minipage}}

\parskip 1cm
\columnsep 0pt

\renewcommand{\maketitle}{
  %
  % Move to the left edge of the paper
  \setlength{\tmpl@ngth}{15mm-\hoffset-1in-\oddsidemargin}%
  \noindent\mbox{}\hspace*{\tmpl@ngth}%
  \parbox[t][210mm]{\paperwidth-30mm}{%
    \hfill%
    \raisebox{-0.5\height}{\includegraphics[height=8cm]{Logo/kth_cmyk}}%
    \hfill%
    \begin{minipage}{0.7\textwidth}
      \mbox{}\vfill
      \begin{center}
        \VERYHuge\bfseries
        \@title \\[2cm]
        \Huge \itshape
        \@author
      \end{center}
      \vfill\mbox{}
    \end{minipage}\hfill%
    \ifthenelse{\isundefined{\extral@g@}}{\hspace{5cm}}{%
  \raisebox{-0.5\height}{\includegraphics[height=6cm]{\extral@g@}}}}
}

\newcommand{\pil}[2]{  \draw ($(#1.south east)+(0,3cm)$) -| ($ (#1)!.5!(#2) $)  |- ($(#2.north west)-(0,3cm)$);
}