/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import lib.common.Util;
import lib.huvud.Div;
import lib.huvud.ProgramConf;
import lib.huvud.RunProgr;
import lib.kemi.graph_lib.GraphLib;
import spana.ProgramDataSpana;
import spana.SpanaFrame;

public class DiagrConvert
extends JFrame {
    private ProgramConf pc;
    private final ProgramDataSpana pd;
    private final GraphLib.PltData dd;
    private boolean finished = false;
    private final Dimension windowSize;
    private int type = -1;
    private String pltFileFullName;
    private String convertedFileFullN;
    private File convertedFile;
    private boolean cancel = true;
    private boolean convertHeader = true;
    private boolean convertColours = true;
    private int convertFont = 2;
    private boolean convertPortrait = true;
    private boolean convertEPS = false;
    private int convertSizeX = 100;
    private int convertSizeY = 100;
    private float convertMarginB = 1.0f;
    private float convertMarginL = 1.0f;
    private Rectangle paper = new Rectangle(0, 0, 100, 100);
    private Rectangle marginB = new Rectangle(0, 0, 16, 100);
    private Rectangle marginL = new Rectangle(0, 0, 100, 16);
    private final Rectangle diagram = new Rectangle(0, 0, 100, 100);
    private final Dimension A4 = new Dimension(84, 116);
    private final double D_FACTOR = 4.0;
    private static final String[] EXTS = new String[]{"pdf", "ps", "eps"};
    private static final String nl = System.getProperty("line.separator");
    private ImageIcon icon = null;
    private ButtonGroup buttonGroupO;
    private JButton jButtonDoIt;
    private JCheckBox jCheckBoxEPS;
    private JCheckBox jCheckColours;
    private JCheckBox jCheckHeader;
    private JComboBox jComboBoxFonts;
    private JLabel jLabelDiagram;
    private JLabel jLabelDir;
    private JLabel jLabelDirName;
    private JLabel jLabelFont;
    private JLabel jLabelMarginB;
    private JLabel jLabelMarginBcm;
    private JLabel jLabelMarginL;
    private JLabel jLabelMarginLcm;
    private JLabel jLabelOut;
    private JLabel jLabelOutputName;
    private JLabel jLabelPltFile;
    private JLabel jLabelPltFileName;
    private JLabel jLabelSize;
    private JLabel jLabelX;
    private JLabel jLabelX100;
    private JLabel jLabelY;
    private JLabel jLabelY100;
    private JPanel jPanel7;
    private JPanel jPanelBmargin;
    private JPanel jPanelBottom;
    private JPanel jPanelDiagram;
    private JPanel jPanelDisposition;
    private JPanel jPanelEmpty;
    private JPanel jPanelLmargin;
    private JPanel jPanelMain;
    private JPanel jPanelMarginB;
    private JPanel jPanelOrientation;
    private JPanel jPanelPaper;
    private JPanel jPanelPaperMargins;
    private JPanel jPanelRight;
    private JPanel jPanelSize;
    private JPanel jPanelTop;
    private JRadioButton jRadioButtonL;
    private JRadioButton jRadioButtonP;
    private JScrollBar jScrollBarMarginB;
    private JScrollBar jScrollBarMarginL;
    private JScrollBar jScrollBarX;
    private JScrollBar jScrollBarY;

    public DiagrConvert(ProgramConf pc0, ProgramDataSpana pd0, GraphLib.PltData dd0) {
        this.initComponents();
        this.pc = pc0;
        this.pd = pd0;
        this.dd = dd0;
        this.finished = false;
        this.cancel = true;
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagrConvert.this.closeWindow();
            }
        };
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        AbstractAction altXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagrConvert.this.jButtonDoIt.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_X", altXAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagrConvert.this.setCursor(new Cursor(3));
                String[] a = new String[]{"S_Printing_htm_Convert"};
                RunProgr.runProgramInProcess((Component)DiagrConvert.this, (String)"Chem_Diagr_Help.jar", (String[])a, (boolean)false, (boolean)((DiagrConvert)DiagrConvert.this).pc.dbg, (String)((DiagrConvert)DiagrConvert.this).pc.pathAPP);
                DiagrConvert.this.setCursor(new Cursor(0));
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        KeyStroke altHKeyStroke = KeyStroke.getKeyStroke(72, 8, false);
        this.getRootPane().getInputMap(2).put(altHKeyStroke, "ALT_H");
        this.getRootPane().getActionMap().put("ALT_H", f1Action);
        this.windowSize = this.getSize();
        int left = Math.max(55, (SpanaFrame.screenSize.width - this.windowSize.width) / 2);
        int top = Math.max(10, (SpanaFrame.screenSize.height - this.windowSize.height) / 2);
        this.setLocation(Math.min(SpanaFrame.screenSize.width - 100, left), Math.min(SpanaFrame.screenSize.height - 100, top));
        this.setTitle("Convert a diagram:");
        String iconName = this.type == 1 ? "images/Icon-PDF.gif" : "images/Icon-PS.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.icon = new ImageIcon(imgURL);
            this.setIconImage(this.icon.getImage());
        } else {
            System.err.println("--- Error in DiagrConvert constructor: Could not load image = \"" + iconName + "\"");
            this.icon = null;
        }
        this.convertHeader = this.pd.diagrConvertHeader;
        this.convertColours = this.pd.diagrConvertColors;
        this.convertFont = this.pd.diagrConvertFont;
        this.convertPortrait = this.pd.diagrConvertPortrait;
        this.convertSizeX = this.pd.diagrConvertSizeX;
        this.convertSizeY = this.pd.diagrConvertSizeY;
        this.convertMarginB = this.pd.diagrConvertMarginB;
        this.convertMarginL = this.pd.diagrConvertMarginL;
        this.convertEPS = this.pd.diagrConvertEPS;
        this.jCheckHeader.setSelected(this.convertHeader);
        this.jCheckColours.setSelected(this.convertColours);
        this.jComboBoxFonts.setSelectedIndex(Math.max(0, Math.min(this.jComboBoxFonts.getItemCount() - 1, this.convertFont)));
        this.jRadioButtonP.setSelected(this.convertPortrait);
        this.jRadioButtonL.setSelected(!this.convertPortrait);
        this.jScrollBarX.setValue(Math.max(20, Math.min(300, this.convertSizeX)));
        this.jScrollBarY.setValue(Math.max(20, Math.min(300, this.convertSizeY)));
        this.jScrollBarMarginB.setValue(-Math.max(-50, Math.min(200, (int)(10.0f * this.convertMarginB))));
        this.jScrollBarMarginL.setValue(Math.max(-50, Math.min(210, (int)(10.0f * this.convertMarginL))));
        this.jLabelMarginBcm.setText(String.valueOf(this.convertMarginB));
        this.jLabelMarginLcm.setText(String.valueOf(this.convertMarginL));
        this.jButtonDoIt.setIcon(this.icon);
        this.jLabelPltFileName.setText(" ");
        this.jLabelDirName.setText(this.pc.pathDef.toString());
        this.jLabelOutputName.setText(" ");
    }

    public void start(int typ, String pltFileN) {
        this.type = typ;
        if (this.type < 1 || this.type > 3) {
            String msg = "Programming Error: type = " + this.type + " in DiagrConvert. Should be 1, 2 or 3.";
            Util.exceptn((String)msg);
            this.closeWindow();
            return;
        }
        this.jButtonDoIt.setText("convert to " + EXTS[this.type - 1].toUpperCase());
        if (this.type == 1) {
            this.jCheckBoxEPS.setVisible(false);
        } else {
            this.jCheckBoxEPS.setVisible(true);
            this.jCheckBoxEPS.setSelected(this.convertEPS);
        }
        if (this.type == 2 || this.type == 3) {
            this.setEPS(this.convertEPS);
        }
        this.redrawDisposition();
        if (this.pc.dbg) {
            System.out.println(" - - - - - - DiagrConvert, typ=" + typ);
        }
        this.setVisible(true);
        if (pltFileN == null || pltFileN.trim().length() <= 0) {
            String msg = "Programming Error: empty or null file name in DiagrConvert.";
            Util.exceptn((String)msg);
            JOptionPane.showMessageDialog(this, msg, "Programming error", 0);
            this.closeWindow();
            return;
        }
        File pltFile = new File(pltFileN);
        String msg = null;
        if (!pltFile.exists()) {
            msg = "the file does not exist.";
        }
        if (!pltFile.canRead()) {
            msg = "can not open file for reading.";
        }
        if (msg != null) {
            String t = "Error: \"" + pltFileN + "\"" + nl + msg;
            Util.exceptn((String)t);
            JOptionPane.showMessageDialog(this, t, this.pc.progName, 0);
            this.closeWindow();
            return;
        }
        try {
            this.pltFileFullName = pltFile.getCanonicalPath();
        }
        catch (IOException ex) {
            try {
                this.pltFileFullName = pltFile.getAbsolutePath();
            }
            catch (Exception e) {
                this.pltFileFullName = pltFile.getPath();
            }
        }
        this.setTitle(pltFile.getName());
        this.jLabelPltFileName.setText(pltFile.getName());
        this.jLabelDirName.setText(pltFile.getParent());
        this.convertedFileFullN = Div.getFileNameWithoutExtension((String)this.pltFileFullName) + "." + EXTS[this.type - 1];
        this.convertedFile = new File(this.convertedFileFullN);
        this.jLabelOutputName.setText(this.convertedFile.getName());
        int k = this.getWidth() - this.jPanelBottom.getWidth();
        this.validate();
        int j = Math.max(this.jPanelBottom.getWidth(), this.jPanelTop.getWidth());
        Dimension d = new Dimension(k + j, this.getHeight());
        this.setSize(d);
    }

    private void initComponents() {
        this.buttonGroupO = new ButtonGroup();
        this.jPanelTop = new JPanel();
        this.jLabelPltFile = new JLabel();
        this.jLabelPltFileName = new JLabel();
        this.jLabelDir = new JLabel();
        this.jLabelDirName = new JLabel();
        this.jPanelMain = new JPanel();
        this.jPanelSize = new JPanel();
        this.jScrollBarY = new JScrollBar();
        this.jScrollBarX = new JScrollBar();
        this.jLabelSize = new JLabel();
        this.jPanel7 = new JPanel();
        this.jLabelY = new JLabel();
        this.jLabelX = new JLabel();
        this.jLabelX100 = new JLabel();
        this.jLabelY100 = new JLabel();
        this.jPanelDisposition = new JPanel();
        this.jPanelMarginB = new JPanel();
        this.jPanelBmargin = new JPanel();
        this.jLabelMarginB = new JLabel();
        this.jLabelMarginBcm = new JLabel();
        this.jPanelEmpty = new JPanel();
        this.jPanelPaperMargins = new JPanel();
        this.jPanelPaper = new JPanel();
        this.jPanelDiagram = new JPanel();
        this.jLabelDiagram = new JLabel();
        this.jScrollBarMarginL = new JScrollBar();
        this.jScrollBarMarginB = new JScrollBar();
        this.jPanelLmargin = new JPanel();
        this.jLabelMarginL = new JLabel();
        this.jLabelMarginLcm = new JLabel();
        this.jPanelBottom = new JPanel();
        this.jLabelOut = new JLabel();
        this.jLabelOutputName = new JLabel();
        this.jPanelRight = new JPanel();
        this.jLabelFont = new JLabel();
        this.jComboBoxFonts = new JComboBox();
        this.jCheckColours = new JCheckBox();
        this.jCheckHeader = new JCheckBox();
        this.jPanelOrientation = new JPanel();
        this.jRadioButtonP = new JRadioButton();
        this.jRadioButtonL = new JRadioButton();
        this.jCheckBoxEPS = new JCheckBox();
        this.jButtonDoIt = new JButton();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DiagrConvert.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DiagrConvert.this.formComponentResized(evt);
            }
        });
        this.jPanelTop.setFont(new Font("Dialog", 0, 11));
        this.jLabelPltFile.setFont(new Font("Dialog", 0, 11));
        this.jLabelPltFile.setText("Plot file:");
        this.jLabelPltFileName.setFont(new Font("Dialog", 1, 12));
        this.jLabelPltFileName.setText("Hello.plt");
        this.jLabelDir.setFont(new Font("Dialog", 0, 11));
        this.jLabelDir.setText("Directory: ");
        this.jLabelDirName.setFont(new Font("Dialog", 0, 11));
        this.jLabelDirName.setText("\"D:\\myfiles\\subdir");
        GroupLayout jPanelTopLayout = new GroupLayout(this.jPanelTop);
        this.jPanelTop.setLayout(jPanelTopLayout);
        jPanelTopLayout.setHorizontalGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopLayout.createSequentialGroup().addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopLayout.createSequentialGroup().addComponent(this.jLabelPltFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelPltFileName)).addGroup(jPanelTopLayout.createSequentialGroup().addComponent(this.jLabelDir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelDirName))).addGap(0, 0, Short.MAX_VALUE)));
        jPanelTopLayout.setVerticalGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopLayout.createSequentialGroup().addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelPltFile).addComponent(this.jLabelPltFileName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelDir).addComponent(this.jLabelDirName))));
        this.jPanelMain.setFont(new Font("Dialog", 0, 11));
        this.jPanelSize.setFont(new Font("Dialog", 0, 11));
        this.jScrollBarY.setBlockIncrement(5);
        this.jScrollBarY.setMaximum(210);
        this.jScrollBarY.setMinimum(20);
        this.jScrollBarY.setOrientation(0);
        this.jScrollBarY.setValue(100);
        this.jScrollBarY.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                DiagrConvert.this.jScrollBarYAdjustmentValueChanged(evt);
            }
        });
        this.jScrollBarX.setBlockIncrement(5);
        this.jScrollBarX.setMaximum(210);
        this.jScrollBarX.setMinimum(20);
        this.jScrollBarX.setOrientation(0);
        this.jScrollBarX.setValue(100);
        this.jScrollBarX.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                DiagrConvert.this.jScrollBarXAdjustmentValueChanged(evt);
            }
        });
        this.jLabelSize.setFont(new Font("Dialog", 0, 11));
        this.jLabelSize.setText("Size");
        this.jPanel7.setFont(new Font("Dialog", 0, 11));
        this.jLabelY.setFont(new Font("Dialog", 0, 11));
        this.jLabelY.setText("Y");
        this.jLabelY.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DiagrConvert.this.jLabelYMouseClicked(evt);
            }
        });
        this.jLabelX.setFont(new Font("Dialog", 0, 11));
        this.jLabelX.setText("X");
        this.jLabelX.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DiagrConvert.this.jLabelXMouseClicked(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelY, GroupLayout.Alignment.TRAILING).addComponent(this.jLabelX, GroupLayout.Alignment.TRAILING)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabelX).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelY).addGap(0, 0, Short.MAX_VALUE)));
        this.jLabelX100.setFont(new Font("Dialog", 0, 11));
        this.jLabelX100.setText("100 %");
        this.jLabelX100.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DiagrConvert.this.jLabelX100MouseClicked(evt);
            }
        });
        this.jLabelY100.setFont(new Font("Dialog", 0, 11));
        this.jLabelY100.setText("100 %");
        this.jLabelY100.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DiagrConvert.this.jLabelY100MouseClicked(evt);
            }
        });
        GroupLayout jPanelSizeLayout = new GroupLayout(this.jPanelSize);
        this.jPanelSize.setLayout(jPanelSizeLayout);
        jPanelSizeLayout.setHorizontalGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSizeLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSizeLayout.createSequentialGroup().addComponent(this.jScrollBarX, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelX100, -1, 58, Short.MAX_VALUE)).addGroup(jPanelSizeLayout.createSequentialGroup().addComponent(this.jScrollBarY, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelY100, -1, -1, Short.MAX_VALUE))).addGap(0, 10, 10)));
        jPanelSizeLayout.setVerticalGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSizeLayout.createSequentialGroup().addComponent(this.jLabelSize).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE).addGroup(jPanelSizeLayout.createSequentialGroup().addGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelX100).addComponent(this.jScrollBarX, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollBarY, -2, -1, -2).addComponent(this.jLabelY100))));
        this.jPanelDisposition.setFont(new Font("Dialog", 0, 11));
        this.jPanelMarginB.setFont(new Font("Dialog", 0, 11));
        this.jPanelMarginB.setLayout(new CardLayout());
        this.jPanelBmargin.setFont(new Font("Dialog", 0, 11));
        this.jLabelMarginB.setFont(new Font("Dialog", 0, 11));
        this.jLabelMarginB.setText("<html>Bottom<br>margin:</html>");
        this.jLabelMarginB.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DiagrConvert.this.jLabelMarginBMouseClicked(evt);
            }
        });
        this.jLabelMarginBcm.setFont(new Font("Dialog", 0, 11));
        this.jLabelMarginBcm.setText("1.0");
        this.jLabelMarginBcm.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DiagrConvert.this.jLabelMarginBcmMouseClicked(evt);
            }
        });
        GroupLayout jPanelBmarginLayout = new GroupLayout(this.jPanelBmargin);
        this.jPanelBmargin.setLayout(jPanelBmarginLayout);
        jPanelBmarginLayout.setHorizontalGroup(jPanelBmarginLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBmarginLayout.createSequentialGroup().addGroup(jPanelBmarginLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelBmarginLayout.createSequentialGroup().addComponent(this.jLabelMarginB, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanelBmarginLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabelMarginBcm))).addContainerGap()));
        jPanelBmarginLayout.setVerticalGroup(jPanelBmarginLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBmarginLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelMarginB, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelMarginBcm).addGap(0, 11, Short.MAX_VALUE)));
        this.jPanelMarginB.add((Component)this.jPanelBmargin, "labels");
        this.jPanelEmpty.setFont(new Font("Dialog", 0, 11));
        GroupLayout jPanelEmptyLayout = new GroupLayout(this.jPanelEmpty);
        this.jPanelEmpty.setLayout(jPanelEmptyLayout);
        jPanelEmptyLayout.setHorizontalGroup(jPanelEmptyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 46, Short.MAX_VALUE));
        jPanelEmptyLayout.setVerticalGroup(jPanelEmptyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 73, Short.MAX_VALUE));
        this.jPanelMarginB.add((Component)this.jPanelEmpty, "empty");
        this.jPanelPaperMargins.setFont(new Font("Dialog", 0, 11));
        this.jPanelPaperMargins.setLayout(null);
        this.jPanelPaper.setBackground(new Color(255, 255, 255));
        this.jPanelPaper.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanelPaper.setFont(new Font("Dialog", 0, 11));
        this.jPanelPaper.setPreferredSize(new Dimension(42, 60));
        this.jPanelPaper.setLayout(null);
        this.jPanelDiagram.setBackground(new Color(153, 153, 153));
        this.jPanelDiagram.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanelDiagram.setFont(new Font("Dialog", 0, 11));
        this.jPanelDiagram.setLayout(null);
        this.jLabelDiagram.setFont(new Font("Dialog", 1, 11));
        this.jLabelDiagram.setText("Diagram");
        this.jPanelDiagram.add(this.jLabelDiagram);
        this.jLabelDiagram.setBounds(11, 12, 45, 15);
        this.jPanelPaper.add(this.jPanelDiagram);
        this.jPanelDiagram.setBounds(6, 60, 0, 0);
        this.jPanelPaperMargins.add(this.jPanelPaper);
        this.jPanelPaper.setBounds(17, 0, 84, 116);
        this.jScrollBarMarginL.setMaximum(210);
        this.jScrollBarMarginL.setMinimum(-50);
        this.jScrollBarMarginL.setOrientation(0);
        this.jScrollBarMarginL.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                DiagrConvert.this.jScrollBarMarginLAdjustmentValueChanged(evt);
            }
        });
        this.jPanelPaperMargins.add(this.jScrollBarMarginL);
        this.jScrollBarMarginL.setBounds(17, 117, 84, 16);
        this.jScrollBarMarginB.setMaximum(60);
        this.jScrollBarMarginB.setMinimum(-200);
        this.jScrollBarMarginB.setValue(-10);
        this.jScrollBarMarginB.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                DiagrConvert.this.jScrollBarMarginBAdjustmentValueChanged(evt);
            }
        });
        this.jPanelPaperMargins.add(this.jScrollBarMarginB);
        this.jScrollBarMarginB.setBounds(0, 0, 16, 116);
        this.jPanelLmargin.setFont(new Font("Dialog", 0, 11));
        this.jLabelMarginL.setFont(new Font("Dialog", 0, 11));
        this.jLabelMarginL.setText("Left margin:");
        this.jLabelMarginL.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DiagrConvert.this.jLabelMarginLMouseClicked(evt);
            }
        });
        this.jLabelMarginLcm.setFont(new Font("Dialog", 0, 11));
        this.jLabelMarginLcm.setText("1.0");
        this.jLabelMarginLcm.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DiagrConvert.this.jLabelMarginLcmMouseClicked(evt);
            }
        });
        GroupLayout jPanelLmarginLayout = new GroupLayout(this.jPanelLmargin);
        this.jPanelLmargin.setLayout(jPanelLmarginLayout);
        jPanelLmarginLayout.setHorizontalGroup(jPanelLmarginLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLmarginLayout.createSequentialGroup().addComponent(this.jLabelMarginL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelMarginLcm).addGap(0, 55, Short.MAX_VALUE)));
        jPanelLmarginLayout.setVerticalGroup(jPanelLmarginLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLmarginLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMarginL).addComponent(this.jLabelMarginLcm)));
        GroupLayout jPanelDispositionLayout = new GroupLayout(this.jPanelDisposition);
        this.jPanelDisposition.setLayout(jPanelDispositionLayout);
        jPanelDispositionLayout.setHorizontalGroup(jPanelDispositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDispositionLayout.createSequentialGroup().addComponent(this.jPanelMarginB, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelPaperMargins, -2, 133, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanelDispositionLayout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.jPanelLmargin, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelDispositionLayout.setVerticalGroup(jPanelDispositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDispositionLayout.createSequentialGroup().addGroup(jPanelDispositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelPaperMargins, -2, 133, -2).addGroup(jPanelDispositionLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jPanelMarginB, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelLmargin, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelSize, -2, -1, -2).addComponent(this.jPanelDisposition, -2, -1, -2));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addComponent(this.jPanelSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelDisposition, -2, 158, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelBottom.setFont(new Font("Dialog", 0, 11));
        this.jLabelOut.setFont(new Font("Dialog", 0, 11));
        this.jLabelOut.setText("Output file:");
        this.jLabelOutputName.setFont(new Font("Dialog", 1, 12));
        this.jLabelOutputName.setText("Hello.pdf");
        GroupLayout jPanelBottomLayout = new GroupLayout(this.jPanelBottom);
        this.jPanelBottom.setLayout(jPanelBottomLayout);
        jPanelBottomLayout.setHorizontalGroup(jPanelBottomLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBottomLayout.createSequentialGroup().addComponent(this.jLabelOut).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelOutputName).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelBottomLayout.setVerticalGroup(jPanelBottomLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBottomLayout.createSequentialGroup().addGroup(jPanelBottomLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOutputName).addComponent(this.jLabelOut)).addGap(8, 8, 8)));
        this.jPanelRight.setFont(new Font("Dialog", 0, 11));
        this.jLabelFont.setFont(new Font("Dialog", 0, 11));
        this.jLabelFont.setText("Font");
        this.jComboBoxFonts.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxFonts.setModel(new DefaultComboBoxModel<String>(new String[]{"Vector graphics", "Times-Roman", "Helvetica", "Courier"}));
        this.jComboBoxFonts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagrConvert.this.jComboBoxFontsActionPerformed(evt);
            }
        });
        this.jCheckColours.setFont(new Font("Dialog", 0, 11));
        this.jCheckColours.setMnemonic('c');
        this.jCheckColours.setText("Colours");
        this.jCheckColours.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagrConvert.this.jCheckColoursActionPerformed(evt);
            }
        });
        this.jCheckHeader.setFont(new Font("Dialog", 0, 11));
        this.jCheckHeader.setMnemonic('h');
        this.jCheckHeader.setText("Header");
        this.jCheckHeader.setFocusPainted(false);
        this.jCheckHeader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagrConvert.this.jCheckHeaderActionPerformed(evt);
            }
        });
        this.jPanelOrientation.setBorder(BorderFactory.createTitledBorder(null, "Orientation", 0, 0, new Font("Dialog", 0, 11)));
        this.jPanelOrientation.setFont(new Font("Dialog", 0, 11));
        this.buttonGroupO.add(this.jRadioButtonP);
        this.jRadioButtonP.setFont(new Font("Dialog", 0, 11));
        this.jRadioButtonP.setMnemonic('p');
        this.jRadioButtonP.setSelected(true);
        this.jRadioButtonP.setText("Portrait");
        this.jRadioButtonP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagrConvert.this.jRadioButtonPActionPerformed(evt);
            }
        });
        this.buttonGroupO.add(this.jRadioButtonL);
        this.jRadioButtonL.setFont(new Font("Dialog", 0, 11));
        this.jRadioButtonL.setMnemonic('l');
        this.jRadioButtonL.setText("Landscape");
        this.jRadioButtonL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagrConvert.this.jRadioButtonLActionPerformed(evt);
            }
        });
        GroupLayout jPanelOrientationLayout = new GroupLayout(this.jPanelOrientation);
        this.jPanelOrientation.setLayout(jPanelOrientationLayout);
        jPanelOrientationLayout.setHorizontalGroup(jPanelOrientationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOrientationLayout.createSequentialGroup().addContainerGap().addGroup(jPanelOrientationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonP).addComponent(this.jRadioButtonL))));
        jPanelOrientationLayout.setVerticalGroup(jPanelOrientationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOrientationLayout.createSequentialGroup().addComponent(this.jRadioButtonP).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonL).addContainerGap()));
        this.jCheckBoxEPS.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxEPS.setMnemonic('e');
        this.jCheckBoxEPS.setText("encapsulated PS");
        this.jCheckBoxEPS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagrConvert.this.jCheckBoxEPSActionPerformed(evt);
            }
        });
        GroupLayout jPanelRightLayout = new GroupLayout(this.jPanelRight);
        this.jPanelRight.setLayout(jPanelRightLayout);
        jPanelRightLayout.setHorizontalGroup(jPanelRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRightLayout.createSequentialGroup().addContainerGap().addGroup(jPanelRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxFonts, 0, -1, Short.MAX_VALUE).addGroup(jPanelRightLayout.createSequentialGroup().addGroup(jPanelRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelFont).addComponent(this.jPanelOrientation, -2, -1, -2).addComponent(this.jCheckColours).addComponent(this.jCheckBoxEPS).addComponent(this.jCheckHeader)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelRightLayout.setVerticalGroup(jPanelRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRightLayout.createSequentialGroup().addComponent(this.jLabelFont).addGap(3, 3, 3).addComponent(this.jComboBoxFonts, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckColours).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckHeader).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelOrientation, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxEPS).addContainerGap()));
        this.jButtonDoIt.setFont(new Font("Dialog", 0, 11));
        this.jButtonDoIt.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Icon-PDF.gif")));
        this.jButtonDoIt.setMnemonic('c');
        this.jButtonDoIt.setText("convert to ...");
        this.jButtonDoIt.setIconTextGap(8);
        this.jButtonDoIt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagrConvert.this.jButtonDoItActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelBottom, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelTop, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jButtonDoIt).addGap(0, 242, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jPanelMain, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelRight, -1, -1, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelTop, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelRight, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelBottom, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDoIt).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jRadioButtonPActionPerformed(ActionEvent evt) {
        this.convertPortrait = this.jRadioButtonP.isSelected();
        this.redrawDisposition();
    }

    private void jRadioButtonLActionPerformed(ActionEvent evt) {
        this.convertPortrait = this.jRadioButtonP.isSelected();
        this.redrawDisposition();
    }

    private void jCheckHeaderActionPerformed(ActionEvent evt) {
        this.convertHeader = this.jCheckHeader.isSelected();
    }

    private void jCheckColoursActionPerformed(ActionEvent evt) {
        this.convertColours = this.jCheckColours.isSelected();
    }

    private void jButtonDoItActionPerformed(ActionEvent evt) {
        this.saveSettings();
        this.cancel = false;
        DiagrConvert.doIt(this, this.type, this.pltFileFullName, this.pd, this.pc);
        this.closeWindow();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void jScrollBarXAdjustmentValueChanged(AdjustmentEvent evt) {
        this.convertSizeX = this.jScrollBarX.getValue();
        this.jLabelX100.setText(String.valueOf(this.jScrollBarX.getValue()) + " %");
        this.redrawDisposition();
    }

    private void jScrollBarYAdjustmentValueChanged(AdjustmentEvent evt) {
        this.convertSizeY = this.jScrollBarY.getValue();
        this.jLabelY100.setText(String.valueOf(this.jScrollBarY.getValue()) + " %");
        this.redrawDisposition();
    }

    private void jLabelXMouseClicked(MouseEvent evt) {
        this.jScrollBarX.setValue(100);
    }

    private void jLabelX100MouseClicked(MouseEvent evt) {
        this.jScrollBarX.setValue(100);
    }

    private void jLabelYMouseClicked(MouseEvent evt) {
        this.jScrollBarY.setValue(100);
    }

    private void jLabelY100MouseClicked(MouseEvent evt) {
        this.jScrollBarY.setValue(100);
    }

    private void jScrollBarMarginBAdjustmentValueChanged(AdjustmentEvent evt) {
        this.convertMarginB = -((float)this.jScrollBarMarginB.getValue()) / 10.0f;
        if ((double)Math.abs(this.convertMarginB) < 0.001) {
            this.convertMarginB = 0.0f;
        }
        this.jLabelMarginBcm.setText(String.valueOf(this.convertMarginB));
        this.redrawDisposition();
    }

    private void jScrollBarMarginLAdjustmentValueChanged(AdjustmentEvent evt) {
        this.convertMarginL = (float)this.jScrollBarMarginL.getValue() / 10.0f;
        if ((double)Math.abs(this.convertMarginL) < 0.001) {
            this.convertMarginL = 0.0f;
        }
        this.jLabelMarginLcm.setText(String.valueOf(this.convertMarginL));
        this.redrawDisposition();
    }

    private void jLabelMarginBMouseClicked(MouseEvent evt) {
        this.jScrollBarMarginB.setValue(-10);
    }

    private void jLabelMarginBcmMouseClicked(MouseEvent evt) {
        this.jScrollBarMarginB.setValue(-10);
    }

    private void jLabelMarginLMouseClicked(MouseEvent evt) {
        this.jScrollBarMarginL.setValue(10);
    }

    private void jLabelMarginLcmMouseClicked(MouseEvent evt) {
        this.jScrollBarMarginL.setValue(10);
    }

    private void jComboBoxFontsActionPerformed(ActionEvent evt) {
        this.convertFont = this.jComboBoxFonts.getSelectedIndex();
    }

    private void jCheckBoxEPSActionPerformed(ActionEvent evt) {
        this.setEPS(this.jCheckBoxEPS.isSelected());
        this.redrawDisposition();
    }

    public final void closeWindow() {
        if (this.cancel && this.changes()) {
            Object[] opt = new Object[]{"Yes", "NO", "Cancel"};
            int answer = JOptionPane.showOptionDialog(this, "Save options?", this.pc.progName, 1, 2, null, opt, opt[1]);
            if (answer == 0) {
                this.saveSettings();
            } else if (answer == 2) {
                return;
            }
        }
        this.finished = true;
        this.setVisible(false);
        this.dispose();
        this.notify_All();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public synchronized boolean waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.cancel;
    }

    private boolean changes() {
        boolean changed = false;
        if (this.pd.diagrConvertHeader != this.convertHeader) {
            changed = true;
        } else if (this.pd.diagrConvertColors != this.convertColours) {
            changed = true;
        } else if (this.pd.diagrConvertFont != this.convertFont) {
            changed = true;
        } else if (this.pd.diagrConvertPortrait != this.convertPortrait) {
            changed = true;
        } else if (this.pd.diagrConvertSizeX != this.convertSizeX) {
            changed = true;
        } else if (this.pd.diagrConvertSizeY != this.convertSizeY) {
            changed = true;
        } else if (this.pd.diagrConvertMarginB != this.convertMarginB) {
            changed = true;
        } else if (this.pd.diagrConvertMarginL != this.convertMarginL) {
            changed = true;
        } else if (this.pd.diagrConvertEPS != this.convertEPS) {
            changed = true;
        }
        return changed;
    }

    private void saveSettings() {
        this.pd.diagrConvertHeader = this.convertHeader;
        this.pd.diagrConvertColors = this.convertColours;
        this.pd.diagrConvertFont = this.convertFont;
        this.pd.diagrConvertPortrait = this.convertPortrait;
        this.pd.diagrConvertSizeX = this.convertSizeX;
        this.pd.diagrConvertSizeY = this.convertSizeY;
        this.pd.diagrConvertMarginB = this.convertMarginB;
        this.pd.diagrConvertMarginL = this.convertMarginL;
        this.pd.diagrConvertEPS = this.convertEPS;
    }

    private void setEPS(boolean eps) {
        this.convertEPS = eps;
        CardLayout cl = (CardLayout)this.jPanelMarginB.getLayout();
        if (eps) {
            this.type = 3;
            cl.show(this.jPanelMarginB, "empty");
            this.jLabelMarginL.setText(" ");
            this.jLabelMarginLcm.setText(" ");
        } else {
            this.type = 2;
            cl.show(this.jPanelMarginB, "labels");
            this.jLabelMarginL.setText("Left margin:");
            this.jLabelMarginLcm.setText(String.valueOf(this.convertMarginL));
        }
        this.jScrollBarMarginB.setEnabled(!eps);
        this.jScrollBarMarginL.setEnabled(!eps);
        this.jPanelOrientation.setVisible(!eps);
        this.jCheckHeader.setVisible(!eps);
        this.jButtonDoIt.setText("convert to " + EXTS[this.type - 1].toUpperCase());
        this.convertedFileFullN = Div.getFileNameWithoutExtension((String)this.pltFileFullName) + "." + EXTS[this.type - 1];
        this.convertedFile = new File(this.convertedFileFullN);
        this.jLabelOutputName.setText(this.convertedFile.getName());
    }

    private void redrawDisposition() {
        this.paper = this.jPanelPaper.getBounds();
        this.marginB = this.jScrollBarMarginB.getBounds();
        this.marginL = this.jScrollBarMarginL.getBounds();
        boolean portrait = this.type != 1 && this.convertEPS ? true : this.convertPortrait;
        if (portrait) {
            this.paper.height = this.A4.height;
            this.paper.width = this.A4.width;
            this.paper.y = 0;
        } else {
            this.paper.width = this.A4.height;
            this.paper.height = this.A4.width;
            this.paper.y = this.A4.height - this.paper.height;
        }
        this.paper.x = this.marginB.width + 1;
        this.marginB.height = this.paper.height;
        this.marginB.y = this.paper.y;
        this.marginL.width = this.paper.width;
        this.jPanelPaper.setBounds(this.paper);
        this.jScrollBarMarginB.setBounds(this.marginB);
        this.jScrollBarMarginL.setBounds(this.marginL);
        this.diagram.height = (int)((double)Math.abs(this.dd.userSpaceMax.y - this.dd.userSpaceMin.y) / 100.0 * ((double)this.convertSizeY / 100.0) * 4.0);
        this.diagram.width = (int)((double)Math.abs(this.dd.userSpaceMax.x - this.dd.userSpaceMin.x) / 100.0 * ((double)this.convertSizeX / 100.0) * 4.0);
        if (this.type != 1 && this.convertEPS) {
            this.diagram.x = (this.paper.width - this.diagram.width) / 2;
            this.diagram.y = (this.paper.height - this.diagram.height) / 2;
        } else {
            this.diagram.x = (int)(this.convertMarginL * 4.0f);
            this.diagram.y = (int)((float)(this.paper.height - this.diagram.height) - this.convertMarginB * 4.0f);
        }
        int x = (this.diagram.width - this.jLabelDiagram.getWidth()) / 2;
        int y = (this.diagram.height - this.jLabelDiagram.getHeight()) / 2;
        this.jLabelDiagram.setLocation(x, y);
        this.jPanelDiagram.setBounds(this.diagram);
        this.jPanelDisposition.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doIt(Frame parent, int typ, String fileName, ProgramDataSpana pd0, ProgramConf pc0) {
        if (typ < 1 || typ > 3) {
            Util.exceptn((String)("Error: typ = " + typ + " (must be 1,2 or 3)"));
            return;
        }
        if (fileName == null || fileName.trim().length() <= 0) {
            Util.exceptn((String)"Error: empty file name");
            return;
        }
        if (pd0 == null) {
            Util.exceptn((String)"Error: prgram data = null");
            return;
        }
        if (pc0 == null) {
            Util.exceptn((String)"Error: program configuration = null");
            return;
        }
        ProgramDataSpana pd = pd0;
        ProgramConf pc = pc0;
        int type = typ;
        String pltFileFullName = fileName;
        String program = type <= 2 ? "Plot" + EXTS[type - 1].toUpperCase() + ".jar" : "Plot" + EXTS[type - 1].substring(1).toUpperCase() + ".jar";
        ArrayList<String> options = new ArrayList<String>();
        options.add(pltFileFullName);
        String convertedFileFullN = Div.getFileNameWithoutExtension((String)pltFileFullName) + "." + EXTS[type - 1];
        if (type == 1) {
            options.add("-pdf=" + convertedFileFullN);
        } else if (type == 2 || type == 3) {
            options.add("-ps=" + convertedFileFullN);
        }
        ProgramDataSpana programDataSpana = pd;
        synchronized (programDataSpana) {
            options.add("-b=" + pd.diagrConvertMarginB);
            options.add("-l=" + pd.diagrConvertMarginL);
            options.add("-sX=" + pd.diagrConvertSizeX);
            options.add("-sY=" + pd.diagrConvertSizeY);
            if (!pd.diagrConvertHeader) {
                options.add("-noH");
            }
            if (pd.diagrConvertColors) {
                options.add("-clr");
            } else {
                options.add("-bw");
            }
            if (pd.diagrConvertPortrait) {
                options.add("-o=P");
            } else {
                options.add("-o=L");
            }
            options.add("-f=" + (1 + Math.max(0, Math.min(3, pd.diagrConvertFont))));
        }
        String[] args = new String[options.size()];
        args = options.toArray(args);
        if (pd.keepFrame || pc.dbg) {
            System.out.println("Running:");
            System.out.print(program + " ");
            for (String t : args) {
                System.out.print(" " + t);
            }
            System.out.println();
        }
        File convertedFile = new File(convertedFileFullN);
        long fileDate0 = convertedFile.lastModified();
        boolean waitForCompletion = true;
        RunProgr.runProgramInProcess((Component)parent, (String)program, (String[])args, (boolean)waitForCompletion, (boolean)pc.dbg, (String)pc.pathAPP);
        long fileDate = convertedFile.lastModified();
        if (fileDate > fileDate0) {
            if (pc.dbg) {
                System.out.println("--- Created file \"" + convertedFile.getName() + "\"");
            }
            if (parent != null) {
                ImageIcon icon;
                String msg = "<html>Created ";
                if (type == 1) {
                    msg = msg + "pdf-";
                } else if (type == 3) {
                    msg = msg + "encapsulated ";
                }
                if (type == 2 || type == 3) {
                    msg = msg + "PostScript-";
                }
                msg = msg + "file:<br>" + "<b>\"" + convertedFile.getName() + "\"</b></html>";
                String iconName = "images/Successful.gif";
                URL imgURL = DiagrConvert.class.getResource(iconName);
                if (imgURL != null) {
                    icon = new ImageIcon(imgURL);
                } else {
                    System.err.println("--- Error in DiagrConvert constructor: Could not load image = \"" + iconName + "\"");
                    icon = null;
                }
                if (icon != null) {
                    JOptionPane.showMessageDialog(parent, msg, pc.progName, 1, icon);
                } else {
                    JOptionPane.showMessageDialog(parent, msg, pc.progName, 1);
                }
            }
        } else {
            if (pc.dbg) {
                System.out.println("--- Failed to create file \"" + convertedFile.getName() + "\"");
            }
            if (parent != null) {
                JOptionPane.showMessageDialog(parent, "<html>Failed to create file:<br><b>\"" + convertedFile.getName() + "\"</b></html>", pc.progName, 0);
            }
        }
    }
}

