/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import lib.common.Util;
import lib.kemi.chem.Chem;
import spana.ModifyChemSyst;
import spana.SpanaFrame;

public class LogKchange
extends JFrame {
    private final Dimension windowSize;
    private boolean finished = false;
    private Chem.ChemSystem cs = null;
    private Chem.ChemSystem.NamesEtc namn = null;
    private final int species;
    private boolean deactivated_old;
    private double lBeta_old;
    private boolean modified;
    private ButtonGroup buttonGroup;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonQuit;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelLogKOld;
    private JLabel jLabelReaction;
    private JLabel jLabelWarning;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelButtons;
    private JRadioButton jRadioButtonAct;
    private JRadioButton jRadioButtonDeact;
    private JTextField jTextFieldLogK;

    public LogKchange(Chem.ChemSystem chemS, int complex) {
        this.initComponents();
        this.cs = chemS;
        this.namn = this.cs.namn;
        this.species = complex;
        this.modified = false;
        this.setDefaultCloseOperation(0);
        this.windowSize = this.getSize();
        int left = Math.max(0, (SpanaFrame.screenSize.width - this.windowSize.width) / 2);
        int top = Math.max(0, (SpanaFrame.screenSize.height - this.windowSize.height) / 2);
        this.setLocation(Math.min(SpanaFrame.screenSize.width - 100, left), Math.min(SpanaFrame.screenSize.height - 100, top));
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogKchange.this.quitDialog();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        AbstractAction altXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogKchange.this.jButtonOK.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_X", altXAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogKchange.this.jButtonHelp.doClick();
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        this.setTitle("Change logK");
        String iconName = "images/LogK_32x32.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            Util.exceptn((String)("Error: Could not load image = \"" + iconName + "\""));
        }
        this.jLabelReaction.setText(ModifyChemSyst.reactionText(this.cs, this.species, false));
        this.lBeta_old = this.cs.lBeta[this.species];
        this.jLabelLogKOld.setText(Util.formatDbl4((double)this.lBeta_old));
        this.jTextFieldLogK.setText(Util.formatDbl4((double)this.lBeta_old));
        this.setCheckBox(this.namn.ident[this.cs.Na + this.species]);
        this.deactivated_old = this.jRadioButtonDeact.isSelected();
        this.setCursor(new Cursor(0));
        this.setVisible(true);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabelReaction = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabelLogKOld = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldLogK = new JTextField();
        this.jPanel3 = new JPanel();
        this.jRadioButtonAct = new JRadioButton();
        this.jRadioButtonDeact = new JRadioButton();
        this.jPanelButtons = new JPanel();
        this.jButtonQuit = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabelWarning = new JLabel();
        this.setDefaultCloseOperation(3);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                LogKchange.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LogKchange.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setFont(new Font("Dialog", 1, 18));
        this.jLabel1.setForeground(new Color(0, 0, 204));
        this.jLabel1.setText("Reaction:");
        this.jLabelReaction.setFont(new Font("Dialog", 1, 14));
        this.jLabelReaction.setHorizontalAlignment(2);
        this.jLabelReaction.setText("8 Cu 2+ + 8 H3(urid)  =  Cu8(urid)8 + 24 H+");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelReaction, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelReaction).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel2.setFont(new Font("Dialog", 1, 12));
        this.jLabel2.setForeground(new Color(0, 0, 204));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("old logK = ");
        this.jLabelLogKOld.setFont(new Font("Dialog", 0, 12));
        this.jLabelLogKOld.setText("jLabel5");
        this.jLabel3.setFont(new Font("Dialog", 1, 12));
        this.jLabel3.setForeground(new Color(0, 0, 204));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Enter new logK:");
        this.jTextFieldLogK.setFont(new Font("Dialog", 0, 11));
        this.jTextFieldLogK.setText("-999.999");
        this.jTextFieldLogK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogKchange.this.jTextFieldLogKActionPerformed(evt);
            }
        });
        this.jTextFieldLogK.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                LogKchange.this.jTextFieldLogKFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                LogKchange.this.jTextFieldLogKFocusLost(evt);
            }
        });
        this.jTextFieldLogK.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LogKchange.this.jTextFieldLogKKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                LogKchange.this.jTextFieldLogKKeyTyped(evt);
            }
        });
        this.jPanel3.setFont(new Font("Dialog", 0, 11));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 99, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 33, Short.MAX_VALUE));
        this.buttonGroup.add(this.jRadioButtonAct);
        this.jRadioButtonAct.setFont(new Font("Dialog", 1, 11));
        this.jRadioButtonAct.setForeground(new Color(0, 0, 204));
        this.jRadioButtonAct.setMnemonic('a');
        this.jRadioButtonAct.setText("activate");
        this.jRadioButtonAct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogKchange.this.jRadioButtonActActionPerformed(evt);
            }
        });
        this.buttonGroup.add(this.jRadioButtonDeact);
        this.jRadioButtonDeact.setFont(new Font("Dialog", 1, 11));
        this.jRadioButtonDeact.setForeground(new Color(0, 0, 204));
        this.jRadioButtonDeact.setMnemonic('d');
        this.jRadioButtonDeact.setText("deactivate");
        this.jRadioButtonDeact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogKchange.this.jRadioButtonDeactActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(157, 157, 157).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonDeact).addComponent(this.jRadioButtonAct)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 117, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelLogKOld).addComponent(this.jTextFieldLogK, -2, 89, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel3, -2, -1, -2)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabelLogKOld)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldLogK, -2, -1, -2))).addComponent(this.jPanel3, -2, -1, -2)).addGap(4, 4, 4).addComponent(this.jRadioButtonAct).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonDeact).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelButtons.setFont(new Font("Dialog", 0, 11));
        this.jButtonQuit.setFont(new Font("Dialog", 1, 11));
        this.jButtonQuit.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Quit_32x32.gif")));
        this.jButtonQuit.setMnemonic('Q');
        this.jButtonQuit.setText("<html><u>Q</u>uit</html>");
        this.jButtonQuit.setHorizontalAlignment(10);
        this.jButtonQuit.setIconTextGap(8);
        this.jButtonQuit.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogKchange.this.jButtonQuitActionPerformed(evt);
            }
        });
        this.jButtonOK.setFont(new Font("Dialog", 1, 11));
        this.jButtonOK.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Save_32x32.gif")));
        this.jButtonOK.setMnemonic('O');
        this.jButtonOK.setText("OK");
        this.jButtonOK.setHorizontalAlignment(10);
        this.jButtonOK.setIconTextGap(8);
        this.jButtonOK.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogKchange.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setFont(new Font("Dialog", 1, 11));
        this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Help_32x32.gif")));
        this.jButtonHelp.setMnemonic('H');
        this.jButtonHelp.setMargin(new Insets(2, 2, 2, 2));
        GroupLayout jPanelButtonsLayout = new GroupLayout(this.jPanelButtons);
        this.jPanelButtons.setLayout(jPanelButtonsLayout);
        jPanelButtonsLayout.setHorizontalGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonHelp).addGroup(jPanelButtonsLayout.createSequentialGroup().addComponent(this.jButtonOK, -2, 73, -2).addGap(10, 10, 10).addComponent(this.jButtonQuit, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelButtonsLayout.setVerticalGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonsLayout.createSequentialGroup().addGap(19, 19, 19).addGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonOK).addComponent(this.jButtonQuit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE).addComponent(this.jButtonHelp).addContainerGap()));
        this.jLabelWarning.setFont(new Font("Dialog", 1, 14));
        this.jLabelWarning.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Warn_RedTriangl.gif")));
        this.jLabelWarning.setText("<html>Warning! This species is not active.<br>This may result in wrong diagrams!</html>");
        this.jLabelWarning.setAlignmentY(0.0f);
        this.jLabelWarning.setVerticalTextPosition(1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jLabelWarning, -2, 331, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelButtons, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelWarning)).addComponent(this.jPanelButtons, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonQuitActionPerformed(ActionEvent evt) {
        this.quitDialog();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.validateLogK();
        this.lBeta_old = this.cs.lBeta[this.species];
        this.deactivated_old = this.jRadioButtonDeact.isSelected();
        this.quitDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.quitDialog();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void jTextFieldLogKFocusLost(FocusEvent evt) {
        this.validateLogK();
    }

    private void jTextFieldLogKKeyPressed(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.validateLogK();
        }
    }

    private void jTextFieldLogKKeyTyped(KeyEvent evt) {
        char key = evt.getKeyChar();
        if (!this.isCharOKforNumberInput(key)) {
            evt.consume();
        }
    }

    private void jTextFieldLogKActionPerformed(ActionEvent evt) {
        this.validateLogK();
    }

    private void jTextFieldLogKFocusGained(FocusEvent evt) {
        this.jTextFieldLogK.selectAll();
    }

    private void jRadioButtonActActionPerformed(ActionEvent evt) {
        if (this.jRadioButtonAct.isSelected()) {
            if (this.namn.ident[this.cs.Na + this.species].startsWith("*")) {
                this.namn.ident[this.cs.Na + this.species] = this.namn.ident[this.cs.Na + this.species].substring(1);
            }
        } else if (!this.namn.ident[this.cs.Na + this.species].startsWith("*")) {
            this.namn.ident[this.cs.Na + this.species] = "*" + this.namn.ident[this.cs.Na + this.species];
        }
        this.jLabelReaction.setText(ModifyChemSyst.reactionText(this.cs, this.species, false));
        this.setCheckBox(this.namn.ident[this.cs.Na + this.species]);
    }

    private void jRadioButtonDeactActionPerformed(ActionEvent evt) {
        if (this.jRadioButtonDeact.isSelected()) {
            if (!this.namn.ident[this.cs.Na + this.species].startsWith("*")) {
                this.namn.ident[this.cs.Na + this.species] = "*" + this.namn.ident[this.cs.Na + this.species];
            }
        } else if (this.namn.ident[this.cs.Na + this.species].startsWith("*")) {
            this.namn.ident[this.cs.Na + this.species] = this.namn.ident[this.cs.Na + this.species].substring(1);
        }
        this.jLabelReaction.setText(ModifyChemSyst.reactionText(this.cs, this.species, false));
        this.setCheckBox(this.namn.ident[this.cs.Na + this.species]);
    }

    private void quitDialog() {
        if (Math.abs(this.cs.lBeta[this.species] - this.lBeta_old) > 1.0E-8 || this.deactivated_old != this.jRadioButtonDeact.isSelected()) {
            this.modified = true;
        }
        if (this.modified) {
            Object[] options = new Object[]{"Cancel", "Yes"};
            int n = JOptionPane.showOptionDialog(this, "Discard your changes?", "Modify Chemical System", 0, 2, null, options, null);
            if (n != 1) {
                return;
            }
            this.cs.lBeta[this.species] = this.lBeta_old;
            if (this.deactivated_old) {
                if (!this.namn.ident[this.cs.Na + this.species].startsWith("*")) {
                    this.namn.ident[this.cs.Na + this.species] = "*" + this.namn.ident[this.cs.Na + this.species];
                }
            } else if (this.namn.ident[this.cs.Na + this.species].startsWith("*")) {
                this.namn.ident[this.cs.Na + this.species] = this.namn.ident[this.cs.Na + this.species].substring(1);
            }
        }
        this.finished = true;
        this.notify_All();
        this.dispose();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public synchronized boolean waitForLogKchange() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.modified;
    }

    private void setCheckBox(String name) {
        if (name.startsWith("*")) {
            this.jRadioButtonDeact.setSelected(true);
            this.jRadioButtonDeact.setText("deactivated");
            this.jRadioButtonAct.setText("activate");
            this.jLabelWarning.setVisible(true);
        } else {
            this.jRadioButtonAct.setSelected(true);
            this.jRadioButtonDeact.setText("deactivate");
            this.jRadioButtonAct.setText("activated");
            this.jLabelWarning.setVisible(false);
        }
    }

    private void validateLogK() {
        this.cs.lBeta[this.species] = this.readLogK();
        String t = Util.formatNum((double)this.cs.lBeta[this.species]);
        if (Double.parseDouble(t) != this.cs.lBeta[this.species]) {
            this.jTextFieldLogK.setText(t);
        }
    }

    private double readLogK() {
        double w;
        if (this.jTextFieldLogK.getText().length() <= 0) {
            return 0.0;
        }
        try {
            w = Double.parseDouble(this.jTextFieldLogK.getText());
            w = Math.min(1.0E50, Math.max(w, -1.0E50));
        }
        catch (NumberFormatException nfe) {
            w = Double.NaN;
            System.out.println("Error reading logK:\n   " + nfe.toString());
        }
        return w;
    }

    private boolean isCharOKforNumberInput(char key) {
        return Character.isDigit(key) || key == '-' || key == '+' || key == '.' || key == 'E' || key == 'e';
    }
}

