/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lib.common.Util;
import lib.huvud.ProgramConf;
import lib.huvud.RunProgr;
import lib.kemi.chem.Chem;
import lib.kemi.readDataLib.ReadDataLib;
import lib.kemi.readWriteDataFiles.DefaultPlotAndConcs;
import lib.kemi.readWriteDataFiles.ReadChemSyst;
import lib.kemi.readWriteDataFiles.WriteChemSyst;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import spana.LogKchange;
import spana.ModifyConfirm;
import spana.ProgramDataSpana;
import spana.SpanaFrame;

public class ModifyChemSyst
extends JFrame {
    private final ProgramDataSpana pd;
    private ProgramConf pc;
    private boolean dbg = true;
    private ModifyChemSyst thisFrame = null;
    private final Dimension windowSize;
    private boolean finished = false;
    private File dataFile;
    private Chem ch = null;
    private Chem.ChemSystem cs = null;
    private Chem.ChemSystem.NamesEtc namn = null;
    private Chem.Diagr diagr = null;
    private Chem.DiagrConcs dgrC = null;
    private final ArrayList<String> identC0 = new ArrayList();
    private String compXname0 = null;
    private String compYname0 = null;
    private String compMainName0 = null;
    private int Na0;
    private final DefaultListModel listSolubleCompModel = new DefaultListModel();
    private final DefaultListModel listSolidCompModel = new DefaultListModel();
    private final DefaultListModel listSolubleCmplxModel = new DefaultListModel();
    private final DefaultListModel listSolidCmplxModel = new DefaultListModel();
    private final Border defBorder;
    private final Border highlightedBorder = BorderFactory.createBevelBorder(1, Color.gray, Color.black);
    private boolean modified = false;
    private int compToDelete;
    private int complxToExchange;
    private static final String noReactionMessage = "(double-click or type space on a name to change its logK)";
    private static final String nl = System.getProperty("line.separator");
    private JButton jButtonDn;
    private JButton jButtonUp;
    private JButton jButton_Delete;
    private JButton jButton_Exchange;
    private JButton jButton_Merge;
    private JButton jButton_Quit;
    private JButton jButton_Save;
    private JLabel jLabel0;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelReaction;
    private JList jListSolidCmplx;
    private JList jListSolidComps;
    private JList jListSolubCmplx;
    private JList jListSolubComps;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel1Top;
    private JPanel jPanel2;
    private JPanel jPanel2down;
    private JPanel jPanel2up;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanelDataFile;
    private JPanel jPanelNew;
    private JPanel jPanelUpDown;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTextField jTextFieldDataFile;

    public ModifyChemSyst(ProgramConf pc0, ProgramDataSpana pd0) {
        this.initComponents();
        this.pd = pd0;
        this.pc = pc0;
        this.dbg = true;
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyChemSyst.this.jButton_Quit.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyChemSyst.this.setCursor(new Cursor(3));
                String[] a = new String[]{"S_Modify_Chem_System_htm"};
                RunProgr.runProgramInProcess((Component)ModifyChemSyst.this, (String)"Chem_Diagr_Help.jar", (String[])a, (boolean)false, (boolean)((ModifyChemSyst)ModifyChemSyst.this).pc.dbg, (String)((ModifyChemSyst)ModifyChemSyst.this).pc.pathAPP);
                ModifyChemSyst.this.setCursor(new Cursor(0));
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        KeyStroke altHKeyStroke = KeyStroke.getKeyStroke(72, 8, false);
        this.getRootPane().getInputMap(2).put(altHKeyStroke, "ALT_H");
        this.getRootPane().getActionMap().put("ALT_H", f1Action);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        AbstractAction altXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyChemSyst.this.jButton_Save.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_X", altXAction);
        String iconName = "images/Modify_32x32.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            Util.exceptn((String)("Error: Could not load image = \"" + iconName + "\""));
        }
        this.defBorder = this.jScrollPane1.getBorder();
        CardLayout cl = (CardLayout)this.jPanel1Top.getLayout();
        cl.show(this.jPanel1Top, "cardDataFile");
        this.jButton_Merge.setEnabled(this.pd.advancedVersion);
        this.jButton_Merge.setVisible(this.pd.advancedVersion);
        Dimension d = this.jPanelUpDown.getPreferredSize();
        if (!this.pd.advancedVersion) {
            this.jButtonUp.setVisible(false);
            this.jButtonDn.setVisible(false);
        } else {
            this.jButtonUp.setEnabled(false);
            this.jButtonDn.setEnabled(false);
        }
        this.pack();
        this.windowSize = this.getSize();
        int left = Math.max(0, (SpanaFrame.screenSize.width - this.windowSize.width) / 2);
        int top = Math.max(0, (SpanaFrame.screenSize.height - this.windowSize.height) / 2);
        this.setLocation(Math.min(SpanaFrame.screenSize.width - 100, left), Math.min(SpanaFrame.screenSize.height - 100, top));
        SpanaFrame.getInstance().setCursorDef();
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModifyChemSyst.this.thisFrame = ModifyChemSyst.this;
            }
        });
    }

    public void startDataFile(File datFile) {
        this.dataFile = datFile;
        if (this.dbg) {
            System.out.println(" ---- Modify Chemical System: " + datFile.getName());
        }
        if (!this.readDataFile(this.dataFile, this.pc.dbg, this.ch)) {
            System.out.println("Error reading file \"" + this.dataFile.getName() + "\"");
            SpanaFrame.getInstance().setCursorDef();
            this.quitFrame();
            return;
        }
        this.cs = this.ch.chemSystem;
        this.namn = this.cs.namn;
        this.diagr = this.ch.diag;
        this.dgrC = this.ch.diagrConcs;
        if (this.cs.Na <= 0) {
            return;
        }
        this.storeInitialSystem(this.ch);
        this.setupFrame();
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel1Top = new JPanel();
        this.jPanelDataFile = new JPanel();
        this.jLabel0 = new JLabel();
        this.jTextFieldDataFile = new JTextField();
        this.jPanelNew = new JPanel();
        this.jLabel5 = new JLabel();
        this.jPanelUpDown = new JPanel();
        this.jButtonUp = new JButton();
        this.jButtonDn = new JButton();
        this.jPanel2up = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListSolubComps = new JList();
        this.jPanel6 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jListSolubCmplx = new JList();
        this.jPanel2down = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jListSolidComps = new JList();
        this.jPanel8 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.jListSolidCmplx = new JList();
        this.jPanel2 = new JPanel();
        this.jLabelReaction = new JLabel();
        this.jPanel10 = new JPanel();
        this.jButton_Delete = new JButton();
        this.jButton_Exchange = new JButton();
        this.jButton_Merge = new JButton();
        this.jPanel11 = new JPanel();
        this.jButton_Quit = new JButton();
        this.jButton_Save = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Modify Data File");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ModifyChemSyst.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ModifyChemSyst.this.formComponentResized(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jPanel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModifyChemSyst.this.jPanel1MouseEntered(evt);
            }
        });
        this.jPanel1Top.setFont(new Font("Dialog", 0, 11));
        this.jPanel1Top.setLayout(new CardLayout());
        this.jPanelDataFile.setFont(new Font("Dialog", 0, 11));
        this.jLabel0.setFont(new Font("Dialog", 1, 11));
        this.jLabel0.setForeground(new Color(0, 0, 153));
        this.jLabel0.setLabelFor(this.jTextFieldDataFile);
        this.jLabel0.setText("Original Data File:");
        this.jLabel0.setToolTipText("Click to change Data File");
        this.jTextFieldDataFile.setFont(new Font("Dialog", 0, 11));
        this.jTextFieldDataFile.setText("jTextField1");
        this.jTextFieldDataFile.setToolTipText("Click to change Data File");
        this.jTextFieldDataFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyChemSyst.this.jTextFieldDataFileActionPerformed(evt);
            }
        });
        this.jTextFieldDataFile.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ModifyChemSyst.this.jTextFieldDataFileFocusGained(evt);
            }
        });
        this.jTextFieldDataFile.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ModifyChemSyst.this.jTextFieldDataFileKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                ModifyChemSyst.this.jTextFieldDataFileKeyTyped(evt);
            }
        });
        this.jTextFieldDataFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ModifyChemSyst.this.jTextFieldDataFileMouseClicked(evt);
            }
        });
        GroupLayout jPanelDataFileLayout = new GroupLayout(this.jPanelDataFile);
        this.jPanelDataFile.setLayout(jPanelDataFileLayout);
        jPanelDataFileLayout.setHorizontalGroup(jPanelDataFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataFileLayout.createSequentialGroup().addComponent(this.jLabel0).addContainerGap(292, Short.MAX_VALUE)).addComponent(this.jTextFieldDataFile, -1, 385, Short.MAX_VALUE));
        jPanelDataFileLayout.setVerticalGroup(jPanelDataFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataFileLayout.createSequentialGroup().addComponent(this.jLabel0).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDataFile, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1Top.add((Component)this.jPanelDataFile, "cardDataFile");
        this.jPanelNew.setFont(new Font("Dialog", 0, 11));
        this.jLabel5.setFont(new Font("Dialog", 1, 14));
        this.jLabel5.setForeground(new Color(0, 0, 153));
        this.jLabel5.setText("New Chemical System:");
        GroupLayout jPanelNewLayout = new GroupLayout(this.jPanelNew);
        this.jPanelNew.setLayout(jPanelNewLayout);
        jPanelNewLayout.setHorizontalGroup(jPanelNewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNewLayout.createSequentialGroup().addGap(105, 105, 105).addComponent(this.jLabel5).addContainerGap(124, Short.MAX_VALUE)));
        jPanelNewLayout.setVerticalGroup(jPanelNewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNewLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addContainerGap(18, Short.MAX_VALUE)));
        this.jPanel1Top.add((Component)this.jPanelNew, "cardNewSystem");
        this.jPanelUpDown.setFont(new Font("Dialog", 0, 11));
        this.jButtonUp.setFont(new Font("Dialog", 0, 11));
        this.jButtonUp.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Arrow_up.gif")));
        this.jButtonUp.setToolTipText("move component up");
        this.jButtonUp.setMargin(new Insets(1, 0, 1, 0));
        this.jButtonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyChemSyst.this.jButtonUpActionPerformed(evt);
            }
        });
        this.jButtonDn.setFont(new Font("Dialog", 0, 11));
        this.jButtonDn.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Arrow_down.gif")));
        this.jButtonDn.setToolTipText("move component down");
        this.jButtonDn.setMargin(new Insets(1, 0, 1, 0));
        this.jButtonDn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyChemSyst.this.jButtonDnActionPerformed(evt);
            }
        });
        GroupLayout jPanelUpDownLayout = new GroupLayout(this.jPanelUpDown);
        this.jPanelUpDown.setLayout(jPanelUpDownLayout);
        jPanelUpDownLayout.setHorizontalGroup(jPanelUpDownLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelUpDownLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(jPanelUpDownLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDn).addComponent(this.jButtonUp)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelUpDownLayout.setVerticalGroup(jPanelUpDownLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelUpDownLayout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.jButtonUp).addGap(18, 18, 18).addComponent(this.jButtonDn).addContainerGap(179, Short.MAX_VALUE)));
        this.jPanel2up.setFont(new Font("Dialog", 0, 11));
        this.jPanel2up.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModifyChemSyst.this.jPanel2upMouseEntered(evt);
            }
        });
        this.jPanel2up.setLayout(new BoxLayout(this.jPanel2up, 2));
        this.jPanel5.setFont(new Font("Dialog", 0, 11));
        this.jPanel5.setPreferredSize(new Dimension(190, 141));
        this.jLabel1.setFont(new Font("Dialog", 1, 11));
        this.jLabel1.setForeground(new Color(0, 0, 153));
        this.jLabel1.setLabelFor(this.jScrollPane1);
        this.jLabel1.setText("Soluble Components:");
        this.jScrollPane1.setFont(new Font("Dialog", 0, 11));
        this.jListSolubComps.setFont(new Font("Dialog", 0, 11));
        this.jListSolubComps.setModel(this.listSolubleCompModel);
        this.jListSolubComps.setSelectionMode(0);
        this.jListSolubComps.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModifyChemSyst.this.jListSolubCompsMouseReleased(evt);
            }
        });
        this.jListSolubComps.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ModifyChemSyst.this.jListSolubCompsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ModifyChemSyst.this.jListSolubCompsFocusLost(evt);
            }
        });
        this.jListSolubComps.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModifyChemSyst.this.jListSolubCompsKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                ModifyChemSyst.this.jListSolubCompsKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListSolubComps);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jScrollPane1, -1, 173, Short.MAX_VALUE)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 146, Short.MAX_VALUE).addContainerGap()));
        this.jPanel2up.add(this.jPanel5);
        this.jPanel6.setFont(new Font("Dialog", 0, 11));
        this.jPanel6.setPreferredSize(new Dimension(190, 141));
        this.jPanel6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModifyChemSyst.this.jPanel6MouseEntered(evt);
            }
        });
        this.jLabel2.setFont(new Font("Dialog", 1, 11));
        this.jLabel2.setForeground(new Color(0, 0, 153));
        this.jLabel2.setLabelFor(this.jScrollPane2);
        this.jLabel2.setText("Soluble Complexes:");
        this.jScrollPane2.setFont(new Font("Dialog", 0, 11));
        this.jScrollPane2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModifyChemSyst.this.jScrollPane2MouseEntered(evt);
            }
        });
        this.jListSolubCmplx.setFont(new Font("Dialog", 0, 11));
        this.jListSolubCmplx.setModel(this.listSolubleCmplxModel);
        this.jListSolubCmplx.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ModifyChemSyst.this.jListSolubCmplxMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModifyChemSyst.this.jListSolubCmplxMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModifyChemSyst.this.jListSolubCmplxMouseExited(evt);
            }
        });
        this.jListSolubCmplx.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ModifyChemSyst.this.jListSolubCmplxMouseMoved(evt);
            }
        });
        this.jListSolubCmplx.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ModifyChemSyst.this.jListSolubCmplxFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ModifyChemSyst.this.jListSolubCmplxFocusLost(evt);
            }
        });
        this.jListSolubCmplx.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ModifyChemSyst.this.jListSolubCmplxKeyTyped(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jListSolubCmplx);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel2).addContainerGap(64, Short.MAX_VALUE)))));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 146, Short.MAX_VALUE).addContainerGap()));
        this.jPanel2up.add(this.jPanel6);
        this.jPanel2down.setFont(new Font("Dialog", 0, 11));
        this.jPanel2down.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModifyChemSyst.this.jPanel2downMouseEntered(evt);
            }
        });
        this.jPanel2down.setLayout(new BoxLayout(this.jPanel2down, 2));
        this.jPanel7.setFont(new Font("Dialog", 0, 11));
        this.jPanel7.setPreferredSize(new Dimension(190, 123));
        this.jLabel3.setFont(new Font("Dialog", 1, 11));
        this.jLabel3.setForeground(new Color(0, 0, 153));
        this.jLabel3.setLabelFor(this.jScrollPane3);
        this.jLabel3.setText("Solid Components");
        this.jScrollPane3.setFont(new Font("Dialog", 0, 11));
        this.jListSolidComps.setFont(new Font("Dialog", 0, 11));
        this.jListSolidComps.setModel(this.listSolidCompModel);
        this.jListSolidComps.setSelectionMode(0);
        this.jListSolidComps.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ModifyChemSyst.this.jListSolidCompsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ModifyChemSyst.this.jListSolidCompsFocusLost(evt);
            }
        });
        this.jListSolidComps.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModifyChemSyst.this.jListSolidCompsKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                ModifyChemSyst.this.jListSolidCompsKeyTyped(evt);
            }
        });
        this.jListSolidComps.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModifyChemSyst.this.jListSolidCompsMouseReleased(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jListSolidComps);
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 82, Short.MAX_VALUE)).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jScrollPane3, -2, 0, Short.MAX_VALUE).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 140, Short.MAX_VALUE)));
        this.jPanel2down.add(this.jPanel7);
        this.jPanel8.setFont(new Font("Dialog", 0, 11));
        this.jPanel8.setPreferredSize(new Dimension(190, 123));
        this.jPanel8.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModifyChemSyst.this.jPanel8MouseEntered(evt);
            }
        });
        this.jLabel4.setFont(new Font("Dialog", 1, 11));
        this.jLabel4.setForeground(new Color(0, 0, 153));
        this.jLabel4.setLabelFor(this.jScrollPane4);
        this.jLabel4.setText("Solid Products");
        this.jScrollPane4.setFont(new Font("Dialog", 0, 11));
        this.jScrollPane4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModifyChemSyst.this.jScrollPane4MouseEntered(evt);
            }
        });
        this.jListSolidCmplx.setFont(new Font("Dialog", 0, 11));
        this.jListSolidCmplx.setModel(this.listSolidCmplxModel);
        this.jListSolidCmplx.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ModifyChemSyst.this.jListSolidCmplxMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModifyChemSyst.this.jListSolidCmplxMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModifyChemSyst.this.jListSolidCmplxMouseExited(evt);
            }
        });
        this.jListSolidCmplx.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ModifyChemSyst.this.jListSolidCmplxMouseMoved(evt);
            }
        });
        this.jListSolidCmplx.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ModifyChemSyst.this.jListSolidCmplxFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ModifyChemSyst.this.jListSolidCmplxFocusLost(evt);
            }
        });
        this.jListSolidCmplx.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ModifyChemSyst.this.jListSolidCmplxKeyTyped(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jListSolidCmplx);
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -2, 0, Short.MAX_VALUE).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 93, Short.MAX_VALUE)))));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 140, Short.MAX_VALUE)));
        this.jPanel2down.add(this.jPanel8);
        this.jPanel2.setFont(new Font("Dialog", 0, 11));
        this.jPanel2.setLayout(new AbsoluteLayout());
        this.jLabelReaction.setFont(new Font("Dialog", 0, 11));
        this.jLabelReaction.setHorizontalAlignment(4);
        this.jLabelReaction.setText("jLabelReaction");
        this.jPanel2.add((Component)this.jLabelReaction, new AbsoluteConstraints(0, 0, 360, -1));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jPanel1Top, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanelUpDown, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2up, -2, 0, Short.MAX_VALUE).addComponent(this.jPanel2down, -2, 0, Short.MAX_VALUE)))).addGap(10, 10, 10)).addGroup(jPanel1Layout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jPanel1Top, -2, 48, -2).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanelUpDown, -2, -1, -2).addContainerGap(86, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2up, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jPanel2down, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jPanel2, -2, -1, -2).addGap(5, 5, 5)))));
        this.jPanel10.setFont(new Font("Dialog", 0, 11));
        this.jButton_Delete.setFont(new Font("Dialog", 1, 11));
        this.jButton_Delete.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Delete_32x32.gif")));
        this.jButton_Delete.setMnemonic('D');
        this.jButton_Delete.setText("<html><u>D</u>elete</html>");
        this.jButton_Delete.setToolTipText("Alt-D");
        this.jButton_Delete.setHorizontalAlignment(10);
        this.jButton_Delete.setIconTextGap(8);
        this.jButton_Delete.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_Delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyChemSyst.this.jButton_DeleteActionPerformed(evt);
            }
        });
        this.jButton_Exchange.setFont(new Font("Dialog", 1, 11));
        this.jButton_Exchange.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Exchange_32x32.gif")));
        this.jButton_Exchange.setMnemonic('E');
        this.jButton_Exchange.setText("<html><u>E</u>xchange a component<br>with a reaction</html>");
        this.jButton_Exchange.setToolTipText("Alt-E");
        this.jButton_Exchange.setHorizontalAlignment(10);
        this.jButton_Exchange.setIconTextGap(8);
        this.jButton_Exchange.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_Exchange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyChemSyst.this.jButton_ExchangeActionPerformed(evt);
            }
        });
        this.jButton_Merge.setFont(new Font("Dialog", 1, 11));
        this.jButton_Merge.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Merge_32x32.gif")));
        this.jButton_Merge.setMnemonic('M');
        this.jButton_Merge.setText("<html><u>M</u>erge with another<br> data file</html>");
        this.jButton_Merge.setToolTipText("Alt-M");
        this.jButton_Merge.setHorizontalAlignment(10);
        this.jButton_Merge.setIconTextGap(8);
        this.jButton_Merge.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_Merge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyChemSyst.this.jButton_MergeActionPerformed(evt);
            }
        });
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton_Exchange, -2, 217, -2).addComponent(this.jButton_Delete, -2, 217, -2).addComponent(this.jButton_Merge, -2, 217, -2));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addComponent(this.jButton_Delete, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton_Exchange, -2, -1, -2).addGap(11, 11, 11).addComponent(this.jButton_Merge, -2, -1, -2)));
        this.jPanel11.setFont(new Font("Dialog", 0, 11));
        this.jButton_Quit.setFont(new Font("Dialog", 1, 11));
        this.jButton_Quit.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Quit_32x32.gif")));
        this.jButton_Quit.setMnemonic('Q');
        this.jButton_Quit.setText("<html><u>Q</u>uit</html>");
        this.jButton_Quit.setToolTipText("Esc or Alt-Q");
        this.jButton_Quit.setHorizontalAlignment(10);
        this.jButton_Quit.setIconTextGap(8);
        this.jButton_Quit.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_Quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyChemSyst.this.jButton_QuitActionPerformed(evt);
            }
        });
        this.jButton_Save.setFont(new Font("Dialog", 1, 11));
        this.jButton_Save.setIcon(new ImageIcon(this.getClass().getResource("/spana/images/Save_32x32.gif")));
        this.jButton_Save.setMnemonic('S');
        this.jButton_Save.setText("Save and exit");
        this.jButton_Save.setToolTipText("Alt-S or Alt-X");
        this.jButton_Save.setHorizontalAlignment(10);
        this.jButton_Save.setIconTextGap(8);
        this.jButton_Save.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyChemSyst.this.jButton_SaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jButton_Save, -2, 136, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel11Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jButton_Quit, -2, 136, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addComponent(this.jButton_Quit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton_Save)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jPanel10, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel11, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel10, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel11, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)))));
        this.pack();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
            this.jLabelReactionSetSize();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.quitFrame();
    }

    private void jTextFieldDataFileKeyTyped(KeyEvent evt) {
        char c = Character.toUpperCase(evt.getKeyChar());
        if (evt.getKeyChar() != '\u001b' && (!evt.isAltDown() || c != 'X' && c != 'D' && c != 'E' && c != 'M' && c != 'Q' && evt.getKeyChar() != '\n')) {
            evt.consume();
            this.dataFile_Click();
        }
    }

    private void jTextFieldDataFileKeyPressed(KeyEvent evt) {
        if (!Util.isKeyPressedOK((KeyEvent)evt)) {
            evt.consume();
        }
    }

    private void jTextFieldDataFileMouseClicked(MouseEvent evt) {
        this.dataFile_Click();
    }

    private void jTextFieldDataFileActionPerformed(ActionEvent evt) {
        this.dataFile_Click();
    }

    private void jTextFieldDataFileFocusGained(FocusEvent evt) {
        this.jTextFieldDataFile.selectAll();
    }

    private void jButton_DeleteActionPerformed(ActionEvent evt) {
        this.delete_Click();
    }

    private void jButton_ExchangeActionPerformed(ActionEvent evt) {
        this.exchangeComponentWithComplex();
    }

    private void jButton_QuitActionPerformed(ActionEvent evt) {
        this.quitFrame();
    }

    private void jButton_SaveActionPerformed(ActionEvent evt) {
        if (!this.modified) {
            JOptionPane.showMessageDialog(this, "No changes made,\ndata-file does not need to be saved.", "Modify Chemical System", 1);
            this.quitFrame();
            return;
        }
        String fileNameToSave = Util.getSaveFileName((Component)this, (String)this.pc.progName, (String)"Enter a file name or select a file:", (int)5, (String)this.dataFile.getPath(), (String)this.pc.pathDef.toString());
        if (fileNameToSave == null) {
            return;
        }
        this.setCursor(new Cursor(3));
        File dataFileToSave = new File(fileNameToSave);
        if (this.dbg) {
            System.out.println(" ---- Saving modified system in data file:" + dataFileToSave.getName());
        }
        this.checkPlotInfo();
        try {
            WriteChemSyst.writeChemSyst((Chem)this.ch, (File)dataFileToSave);
        }
        catch (WriteChemSyst.DataLimitsException ex) {
            System.err.println(ex.getMessage());
            this.setCursor(new Cursor(0));
            return;
        }
        catch (WriteChemSyst.writeChemSystArgsException ex) {
            System.err.println(ex.getMessage());
            this.setCursor(new Cursor(0));
            return;
        }
        if (this.dbg) {
            System.out.println(" ---- data file written: \"" + dataFileToSave.getName() + "\"");
        }
        SpanaFrame.getInstance().addDatFile(fileNameToSave);
        this.modified = false;
        this.setCursor(new Cursor(0));
        this.quitFrame();
    }

    private void jListSolubCompsKeyTyped(KeyEvent evt) {
        this.jListSolidComps.clearSelection();
        this.component_Click();
    }

    private void jListSolubCompsFocusGained(FocusEvent evt) {
        this.jScrollPane1.setBorder(this.highlightedBorder);
    }

    private void jListSolubCompsFocusLost(FocusEvent evt) {
        this.jScrollPane1.setBorder(this.defBorder);
    }

    private void jListSolubCmplxMouseClicked(MouseEvent evt) {
        this.complex_Click();
        if (evt.getClickCount() > 1) {
            this.checkLogKchange(this.jListSolubCmplx, this.jListSolubCmplx.getSelectedIndex());
        }
    }

    private void jListSolubCmplxKeyTyped(KeyEvent evt) {
        this.complex_Click();
        if (!(evt.isControlDown() || evt.isAltGraphDown() || evt.isAltDown() || evt.isMetaDown() || evt.getKeyChar() != ' ')) {
            this.checkLogKchange(this.jListSolubCmplx, this.jListSolubCmplx.getSelectedIndex());
        }
        evt.consume();
    }

    private void jListSolubCmplxMouseMoved(MouseEvent evt) {
        float cellBounds;
        try {
            cellBounds = (float)this.jListSolubCmplx.getCellBounds(0, 0).getHeight();
        }
        catch (Exception ex) {
            cellBounds = (float)this.jListSolubCmplx.getHeight() / (float)this.listSolubleCmplxModel.getSize();
        }
        if (this.listSolubleCmplxModel.getSize() > 0) {
            int ix = (int)((float)evt.getY() / cellBounds);
            if (ix >= this.listSolubleCmplxModel.getSize()) {
                ix = -1;
            }
            this.jLabelReaction.setText(ModifyChemSyst.reactionText(this.cs, ix, true));
            this.jLabelReactionSetSize();
        }
    }

    private void jListSolubCmplxMouseExited(MouseEvent evt) {
        this.jLabelReaction.setText(noReactionMessage);
        this.jLabelReactionSetSize();
    }

    private void jListSolubCmplxFocusGained(FocusEvent evt) {
        this.jScrollPane2.setBorder(this.highlightedBorder);
    }

    private void jListSolubCmplxFocusLost(FocusEvent evt) {
        this.jScrollPane2.setBorder(this.defBorder);
        if (this.jListSolubCmplx.getSelectedIndex() < 0 && this.jListSolidCmplx.getSelectedIndex() < 0 && this.cs.Na <= 1) {
            this.jButton_Delete.setEnabled(false);
        }
    }

    private void jListSolidCmplxKeyTyped(KeyEvent evt) {
        this.complex_Click();
        if (!(evt.isControlDown() || evt.isAltGraphDown() || evt.isAltDown() || evt.isMetaDown() || evt.getKeyChar() != ' ')) {
            this.checkLogKchange(this.jListSolidCmplx, this.jListSolidCmplx.getSelectedIndex() + this.listSolubleCmplxModel.getSize());
        }
        evt.consume();
    }

    private void jListSolidCmplxMouseClicked(MouseEvent evt) {
        this.complex_Click();
        if (evt.getClickCount() > 1) {
            this.checkLogKchange(this.jListSolidCmplx, this.jListSolidCmplx.getSelectedIndex() + this.listSolubleCmplxModel.getSize());
        }
    }

    private void jListSolidCmplxMouseMoved(MouseEvent evt) {
        float cellBounds;
        try {
            cellBounds = (float)this.jListSolidCmplx.getCellBounds(0, 0).getHeight();
        }
        catch (Exception ex) {
            cellBounds = (float)this.jListSolidCmplx.getHeight() / (float)this.listSolidCmplxModel.getSize();
        }
        if (this.listSolidCmplxModel.getSize() > 0) {
            int ix = (int)((float)evt.getY() / cellBounds);
            ix = ix >= this.listSolidCmplxModel.getSize() ? -1 : this.cs.nx + ix;
            this.jLabelReaction.setText(ModifyChemSyst.reactionText(this.cs, ix, true));
            this.jLabelReactionSetSize();
        }
    }

    private void jListSolidCmplxMouseExited(MouseEvent evt) {
        this.jLabelReaction.setText(noReactionMessage);
        this.jLabelReactionSetSize();
    }

    private void jListSolidCmplxFocusGained(FocusEvent evt) {
        this.jScrollPane4.setBorder(this.highlightedBorder);
    }

    private void jListSolidCmplxFocusLost(FocusEvent evt) {
        this.jScrollPane4.setBorder(this.defBorder);
        if (this.jListSolubCmplx.getSelectedIndex() < 0 && this.jListSolidCmplx.getSelectedIndex() < 0 && this.cs.Na <= 1) {
            this.jButton_Delete.setEnabled(false);
        }
    }

    private void jListSolidCompsKeyTyped(KeyEvent evt) {
        this.jListSolubComps.clearSelection();
        this.component_Click();
    }

    private void jListSolidCompsFocusLost(FocusEvent evt) {
        this.jScrollPane3.setBorder(this.defBorder);
    }

    private void jListSolidCompsFocusGained(FocusEvent evt) {
        this.jScrollPane3.setBorder(this.highlightedBorder);
    }

    private void jButton_MergeActionPerformed(ActionEvent evt) {
        this.mergeTwoSystems();
    }

    private void jListSolubCompsKeyReleased(KeyEvent evt) {
        this.jListSolidComps.clearSelection();
        this.component_Click();
    }

    private void jListSolidCompsKeyReleased(KeyEvent evt) {
        this.jListSolubComps.clearSelection();
        this.component_Click();
    }

    private void jButtonUpActionPerformed(ActionEvent evt) {
        this.upDownComponent(true);
    }

    private void jButtonDnActionPerformed(ActionEvent evt) {
        this.upDownComponent(false);
    }

    private void jListSolubCompsMouseReleased(MouseEvent evt) {
        this.jListSolidComps.clearSelection();
        this.component_Click();
    }

    private void jListSolidCompsMouseReleased(MouseEvent evt) {
        this.jListSolubComps.clearSelection();
        this.component_Click();
    }

    private void jPanel1MouseEntered(MouseEvent evt) {
        this.jLabelReactionSetSize();
    }

    private void jPanel2upMouseEntered(MouseEvent evt) {
        this.jLabelReactionSetSize();
    }

    private void jPanel2downMouseEntered(MouseEvent evt) {
        this.jLabelReactionSetSize();
    }

    private void jScrollPane4MouseEntered(MouseEvent evt) {
        this.jLabelReactionSetSize();
    }

    private void jScrollPane2MouseEntered(MouseEvent evt) {
        this.jLabelReactionSetSize();
    }

    private void jPanel8MouseEntered(MouseEvent evt) {
        this.jLabelReactionSetSize();
    }

    private void jPanel6MouseEntered(MouseEvent evt) {
        this.jLabelReactionSetSize();
    }

    private void jListSolubCmplxMouseEntered(MouseEvent evt) {
        this.jLabelReactionSetSize();
    }

    private void jListSolidCmplxMouseEntered(MouseEvent evt) {
        this.jLabelReactionSetSize();
    }

    public final void quitFrame() {
        if (this.thisFrame != null && this.modified) {
            this.bringToFront();
            Object[] options = new Object[]{"Cancel", "Yes"};
            int n = JOptionPane.showOptionDialog(this, "Discard your changes?", "Modify Chemical System", 0, 2, null, options, null);
            if (n != 1) {
                return;
            }
        }
        this.modified = false;
        this.finished = true;
        this.notify_All();
        this.setVisible(false);
        this.thisFrame = null;
        this.dispose();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public synchronized void waitForModifyChemSyst() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void bringToFront() {
        if (this.thisFrame != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModifyChemSyst.this.thisFrame.setVisible(true);
                    if ((ModifyChemSyst.this.thisFrame.getExtendedState() & 1) == 1) {
                        ModifyChemSyst.this.thisFrame.setExtendedState(0);
                    }
                    ModifyChemSyst.this.thisFrame.setAlwaysOnTop(true);
                    ModifyChemSyst.this.thisFrame.toFront();
                    ModifyChemSyst.this.thisFrame.requestFocus();
                    ModifyChemSyst.this.thisFrame.setAlwaysOnTop(false);
                }
            });
        }
    }

    private void jLabelReactionSetSize() {
        this.jLabelReaction.setSize(this.jPanel2.getWidth(), this.jPanel2.getHeight());
        int i = Math.max(0, this.jPanel2.getWidth() - this.jLabelReaction.getWidth());
        this.jLabelReaction.setLocation(i, 0);
    }

    private void checkPlotInfo() {
        Chem.DiagrConcs dgrCnew;
        int inew;
        boolean found;
        boolean plotMustBeChanged = false;
        int compXnew = -1;
        int compYnew = -1;
        int compMainNew = -1;
        if (this.dbg) {
            System.out.println(" ---- Checking if plot information is still valid");
            this.diagr.printPlotType(null);
            System.out.println(this.dgrC.toString());
        }
        if (this.diagr.plotType < 0 || this.diagr.compX < 0 || this.diagr.plotType == 0 && (this.diagr.compY < 0 || this.diagr.compMain < 0) || (this.diagr.plotType == 1 || this.diagr.plotType == 4) && this.diagr.compY < 0) {
            plotMustBeChanged = true;
            if (this.dbg) {
                System.out.println("Plot Must Be Changed: plotType=" + this.diagr.plotType + " compX=" + this.diagr.compX + " compY=" + this.diagr.compY + " compMain=" + this.diagr.compMain);
            }
        }
        if (this.compXname0 != null && !plotMustBeChanged) {
            found = false;
            for (inew = 0; inew < this.cs.Na; ++inew) {
                if (!this.namn.identC[inew].equals(this.compXname0)) continue;
                compXnew = inew;
                found = true;
                break;
            }
            if (!found) {
                plotMustBeChanged = true;
                if (this.dbg) {
                    System.out.println("Plot Must Be Changed: component \"" + this.compXname0 + "\" in X-axis has been removed");
                }
            }
        }
        if (!(this.diagr.plotType != 0 && this.diagr.plotType != 1 && this.diagr.plotType != 4 || this.compYname0 == null || plotMustBeChanged)) {
            found = false;
            for (inew = 0; inew < this.cs.Na; ++inew) {
                if (!this.namn.identC[inew].equals(this.compYname0)) continue;
                compYnew = inew;
                found = true;
                break;
            }
            if (!found) {
                plotMustBeChanged = true;
                if (this.dbg) {
                    System.out.println("Plot Must Be Changed: component \"" + this.compYname0 + "\" in Y-axis has been removed");
                }
            }
        }
        if (this.diagr.plotType == 0 && this.compMainName0 != null && !plotMustBeChanged) {
            found = false;
            for (inew = 0; inew < this.cs.Na; ++inew) {
                if (!this.namn.identC[inew].equals(this.compMainName0)) continue;
                compMainNew = inew;
                found = true;
                break;
            }
            if (!found) {
                plotMustBeChanged = true;
                if (this.dbg) {
                    System.out.println("Plot Must Be Changed: main-component \"" + this.compMainName0 + "\" has been removed");
                }
            }
        }
        if (!plotMustBeChanged) {
            for (int iold = 0; iold < this.Na0; ++iold) {
                if (this.dgrC.hur[iold] != 2 && this.dgrC.hur[iold] != 3 && this.dgrC.hur[iold] != 5) continue;
                found = false;
                for (int inew2 = 0; inew2 < this.cs.Na; ++inew2) {
                    if (!this.namn.identC[inew2].equals(this.identC0.get(iold))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                plotMustBeChanged = true;
                if (!this.dbg) break;
                System.out.println("Plot Must Be Changed: component \"" + this.identC0.get(iold) + "\" (with varied concentration) has been removed");
                break;
            }
        }
        int H_present = -1;
        int e_present = -1;
        int e_cmplx = -1;
        for (int inew3 = 0; inew3 < this.cs.Na; ++inew3) {
            if (Util.isProton((String)this.namn.identC[inew3])) {
                H_present = inew3;
            }
            if (!Util.isElectron((String)this.namn.identC[inew3])) continue;
            e_present = inew3;
        }
        if (e_present < 0) {
            for (int ix = 0; ix < this.cs.nx; ++ix) {
                if (!Util.isElectron((String)this.namn.ident[ix + this.cs.Na])) continue;
                e_cmplx = ix;
                break;
            }
        }
        if (!(this.diagr.plotType != 6 && this.diagr.plotType != 8 || plotMustBeChanged || H_present >= 0)) {
            plotMustBeChanged = true;
            if (this.dbg) {
                System.out.println("Plot Must Be Changed: calculated pH or H-affinity requested but \"H+\" has been removed");
            }
        }
        if (this.diagr.plotType == 5 && !plotMustBeChanged && e_present < 0 && e_cmplx < 0) {
            plotMustBeChanged = true;
            if (this.dbg) {
                System.out.println("Plot Must Be Changed: calculated pe/Eh requested but \"e-\" has been removed");
            }
        }
        if (plotMustBeChanged) {
            this.diagr.Eh = this.pd.useEh;
            if (this.dbg) {
                System.out.println("Setting New Plot Type");
            }
            DefaultPlotAndConcs.setDefaultPlot((Chem.ChemSystem)this.cs, (Chem.Diagr)this.diagr, (Chem.DiagrConcs)this.dgrC);
        } else {
            this.diagr.compX = compXnew;
            this.diagr.compY = compYnew;
            this.diagr.compMain = compMainNew;
        }
        if (this.dbg) {
            this.diagr.printPlotType(null);
        }
        try {
            Chem chem = this.ch;
            chem.getClass();
            dgrCnew = new Chem.DiagrConcs(chem, this.cs.Na);
        }
        catch (Chem.ChemicalParameterException ex) {
            ex.printStackTrace();
            this.storeInitialSystem(this.ch);
            return;
        }
        if (this.dbg) {
            System.out.println("Checking concentrations:");
        }
        for (int inew4 = 0; inew4 < this.cs.Na; ++inew4) {
            found = false;
            for (int iold = 0; iold < this.Na0; ++iold) {
                if (!this.namn.identC[inew4].equals(this.identC0.get(iold)) || this.dgrC.hur[iold] <= 0) continue;
                dgrCnew.hur[inew4] = this.dgrC.hur[iold];
                dgrCnew.cLow[inew4] = this.dgrC.cLow[iold];
                dgrCnew.cHigh[inew4] = this.dgrC.cHigh[iold];
                found = true;
                break;
            }
            if (found) continue;
            if (this.dbg) {
                System.out.println("component \"" + this.namn.identC[inew4] + "\" not found among old components; setting default conc.");
            }
            DefaultPlotAndConcs.setDefaultConc((int)inew4, (String)this.namn.identC[inew4], (Chem.DiagrConcs)dgrCnew);
        }
        this.dgrC = this.ch.diagrConcs = dgrCnew;
        if (this.dbg) {
            System.out.println("Checking concentrations for components in axes...");
        }
        DefaultPlotAndConcs.checkConcsInAxesAndMain((Chem.ChemSystem.NamesEtc)this.namn, (Chem.Diagr)this.diagr, (Chem.DiagrConcs)this.dgrC, (boolean)this.dbg);
        if (this.dbg) {
            System.out.println("Component's concentrations:");
            for (int ic = 0; ic < this.cs.Na; ++ic) {
                System.out.println("  \"" + this.namn.identC[ic] + "\" hur=" + this.dgrC.hur[ic] + " cLow=" + this.dgrC.cLow[ic] + " cHigh=" + this.dgrC.cHigh[ic]);
            }
            System.out.println(" ---- Finished checking concentrations and plot-information.");
        }
        this.storeInitialSystem(this.ch);
    }

    private void complex_Click() {
        int[] indx;
        int nbr = 0;
        if (this.listSolubleCmplxModel.getSize() > 0 && this.jListSolubCmplx.getSelectedIndex() >= 0) {
            if (!this.jButton_Delete.isEnabled()) {
                this.jButton_Delete.setEnabled(true);
            }
            if ((indx = this.jListSolubCmplx.getSelectedIndices()).length == 1) {
                nbr = 1;
            } else if (indx.length > 1) {
                nbr = 2;
            }
        }
        if (this.listSolidCmplxModel.getSize() > 0 && this.jListSolidCmplx.getSelectedIndex() >= 0) {
            if (!this.jButton_Delete.isEnabled()) {
                this.jButton_Delete.setEnabled(true);
            }
            if ((indx = this.jListSolidCmplx.getSelectedIndices()).length == 1) {
                ++nbr;
            } else if (indx.length > 1) {
                nbr += 2;
            }
        }
        if (nbr <= 1) {
            this.jButton_Delete.setText("<html><u>D</u>elete a reaction</html>");
        } else {
            this.jButton_Delete.setText("<html><u>D</u>elete reactions</html>");
        }
    }

    private void component_Click() {
        int nbr = 0;
        this.jButtonUp.setEnabled(false);
        this.jButtonDn.setEnabled(false);
        if (this.listSolubleCompModel.getSize() > 0 && this.jListSolubComps.getSelectedIndex() >= 0) {
            ++nbr;
            if (this.listSolubleCompModel.getSize() >= 2) {
                if (this.jListSolubComps.getSelectedIndex() >= 1) {
                    this.jButtonUp.setEnabled(true);
                }
                if (this.jListSolubComps.getSelectedIndex() < this.listSolubleCompModel.getSize() - 1) {
                    this.jButtonDn.setEnabled(true);
                }
            }
        }
        if (this.listSolidCompModel.getSize() > 0 && this.jListSolidComps.getSelectedIndex() >= 0) {
            ++nbr;
            if (this.listSolidCompModel.getSize() >= 2) {
                if (this.jListSolidComps.getSelectedIndex() >= 1) {
                    this.jButtonUp.setEnabled(true);
                }
                if (this.jListSolidComps.getSelectedIndex() < this.listSolidCompModel.getSize() - 1) {
                    this.jButtonDn.setEnabled(true);
                }
            }
        }
        if (nbr < 1) {
            this.jButton_Delete.setText("Delete");
        } else {
            this.jButton_Delete.setText("Delete a component");
        }
    }

    private void dataFile_Click() {
        String fileName = Util.getOpenFileName((Component)this, (String)this.pc.progName, (boolean)true, (String)"Enter a Data file name:", (int)5, (String)this.dataFile.getPath(), (String)this.pc.pathDef.toString());
        if (fileName == null) {
            this.jTextFieldDataFile.requestFocusInWindow();
            return;
        }
        if (SpanaFrame.getInstance().addDatFile(fileName)) {
            this.setCursor(new Cursor(3));
            this.dataFile = new File(fileName);
            if (!this.readDataFile(this.dataFile, this.pc.dbg, this.ch)) {
                System.out.println("Error reading file \"" + this.dataFile.getName() + "\"");
                this.setCursor(new Cursor(0));
                return;
            }
            if (this.dbg) {
                System.out.println(" ---- new data file = \"" + this.dataFile.getName() + "\"");
            }
            this.cs = this.ch.chemSystem;
            this.namn = this.cs.namn;
            this.diagr = this.ch.diag;
            this.dgrC = this.ch.diagrConcs;
        }
        this.storeInitialSystem(this.ch);
        this.setupFrame();
        this.toFront();
        this.requestFocus();
        this.jTextFieldDataFile.requestFocusInWindow();
        this.setCursor(new Cursor(0));
    }

    private void disableButtons() {
        this.jTextFieldDataFile.setEnabled(false);
        this.jButton_Delete.setEnabled(false);
        this.jButton_Delete.setForeground(Color.gray);
        this.jButton_Exchange.setEnabled(false);
        this.jButton_Exchange.setForeground(Color.gray);
        this.jButton_Merge.setEnabled(false);
        this.jButton_Merge.setForeground(Color.gray);
        this.jButton_Save.setEnabled(false);
        this.jButton_Save.setForeground(Color.gray);
        this.jButtonUp.setEnabled(false);
        this.jButtonDn.setEnabled(false);
    }

    private void delete_Click() {
        this.disableButtons();
        int del_Comp_or_Cmplx = -1;
        if (this.jButton_Delete.getText().contains("component")) {
            if (this.listSolubleCompModel.getSize() > 0 && this.jListSolubComps.getSelectedIndex() >= 0) {
                del_Comp_or_Cmplx = 1;
            }
            if (this.listSolidCompModel.getSize() > 0 && this.jListSolidComps.getSelectedIndex() >= 0) {
                del_Comp_or_Cmplx = 1;
            }
        } else if (this.jButton_Delete.getText().contains("reaction")) {
            if (this.listSolubleCmplxModel.getSize() > 0 && this.jListSolubCmplx.getSelectedIndex() >= 0) {
                del_Comp_or_Cmplx = 2;
            }
            if (this.listSolidCmplxModel.getSize() > 0 && this.jListSolidCmplx.getSelectedIndex() >= 0) {
                del_Comp_or_Cmplx = 2;
            }
        }
        switch (del_Comp_or_Cmplx) {
            case 1: {
                if (this.listSolubleCompModel.getSize() > 0 && this.jListSolubComps.getSelectedIndex() >= 0 && Util.isWater((String)this.jListSolubComps.getSelectedValue().toString())) {
                    int n;
                    this.compToDelete = this.jListSolubComps.getSelectedIndex();
                    String water = this.jListSolubComps.getSelectedValue().toString();
                    boolean YES_OPTION = true;
                    int NO_OPTION = 2;
                    if (this.listSolubleCmplxModel.getSize() > 0 || this.listSolidCmplxModel.getSize() > 0) {
                        String oh = "";
                        for (int i = 0; i < this.cs.Ms - this.cs.mSol; ++i) {
                            if (!this.namn.ident[i].equals("OH-") && !this.namn.ident[i].equals("OH -")) continue;
                            oh = "\"OH-\" and ";
                        }
                        Object[] options = new Object[]{"Cancel", "Yes", "No"};
                        n = JOptionPane.showOptionDialog(this, "Remove water without removing its reactions?\n\nPress \"YES\" to remove " + water + " but keep its reactions\n" + "(for example to keep " + oh + "any hydrolysis species).\n\n" + "Press \"NO\" to delete " + water + " and all its reactions.\n\n", "Modify Chemical System", 1, 3, null, options, null);
                    } else {
                        n = 2;
                    }
                    if (n == 1) {
                        if (this.dbg) {
                            System.out.println(" ---- Remove water but leave its reactions");
                        }
                        for (int ic = this.compToDelete; ic < this.cs.Na - 1; ++ic) {
                            this.namn.identC[ic] = this.namn.identC[ic + 1];
                            this.namn.ident[ic] = this.namn.ident[ic + 1];
                        }
                        for (int i = this.cs.Na - 1; i < this.cs.Ms - 1; ++i) {
                            this.namn.ident[i] = this.namn.ident[i + 1];
                        }
                        for (int ix = 0; ix < this.cs.Ms - this.cs.Na; ++ix) {
                            for (int ic = this.compToDelete; ic < this.cs.Na - 1; ++ic) {
                                this.cs.a[ix][ic] = this.cs.a[ix][ic + 1];
                            }
                        }
                        --this.cs.Na;
                        --this.cs.Ms;
                        this.cs.jWater = -1;
                        this.checkPlotInfo();
                        this.modified = true;
                        this.setupFrame();
                        break;
                    }
                    if (n == 2) {
                        if (this.dbg) {
                            System.out.println(" ---- Remove water and all its reactions");
                        }
                        this.setVisible(false);
                        final ModifyChemSyst thisModify = this;
                        Thread mod = new Thread(){

                            @Override
                            public void run() {
                                ModifyConfirm modifyC = new ModifyConfirm(thisModify.getLocation(), ModifyChemSyst.this.ch, ModifyChemSyst.this.compToDelete, -99, ModifyChemSyst.this.pc);
                                boolean cancel = modifyC.waitForModifyConfirm();
                                thisModify.cs = ((ModifyChemSyst)ModifyChemSyst.this).ch.chemSystem;
                                thisModify.namn = ((ModifyChemSyst)ModifyChemSyst.this).cs.namn;
                                if (!cancel) {
                                    ModifyChemSyst.this.checkPlotInfo();
                                    ModifyChemSyst.this.modified = true;
                                    ((ModifyChemSyst)ModifyChemSyst.this).cs.jWater = -1;
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ModifyChemSyst.this.setupFrame();
                                        thisModify.setVisible(true);
                                    }
                                });
                            }
                        };
                        mod.start();
                        break;
                    }
                    this.setupFrame();
                    break;
                }
                this.compToDelete = this.jListSolubComps.getSelectedIndex() >= 0 ? this.jListSolubComps.getSelectedIndex() : this.jListSolidComps.getSelectedIndex() + (this.cs.Na - this.cs.solidC);
                if (this.dbg) {
                    System.out.println(" ---- Remove component \"" + this.namn.identC[this.compToDelete] + "\"");
                }
                this.setVisible(false);
                final ModifyChemSyst thisModify = this;
                Thread mod = new Thread(){

                    @Override
                    public void run() {
                        ModifyConfirm modifyC = new ModifyConfirm(thisModify.getLocation(), ModifyChemSyst.this.ch, ModifyChemSyst.this.compToDelete, -99, ModifyChemSyst.this.pc);
                        boolean cancel = modifyC.waitForModifyConfirm();
                        thisModify.cs = ((ModifyChemSyst)ModifyChemSyst.this).ch.chemSystem;
                        thisModify.namn = ((ModifyChemSyst)ModifyChemSyst.this).cs.namn;
                        if (!cancel) {
                            ModifyChemSyst.this.checkPlotInfo();
                            ModifyChemSyst.this.modified = true;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ModifyChemSyst.this.setupFrame();
                                thisModify.setVisible(true);
                            }
                        });
                    }
                };
                mod.start();
                break;
            }
            case 2: {
                int i1;
                int ix;
                String onlyOne = "";
                if (this.jListSolubCmplx.getSelectedIndex() >= 0 && this.jListSolubCmplx.getMaxSelectionIndex() == this.jListSolubCmplx.getMinSelectionIndex()) {
                    onlyOne = this.jListSolubCmplx.getSelectedValue().toString();
                }
                if (this.jListSolidCmplx.getSelectedIndex() >= 0) {
                    onlyOne = this.jListSolidCmplx.getMaxSelectionIndex() == this.jListSolidCmplx.getMinSelectionIndex() ? (onlyOne.length() == 0 ? this.jListSolidCmplx.getSelectedValue().toString() : "") : "";
                }
                onlyOne = onlyOne.length() == 0 ? "selected reactions" : "\"" + onlyOne + "\"";
                Object[] options = new Object[]{"Cancel", "Yes"};
                int n = JOptionPane.showOptionDialog(this, "Remove " + onlyOne + " ?", "Modify Chemical System", 0, 2, null, options, null);
                if (n != 1) {
                    this.setupFrame();
                    break;
                }
                n = JOptionPane.showOptionDialog(this, "Warning!\nRemoving reactions will probably result in wrong diagrams !\n\nRemove " + onlyOne + " anyway?", "Modify Chemical System", 0, 2, null, options, null);
                if (n != 1) {
                    this.setupFrame();
                    break;
                }
                int ixCount = 0;
                for (int i = 0; i < this.listSolubleCmplxModel.getSize(); ++i) {
                    ix = i;
                    if (this.jListSolubCmplx.isSelectedIndex(i)) {
                        ++ixCount;
                        continue;
                    }
                    if (ixCount <= 0) continue;
                    i1 = ix - ixCount;
                    this.namn.ident[this.cs.Na + i1] = this.namn.ident[this.cs.Na + ix];
                    this.cs.lBeta[i1] = this.cs.lBeta[ix];
                    System.arraycopy(this.cs.a[ix], 0, this.cs.a[i1], 0, this.cs.Na);
                }
                this.cs.Ms -= ixCount;
                this.cs.nx -= ixCount;
                int ifCount = 0;
                for (int i = 0; i < this.listSolidCmplxModel.getSize(); ++i) {
                    ix = this.cs.nx + ixCount + i;
                    if (this.jListSolidCmplx.isSelectedIndex(i)) {
                        ++ifCount;
                        continue;
                    }
                    int iCount = ixCount + ifCount;
                    if (iCount <= 0) continue;
                    i1 = ix - iCount;
                    this.namn.ident[this.cs.Na + i1] = this.namn.ident[this.cs.Na + ix];
                    this.cs.lBeta[i1] = this.cs.lBeta[ix];
                    System.arraycopy(this.cs.a[ix], 0, this.cs.a[i1], 0, this.cs.Na);
                }
                this.cs.Ms -= ifCount;
                this.cs.mSol -= ifCount;
                this.modified = true;
                this.setupFrame();
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, "Please, select either:\n    - a component, or\n    - one or more reaction products\nfrom the lists.", "Modify Chemical System", 2);
                this.setupFrame();
            }
        }
    }

    private void exchangeComponentWithComplex() {
        int[] solidSel;
        int i;
        if (this.listSolubleCmplxModel.getSize() <= 0 && this.listSolidCmplxModel.getSize() <= 0) {
            return;
        }
        this.disableButtons();
        this.compToDelete = -1;
        this.compToDelete = this.jListSolubComps.getSelectedIndex();
        if (this.compToDelete < 0) {
            this.compToDelete = this.jListSolidComps.getSelectedIndex();
            if (this.compToDelete >= 0) {
                this.compToDelete += this.cs.Na - this.cs.solidC;
            }
        }
        if (this.compToDelete < 0) {
            String msg = "list";
            if (this.listSolubleCompModel.getSize() > 0 && this.listSolidCompModel.getSize() > 0) {
                msg = "lists";
            }
            JOptionPane.showMessageDialog(this, "Please, select one component from the " + msg + ".", "Modify Chemical System", 2);
            this.setupFrame();
            return;
        }
        int complxs = 0;
        for (i = 0; i < this.cs.nx; ++i) {
            if (!(Math.abs(this.cs.a[i][this.compToDelete]) > 1.0E-7)) continue;
            ++complxs;
            break;
        }
        if (complxs <= 0) {
            for (int is = 0; is < this.cs.mSol - this.cs.solidC; ++is) {
                i = is + this.cs.nx;
                if (!(Math.abs(this.cs.a[i][this.compToDelete]) > 1.0E-7)) continue;
                ++complxs;
                break;
            }
        }
        if (complxs <= 0) {
            String comp = this.namn.identC[this.compToDelete];
            JOptionPane.showMessageDialog(this, "\"" + comp + "\" does not form any reaction products.\n\n" + "Can not exchange this component.", "Modify Chemical System", 2);
            this.setupFrame();
            return;
        }
        this.complxToExchange = -1;
        int[] cmplxSel = this.jListSolubCmplx.getSelectedIndices();
        if (cmplxSel.length == 1) {
            this.complxToExchange = this.jListSolubCmplx.getSelectedIndex();
        }
        if (this.complxToExchange < 0 && (solidSel = this.jListSolidCmplx.getSelectedIndices()).length == 1) {
            this.complxToExchange = this.jListSolidCmplx.getSelectedIndex() + this.listSolubleCmplxModel.getSize();
        }
        if (this.complxToExchange < 0) {
            this.complxToExchange = -1;
        }
        if (this.dbg) {
            System.out.println(" ---- Exchange \"" + this.namn.identC[this.compToDelete] + "\" with reaction=" + this.complxToExchange);
        }
        this.setVisible(false);
        final ModifyChemSyst thisModify = this;
        Thread exch = new Thread(){

            @Override
            public void run() {
                ModifyConfirm modifyC = new ModifyConfirm(thisModify.getLocation(), ModifyChemSyst.this.ch, ModifyChemSyst.this.compToDelete, ModifyChemSyst.this.complxToExchange, ModifyChemSyst.this.pc);
                boolean cancel = modifyC.waitForModifyConfirm();
                thisModify.cs = ((ModifyChemSyst)ModifyChemSyst.this).ch.chemSystem;
                thisModify.namn = ((ModifyChemSyst)ModifyChemSyst.this).cs.namn;
                if (!cancel) {
                    ModifyChemSyst.this.checkPlotInfo();
                    ModifyChemSyst.this.modified = true;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ModifyChemSyst.this.setupFrame();
                        thisModify.setVisible(true);
                    }
                });
            }
        };
        exch.start();
    }

    private void checkLogKchange(final JList list, final int cmplx) {
        if (cmplx < 0) {
            return;
        }
        this.disableButtons();
        this.setVisible(false);
        final ModifyChemSyst thisModify = this;
        final int i = list.getSelectedIndex();
        Thread lgK = new Thread(){

            @Override
            public void run() {
                LogKchange logKc = new LogKchange(ModifyChemSyst.this.cs, cmplx);
                boolean cancel = logKc.waitForLogKchange();
                if (!cancel) {
                    ModifyChemSyst.this.modified = true;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ModifyChemSyst.this.modified) {
                            CardLayout cl = (CardLayout)ModifyChemSyst.this.jPanel1Top.getLayout();
                            cl.show(ModifyChemSyst.this.jPanel1Top, "cardNewSystem");
                            ModifyChemSyst.this.jTextFieldDataFile.setEnabled(false);
                        }
                        ModifyChemSyst.this.setupFrame();
                        thisModify.setVisible(true);
                        list.setSelectedIndex(i);
                        list.requestFocusInWindow();
                    }
                });
            }
        };
        lgK.start();
    }

    private void mergeTwoSystems() {
        int ic2;
        int ic1;
        int ic;
        Chem.ChemSystem csNew;
        int found;
        if (this.modified) {
            JOptionPane.showMessageDialog(this, "Please save first this modified chemical system.\nOnly existing (un-modified) data files can be merged.", "Modify Chemical System", 2);
            return;
        }
        Object[] options = new Object[]{"Cancel", "Yes"};
        int answ = JOptionPane.showOptionDialog(this, "<html><b>Note: a merged chemical system<br>is probably incomplete.</b><br>For example, after merging the two systems:<br>&nbsp;&nbsp;&nbsp;H+, Ca+2, Cl&#x2212;,<br>&nbsp;&nbsp;&nbsp;H+, Fe+3, CO3&#x2212;2,<br>you will <b>NOT</b> have chloride complexes of Fe(III)<br>nor calcium carbonate!<br><br>Are you <b>sure</b> that you still want to do this?</html>", "Modify Chemical System", 0, 2, null, options, null);
        if (answ != 1) {
            return;
        }
        this.disableButtons();
        String fileName2 = Util.getOpenFileName((Component)this, (String)this.pc.progName, (boolean)true, (String)"Select data file to merge with this chemical system:", (int)5, null, (String)this.pc.pathDef.toString());
        if (fileName2 == null) {
            this.setupFrame();
            return;
        }
        File dataFile2 = new File(fileName2);
        if (dataFile2.getPath().equalsIgnoreCase(this.dataFile.getPath())) {
            JOptionPane.showMessageDialog(this, "File \"" + dataFile2.getPath() + "\"\n" + "is already open!", "Modify Chemical System", 0);
            this.setupFrame();
            return;
        }
        this.setCursor(new Cursor(3));
        if (this.dbg) {
            System.out.println(" ---- merge with data file = \"" + dataFile2.getName() + "\"");
        }
        Chem ch2 = null;
        boolean ok = this.readDataFile(dataFile2, this.pc.dbg, ch2);
        if (ch2 == null || !ok) {
            System.out.println("Error reading file \"" + dataFile2.getName() + "\"");
            this.setupFrame();
            this.setCursor(new Cursor(0));
            return;
        }
        if (this.dbg) {
            System.out.println(" ---- data file read: \"" + dataFile2.getName() + "\"");
        }
        Chem.ChemSystem cs2 = ch2.chemSystem;
        Chem.ChemSystem.NamesEtc namn2 = cs2.namn;
        Chem.Diagr diag2 = ch2.diag;
        Chem.DiagrConcs dgrC2 = ch2.diagrConcs;
        int Ms = this.cs.Ms;
        int mSol = this.cs.mSol;
        if (this.cs.solidC > 0) {
            Ms = this.cs.Ms - this.cs.solidC;
            mSol = this.cs.mSol - this.cs.solidC;
        }
        int mSol2 = cs2.mSol;
        if (cs2.solidC > 0) {
            mSol2 = cs2.mSol - cs2.solidC;
        }
        int naOut = this.cs.Na;
        int solidC_Out = this.cs.solidC;
        for (int ic22 = 0; ic22 < cs2.Na; ++ic22) {
            found = -1;
            for (int ic12 = 0; ic12 < this.cs.Na; ++ic12) {
                if (!Util.nameCompare((String)this.namn.identC[ic12], (String)namn2.identC[ic22])) continue;
                found = ic12;
                break;
            }
            namn2.iel[ic22] = found;
            if (found >= 0) continue;
            ++naOut;
            if (this.dbg) {
                System.out.println("Component to add: \"" + namn2.identC[ic22] + "\"");
            }
            if (ic22 > cs2.Na - cs2.solidC - 1) {
                ++solidC_Out;
            }
            for (int ix1 = this.cs.Na; ix1 < Ms; ++ix1) {
                if (!Util.nameCompare((String)this.namn.ident[ix1], (String)namn2.identC[ic22])) continue;
                JOptionPane.showMessageDialog(this, "Big trouble!\n\ncomponent: \"" + namn2.identC[ic22] + "\"\n" + "in file \"" + dataFile2.getName() + "\"\n" + "has the same name as reaction product: \"" + this.namn.ident[ix1] + "\"\n" + "in file \"" + this.dataFile.getName() + "\"\n\n" + "Please switch a component/reaction.\n" + "Terminating . . .", "Modify Chemical System", 0);
                if (this.dbg) {
                    System.out.println("Component in file \"" + dataFile2.getName() + "\"" + nl + "   has the same name as reaction in file \"" + this.dataFile.getName() + "\"." + nl + "   Can not continue merge.");
                }
                this.setupFrame();
                this.setCursor(new Cursor(0));
                return;
            }
        }
        int newSolidComps = solidC_Out - this.cs.solidC;
        int newSolblComps = naOut - this.cs.Na - newSolidComps;
        if (this.dbg) {
            System.out.println("New components= " + (naOut - this.cs.Na) + "  total= " + naOut + nl + "   new components: soluble= " + newSolblComps + "  solid= " + newSolidComps);
        }
        ArrayList<String> identCM = new ArrayList<String>();
        for (int i = 0; i < naOut; ++i) {
            identCM.add(i, null);
        }
        for (int ic13 = 0; ic13 < this.cs.Na; ++ic13) {
            if (ic13 > this.cs.Na - this.cs.solidC - 1) {
                this.namn.iel[ic13] = ic13 + newSolblComps;
                identCM.set(ic13 + newSolblComps, this.namn.identC[ic13]);
                continue;
            }
            this.namn.iel[ic13] = ic13;
            identCM.set(ic13, this.namn.identC[ic13]);
        }
        int iaCount = 0;
        for (int ic23 = 0; ic23 < cs2.Na; ++ic23) {
            if (namn2.iel[ic23] >= 0) continue;
            int iaNew = ++iaCount <= newSolblComps ? iaCount + (this.cs.Na - this.cs.solidC - 1) : iaCount + this.cs.Na - 1;
            identCM.set(iaNew, namn2.identC[ic23]);
            namn2.iel[ic23] = iaNew;
        }
        if (this.dbg) {
            System.out.println("Components:");
            System.out.print("    ");
            int n0 = 0;
            int nM = naOut - 1;
            int iPl = 5;
            int nP = nM - n0;
            if (nP >= 0) {
                block14: for (int ijj = 0; ijj <= nP / iPl; ++ijj) {
                    for (int jjj = 0; jjj < iPl; ++jjj) {
                        int kjj = n0 + (ijj * iPl + jjj);
                        System.out.format(" %15s", identCM.get(kjj));
                        if (kjj <= nM - 1) continue;
                        System.out.println();
                        break block14;
                    }
                    System.out.println();
                    System.out.print("    ");
                }
            }
        }
        int nxOut = this.cs.nx;
        ArrayList<String> identM = new ArrayList<String>();
        ArrayList<Double> lBetaM = new ArrayList<Double>();
        ArrayList<Double[]> aM = new ArrayList<Double[]>();
        double[] a1 = new double[naOut];
        double[] a2 = new double[naOut];
        for (int ix2 = 0; ix2 < cs2.nx; ++ix2) {
            int ic3;
            found = -1;
            for (int ix1 = 0; ix1 < this.cs.nx; ++ix1) {
                if (!Util.nameCompare((String)this.namn.ident[ix1 + this.cs.Na], (String)namn2.ident[ix2 + cs2.Na])) continue;
                found = ix1;
                break;
            }
            if (found < 0) {
                if (this.dbg) {
                    System.out.println("New soluble complex: " + namn2.ident[ix2 + cs2.Na]);
                }
                for (int ic14 = 0; ic14 < this.cs.Na; ++ic14) {
                    if (!Util.nameCompare((String)this.namn.identC[ic14], (String)namn2.ident[ix2 + cs2.Na])) continue;
                    JOptionPane.showMessageDialog(this, "Big trouble!\n\ncomplex: \"" + namn2.ident[ix2 + cs2.Na] + "\"\n" + "in file \"" + dataFile2.getName() + "\"\n" + "has the same name as component: \"" + this.namn.identC[ic14] + "\"\n" + "in file \"" + this.dataFile.getName() + "\"\n\n" + "Please switch a component/complex.\n" + "Terminating . . .", "Modify Chemical System", 0);
                    if (this.dbg) {
                        System.out.println("Complex in file \"" + dataFile2.getName() + "\"" + nl + "   has the same name as component in file \"" + this.dataFile.getName() + "\"." + nl + "   Can not continue merge.");
                    }
                    this.setupFrame();
                    this.setCursor(new Cursor(0));
                    return;
                }
                ++nxOut;
                identM.add(namn2.ident[ix2 + cs2.Na]);
                lBetaM.add(cs2.lBeta[ix2]);
                aM.add(new Double[cs2.Na]);
                for (int i = 0; i < cs2.Na; ++i) {
                    ((Double[])aM.get((int)(aM.size() - 1)))[i] = cs2.a[ix2][i];
                }
                int iz = lBetaM.size() - 1;
                continue;
            }
            for (ic3 = 0; ic3 < naOut; ++ic3) {
                a1[ic3] = 0.0;
                a2[ic3] = 0.0;
            }
            for (ic3 = 0; ic3 < this.cs.Na; ++ic3) {
                a1[this.namn.iel[ic3]] = this.cs.a[found][ic3];
            }
            for (ic3 = 0; ic3 < cs2.Na; ++ic3) {
                a2[namn2.iel[ic3]] = cs2.a[ix2][ic3];
            }
            for (ic3 = 0; ic3 < naOut; ++ic3) {
                if (!(Math.abs(a1[ic3] - a2[ic3]) > 1.0E-4)) continue;
                JOptionPane.showMessageDialog(this, "Big trouble!\n\nthe complex \"" + this.namn.ident[found + this.cs.Na] + "\" exists both\n" + "in file \"" + dataFile2.getName() + "\" and\n" + "in file \"" + this.dataFile.getName() + "\",\n" + "but the stoichiometries are different!\n\n" + "Please correct the input files.\nTerminating . . .", "Modify Chemical System", 0);
                if (this.dbg) {
                    System.out.println("Complex has the same name in both files but different stoichiometries." + nl + "   Can not continue merge.");
                }
                this.setupFrame();
                this.setCursor(new Cursor(0));
                return;
            }
            if (!(Math.abs(this.cs.lBeta[found] - cs2.lBeta[ix2]) > 0.02)) continue;
            JOptionPane.showMessageDialog(this, "Warning:\n\nlogK = " + this.cs.lBeta[found] + "for complex \"" + this.namn.ident[found + this.cs.Na] + "\"\n" + "in file \"" + this.dataFile.getName() + "\"\n" + "but logK = " + cs2.lBeta[ix2] + "in file \"" + dataFile2.getName() + "\",\n\n" + "The first value will be used.", "Modify Chemical System", 1);
        }
        int newSolblComplxs = nxOut - this.cs.nx;
        if (this.dbg) {
            System.out.println("New soluble complexes= " + newSolblComplxs + "  total=" + nxOut);
        }
        int mSolOut = mSol + solidC_Out;
        for (int ix2 = cs2.nx; ix2 < cs2.nx + mSol2; ++ix2) {
            int ic4;
            found = -1;
            for (int ix1 = this.cs.nx; ix1 < this.cs.nx + mSol; ++ix1) {
                if (!Util.nameCompare((String)this.namn.ident[ix1 + this.cs.Na], (String)namn2.ident[ix2 + cs2.Na])) continue;
                found = ix1;
                break;
            }
            if (found < 0) {
                if (this.dbg) {
                    System.out.println("New solid reaction: " + namn2.ident[ix2 + cs2.Na]);
                }
                for (int ic15 = 0; ic15 < this.cs.Na; ++ic15) {
                    if (!Util.nameCompare((String)this.namn.identC[ic15], (String)namn2.ident[ix2 + cs2.Na])) continue;
                    JOptionPane.showMessageDialog(this, "Big trouble!\n\nsolid product: \"" + namn2.ident[ix2 + cs2.Na] + "\"\n" + "in file \"" + dataFile2.getName() + "\"\n" + "has the same name as component: \"" + this.namn.identC[ic15] + "\"\n" + "in file \"" + this.dataFile.getName() + "\"\n\n" + "Please switch a component/reaction.\n" + "Terminating . . .", "Modify Chemical System", 0);
                    if (this.dbg) {
                        System.out.println("Solid product in file \"" + dataFile2.getName() + "\"" + nl + "   has the same name as component in file \"" + this.dataFile.getName() + "\"." + nl + "   Can not continue merge.");
                    }
                    this.setupFrame();
                    this.setCursor(new Cursor(0));
                    return;
                }
                ++mSolOut;
                identM.add(namn2.ident[ix2 + cs2.Na]);
                lBetaM.add(cs2.lBeta[ix2]);
                aM.add(new Double[cs2.Na]);
                for (int i = 0; i < cs2.Na; ++i) {
                    ((Double[])aM.get((int)(aM.size() - 1)))[i] = cs2.a[ix2][i];
                }
                continue;
            }
            for (ic4 = 0; ic4 < naOut; ++ic4) {
                a1[ic4] = 0.0;
                a2[ic4] = 0.0;
            }
            for (ic4 = 0; ic4 < this.cs.Na; ++ic4) {
                a1[this.namn.iel[ic4]] = this.cs.a[found][ic4];
            }
            for (ic4 = 0; ic4 < cs2.Na; ++ic4) {
                a2[namn2.iel[ic4]] = cs2.a[ix2][ic4];
            }
            for (ic4 = 0; ic4 < naOut; ++ic4) {
                if (!(Math.abs(a1[ic4] - a2[ic4]) > 1.0E-4)) continue;
                JOptionPane.showMessageDialog(this, "Big trouble!\n\nthe solid product \"" + this.namn.ident[found + this.cs.Na] + "\" exists both\n" + "in file \"" + dataFile2.getName() + "\" and\n" + "in file \"" + this.dataFile.getName() + "\",\n" + "but the stoichiometries are different!\n\n" + "Please correct the input files.\nTerminating . . .", "Modify Chemical System", 0);
                if (this.dbg) {
                    System.out.println("Solid product has the same name in both files but different stoichiometries." + nl + "   Can not continue merge.");
                }
                this.setupFrame();
                this.setCursor(new Cursor(0));
                return;
            }
            if (!(Math.abs(this.cs.lBeta[found] - cs2.lBeta[ix2]) > 0.02)) continue;
            JOptionPane.showMessageDialog(this, "Warning:\n\nlogK = " + this.cs.lBeta[found] + "for reaction \"" + this.namn.ident[found + this.cs.Na] + "\"\n" + "in file \"" + this.dataFile.getName() + "\"\n" + "but logK = " + cs2.lBeta[ix2] + "in file \"" + dataFile2.getName() + "\",\n\n" + "The first value will be used.", "Modify Chemical System", 1);
        }
        int newSolidComplxs = mSolOut - (mSol + solidC_Out);
        if (this.dbg) {
            System.out.println("New solid products= " + newSolidComplxs + "  total= " + (mSolOut - solidC_Out));
        }
        if (Double.isNaN(this.diagr.temperature) && !Double.isNaN(diag2.temperature)) {
            if (this.dbg) {
                System.out.println("Setting temperature to: " + diag2.temperature);
            }
            this.diagr.temperature = diag2.temperature;
        }
        if (!Double.isNaN(this.diagr.temperature) && !Double.isNaN(diag2.temperature) && Math.abs(this.diagr.temperature - diag2.temperature) > 1.0E-4 && this.dbg) {
            System.out.println("Warning: different temperatures." + nl + "  in file \"" + this.dataFile.getName() + "\" t=" + this.diagr.temperature + nl + "  but in file \"" + dataFile2.getName() + "\" t=" + diag2.temperature + "," + nl + "  keeping t = " + this.diagr.temperature);
        }
        if (Double.isNaN(this.diagr.pressure) && !Double.isNaN(diag2.pressure)) {
            if (this.dbg) {
                System.out.println("Setting pressure to: " + diag2.pressure);
            }
            this.diagr.pressure = diag2.pressure;
        }
        if (!Double.isNaN(this.diagr.pressure) && !Double.isNaN(diag2.pressure) && Math.abs(this.diagr.pressure - diag2.pressure) > 1.0E-4 && this.dbg) {
            System.out.println("Warning: different pressures." + nl + "  in file \"" + this.dataFile.getName() + "\" P=" + this.diagr.pressure + nl + "  but in file \"" + dataFile2.getName() + "\" P=" + diag2.pressure + "," + nl + "  keeping P = " + this.diagr.pressure);
        }
        if (diag2.title != null && this.diagr.title == null) {
            if (this.dbg) {
                System.out.println("Setting title to: \"" + diag2.title + "\"");
            }
            this.diagr.title = diag2.title;
        }
        if (this.diagr.title != null && diag2.title != null && this.dbg) {
            System.out.println("Warning: title in merge file discarded.");
        }
        try {
            Chem chem = this.ch;
            chem.getClass();
            csNew = new Chem.ChemSystem(chem, naOut, naOut + nxOut + mSolOut, mSolOut);
        }
        catch (Chem.ChemicalParameterException ex) {
            ex.printStackTrace();
            csNew = null;
        }
        Chem.ChemSystem.NamesEtc namnNew = null;
        if (csNew != null) {
            try {
                Chem.ChemSystem chemSystem = csNew;
                chemSystem.getClass();
                namnNew = new Chem.ChemSystem.NamesEtc(chemSystem, naOut, naOut + nxOut + mSolOut, mSolOut);
            }
            catch (Chem.ChemicalParameterException ex) {
                ex.printStackTrace();
                namnNew = null;
            }
        }
        if (csNew == null || namnNew == null) {
            this.storeInitialSystem(this.ch);
            this.modified = true;
            this.setupFrame();
            this.setCursor(new Cursor(0));
            return;
        }
        if (this.dbg) {
            System.out.print("New chemical system: components total= " + naOut + "  of which solid=" + solidC_Out + nl + "  reactions: soluble=" + nxOut + "  solid=" + (mSolOut - solidC_Out) + nl + "  total number of species = " + (naOut + nxOut + mSolOut));
            if (solidC_Out > 0) {
                System.out.print(" (including solids corresponding to solid components)");
            }
            System.out.println();
        }
        boolean plotInfoGiven = this.diagr.plotType >= 0 && this.diagr.compX >= 0 && this.dgrC.hur[0] > 0;
        Chem.DiagrConcs dgrCNew = null;
        if (plotInfoGiven) {
            try {
                Chem chem = this.ch;
                chem.getClass();
                dgrCNew = new Chem.DiagrConcs(chem, naOut);
            }
            catch (Chem.ChemicalParameterException ex) {
                plotInfoGiven = false;
                dgrCNew = null;
                ex.printStackTrace();
            }
        }
        csNew.chemConcs = this.cs.chemConcs;
        csNew.solidC = solidC_Out;
        csNew.nx = nxOut;
        for (int ic16 = 0; ic16 < this.cs.Na; ++ic16) {
            namnNew.identC[this.namn.iel[ic16]] = this.namn.identC[ic16];
            namnNew.ident[this.namn.iel[ic16]] = this.namn.identC[ic16];
        }
        for (int ic24 = 0; ic24 < cs2.Na; ++ic24) {
            namnNew.identC[namn2.iel[ic24]] = namn2.identC[ic24];
            namnNew.ident[namn2.iel[ic24]] = namn2.identC[ic24];
        }
        for (int ix1 = 0; ix1 < this.cs.nx; ++ix1) {
            namnNew.ident[naOut + ix1] = this.namn.ident[this.cs.Na + ix1];
            csNew.lBeta[ix1] = this.cs.lBeta[ix1];
            for (ic = 0; ic < naOut; ++ic) {
                csNew.a[ix1][ic] = 0.0;
            }
            for (ic1 = 0; ic1 < this.cs.Na; ++ic1) {
                csNew.a[ix1][this.namn.iel[ic1]] = this.cs.a[ix1][ic1];
            }
        }
        for (int ixM = 0; ixM < newSolblComplxs; ++ixM) {
            namnNew.ident[naOut + this.cs.nx + ixM] = (String)identM.get(ixM);
            csNew.lBeta[this.cs.nx + ixM] = (Double)lBetaM.get(ixM);
            for (ic = 0; ic < naOut; ++ic) {
                csNew.a[this.cs.nx + ixM][ic] = 0.0;
            }
            for (ic2 = 0; ic2 < cs2.Na; ++ic2) {
                csNew.a[this.cs.nx + ixM][namn2.iel[ic2]] = ((Double[])aM.get(ixM))[ic2];
            }
        }
        for (int if1 = 0; if1 < mSol; ++if1) {
            namnNew.ident[naOut + nxOut + if1] = this.namn.ident[this.cs.Na + this.cs.nx + if1];
            csNew.lBeta[nxOut + if1] = this.cs.lBeta[this.cs.nx + if1];
            for (ic = 0; ic < naOut; ++ic) {
                csNew.a[nxOut + if1][ic] = 0.0;
            }
            for (ic1 = 0; ic1 < this.cs.Na; ++ic1) {
                csNew.a[nxOut + if1][this.namn.iel[ic1]] = this.cs.a[this.cs.nx + if1][ic1];
            }
        }
        int soFar = nxOut + mSol;
        for (int ifM = newSolblComplxs; ifM < newSolblComplxs + newSolidComplxs; ++ifM) {
            int ifS = ifM - newSolblComplxs;
            namnNew.ident[naOut + soFar + ifS] = (String)identM.get(ifM);
            csNew.lBeta[soFar + ifS] = (Double)lBetaM.get(ifM);
            for (int ic5 = 0; ic5 < naOut; ++ic5) {
                csNew.a[soFar + ifS][ic5] = 0.0;
            }
            for (int ic25 = 0; ic25 < cs2.Na; ++ic25) {
                csNew.a[soFar + ifS][namn2.iel[ic25]] = ((Double[])aM.get(ifM))[ic25];
            }
        }
        if (this.diagr.compMain >= 0) {
            this.diagr.compMain = this.namn.iel[this.diagr.compMain];
        }
        if (this.diagr.compX >= 0) {
            this.diagr.compX = this.namn.iel[this.diagr.compX];
        }
        if (this.diagr.compY >= 0) {
            this.diagr.compY = this.namn.iel[this.diagr.compY];
        }
        if (plotInfoGiven && dgrCNew != null) {
            for (ic1 = 0; ic1 < this.cs.Na; ++ic1) {
                if (this.dgrC.hur[ic1] <= 0) continue;
                dgrCNew.hur[this.namn.iel[ic1]] = this.dgrC.hur[ic1];
                dgrCNew.cLow[this.namn.iel[ic1]] = this.dgrC.cLow[ic1];
                dgrCNew.cHigh[this.namn.iel[ic1]] = this.dgrC.cHigh[ic1];
            }
            for (ic2 = 0; ic2 < cs2.Na; ++ic2) {
                if (dgrC2.hur[ic2] <= 0) continue;
                dgrCNew.hur[namn2.iel[ic2]] = dgrC2.hur[ic2];
                dgrCNew.cLow[namn2.iel[ic2]] = dgrC2.cLow[ic2];
                dgrCNew.cHigh[namn2.iel[ic2]] = dgrC2.cHigh[ic2];
            }
        }
        this.ch.chemSystem = csNew;
        this.ch.chemSystem.namn = namnNew;
        try {
            Chem chem = this.ch;
            chem.getClass();
            this.ch.diagrConcs = new Chem.DiagrConcs(chem, naOut);
        }
        catch (Chem.ChemicalParameterException ex) {
            ex.printStackTrace();
            return;
        }
        this.cs = csNew;
        this.namn = namnNew;
        this.diagr = this.ch.diag;
        this.dgrC = dgrCNew;
        this.cs = csNew;
        this.namn = namnNew;
        this.dgrC = dgrCNew;
        if (plotInfoGiven && this.dgrC != null) {
            for (ic = 0; ic < this.cs.Na; ++ic) {
                if (this.dgrC.hur[ic] > 0) continue;
                DefaultPlotAndConcs.setDefaultConc((int)ic, (String)this.namn.identC[ic], (Chem.DiagrConcs)this.dgrC);
            }
        }
        ReadChemSyst.addFictiveSolids((Chem.ChemSystem)this.cs);
        this.storeInitialSystem(this.ch);
        this.modified = true;
        if (this.dbg) {
            System.out.println(" ---- Merge successful.");
        }
        this.setupFrame();
        this.setCursor(new Cursor(0));
    }

    public static String reactionText(Chem.ChemSystem cs, int complex, boolean logK) {
        String stoich;
        double w;
        int ic;
        if (cs == null || cs.namn == null) {
            return "** Error **";
        }
        if (complex < 0 || complex >= cs.Ms - cs.Na) {
            return noReactionMessage;
        }
        boolean first = true;
        String text = "";
        for (ic = 0; ic < cs.Na; ++ic) {
            w = cs.a[complex][ic];
            if (!(w > 0.0)) continue;
            if (first) {
                stoich = "";
                first = false;
            } else {
                stoich = " +";
            }
            if (Math.abs(w - 1.0) > 1.0E-6) {
                stoich = stoich + Util.formatNumAsInt((double)w);
            }
            text = text + stoich + " " + cs.namn.identC[ic];
        }
        text = text + " = ";
        first = true;
        for (ic = 0; ic < cs.Na; ++ic) {
            w = -cs.a[complex][ic];
            if (!(w > 0.0)) continue;
            if (first) {
                stoich = "";
                first = false;
            } else {
                stoich = " +";
            }
            if (Math.abs(w - 1.0) > 1.0E-6) {
                stoich = stoich + Util.formatNumAsInt((double)w);
            }
            text = text + stoich + " " + cs.namn.identC[ic];
        }
        stoich = first ? " " : " + ";
        text = Util.rTrim((String)text) + stoich + cs.namn.ident[complex + cs.Na];
        if (logK) {
            text = text + ";  logK=" + Util.formatNum((double)cs.lBeta[complex]);
        }
        return text;
    }

    private boolean readDataFile(File dtaFile, boolean dbg, Chem chm) {
        double w;
        ReadDataLib rd;
        try {
            rd = new ReadDataLib(dtaFile);
        }
        catch (ReadDataLib.DataFileException ex) {
            System.err.println("Error: " + ex.getMessage());
            return false;
        }
        if (dbg) {
            System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - - -");
            System.out.println("Reading input data file \"" + dtaFile + "\"");
        }
        boolean warn = true;
        try {
            chm = ReadChemSyst.readChemSystAndPlotInfo((ReadDataLib)rd, (boolean)dbg, (boolean)warn, (PrintStream)System.out);
        }
        catch (ReadChemSyst.DataLimitsException ex) {
            System.err.println(ex.getMessage());
        }
        catch (ReadChemSyst.ReadDataFileException ex) {
            System.err.println(ex.getMessage());
        }
        catch (ReadChemSyst.PlotDataException ex) {
        }
        catch (ReadChemSyst.ConcDataException ex) {
            // empty catch block
        }
        if (chm == null) {
            System.out.println("Error: \"readChemSystAndPlotInfo\" returns null for file \"" + dtaFile.getName() + "\"");
            try {
                rd.close();
            }
            catch (ReadDataLib.ReadDataLibException ex) {
                System.err.println(ex.getMessage());
            }
            return false;
        }
        this.ch = chm;
        try {
            w = rd.getTemperature();
        }
        catch (ReadDataLib.DataReadException ex) {
            System.err.println(nl + ex.getMessage());
            w = Double.NaN;
        }
        chm.diag.temperature = w;
        try {
            w = rd.getPressure();
        }
        catch (ReadDataLib.DataReadException ex) {
            System.err.println(nl + ex.getMessage());
            w = Double.NaN;
        }
        chm.diag.pressure = w;
        if (chm.diag.plotType >= 0 && chm.diagrConcs.hur[0] >= 1) {
            try {
                chm.diag.title = rd.readLine();
            }
            catch (ReadDataLib.DataEofException ex) {
                chm.diag.title = null;
            }
            catch (ReadDataLib.DataReadException ex) {
                chm.diag.title = null;
            }
        }
        try {
            rd.close();
        }
        catch (ReadDataLib.ReadDataLibException ex) {
            System.err.println(ex.getMessage());
            return false;
        }
        if (dbg) {
            System.out.println("Finished reading the input data file");
            System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - - -");
        }
        return true;
    }

    private void setupFrame() {
        int solidComplexes;
        int i;
        this.jTextFieldDataFile.setText(this.dataFile.getPath());
        int solubleComps = this.cs.Na - this.cs.solidC;
        if (solubleComps <= 0) {
            this.jLabel1.setText("No Soluble Components");
        } else if (solubleComps == 1) {
            this.jLabel1.setText("1 Soluble Component:");
        } else if (solubleComps > 1) {
            this.jLabel1.setText(solubleComps + " Soluble Components:");
        }
        this.listSolubleCompModel.clear();
        if (solubleComps >= 1) {
            for (i = 0; i < solubleComps; ++i) {
                this.listSolubleCompModel.addElement(this.namn.identC[i]);
            }
        }
        if (this.cs.solidC <= 0) {
            this.jLabel3.setText("No Solid Components");
        } else if (this.cs.solidC == 1) {
            this.jLabel3.setText("1 Solid Component:");
        } else if (this.cs.solidC > 1) {
            this.jLabel3.setText(this.cs.solidC + " Solid Components:");
        }
        this.listSolidCompModel.clear();
        if (this.cs.solidC >= 1) {
            for (i = solubleComps; i < this.cs.Na; ++i) {
                this.listSolidCompModel.addElement(this.namn.identC[i]);
            }
        }
        if (this.cs.nx <= 0) {
            this.jLabel2.setText("No Soluble Complexes");
        } else if (this.cs.nx == 1) {
            this.jLabel2.setText("1 Soluble Complex:");
        } else if (this.cs.nx > 1) {
            this.jLabel2.setText(this.cs.nx + " Soluble Complexes:");
        }
        this.listSolubleCmplxModel.clear();
        if (this.cs.nx >= 1) {
            for (i = this.cs.Na; i < this.cs.Na + this.cs.nx; ++i) {
                this.listSolubleCmplxModel.addElement(this.namn.ident[i]);
            }
        }
        if ((solidComplexes = this.cs.mSol - this.cs.solidC) <= 0) {
            this.jLabel4.setText("No Solid Products");
        } else if (solidComplexes == 1) {
            this.jLabel4.setText("1 Solid Product:");
        } else if (solidComplexes > 1) {
            this.jLabel4.setText(solidComplexes + " Solid Products:");
        }
        this.listSolidCmplxModel.clear();
        if (solidComplexes >= 1) {
            for (int i2 = this.cs.Na + this.cs.nx; i2 < this.cs.Ms - this.cs.solidC; ++i2) {
                this.listSolidCmplxModel.addElement(this.namn.ident[i2]);
            }
        }
        if (!this.modified) {
            this.jTextFieldDataFile.setEnabled(true);
        } else {
            CardLayout cl = (CardLayout)this.jPanel1Top.getLayout();
            cl.show(this.jPanel1Top, "cardNewSystem");
            this.jTextFieldDataFile.setEnabled(false);
        }
        this.jButton_Delete.setEnabled(true);
        this.jButton_Delete.setText("<html><u>D</u>elete</html>");
        this.jButton_Delete.setForeground(Color.black);
        this.jButton_Exchange.setEnabled(true);
        this.jButton_Exchange.setForeground(Color.black);
        this.jButton_Merge.setEnabled(true);
        this.jButton_Merge.setForeground(Color.black);
        this.jButton_Save.setEnabled(true);
        this.jButton_Save.setForeground(Color.black);
        this.jButtonUp.setEnabled(false);
        this.jButtonDn.setEnabled(false);
        if (this.listSolubleCmplxModel.getSize() <= 0 && this.listSolidCmplxModel.getSize() <= 0) {
            this.jButton_Exchange.setEnabled(false);
            this.jButton_Exchange.setForeground(Color.gray);
        }
    }

    private void storeInitialSystem(Chem chem) {
        int i;
        this.Na0 = chem.chemSystem.Na;
        if (chem.diag.compX >= 0) {
            this.compXname0 = chem.chemSystem.namn.identC[chem.diag.compX];
        }
        if (chem.diag.compY >= 0) {
            this.compYname0 = chem.chemSystem.namn.identC[chem.diag.compY];
        }
        if (chem.diag.compMain >= 0) {
            this.compMainName0 = chem.chemSystem.namn.identC[chem.diag.compMain];
        }
        if (this.identC0.size() > 0) {
            for (i = this.identC0.size() - 1; i >= 0; --i) {
                this.identC0.remove(i);
            }
        }
        for (i = 0; i < chem.chemSystem.Na; ++i) {
            this.identC0.add(i, chem.chemSystem.namn.identC[i]);
        }
    }

    private void upDownComponent(boolean up) {
        double w;
        String compToMoveName;
        boolean impossibleMove = false;
        int compToMove = this.jListSolubComps.getSelectedIndex();
        if (compToMove >= 0) {
            if (compToMove == 0 && up) {
                impossibleMove = true;
            }
            if (compToMove >= this.listSolubleCompModel.getSize() - 1 && !up) {
                impossibleMove = true;
            }
            compToMoveName = this.jListSolubComps.getSelectedValue().toString();
        } else {
            compToMove = this.jListSolidComps.getSelectedIndex();
            if (compToMove == 0 && up) {
                impossibleMove = true;
            }
            if (compToMove >= this.listSolidCompModel.getSize() - 1 && !up) {
                impossibleMove = true;
            }
            compToMoveName = this.jListSolidComps.getSelectedValue().toString();
            if (compToMove >= 0) {
                compToMove += this.cs.Na - this.cs.solidC;
            }
        }
        if (impossibleMove) {
            String move = "up";
            if (!up) {
                move = "down";
            }
            System.err.println("Programming error: impossible move \"" + move + "\"" + " of component " + compToMove + " \"" + compToMoveName + "\"");
            this.setupFrame();
            return;
        }
        if (compToMove < 0) {
            String msg = "list";
            if (this.listSolubleCompModel.getSize() > 0 && this.listSolidCompModel.getSize() > 0) {
                msg = "lists";
            }
            JOptionPane.showMessageDialog(this, "Please, select one component from the " + msg + ".", "Modify Chemical System", 2);
            this.setupFrame();
            return;
        }
        this.disableButtons();
        int otherCompMoved = up ? compToMove - 1 : compToMove + 1;
        this.setCursor(new Cursor(3));
        for (int ic = 0; ic < this.cs.Na; ++ic) {
            this.namn.iel[ic] = ic;
        }
        this.namn.iel[otherCompMoved] = compToMove;
        this.namn.iel[compToMove] = otherCompMoved;
        String other = this.namn.identC[otherCompMoved];
        this.namn.identC[otherCompMoved] = compToMoveName;
        this.namn.identC[compToMove] = other;
        this.namn.ident[otherCompMoved] = this.namn.identC[otherCompMoved];
        this.namn.ident[compToMove] = this.namn.identC[compToMove];
        boolean plotInfoGiven = false;
        if (this.diagr.plotType >= 0 && this.diagr.compX >= 0 && this.dgrC.hur[0] >= 1) {
            plotInfoGiven = true;
        }
        if (plotInfoGiven) {
            this.diagr.compX = this.namn.iel[this.diagr.compX];
            if (this.diagr.compY >= 0) {
                this.diagr.compY = this.namn.iel[this.diagr.compY];
            }
            if (this.diagr.compMain >= 0) {
                this.diagr.compMain = this.namn.iel[this.diagr.compMain];
            }
            int otherHur = this.dgrC.hur[otherCompMoved];
            this.dgrC.hur[otherCompMoved] = this.dgrC.hur[compToMove];
            this.dgrC.hur[compToMove] = otherHur;
            w = this.dgrC.cLow[otherCompMoved];
            this.dgrC.cLow[otherCompMoved] = this.dgrC.cLow[compToMove];
            this.dgrC.cLow[compToMove] = w;
            w = this.dgrC.cHigh[otherCompMoved];
            this.dgrC.cHigh[otherCompMoved] = this.dgrC.cHigh[compToMove];
            this.dgrC.cHigh[compToMove] = w;
        }
        for (int ix = 0; ix < this.cs.Ms - this.cs.Na; ++ix) {
            w = this.cs.a[ix][otherCompMoved];
            this.cs.a[ix][otherCompMoved] = this.cs.a[ix][compToMove];
            this.cs.a[ix][compToMove] = w;
        }
        this.modified = true;
        this.storeInitialSystem(this.ch);
        this.setupFrame();
        if (compToMove < this.cs.Na - this.cs.solidC) {
            this.jListSolubComps.setSelectedIndex(otherCompMoved);
        } else {
            this.jListSolidComps.setSelectedIndex(otherCompMoved - (this.cs.Na - this.cs.solidC));
        }
        this.component_Click();
        this.setCursor(new Cursor(0));
    }
}

