/*
 * Decompiled with CFR 0.152.
 */
package simpleEquilibriumDiagrams;

import java.awt.AWTKeyStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import simpleEquilibriumDiagrams.SED;

public class Debugging
extends JDialog {
    private boolean finished = false;
    private final SED sed;
    private final Dimension windowSize;
    private final PrintStream err;
    private static final String nl = System.getProperty("line.separator");
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxDbgH;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public Debugging(Frame parent, boolean modal, SED sed0, PrintStream err0) {
        super(parent, modal);
        this.err = err0 != null ? err0 : System.err;
        this.initComponents();
        this.sed = sed0;
        this.finished = false;
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Debugging.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        AbstractAction altXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Debugging.this.jButtonOK.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_X", altXAction);
        Set<AWTKeyStroke> keys = this.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(39, 0));
        this.setFocusTraversalKeys(0, newKeys);
        keys = this.getFocusTraversalKeys(1);
        newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(37, 0));
        this.setFocusTraversalKeys(1, newKeys);
        this.setTitle(" SED: Debugging in HaltaFall");
        int left = Math.max(0, (SED.screenSize.width - this.getWidth()) / 2);
        int top = Math.max(0, (SED.screenSize.height - this.getHeight()) / 2);
        this.setLocation(Math.min(SED.screenSize.width - 100, left), Math.min(SED.screenSize.height - 100, top));
        this.windowSize = this.getSize();
        int calcDbgHalta = Math.max(0, Math.min(this.jComboBoxDbgH.getItemCount() - 1, this.sed.dbgHalta));
        this.jComboBoxDbgH.setSelectedIndex(calcDbgHalta);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBoxDbgH = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Debugging.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Debugging.this.formComponentResized(evt);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setText("<html>Select output level from HaltaFall</html>");
        this.jComboBoxDbgH.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxDbgH.setModel(new DefaultComboBoxModel<String>(new String[]{"0 - none", "1 - errors only", "2 - errors + results", "3 - errors + results + input", "4 = 3 + output from Fasta", "5 = 3 + output from activity coeffs.", "6 = 4 + lots of output"}));
        this.jLabel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel2.setText("<html>Note: printout is <u>only</u> performed on<br> the first 5 calculation points.</html>");
        this.jButtonOK.setFont(new Font("Dialog", 0, 11));
        this.jButtonOK.setMnemonic('O');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Debugging.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Debugging.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxDbgH, 0, 284, Short.MAX_VALUE).addComponent(this.jLabel1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jButtonOK, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel)).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDbgH, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap(21, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.sed.dbgHalta = Integer.parseInt(this.jComboBoxDbgH.getSelectedItem().toString().substring(0, 2).trim());
        this.closeWindow();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.closeWindow();
    }

    private void closeWindow() {
        this.finished = true;
        this.notify_All();
        this.dispose();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public synchronized void waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

