/*
 * Decompiled with CFR 0.152.
 */
package lib.database;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lib.common.Util;
import lib.database.AddDataElem;
import lib.database.LibDB;
import lib.huvud.ProgramConf;
import lib.huvud.RunProgr;

public class DBnamesDialog
extends JDialog {
    private ProgramConf pc;
    private final ArrayList<String[]> elemComp;
    private final ArrayList<String> dbList;
    private final ArrayList<String> dbListLocal;
    private StringBuffer pathDatabaseFiles;
    private final DefaultListModel dBnamesModel = new DefaultListModel();
    private Dimension windowSize = new Dimension(300, 200);
    private final Border defBorder;
    private final Border highlightedBorder = BorderFactory.createBevelBorder(1, Color.gray, Color.black);
    private static final String nl = System.getProperty("line.separator");
    public boolean cancel = false;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDn;
    private JButton jButtonOK;
    private JButton jButtonRemove;
    private JButton jButtonUp;
    private JLabel jLabelNr;
    private JList jListDBnames;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;

    public DBnamesDialog(Frame parent, boolean modal, ProgramConf pc0, ArrayList<String> dbList0, StringBuffer pathDatabaseFiles0, ArrayList<String[]> elemComp0) {
        super(parent, modal);
        int top;
        int left;
        this.initComponents();
        this.pc = pc0;
        this.dbList = dbList0;
        this.pathDatabaseFiles = pathDatabaseFiles0;
        this.elemComp = elemComp0;
        if (this.pathDatabaseFiles == null) {
            this.pathDatabaseFiles = new StringBuffer();
        }
        if (this.pathDatabaseFiles.length() > 0) {
            File f = new File(this.pathDatabaseFiles.toString());
            if (f.exists()) {
                if (f.isFile()) {
                    this.pathDatabaseFiles.replace(0, this.pathDatabaseFiles.length(), f.getParent());
                }
            } else if (this.pc.pathAPP != null && this.pc.pathAPP.trim().length() > 0) {
                this.pathDatabaseFiles.replace(0, this.pathDatabaseFiles.length(), this.pc.pathAPP);
            } else {
                this.pathDatabaseFiles.replace(0, this.pathDatabaseFiles.length(), ".");
            }
        }
        if (this.pc.dbg) {
            System.out.println("---- Select Databases ----");
        }
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBnamesDialog.this.cancel = true;
                DBnamesDialog.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        AbstractAction altXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBnamesDialog.this.jButtonOK.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_X", altXAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBnamesDialog.this.setCursor(new Cursor(3));
                String[] a = new String[]{"DB_Remove_change_data_htm"};
                RunProgr.runProgramInProcess((Component)DBnamesDialog.this, (String)"Chem_Diagr_Help.jar", (String[])a, (boolean)false, (boolean)((DBnamesDialog)DBnamesDialog.this).pc.dbg, (String)((DBnamesDialog)DBnamesDialog.this).pc.pathAPP);
                DBnamesDialog.this.setCursor(new Cursor(0));
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        KeyStroke altHKeyStroke = KeyStroke.getKeyStroke(72, 8, false);
        this.getRootPane().getInputMap(2).put(altHKeyStroke, "ALT_H");
        this.getRootPane().getActionMap().put("ALT_H", f1Action);
        Set<AWTKeyStroke> keys = this.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(39, 0));
        this.setFocusTraversalKeys(0, newKeys);
        keys = this.getFocusTraversalKeys(1);
        newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(37, 0));
        this.setFocusTraversalKeys(1, newKeys);
        this.setTitle(this.pc.progName + " - Set Database Names");
        this.defBorder = this.jScrollPane1.getBorder();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (parent != null) {
            left = Math.max(0, parent.getX() + parent.getWidth() / 2 - this.getWidth() / 2);
            top = Math.max(0, parent.getY() + parent.getHeight() / 2 - this.getHeight() / 2);
        } else {
            left = Math.max(0, (screenSize.width - this.getWidth()) / 2);
            top = Math.max(0, (screenSize.height - this.getHeight()) / 2);
        }
        this.setLocation(Math.min(screenSize.width - this.getWidth() - 20, left), Math.min(screenSize.height - this.getHeight() - 20, top));
        if (parent != null) {
            this.jButtonOK.setIcon(new ImageIcon(parent.getIconImage()));
        }
        this.dbListLocal = new ArrayList();
        this.dbListLocal.addAll(this.dbList);
        if (this.pc.dbg) {
            if (this.dbListLocal.size() > 0) {
                System.out.println("---- Database list:" + nl + this.dbListLocal.toString());
            } else {
                System.out.println("---- Database list is empty.");
            }
        }
        this.updateDBnames();
        this.windowSize = this.getSize();
        this.jButtonRemove.setEnabled(false);
        if (this.dBnamesModel.getSize() <= 0) {
            this.jButtonAdd.requestFocusInWindow();
        } else {
            this.jButtonOK.requestFocusInWindow();
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabelNr = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListDBnames = new JList();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel4 = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonUp = new JButton();
        this.jButtonDn = new JButton();
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DBnamesDialog.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DBnamesDialog.this.formComponentResized(evt);
            }
        });
        this.jLabelNr.setFont(new Font("Dialog", 1, 11));
        this.jLabelNr.setText("0 Databases");
        this.jScrollPane1.setFont(new Font("Dialog", 0, 11));
        this.jListDBnames.setFont(new Font("Dialog", 0, 11));
        this.jListDBnames.setModel(this.dBnamesModel);
        this.jListDBnames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DBnamesDialog.this.jListDBnamesMouseClicked(evt);
            }
        });
        this.jListDBnames.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DBnamesDialog.this.jListDBnamesValueChanged(evt);
            }
        });
        this.jListDBnames.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DBnamesDialog.this.jListDBnamesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                DBnamesDialog.this.jListDBnamesFocusLost(evt);
            }
        });
        this.jListDBnames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DBnamesDialog.this.jListDBnamesKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListDBnames);
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jPanel3.setFont(new Font("Dialog", 0, 11));
        this.jButtonOK.setFont(new Font("Dialog", 1, 12));
        this.jButtonOK.setIcon(new ImageIcon(this.getClass().getResource("/lib/database/images/Java_32x32.gif")));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.setToolTipText("exit");
        this.jButtonOK.setHorizontalTextPosition(0);
        this.jButtonOK.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonOK.setVerticalTextPosition(3);
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBnamesDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setFont(new Font("Dialog", 1, 12));
        this.jButtonCancel.setIcon(new ImageIcon(this.getClass().getResource("/lib/database/images/Quit_32x32.gif")));
        this.jButtonCancel.setMnemonic('C');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setToolTipText("quit");
        this.jButtonCancel.setHorizontalTextPosition(0);
        this.jButtonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonCancel.setVerticalTextPosition(3);
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBnamesDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jButtonOK, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, -2, 60, -2).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setFont(new Font("Dialog", 0, 11));
        this.jButtonAdd.setFont(new Font("Dialog", 1, 11));
        this.jButtonAdd.setMnemonic('a');
        this.jButtonAdd.setText("<html><u>A</u>dd another file</html>");
        this.jButtonAdd.setToolTipText("Add a new file to the list");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBnamesDialog.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonRemove.setFont(new Font("Dialog", 1, 11));
        this.jButtonRemove.setMnemonic('r');
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.setToolTipText("Remove the selected file from the list");
        this.jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBnamesDialog.this.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonUp.setFont(new Font("Dialog", 0, 11));
        this.jButtonUp.setIcon(new ImageIcon(this.getClass().getResource("/lib/database/images/ArrowUp.gif")));
        this.jButtonUp.setMnemonic('u');
        this.jButtonUp.setToolTipText("move Up (Alt-U)");
        this.jButtonUp.setIconTextGap(0);
        this.jButtonUp.setMargin(new Insets(0, 2, 0, 2));
        this.jButtonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBnamesDialog.this.jButtonUpActionPerformed(evt);
            }
        });
        this.jButtonDn.setFont(new Font("Dialog", 0, 11));
        this.jButtonDn.setIcon(new ImageIcon(this.getClass().getResource("/lib/database/images/ArrowDn.gif")));
        this.jButtonDn.setMnemonic('d');
        this.jButtonDn.setToolTipText("move Down (Alt-D)");
        this.jButtonDn.setIconTextGap(0);
        this.jButtonDn.setMargin(new Insets(0, 2, 0, 2));
        this.jButtonDn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBnamesDialog.this.jButtonDnActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jButtonAdd, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonRemove).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonUp, -2, 26, -2).addComponent(this.jButtonDn, -2, 26, -2)).addGap(14, 14, 14)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jButtonRemove, -2, 31, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jButtonAdd).addGroup(jPanel4Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jButtonUp, -2, 29, -2).addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonDn, -2, 29, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanel4, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel3, -2, -1, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel3, -2, 67, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel4, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelNr).addComponent(this.jPanel1, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelNr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 173, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, 68, -2).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancel = true;
        this.closeWindow();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.pc.dbg) {
            System.out.println("---- Exit: New database list:" + nl + this.dbListLocal.toString() + nl + "----");
        }
        this.dbList.clear();
        this.dbList.addAll(this.dbListLocal);
        this.closeWindow();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.cancel = true;
        if (this.pc.dbg) {
            System.out.println("---- Quit: database list unchanged.");
        }
        this.closeWindow();
    }

    private void jListDBnamesKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\u007f' || evt.getKeyChar() == '\b') {
            evt.consume();
            this.jButtonRemoveActionPerformed(null);
            return;
        }
        char c = Character.toUpperCase(evt.getKeyChar());
        if (evt.getKeyChar() != '\u001b' && evt.getKeyChar() != '\n' && (!evt.isAltDown() || c != 'X' && c != 'A' && c != 'R' && c != 'U' && c != 'D' && c != 'C' && c != 'O' && evt.getKeyChar() != '\n')) {
            evt.consume();
            this.dBnames_Click();
        }
    }

    private void jListDBnamesFocusGained(FocusEvent evt) {
        if (this.jListDBnames.isFocusOwner()) {
            this.jScrollPane1.setBorder(this.highlightedBorder);
        }
        if (this.dBnamesModel.getSize() > 0) {
            int i = Math.max(0, this.jListDBnames.getSelectedIndex());
            this.jListDBnames.setSelectedIndex(i);
            this.jListDBnames.ensureIndexIsVisible(i);
        }
    }

    private void jListDBnamesValueChanged(ListSelectionEvent evt) {
        int i = -1;
        if (this.dBnamesModel.getSize() > 0) {
            i = this.jListDBnames.getSelectedIndex();
        } else {
            this.jButtonRemove.setEnabled(false);
        }
        int n = this.dBnamesModel.size();
        if (i < 0 || i >= n) {
            this.jButtonRemove.setEnabled(false);
            return;
        }
        this.jButtonRemove.setEnabled(true);
        this.jButtonUp.setEnabled(i > 0);
        this.jButtonDn.setEnabled(i < n - 1);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        this.dBnames_Click();
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        this.dbNameRemove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonUpActionPerformed(ActionEvent evt) {
        int i = -1;
        if (this.dBnamesModel.getSize() > 0) {
            i = this.jListDBnames.getSelectedIndex();
        }
        if (i < 1 || i >= this.dBnamesModel.size()) {
            return;
        }
        DBnamesDialog dBnamesDialog = this;
        synchronized (dBnamesDialog) {
            String dbn = this.dBnamesModel.get(i).toString();
            if (this.pc.dbg) {
                System.out.println("---- Moving up: \"" + dbn + "\"");
            }
            String dbnUp = this.dBnamesModel.get(i - 1).toString();
            this.dbListLocal.set(i, dbnUp);
            this.dbListLocal.set(i - 1, dbn);
        }
        this.updateDBnames();
        this.jListDBnames.setSelectedIndex(i - 1);
        this.jListDBnames.ensureIndexIsVisible(i - 1);
        this.jListDBnames.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDnActionPerformed(ActionEvent evt) {
        int i = -1;
        if (this.dBnamesModel.getSize() > 0) {
            i = this.jListDBnames.getSelectedIndex();
        }
        if (i < 0 || i >= this.dBnamesModel.size() - 1) {
            return;
        }
        DBnamesDialog dBnamesDialog = this;
        synchronized (dBnamesDialog) {
            String dbn = this.dBnamesModel.get(i).toString();
            if (this.pc.dbg) {
                System.out.println("---- Moving down: \"" + dbn + "\"");
            }
            String dbnDn = this.dBnamesModel.get(i + 1).toString();
            this.dbListLocal.set(i, dbnDn);
            this.dbListLocal.set(i + 1, dbn);
        }
        this.updateDBnames();
        this.jListDBnames.setSelectedIndex(i + 1);
        this.jListDBnames.ensureIndexIsVisible(i + 1);
        this.jListDBnames.requestFocusInWindow();
    }

    private void jListDBnamesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            this.dBnames_Click();
        }
    }

    private void jListDBnamesFocusLost(FocusEvent evt) {
        if (!this.jListDBnames.isFocusOwner()) {
            this.jScrollPane1.setBorder(this.defBorder);
        }
    }

    private void closeWindow() {
        if (!this.cancel && this.dbListLocal.size() <= 0) {
            JOptionPane.showMessageDialog(this, "There are no databases selected?" + nl + "Please note that the program is useless without databases." + nl + nl, this.pc.progName, 2);
        }
        this.setVisible(false);
    }

    public void bringToFront() {
        if (this != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBnamesDialog.this.setVisible(true);
                    DBnamesDialog.this.setAlwaysOnTop(true);
                    DBnamesDialog.this.toFront();
                    DBnamesDialog.this.requestFocus();
                    DBnamesDialog.this.setAlwaysOnTop(false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dBnames_Click() {
        Serializable elemCompNewFile;
        String dbn;
        this.setCursorWait();
        if (this.pc.dbg) {
            System.out.println("dBnames_Click()");
        }
        if ((dbn = this.getDBFileName()) == null) {
            this.setCursorDef();
            this.jListDBnames.requestFocusInWindow();
            return;
        }
        if (!LibDB.isDBnameOK(dbn, this.pc.dbg)) {
            System.out.println("isDBnameOK(" + dbn + ") = false");
            return;
        }
        File dbf = new File(dbn);
        try {
            dbn = dbf.getCanonicalPath();
        }
        catch (IOException ex) {
            try {
                dbn = dbf.getAbsolutePath();
            }
            catch (Exception ex2) {
                dbn = dbf.getPath();
            }
        }
        String dbnEle = AddDataElem.getElemFileName(this.pc.dbg, this, dbn);
        if (dbnEle == null) {
            this.setCursorDef();
            return;
        }
        File dbfEle = new File(dbnEle);
        boolean binaryDB = dbn.toLowerCase().endsWith(".db");
        if (binaryDB) {
            if (!dbfEle.exists()) {
                String msg = "Could not find the \"element\"-file" + nl + "     \"" + dbfEle.getName() + "\"" + nl + "for database: \"" + dbf.getName() + "\"." + nl + nl + "The database can NOT be used.";
                Util.showErrMsg((Component)this, (String)msg, (int)1);
                return;
            }
        } else {
            if (!dbfEle.exists()) {
                String msg = "Could not find the \"element\"-file" + nl + "for database: \"" + dbf.getName() + "\"." + nl + nl + "The file \"" + dbfEle.getName() + "\" will be created.";
                System.out.println("--- Could not find the \"element\"-file for database: \"" + dbf.getName() + "\"");
                Object[] opt = new Object[]{"OK", "Cancel"};
                int m = JOptionPane.showOptionDialog(this, msg, this.pc.progName, 0, 2, null, opt, opt[0]);
                if (m != 0) {
                    if (this.pc.dbg) {
                        System.out.println("Cancelled by the user");
                    }
                    this.setCursorDef();
                    return;
                }
                ArrayList<String[]> elemCompNewFile2 = new ArrayList<String[]>();
                try {
                    AddDataElem.elemCompAdd_Update(this.pc.dbg, this, dbn, dbnEle, this.elemComp, elemCompNewFile2);
                }
                catch (AddDataElem.AddDataException ex) {
                    Util.exceptn((String)ex.toString());
                    if (!this.isVisible()) {
                        this.setVisible(true);
                    }
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.pc.progName, 0);
                    this.setCursorDef();
                    return;
                }
                try {
                    AddDataElem.addFileEle_Write(this.pc.dbg, dbnEle, elemCompNewFile2);
                }
                catch (AddDataElem.AddDataException ex) {
                    Util.exceptn((String)ex.toString());
                    if (!this.isVisible()) {
                        this.setVisible(true);
                    }
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.pc.progName, 0);
                    this.setCursorDef();
                    return;
                }
            }
            elemCompNewFile = new ArrayList();
            try {
                AddDataElem.elemCompAdd_Update(this.pc.dbg, this, dbn, dbnEle, this.elemComp, (ArrayList<String[]>)elemCompNewFile);
            }
            catch (AddDataElem.AddDataException ex) {
                Util.exceptn((String)ex.toString());
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
                JOptionPane.showMessageDialog(this, ex.getMessage(), this.pc.progName, 0);
                this.setCursorDef();
                return;
            }
        }
        elemCompNewFile = this;
        synchronized (elemCompNewFile) {
            int n = this.dbListLocal.size();
            boolean found = false;
            for (int j = 0; j < n; ++j) {
                if (!this.dbListLocal.get(j).equalsIgnoreCase(dbn)) continue;
                found = true;
                break;
            }
            if (!found) {
                if (this.pc.dbg) {
                    System.out.println("---- Adding database: \"" + dbn + "\"");
                }
                this.dbListLocal.add(dbn);
            }
        }
        this.updateDBnames();
        this.setCursorDef();
        this.jListDBnames.requestFocusInWindow();
        for (int i = 0; i < this.dBnamesModel.size(); ++i) {
            if (!this.dBnamesModel.get(i).equals(dbn)) continue;
            this.jListDBnames.setSelectedIndex(i);
            this.jListDBnames.ensureIndexIsVisible(i);
            break;
        }
        this.jButtonOK.requestFocusInWindow();
    }

    private String getDBFileName() {
        this.setCursor(new Cursor(3));
        String dbFileName = Util.getOpenFileName((Component)this, (String)this.pc.progName, (boolean)true, (String)"Select a database file:", (int)2, null, (String)this.pathDatabaseFiles.toString());
        if (dbFileName == null || dbFileName.trim().length() <= 0) {
            return null;
        }
        File dbFile = new File(dbFileName);
        if (this.pathDatabaseFiles.length() > 0) {
            this.pathDatabaseFiles.delete(0, this.pathDatabaseFiles.length());
        }
        this.pathDatabaseFiles.append(dbFile.getParent());
        return dbFileName;
    }

    private synchronized void dbNameRemove() {
        Object[] opt1;
        int m;
        int iold = -1;
        if (this.dBnamesModel.getSize() > 0) {
            iold = this.jListDBnames.getSelectedIndex();
        }
        if (iold < 0) {
            return;
        }
        String dbn = this.dBnamesModel.get(iold).toString();
        String warning = "";
        if (this.dBnamesModel.getSize() == 1) {
            warning = "Removing the last database is not a very good idea!" + nl + nl;
        }
        if ((m = JOptionPane.showOptionDialog(this, warning = warning + "Do you want to remove the database:" + nl + "   \"" + dbn + "\" ??", this.pc.progName, 0, 3, null, opt1 = new Object[]{"OK", "Cancel"}, opt1[1])) == 1) {
            this.jListDBnames.requestFocusInWindow();
            if (iold < this.dBnamesModel.getSize()) {
                this.jListDBnames.setSelectedIndex(iold);
                this.jListDBnames.ensureIndexIsVisible(iold);
            }
            return;
        }
        int n = this.dbListLocal.size();
        boolean found = false;
        int k = 0;
        for (int j = 0; j < n; ++j) {
            if (!this.dbListLocal.get(j).equalsIgnoreCase(dbn)) continue;
            k = j;
            found = true;
            break;
        }
        if (found) {
            if (this.pc.dbg) {
                System.out.println("---- Removing database: \"" + dbn + "\"");
            }
            this.dbListLocal.remove(k);
        }
        this.updateDBnames();
        this.jListDBnames.requestFocusInWindow();
        if (iold >= this.dBnamesModel.getSize()) {
            iold = this.dBnamesModel.getSize() - 1;
        }
        if (iold < this.dBnamesModel.getSize() && iold >= 0) {
            this.jListDBnames.setSelectedIndex(iold);
            this.jListDBnames.ensureIndexIsVisible(iold);
        }
    }

    private synchronized void updateDBnames() {
        this.dBnamesModel.clear();
        int n = this.dbListLocal.size();
        for (int i = 0; i < n; ++i) {
            this.dBnamesModel.addElement(this.dbListLocal.get(i));
        }
        String t = n == 1 ? "1 Database used:" : String.valueOf(n) + " Databases used:";
        this.jLabelNr.setText(t);
        if (this.dBnamesModel.getSize() <= 0) {
            this.jButtonAdd.setText("<html><u>A</u>dd a file</html>");
        } else {
            this.jButtonAdd.setText("<html><u>A</u>dd another file</html>");
        }
        this.jButtonUp.setEnabled(false);
        this.jButtonDn.setEnabled(false);
    }

    private void setCursorWait() {
        this.setCursor(new Cursor(3));
        this.jPanel1.setCursor(new Cursor(3));
    }

    private void setCursorDef() {
        this.setCursor(new Cursor(0));
        this.jPanel1.setCursor(new Cursor(0));
    }
}

