/*
 * Decompiled with CFR 0.152.
 */
package lib.database;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import lib.common.Util;
import lib.database.Complex;
import lib.database.LibSearch;
import lib.database.ProgramDataDB;
import lib.huvud.ProgramConf;
import lib.huvud.RunProgr;
import lib.huvud.SortedListModel;

public class FrameSingleComponent
extends JFrame {
    private ProgramConf pc;
    private ProgramDataDB pd;
    private boolean finished = false;
    private int n;
    private LibSearch hs;
    private Dimension windowSize = new Dimension(227, 122);
    private final DefaultListModel modelComplexes = new DefaultListModel();
    private final SortedListModel sortedModelComplexes = new SortedListModel((ListModel)this.modelComplexes);
    private boolean isPopup = false;
    private static final String nl = System.getProperty("line.separator");
    private static final String SLASH = File.separator;
    private JButton jButtonExit;
    private JButton jButtonSave;
    private JButton jButtonSearch;
    private JComboBox jComboBox;
    private JLabel jLabelFound;
    private JLabel jLabelN;
    private JLabel jLabelSpecies;
    private JLabel jLabelTop;
    private JList jList;
    private JMenuItem jMenuItemCancel;
    private JMenuItem jMenuItemRef;
    private JPanel jPanel1;
    private JPopupMenu jPopupMenu;
    private JScrollPane jScrollPaneList;
    private JPopupMenu.Separator jSeparator;

    public FrameSingleComponent(Frame parent, ProgramConf pc0, ProgramDataDB pd0) {
        int top;
        int left;
        this.initComponents();
        this.pc = pc0;
        this.pd = pd0;
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameSingleComponent.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameSingleComponent.this.setCursor(new Cursor(3));
                String[] a = new String[]{"DB_0_Main_htm"};
                RunProgr.runProgramInProcess((Component)FrameSingleComponent.this, (String)"Chem_Diagr_Help.jar", (String[])a, (boolean)false, (boolean)((FrameSingleComponent)FrameSingleComponent.this).pc.dbg, (String)((FrameSingleComponent)FrameSingleComponent.this).pc.pathAPP);
                FrameSingleComponent.this.setCursor(new Cursor(0));
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        KeyStroke altHKeyStroke = KeyStroke.getKeyStroke(72, 8, false);
        this.getRootPane().getInputMap(2).put(altHKeyStroke, "ALT_H");
        this.getRootPane().getActionMap().put("ALT_H", f1Action);
        KeyStroke altSKeyStroke = KeyStroke.getKeyStroke(83, 8, false);
        this.getRootPane().getInputMap(2).put(altSKeyStroke, "ALT_S");
        AbstractAction altSAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((FrameSingleComponent)FrameSingleComponent.this).pd.msgFrame != null) {
                    ((FrameSingleComponent)FrameSingleComponent.this).pd.msgFrame.setVisible(!((FrameSingleComponent)FrameSingleComponent.this).pd.msgFrame.isVisible());
                }
            }
        };
        this.getRootPane().getActionMap().put("ALT_S", altSAction);
        KeyStroke ctrlSKeyStroke = KeyStroke.getKeyStroke(83, 2, false);
        this.getRootPane().getInputMap(2).put(ctrlSKeyStroke, "CTRL_S");
        AbstractAction ctrlSAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameSingleComponent.this.jButtonSave.doClick();
            }
        };
        this.getRootPane().getActionMap().put("CTRL_S", ctrlSAction);
        Set<AWTKeyStroke> keys = this.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(39, 0));
        this.setFocusTraversalKeys(0, newKeys);
        keys = this.getFocusTraversalKeys(1);
        newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(37, 0));
        this.setFocusTraversalKeys(1, newKeys);
        String iconName = "images/Kemi.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            Util.exceptn((String)("Error: Could not load image = \"" + iconName + "\""));
        }
        if (parent != null) {
            this.jButtonExit.setIcon(new ImageIcon(parent.getIconImage()));
        }
        this.setTitle(this.pc.progName + " - Display a single component");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (parent != null) {
            left = Math.max(0, parent.getX() + parent.getWidth() / 2 - this.getWidth() / 2);
            top = Math.max(0, parent.getY() + parent.getHeight() / 2 - this.getHeight() / 2);
        } else {
            left = Math.max(0, (screenSize.width - this.getWidth()) / 2);
            top = Math.max(0, (screenSize.height - this.getHeight()) / 2);
        }
        this.setLocation(Math.min(screenSize.width - this.getWidth() - 20, left), Math.min(screenSize.height - this.getHeight() - 20, top));
        FrameSingleComponent.fillComboBox(this.jComboBox, this.pd.elemComp, this.pd.includeH2O);
        this.jComboBox.removeItemAt(0);
        this.jLabelTop.setText("<html>Select one of the following<br>" + this.jComboBox.getItemCount() + " components:</html>");
        if (this.pd.dataBasesList.size() > 1) {
            this.jLabelFound.setText("Contents of databases:");
        } else {
            this.jLabelFound.setText("Contents of the database:");
        }
        this.jLabelN.setText(" ");
        this.jLabelSpecies.setText(" ");
        this.jButtonSave.setEnabled(false);
        if (this.pd.references != null) {
            this.jMenuItemRef.setEnabled(true);
        } else {
            this.jMenuItemRef.setEnabled(false);
        }
    }

    public void start() {
        this.setVisible(true);
        this.pd.msgFrame.setParentFrame((JFrame)this);
        this.windowSize = this.getSize();
        this.jButtonExit.requestFocusInWindow();
    }

    private static void fillComboBox(JComboBox jComboBox, ArrayList<String[]> elemCompStr, boolean includeH2O) {
        int i;
        if (jComboBox == null) {
            Util.exceptn((String)"Error: \"JComboBox\" = null in \"fillComboBox\"");
            return;
        }
        if (elemCompStr == null || elemCompStr.size() <= 0) {
            Util.exceptn((String)"Error: \"elemCompStr\" empy in \"fillComboBox\"");
            return;
        }
        ArrayList<String> components = new ArrayList<String>();
        for (i = 0; i < elemCompStr.size(); ++i) {
            components.add(elemCompStr.get(i)[1]);
        }
        Collections.sort(components, String.CASE_INSENSITIVE_ORDER);
        jComboBox.removeAllItems();
        jComboBox.addItem(FrameSingleComponent.makeObj(" "));
        jComboBox.addItem(FrameSingleComponent.makeObj("H+"));
        jComboBox.addItem(FrameSingleComponent.makeObj("e-"));
        if (includeH2O) {
            jComboBox.addItem(FrameSingleComponent.makeObj("H2O"));
        }
        i = jComboBox.getItemCount() - 1;
        for (String t : components) {
            if (t.equals("H+") || t.equals("e-") || t.equals("H2O") || jComboBox.getItemAt(i).toString().equals(t)) continue;
            jComboBox.addItem(FrameSingleComponent.makeObj(t));
            ++i;
        }
    }

    private static Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    private void initComponents() {
        this.jPopupMenu = new JPopupMenu();
        this.jMenuItemRef = new JMenuItem();
        this.jSeparator = new JPopupMenu.Separator();
        this.jMenuItemCancel = new JMenuItem();
        this.jLabelTop = new JLabel();
        this.jComboBox = new JComboBox();
        this.jLabelFound = new JLabel();
        this.jLabelN = new JLabel();
        this.jLabelSpecies = new JLabel();
        this.jScrollPaneList = new JScrollPane();
        this.jList = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonExit = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSearch = new JButton();
        this.jMenuItemRef.setMnemonic('r');
        this.jMenuItemRef.setText("show References");
        this.jMenuItemRef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSingleComponent.this.jMenuItemRefActionPerformed(evt);
            }
        });
        this.jPopupMenu.add(this.jMenuItemRef);
        this.jPopupMenu.add(this.jSeparator);
        this.jMenuItemCancel.setText("Cancel");
        this.jMenuItemCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSingleComponent.this.jMenuItemCancelActionPerformed(evt);
            }
        });
        this.jPopupMenu.add(this.jMenuItemCancel);
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrameSingleComponent.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                FrameSingleComponent.this.formComponentResized(evt);
            }
        });
        this.jLabelTop.setFont(new Font("Dialog", 1, 11));
        this.jLabelTop.setText("<html>Select one of the following<br>321 components:</html>");
        this.jComboBox.setFont(new Font("Dialog", 0, 11));
        this.jComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabelFound.setFont(new Font("Dialog", 0, 11));
        this.jLabelFound.setText("Contents of databases:");
        this.jLabelN.setFont(new Font("Dialog", 0, 11));
        this.jLabelN.setText("000");
        this.jLabelSpecies.setFont(new Font("Dialog", 0, 11));
        this.jLabelSpecies.setText("species");
        this.jScrollPaneList.setFont(new Font("Monospaced", 0, 12));
        this.jList.setFont(new Font("Monospaced", 0, 12));
        this.jList.setModel(this.sortedModelComplexes);
        this.jList.setFocusable(false);
        this.jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrameSingleComponent.this.jListMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                FrameSingleComponent.this.jListMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                FrameSingleComponent.this.jListMouseReleased(evt);
            }
        });
        this.jList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrameSingleComponent.this.jListFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FrameSingleComponent.this.jListFocusLost(evt);
            }
        });
        this.jScrollPaneList.setViewportView(this.jList);
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jButtonExit.setFont(new Font("Dialog", 0, 11));
        this.jButtonExit.setIcon(new ImageIcon(this.getClass().getResource("/lib/database/images/Java_32x32.gif")));
        this.jButtonExit.setMnemonic('x');
        this.jButtonExit.setText("Exit");
        this.jButtonExit.setHorizontalTextPosition(0);
        this.jButtonExit.setMargin(new Insets(5, 2, 5, 2));
        this.jButtonExit.setVerticalTextPosition(3);
        this.jButtonExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSingleComponent.this.jButtonExitActionPerformed(evt);
            }
        });
        this.jButtonSave.setFont(new Font("Dialog", 0, 11));
        this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/lib/database/images/Save_32x32.gif")));
        this.jButtonSave.setMnemonic('a');
        this.jButtonSave.setText("Save");
        this.jButtonSave.setHorizontalTextPosition(0);
        this.jButtonSave.setMargin(new Insets(5, 2, 5, 2));
        this.jButtonSave.setVerticalTextPosition(3);
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSingleComponent.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSearch.setFont(new Font("Dialog", 0, 11));
        this.jButtonSearch.setIcon(new ImageIcon(this.getClass().getResource("/lib/database/images/Search_32x32.gif")));
        this.jButtonSearch.setMnemonic('e');
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.setHorizontalTextPosition(0);
        this.jButtonSearch.setMargin(new Insets(5, 2, 5, 2));
        this.jButtonSearch.setVerticalTextPosition(3);
        this.jButtonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSingleComponent.this.jButtonSearchActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jButtonSearch).addGap(31, 31, 31).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonExit)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonExit).addComponent(this.jButtonSave).addComponent(this.jButtonSearch));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelFound).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelN).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSpecies)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTop, -2, -1, -2).addComponent(this.jComboBox, -2, 205, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2)).addComponent(this.jScrollPaneList, -1, 421, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelTop, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox, -2, -1, -2).addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelFound).addComponent(this.jLabelN).addComponent(this.jLabelSpecies))).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneList, -1, 185, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        this.doSearch();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        PrintWriter pw;
        String fn;
        if (this.modelComplexes.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Nothig to save!", this.pc.progName, 1);
            return;
        }
        String d = this.pd.pathAddData.toString();
        if (!d.endsWith(SLASH)) {
            d = d + SLASH;
        }
        if ((fn = Util.getSaveFileName((Component)this, (String)this.pc.progName, (String)"Enter a file name:", (int)7, (String)(d + "single_comp.txt"), (String)this.pd.pathAddData.toString())) == null || fn.length() <= 0) {
            return;
        }
        File f = new File(fn);
        try {
            fn = f.getCanonicalPath();
        }
        catch (IOException ex) {
            fn = null;
        }
        if (fn == null) {
            try {
                fn = f.getAbsolutePath();
            }
            catch (Exception ex) {
                fn = f.getPath();
            }
        }
        if ((f = new File(fn)).exists()) {
            f.delete();
        }
        if (this.pc.dbg) {
            System.out.println("--- Saving file: \"" + fn + "\"");
        }
        try {
            pw = new PrintWriter(new FileWriter(f));
        }
        catch (IOException ex) {
            String msg = "Error: " + ex.toString() + nl + "while constructing a \"PrintWrite\" for file:" + nl + "\"" + fn + "\"";
            Util.exceptn((String)msg);
            JOptionPane.showMessageDialog(this, msg, this.pc.progName, 0);
            return;
        }
        pw.println("COMPLEX;LogK;DH_kJmol;DCp_Jmol;R1;N1;R2;N2;R3;N3;R4;N4;R5;N5;R6;N6;H;Reference / Comment");
        for (int i = 0; i < this.modelComplexes.getSize(); ++i) {
            pw.println(this.sortedModelComplexes.getElementAt(i).toString());
        }
        pw.close();
    }

    private void jButtonExitActionPerformed(ActionEvent evt) {
        this.closeWindow();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void jListFocusGained(FocusEvent evt) {
        int i = this.jList.getSelectedIndex();
        if (i < 0) {
            i = 0;
        }
        this.jList.setSelectedIndex(i);
        this.jList.ensureIndexIsVisible(i);
    }

    private void jListFocusLost(FocusEvent evt) {
        if (!this.jPopupMenu.isVisible()) {
            this.jList.clearSelection();
        }
    }

    private void jMenuItemCancelActionPerformed(ActionEvent evt) {
        this.jPopupMenu.setVisible(false);
    }

    private void jMenuItemRefActionPerformed(ActionEvent evt) {
        Complex cmplx;
        int index = this.jList.getSelectedIndex();
        if (this.pc.dbg) {
            System.out.println("jMenuItemRef(" + index + ")");
        }
        if (index < 0 || index >= this.modelComplexes.size()) {
            return;
        }
        try {
            cmplx = Complex.fromString(this.sortedModelComplexes.getElementAt(index).toString());
        }
        catch (Complex.ReadComplexException ex) {
            cmplx = null;
        }
        if (cmplx == null || cmplx.name == null) {
            return;
        }
        if (this.pc.dbg) {
            System.out.println("Show reference(s) for: \"" + cmplx.name + "\"" + nl + "   ref: \"" + cmplx.reference.trim() + "\"");
        }
        this.pd.references.displayRefs(this, true, cmplx.name, this.pd.references.splitRefs(cmplx.reference));
        this.jList.requestFocusInWindow();
        this.jList.setSelectedIndex(index);
    }

    private void jListMouseClicked(MouseEvent evt) {
        if (!this.isPopup) {
            return;
        }
        Point p = evt.getPoint();
        int i = this.jList.locationToIndex(p);
        if (i >= 0) {
            Rectangle r = this.jList.getCellBounds(i, i);
            if (p.y < r.y || p.y > r.y + r.height) {
                i = -1;
            }
            if (i >= 0) {
                this.jPopupMenu.show(this.jList, evt.getX(), evt.getY());
                this.jList.setSelectedIndex(i);
            }
        }
        this.isPopup = false;
    }

    private void jListMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.isPopup = true;
        }
    }

    private void jListMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.isPopup = true;
        }
    }

    private void closeWindow() {
        this.finished = true;
        this.notify_All();
        this.dispose();
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public synchronized void waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void bringToFront() {
        if (this != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FrameSingleComponent.this.setVisible(true);
                    if ((FrameSingleComponent.this.getExtendedState() & 1) == 1) {
                        FrameSingleComponent.this.setExtendedState(0);
                    }
                    FrameSingleComponent.this.setAlwaysOnTop(true);
                    FrameSingleComponent.this.toFront();
                    FrameSingleComponent.this.requestFocus();
                    FrameSingleComponent.this.setAlwaysOnTop(false);
                }
            });
        }
    }

    private void doSearch() {
        this.modelComplexes.clear();
        int i = this.jComboBox.getSelectedIndex();
        if (i < 0 || i >= this.jComboBox.getItemCount()) {
            JOptionPane.showMessageDialog(this, "Please select a component" + nl + "from the pull-down list.", this.pc.progName, 1);
            return;
        }
        this.setCursor(new Cursor(3));
        final String choosenComp = this.jComboBox.getItemAt(i).toString();
        final boolean isH = Util.isProton((String)choosenComp);
        try {
            this.hs = new LibSearch(this.pd);
        }
        catch (LibSearch.LibSearchException ex) {
            Util.exceptn((String)ex.toString());
            this.setCursor(new Cursor(0));
            return;
        }
        this.jLabelFound.setText("Checking species:");
        this.jLabelN.setText("0");
        this.jLabelSpecies.setText(" ");
        Thread srch = new Thread(){

            @Override
            public void run() {
                boolean fistComplex = true;
                FrameSingleComponent.this.n = 0;
                Complex cmplx = null;
                String errMsg = null;
                while (true) {
                    int j;
                    try {
                        cmplx = FrameSingleComponent.this.hs.getComplex(fistComplex);
                    }
                    catch (LibSearch.LibSearchException ex) {
                        String msg = ex.toString() + nl + "when reading complex nbr." + (FrameSingleComponent.this.n + 1);
                        Util.exceptn((String)msg);
                        JOptionPane.showMessageDialog(FrameSingleComponent.this, msg, ((FrameSingleComponent)FrameSingleComponent.this).pc.progName, 0);
                        System.err.println(Util.stack2string((Exception)ex));
                    }
                    if (cmplx == null) break;
                    if (cmplx.name.startsWith("@")) {
                        cmplx.name = cmplx.name.substring(1);
                        j = 0;
                        while (j < FrameSingleComponent.this.modelComplexes.getSize()) {
                            if (FrameSingleComponent.this.modelComplexes.get(j).toString().startsWith(cmplx.name)) {
                                final int jj = j;
                                try {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        @Override
                                        public void run() {
                                            FrameSingleComponent.this.modelComplexes.remove(jj);
                                        }
                                    });
                                }
                                catch (InterruptedException ex) {
                                    errMsg = ex.toString() + nl + "when reading complex nbr." + FrameSingleComponent.this.n;
                                    System.err.println(Util.stack2string((Exception)ex));
                                }
                                catch (InvocationTargetException ex) {
                                    errMsg = ex.toString() + nl + "when reading complex nbr." + FrameSingleComponent.this.n;
                                    System.err.println(Util.stack2string((Exception)ex));
                                }
                                if (errMsg == null) continue;
                                Util.exceptn(errMsg);
                                JOptionPane.showMessageDialog(FrameSingleComponent.this, errMsg, ((FrameSingleComponent)FrameSingleComponent.this).pc.progName, 0);
                                continue;
                            }
                            ++j;
                        }
                    } else {
                        boolean fnd = false;
                        for (j = 0; j < 6; ++j) {
                            if (!cmplx.component[j].equals(choosenComp) || !(Math.abs(cmplx.numcomp[j]) > 1.0E-4)) continue;
                            fnd = true;
                            break;
                        }
                        if (isH && Math.abs(cmplx.proton) > 1.0E-4) {
                            fnd = true;
                        }
                        if (fnd) {
                            FrameSingleComponent.this.n++;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    FrameSingleComponent.this.jLabelN.setText(String.valueOf(FrameSingleComponent.this.n));
                                }
                            });
                            final Object o = FrameSingleComponent.makeObj(cmplx.toString());
                            errMsg = null;
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        FrameSingleComponent.this.modelComplexes.addElement(o);
                                    }
                                });
                            }
                            catch (InterruptedException ex) {
                                errMsg = ex.toString() + nl + "when reading complex nbr." + FrameSingleComponent.this.n;
                                System.err.println(Util.stack2string((Exception)ex));
                            }
                            catch (InvocationTargetException ex) {
                                errMsg = ex.toString() + nl + "when reading complex nbr." + FrameSingleComponent.this.n;
                                System.err.println(Util.stack2string((Exception)ex));
                            }
                            if (errMsg != null) {
                                Util.exceptn(errMsg);
                                JOptionPane.showMessageDialog(FrameSingleComponent.this, errMsg, ((FrameSingleComponent)FrameSingleComponent.this).pc.progName, 0);
                            }
                        }
                    }
                    fistComplex = false;
                }
                FrameSingleComponent.this.n = FrameSingleComponent.this.modelComplexes.getSize();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (((FrameSingleComponent)FrameSingleComponent.this).pd.dataBasesList.size() > 1) {
                            FrameSingleComponent.this.jLabelFound.setText("Found in databases:");
                        } else {
                            FrameSingleComponent.this.jLabelFound.setText("Found in the database:");
                        }
                        FrameSingleComponent.this.jLabelN.setText(String.valueOf(FrameSingleComponent.this.n));
                        if (FrameSingleComponent.this.n >= 1) {
                            FrameSingleComponent.this.jLabelSpecies.setText("species");
                            FrameSingleComponent.this.jButtonSave.setEnabled(true);
                            FrameSingleComponent.this.jList.setFocusable(true);
                        } else {
                            FrameSingleComponent.this.jButtonSave.setEnabled(false);
                            FrameSingleComponent.this.jList.setFocusable(false);
                        }
                        FrameSingleComponent.this.jScrollPaneList.validate();
                        FrameSingleComponent.this.setCursor(new Cursor(0));
                    }
                });
            }
        };
        srch.start();
    }
}

