/*
 * Decompiled with CFR 0.152.
 */
package dataMaintenance;

import dataMaintenance.Main;
import dataMaintenance.Statistics;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.Border;
import lib.common.Util;
import lib.database.Complex;
import lib.database.DBnamesDialog;
import lib.database.FrameAddData;
import lib.database.FrameSingleComponent;
import lib.database.LibDB;
import lib.database.ProgramDataDB;
import lib.database.References;
import lib.huvud.Div;
import lib.huvud.ProgramConf;
import lib.huvud.RedirectedFrame;
import lib.huvud.RunProgr;
import lib.huvud.SortedProperties;

public class DataMaintenance
extends JFrame {
    private static final String vers = "2015-June-03";
    private static RedirectedFrame msgFrame = null;
    private final ProgramDataDB pd = new ProgramDataDB();
    private final ProgramConf pc;
    private Dimension windowSize = new Dimension(390, 230);
    private final DefaultListModel modelFiles = new DefaultListModel();
    private static final String DEF_DataBase = "Reactions.db";
    private static File fileIni;
    private static final String fileINI_name = "DataMaintenance.ini";
    private boolean working = false;
    private long cmplxNbr = 0L;
    private final double F_TXT_CMPLX = 54.15;
    private final double F_BIN_ELEM = 38.64;
    private final double F_BIN_CMPLX = 123.39;
    private double fLength;
    private final Set<Complex> dataList = new TreeSet<Complex>();
    private final Color frgrnd;
    private final Color bckgrnd;
    private boolean finished = false;
    private FrameAddData addData = null;
    private final Border defBorder;
    private final Border highlightedBorder = BorderFactory.createBevelBorder(1, Color.gray, Color.black);
    private boolean doNotExit = false;
    private boolean dispatchingArgs = false;
    private String fileCmplxSaveName = null;
    private static final String nl;
    private static final String SLASH;
    static final String LINE = "- - - - - - - - - - - - - - - - - - - - - - - - - - -";
    private JButton jButton2binary;
    private JButton jButton2text;
    private JButton jButtonAddData;
    private JButton jButtonCancel;
    private JButton jButtonExit;
    private JButton jButtonHelp;
    private JButton jButtonOpen;
    private JButton jButtonSave;
    private JButton jButtonSingle;
    private JButton jButtonStatistics;
    private JCheckBox jCheckBoxDebugFrame;
    private JLabel jLabelDataBases;
    private JLabel jLabelNbr;
    private JLabel jLabelSession;
    private JLabel jLabelVersion;
    private JList jListDBlist;
    private JPanel jPanelButtons;
    private JPanel jPanelOutput;
    private JPanel jPanelShow;
    private JProgressBar jProgressBar;
    private JScrollPane jScrollPaneDBlist;

    public DataMaintenance(ProgramConf pc0) {
        this.initComponents();
        this.pc = pc0;
        this.frgrnd = this.jButtonExit.getForeground();
        this.bckgrnd = this.jButtonExit.getBackground().darker();
        this.setDefaultCloseOperation(0);
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESCAPE");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataMaintenance.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ESCAPE", escAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        this.getRootPane().getActionMap().put("ALT_X", escAction);
        KeyStroke altSKeyStroke = KeyStroke.getKeyStroke(83, 8, false);
        this.getRootPane().getInputMap(2).put(altSKeyStroke, "ALT_S");
        AbstractAction altSAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataMaintenance.this.jCheckBoxDebugFrame.doClick();
            }
        };
        this.getRootPane().getActionMap().put("ALT_S", altSAction);
        Set<AWTKeyStroke> keys = this.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(39, 0));
        this.setFocusTraversalKeys(0, newKeys);
        keys = this.getFocusTraversalKeys(1);
        newKeys = new HashSet<AWTKeyStroke>(keys);
        newKeys.add(KeyStroke.getKeyStroke(37, 0));
        this.setFocusTraversalKeys(1, newKeys);
        this.defBorder = this.jScrollPaneDBlist.getBorder();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point frameLocation = new Point(-1000, -1000);
        frameLocation.x = Math.max(0, (screenSize.width - this.getWidth()) / 2);
        frameLocation.y = Math.max(0, (screenSize.height - this.getHeight()) / 2);
        this.setLocation(frameLocation);
        String iconName = "images/Data.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            Image icon = new ImageIcon(imgURL).getImage();
            this.setIconImage(icon);
            if (System.getProperty("os.name").startsWith("Mac OS")) {
                try {
                    Class<?> c = Class.forName("com.apple.eawt.Application");
                    Method m = c.getDeclaredMethod("setDockIconImage", Image.class);
                    Object i = c.newInstance();
                    Object[] paramsObj = new Object[]{icon};
                    m.invoke(i, paramsObj);
                }
                catch (Exception e) {
                    Util.exceptn("Error: " + e.getMessage());
                }
            }
        } else {
            Util.exceptn("Error: Could not load image = \"" + iconName + "\"");
        }
        this.setTitle("Data Maintenance");
        this.jButtonCancel.setEnabled(false);
        this.jLabelSession.setText(" ");
        this.jLabelVersion.setText("vers. 2015-June-03");
    }

    private void start(final String[] args) {
        String r;
        this.setVisible(true);
        if (msgFrame != null) {
            this.pd.msgFrame = msgFrame;
            this.pd.msgFrame.setParentFrame(this);
            if (this.pd.msgFrame.isVisible()) {
                this.jCheckBoxDebugFrame.setSelected(true);
            }
        } else {
            this.jCheckBoxDebugFrame.setEnabled(false);
        }
        this.readIni();
        for (int i = 0; i < this.pd.dataBasesList.size(); ++i) {
            this.modelFiles.addElement(this.pd.dataBasesList.get(i));
        }
        LibDB.getElements(this, this.pc, this.pd.dataBasesList, this.pd.elemComp);
        this.setFrameEnabled(true);
        this.windowSize = this.getSize();
        this.pd.references = new References(false);
        String dir = this.pc.pathAPP;
        if (dir != null) {
            if (dir.endsWith(SLASH)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            r = dir + SLASH + "References.txt";
        } else {
            r = "References.txt";
        }
        if (!this.pd.references.readRefsFile(r, this.pc.dbg)) {
            this.pd.references = null;
        }
        if (this.pc.pathAPP != null && this.pc.pathAPP.trim().length() > 0) {
            this.pd.pathDatabaseFiles.replace(0, this.pd.pathDatabaseFiles.length(), this.pc.pathAPP);
        } else {
            this.pd.pathDatabaseFiles.replace(0, this.pd.pathDatabaseFiles.length(), ".");
        }
        System.out.println(LINE);
        System.out.println("User's home directory: " + System.getProperty("user.home"));
        System.out.println("User's current working directory: " + System.getProperty("user.dir"));
        System.out.print("Application path: ");
        if (this.pc.pathAPP == null) {
            System.out.print("\"null\"");
        } else if (this.pc.pathAPP.trim().length() <= 0) {
            System.out.print("\"\"");
        } else {
            System.out.print(this.pc.pathAPP);
        }
        System.out.println();
        System.out.print("Add-data path: ");
        if (this.pd.pathAddData == null) {
            System.out.print("\"null\"");
        } else if (this.pd.pathAddData.toString().trim().length() <= 0) {
            System.out.print("\"\"");
        } else {
            System.out.print(this.pd.pathAddData);
        }
        System.out.println("Default path: " + this.pc.pathDef.toString());
        System.out.println(nl + LINE);
        if (args != null && args.length > 0) {
            Thread dArg = new Thread(){

                @Override
                public void run() {
                    for (String arg : args) {
                        DataMaintenance.this.dispatchingArgs = true;
                        DataMaintenance.this.dispatchArg(arg);
                        DataMaintenance.this.dispatchingArgs = false;
                    }
                    if (msgFrame == null || !msgFrame.isVisible() && !DataMaintenance.this.doNotExit) {
                        DataMaintenance.this.closeWindow();
                    }
                }
            };
            dArg.start();
        }
    }

    private void initComponents() {
        this.jButtonOpen = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonExit = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabelSession = new JLabel();
        this.jLabelDataBases = new JLabel();
        this.jScrollPaneDBlist = new JScrollPane();
        this.jListDBlist = new JList();
        this.jPanelButtons = new JPanel();
        this.jButtonStatistics = new JButton();
        this.jButtonAddData = new JButton();
        this.jButton2text = new JButton();
        this.jButton2binary = new JButton();
        this.jButtonSingle = new JButton();
        this.jPanelShow = new JPanel();
        this.jCheckBoxDebugFrame = new JCheckBox();
        this.jPanelOutput = new JPanel();
        this.jProgressBar = new JProgressBar();
        this.jButtonCancel = new JButton();
        this.jLabelNbr = new JLabel();
        this.jLabelVersion = new JLabel();
        this.setDefaultCloseOperation(3);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                DataMaintenance.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DataMaintenance.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DataMaintenance.this.formComponentResized(evt);
            }
        });
        this.jButtonOpen.setFont(new Font("Dialog", 0, 11));
        this.jButtonOpen.setMnemonic('o');
        this.jButtonOpen.setText("<html><center>Open<br>session</center></html>");
        this.jButtonOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMaintenance.this.jButtonOpenActionPerformed(evt);
            }
        });
        this.jButtonSave.setFont(new Font("Dialog", 0, 11));
        this.jButtonSave.setMnemonic('v');
        this.jButtonSave.setText("<html><center>Save<br>session</center></html>");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMaintenance.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonExit.setFont(new Font("Dialog", 0, 11));
        this.jButtonExit.setMnemonic('e');
        this.jButtonExit.setText("Exit");
        this.jButtonExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMaintenance.this.jButtonExitActionPerformed(evt);
            }
        });
        this.jButtonHelp.setFont(new Font("Dialog", 0, 11));
        this.jButtonHelp.setMnemonic('h');
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMaintenance.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabelSession.setFont(new Font("Dialog", 0, 11));
        this.jLabelSession.setText("<html><b>Session:</b> DataBaseMaintenance</html>");
        this.jLabelDataBases.setFont(new Font("Dialog", 1, 14));
        this.jLabelDataBases.setLabelFor(this.jScrollPaneDBlist);
        this.jLabelDataBases.setText("Databases:");
        this.jScrollPaneDBlist.setFont(new Font("Dialog", 0, 11));
        this.jListDBlist.setFont(new Font("Dialog", 0, 11));
        this.jListDBlist.setModel(this.modelFiles);
        this.jListDBlist.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DataMaintenance.this.jListDBlistMouseClicked(evt);
            }
        });
        this.jListDBlist.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DataMaintenance.this.jListDBlistFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                DataMaintenance.this.jListDBlistFocusLost(evt);
            }
        });
        this.jListDBlist.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DataMaintenance.this.jListDBlistKeyTyped(evt);
            }
        });
        this.jScrollPaneDBlist.setViewportView(this.jListDBlist);
        this.jPanelButtons.setFont(new Font("Dialog", 0, 11));
        this.jButtonStatistics.setFont(new Font("Dialog", 0, 11));
        this.jButtonStatistics.setMnemonic('c');
        this.jButtonStatistics.setText("<html><center>statistics<br>and<br>Checks</center></html>");
        this.jButtonStatistics.setMargin(new Insets(2, 7, 2, 7));
        this.jButtonStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMaintenance.this.jButtonStatisticsActionPerformed(evt);
            }
        });
        this.jButtonAddData.setFont(new Font("Dialog", 0, 11));
        this.jButtonAddData.setMnemonic('a');
        this.jButtonAddData.setText("<html><center>Add data<br>or edit<br>a text-file</center></html>");
        this.jButtonAddData.setMargin(new Insets(2, 7, 2, 7));
        this.jButtonAddData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMaintenance.this.jButtonAddDataActionPerformed(evt);
            }
        });
        this.jButton2text.setFont(new Font("Dialog", 0, 11));
        this.jButton2text.setMnemonic('t');
        this.jButton2text.setText("<html><center>convert binary<br>databases<br>to Text</center></html>");
        this.jButton2text.setMargin(new Insets(2, 7, 2, 7));
        this.jButton2text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMaintenance.this.jButton2textActionPerformed(evt);
            }
        });
        this.jButton2binary.setFont(new Font("Dialog", 0, 11));
        this.jButton2binary.setMnemonic('b');
        this.jButton2binary.setText("<html><center>merge all<br>databases to<br>a single Binary</center></html>");
        this.jButton2binary.setMargin(new Insets(2, 7, 2, 7));
        this.jButton2binary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMaintenance.this.jButton2binaryActionPerformed(evt);
            }
        });
        this.jButtonSingle.setFont(new Font("Dialog", 0, 11));
        this.jButtonSingle.setText("<html><center>show Data<br>for a single<br>component</center></html>");
        this.jButtonSingle.setMargin(new Insets(2, 7, 2, 7));
        this.jButtonSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMaintenance.this.jButtonSingleActionPerformed(evt);
            }
        });
        GroupLayout jPanelButtonsLayout = new GroupLayout(this.jPanelButtons);
        this.jPanelButtons.setLayout(jPanelButtonsLayout);
        jPanelButtonsLayout.setHorizontalGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonsLayout.createSequentialGroup().addComponent(this.jButtonStatistics, -2, -1, -2).addGap(12, 12, 12).addComponent(this.jButtonAddData, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2text, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2binary, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonSingle, -2, -1, -2).addContainerGap()));
        jPanelButtonsLayout.setVerticalGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelButtonsLayout.createSequentialGroup().addGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2binary, -2, -1, -2).addComponent(this.jButton2text, -2, -1, -2).addComponent(this.jButtonAddData, -2, -1, -2).addComponent(this.jButtonStatistics, -2, -1, -2).addComponent(this.jButtonSingle, -2, -1, -2)).addContainerGap()));
        this.jPanelShow.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxDebugFrame.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxDebugFrame.setMnemonic('s');
        this.jCheckBoxDebugFrame.setText("show messages window");
        this.jCheckBoxDebugFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMaintenance.this.jCheckBoxDebugFrameActionPerformed(evt);
            }
        });
        GroupLayout jPanelShowLayout = new GroupLayout(this.jPanelShow);
        this.jPanelShow.setLayout(jPanelShowLayout);
        jPanelShowLayout.setHorizontalGroup(jPanelShowLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelShowLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxDebugFrame).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelShowLayout.setVerticalGroup(jPanelShowLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxDebugFrame));
        this.jPanelOutput.setFont(new Font("Dialog", 0, 11));
        this.jProgressBar.setFont(new Font("Dialog", 0, 11));
        this.jProgressBar.setForeground(Color.blue);
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMaintenance.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabelNbr.setFont(new Font("Dialog", 0, 11));
        this.jLabelNbr.setText("0000");
        GroupLayout jPanelOutputLayout = new GroupLayout(this.jPanelOutput);
        this.jPanelOutput.setLayout(jPanelOutputLayout);
        jPanelOutputLayout.setHorizontalGroup(jPanelOutputLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOutputLayout.createSequentialGroup().addComponent(this.jButtonCancel).addGap(31, 31, 31).addComponent(this.jProgressBar, -2, 167, -2).addGap(18, 18, 18).addComponent(this.jLabelNbr).addContainerGap(186, Short.MAX_VALUE)));
        jPanelOutputLayout.setVerticalGroup(jPanelOutputLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelNbr, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addGroup(jPanelOutputLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jProgressBar, -2, 0, Short.MAX_VALUE).addGap(6, 6, 6)));
        this.jLabelVersion.setFont(new Font("Dialog", 0, 11));
        this.jLabelVersion.setText("vers. 2014-Aug-31");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelShow, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelOutput, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelButtons, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPaneDBlist).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelDataBases).addComponent(this.jLabelSession, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOpen, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jButtonSave, -2, -1, -2).addGap(38, 38, 38).addComponent(this.jButtonExit).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonHelp))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabelVersion))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOpen, -2, -1, -2).addComponent(this.jButtonSave, -2, -1, -2).addComponent(this.jButtonExit).addComponent(this.jButtonHelp)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelSession, -2, -1, -2).addGap(7, 7, 7).addComponent(this.jLabelDataBases).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneDBlist, -1, 88, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelButtons, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelShow, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelOutput, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabelVersion)));
        this.pack();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.windowSize != null) {
            int w = Math.round((float)this.windowSize.getWidth());
            int h = Math.round((float)this.windowSize.getHeight());
            if (this.getHeight() < h) {
                this.setSize(this.getWidth(), h);
            }
            if (this.getWidth() < w) {
                this.setSize(w, this.getHeight());
            }
        }
    }

    private void jButtonExitActionPerformed(ActionEvent evt) {
        this.closeWindow();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void jCheckBoxDebugFrameActionPerformed(ActionEvent evt) {
        if (this.pd.msgFrame != null) {
            this.pd.msgFrame.setVisible(this.jCheckBoxDebugFrame.isSelected());
            this.pd.msgFrame.setParentFrame(this);
        }
    }

    private void jButton2binaryActionPerformed(ActionEvent evt) {
        this.toBinary(this.pd.elemComp);
    }

    private void jButton2textActionPerformed(ActionEvent evt) {
        this.toText();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (!this.working) {
            this.jButtonCancel.setEnabled(false);
        } else {
            Object[] opt = new Object[]{"Yes, cancel", "Continue"};
            int m = JOptionPane.showOptionDialog(this, "Cancel job?" + nl + "Are you sure?" + nl + " ", this.pc.progName, 0, 2, null, opt, opt[1]);
            if (m != 0) {
                return;
            }
            this.working = false;
            System.err.println("--- Cancelled by the user" + nl + nl + "--- Close this window to terminate the program ---");
        }
    }

    private void jListDBlistMouseClicked(MouseEvent evt) {
        this.setCursorWait();
        DBnamesDialog dbND = new DBnamesDialog(this, true, this.pc, this.pd.dataBasesList, this.pd.pathDatabaseFiles, this.pd.elemComp);
        this.setFrameEnabled(false);
        dbND.setVisible(true);
        if (!dbND.cancel) {
            LibDB.checkDataBasesList(this.pd.dataBasesList, true);
            LibDB.getElements(this, this.pc, this.pd.dataBasesList, this.pd.elemComp);
            this.modelFiles.clear();
            for (int i = 0; i < this.pd.dataBasesList.size(); ++i) {
                this.modelFiles.addElement(this.pd.dataBasesList.get(i));
            }
        }
        this.setFrameEnabled(true);
        dbND.dispose();
        System.out.println("----  pathAddData = " + this.pd.pathAddData.toString());
        this.setCursorDef();
        this.bringToFront();
    }

    private void jListDBlistKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\u007f' || evt.getKeyChar() == '\b') {
            evt.consume();
            this.jListDBlistMouseClicked(null);
            return;
        }
        char c = Character.toUpperCase(evt.getKeyChar());
        if (evt.getKeyChar() != '\u001b' && evt.getKeyChar() != '\n' && (!evt.isAltDown() || c != 'X' && c != 'S')) {
            evt.consume();
            this.jListDBlistMouseClicked(null);
        }
    }

    private void jButtonStatisticsActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Statistics s = new Statistics(DataMaintenance.this.pc, DataMaintenance.this.pd);
                s.start();
                s.waitFor();
                return null;
            }

            @Override
            protected void done() {
                DataMaintenance.this.bringToFront();
                ((DataMaintenance)DataMaintenance.this).pd.msgFrame.setParentFrame(DataMaintenance.this);
            }
        }.execute();
    }

    private void jListDBlistFocusGained(FocusEvent evt) {
        if (this.jListDBlist.isFocusOwner()) {
            this.jScrollPaneDBlist.setBorder(this.highlightedBorder);
        }
        if (this.modelFiles.getSize() > 0) {
            int i = this.jListDBlist.getSelectedIndex();
            if (i >= 0) {
                this.jListDBlist.ensureIndexIsVisible(i);
            } else {
                this.jListDBlist.setSelectedIndex(0);
            }
        }
    }

    private void jListDBlistFocusLost(FocusEvent evt) {
        this.jListDBlist.clearSelection();
        if (!this.jListDBlist.isFocusOwner()) {
            this.jScrollPaneDBlist.setBorder(this.defBorder);
        }
    }

    private void jButtonOpenActionPerformed(ActionEvent evt) {
        String fn = Util.getOpenFileName(this, this.pc.progName, true, "Open INI file", 11, null, this.pc.pathDef.toString());
        if (fn == null || fn.length() <= 0) {
            return;
        }
        File f = new File(fn);
        try {
            fn = f.getCanonicalPath();
        }
        catch (IOException ex) {
            fn = null;
        }
        if (fn == null) {
            try {
                fn = f.getAbsolutePath();
            }
            catch (Exception ex) {
                fn = f.getPath();
            }
        }
        f = new File(fn);
        this.pc.setPathDef(f);
        this.modelFiles.clear();
        this.readIni2(f);
        for (int i = 0; i < this.pd.dataBasesList.size(); ++i) {
            this.modelFiles.addElement(this.pd.dataBasesList.get(i));
        }
        this.setFrameEnabled(true);
        this.jLabelSession.setText("<html><b>Session:</b>&nbsp; \"" + f.getName() + "\"</html>");
        this.setCursorDef();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        String fn = Util.getSaveFileName(this, this.pc.progName, "Open INI file", 11, null, this.pc.pathDef.toString());
        if (fn == null || fn.length() <= 0) {
            return;
        }
        File f = new File(fn);
        try {
            fn = f.getCanonicalPath();
        }
        catch (IOException ex) {
            fn = null;
        }
        if (fn == null) {
            try {
                fn = f.getAbsolutePath();
            }
            catch (Exception ex) {
                fn = f.getPath();
            }
        }
        f = new File(fn);
        this.pc.setPathDef(f);
        this.saveIni(f);
        this.jLabelSession.setText("<html><b>Session:</b>&nbsp; \"" + f.getName() + "\"</html>");
    }

    private void jButtonAddDataActionPerformed(ActionEvent evt) {
        this.jButtonAddData.setEnabled(false);
        if (this.addData != null) {
            Util.exceptn("Programming error: addData != null");
            return;
        }
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                DataMaintenance.this.addData = new FrameAddData(DataMaintenance.this.pc, DataMaintenance.this.pd);
                DataMaintenance.this.setCursorDef();
                DataMaintenance.this.setVisible(false);
                DataMaintenance.this.addData.start();
                DataMaintenance.this.addData.waitFor();
                return null;
            }

            @Override
            protected void done() {
                DataMaintenance.this.addData = null;
                DataMaintenance.this.setFrameEnabled(true);
                DataMaintenance.this.bringToFront();
            }
        }.execute();
    }

    private void jButtonSingleActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        this.jButtonSingle.setEnabled(false);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                LibDB.getElements(DataMaintenance.this, DataMaintenance.this.pc, ((DataMaintenance)DataMaintenance.this).pd.dataBasesList, ((DataMaintenance)DataMaintenance.this).pd.elemComp);
                FrameSingleComponent sc = new FrameSingleComponent(DataMaintenance.this, DataMaintenance.this.pc, DataMaintenance.this.pd);
                DataMaintenance.this.setCursorDef();
                DataMaintenance.this.setVisible(false);
                sc.start();
                sc.waitFor();
                return null;
            }

            @Override
            protected void done() {
                DataMaintenance.this.setFrameEnabled(true);
                DataMaintenance.this.bringToFront();
            }
        }.execute();
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        if (this.pd.msgFrame != null) {
            this.jCheckBoxDebugFrame.setSelected(this.pd.msgFrame.isVisible());
        } else {
            this.jCheckBoxDebugFrame.setEnabled(false);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        this.setCursorWait();
        String[] a = new String[]{"DB_Databases_htm"};
        RunProgr.runProgramInProcess(this, "Chem_Diagr_Help.jar", a, false, this.pc.dbg, this.pc.pathAPP);
        this.setCursorDef();
    }

    private void closeWindow() {
        if (fileIni != null) {
            this.saveIni(fileIni);
        }
        this.finished = true;
        this.notify_All();
        this.dispose();
        System.exit(0);
    }

    public synchronized void waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public void bringToFront() {
        if (this != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataMaintenance.this.setVisible(true);
                    DataMaintenance.this.setAlwaysOnTop(true);
                    DataMaintenance.this.toFront();
                    DataMaintenance.this.requestFocus();
                    DataMaintenance.this.setAlwaysOnTop(false);
                }
            });
        }
    }

    private void setFrameEnabled(boolean enable) {
        this.jButtonExit.setEnabled(enable);
        this.jButtonOpen.setEnabled(enable);
        this.jButtonAddData.setEnabled(enable);
        this.jButtonCancel.setEnabled(!enable);
        boolean b = enable;
        if (this.pd.dataBasesList.size() <= 0) {
            b = false;
        }
        this.jButtonSave.setEnabled(b);
        this.jButtonStatistics.setEnabled(b);
        this.jButton2binary.setEnabled(b);
        this.jButton2text.setEnabled(b);
        this.jButtonSingle.setEnabled(b);
        if (b) {
            this.jButtonSave.setForeground(this.frgrnd);
            this.jButtonStatistics.setForeground(this.frgrnd);
            this.jButton2binary.setForeground(this.frgrnd);
            this.jButton2text.setForeground(this.frgrnd);
            this.jButtonSingle.setForeground(this.frgrnd);
        } else {
            this.jButtonSave.setForeground(this.bckgrnd);
            this.jButtonStatistics.setForeground(this.bckgrnd);
            this.jButton2binary.setForeground(this.bckgrnd);
            this.jButton2text.setForeground(this.bckgrnd);
            this.jButtonSingle.setForeground(this.bckgrnd);
        }
        if (enable) {
            this.jButtonOpen.setForeground(this.frgrnd);
            this.jButtonAddData.setForeground(this.frgrnd);
            this.jLabelNbr.setVisible(false);
            this.jProgressBar.setVisible(false);
            this.jButtonOpen.requestFocusInWindow();
            this.enable2Text();
            this.setCursorDef();
        } else {
            this.jButtonOpen.setForeground(this.bckgrnd);
            this.jButtonAddData.setForeground(this.bckgrnd);
            this.jButtonCancel.requestFocusInWindow();
            this.setCursorWait();
        }
    }

    private void enable2Text() {
        boolean found = false;
        for (int i = 0; i < this.pd.dataBasesList.size(); ++i) {
            if (!Div.getFileNameExtension(this.pd.dataBasesList.get(i)).equalsIgnoreCase("db")) continue;
            found = true;
            break;
        }
        if (!found) {
            this.jButton2text.setEnabled(false);
            this.jButton2text.setForeground(this.bckgrnd);
        } else {
            this.jButton2text.setEnabled(true);
            this.jButton2text.setForeground(this.frgrnd);
        }
    }

    void setCursorWait() {
        this.setCursor(new Cursor(3));
        if (this.pd.msgFrame != null && this.pd.msgFrame.isShowing()) {
            this.pd.msgFrame.setCursorWait();
        }
    }

    void setCursorDef() {
        this.setCursor(new Cursor(0));
        if (this.pd.msgFrame != null) {
            this.pd.msgFrame.setCursorDef();
        }
    }

    private void readIni() {
        boolean ok;
        File fileINInotRO;
        boolean readOk;
        File fileRead;
        block24: {
            String home;
            File p;
            block23: {
                block27: {
                    block26: {
                        block25: {
                            block22: {
                                this.iniDefaults();
                                fileRead = null;
                                readOk = false;
                                fileIni = null;
                                fileINInotRO = null;
                                if (this.pc.pathAPP != null && this.pc.pathAPP.trim().length() > 0) break block22;
                                if (!this.pc.iniFileToApplicationPath) break block23;
                                String name = "\"null\"" + SLASH + fileINI_name;
                                Util.exceptn("Can not read ini file" + nl + "    \"" + name + "\"");
                                break block24;
                            }
                            String dir = this.pc.pathAPP;
                            if (dir != null) {
                                if (dir.endsWith(SLASH)) {
                                    dir = dir.substring(0, dir.length() - 1);
                                }
                                fileIni = new File(dir + SLASH + fileINI_name);
                                p = new File(this.pc.pathAPP);
                            } else {
                                fileIni = new File(fileINI_name);
                                p = new File("");
                            }
                            if (p.exists()) break block25;
                            if (!this.pc.iniFileToApplicationPath) break block23;
                            Util.exceptn("Can not read ini file:" + nl + "    \"" + fileIni.getPath() + "\"");
                            fileIni = null;
                            break block24;
                        }
                        if (!this.pc.iniFileToApplicationPath) break block26;
                        if (fileIni.exists()) {
                            readOk = this.readIni2(fileIni);
                        }
                        if (readOk) {
                            fileRead = fileIni;
                        }
                        fileINInotRO = fileIni;
                        break block24;
                    }
                    if (!fileIni.exists()) break block27;
                    readOk = this.readIni2(fileIni);
                    if (!readOk) break block23;
                    fileRead = fileIni;
                    if (!fileIni.canWrite()) break block23;
                    fileINInotRO = fileIni;
                    break block24;
                }
                try {
                    File tmp = File.createTempFile("datab", ".tmp", p);
                    ok = tmp.exists();
                    if (ok) {
                        tmp.delete();
                    }
                }
                catch (IOException ex) {
                    ok = false;
                }
                if (ok && fileINInotRO == null) {
                    fileINInotRO = fileIni;
                }
            }
            ArrayList<String> dirs = new ArrayList<String>(5);
            String appD = System.getenv("APPDATA");
            if (appD != null && appD.trim().length() > 0 && (p = new File(appD)).exists()) {
                dirs.add(p.getAbsolutePath());
            }
            String homeDrv = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            if (homePath != null && homePath.trim().length() > 0 && !homePath.startsWith(SLASH)) {
                homePath = SLASH + homePath;
            }
            if (homeDrv != null && homeDrv.trim().length() > 0 && homeDrv.endsWith(SLASH)) {
                homeDrv = homeDrv.substring(0, homeDrv.length() - 1);
            }
            if (homeDrv != null && homeDrv.trim().length() > 0 && homePath != null && homePath.trim().length() > 0 && (p = new File(homeDrv + homePath)).exists()) {
                dirs.add(p.getAbsolutePath());
            }
            if ((home = System.getenv("HOME")) != null && home.trim().length() > 0 && (p = new File(home)).exists()) {
                dirs.add(p.getAbsolutePath());
            }
            for (String t : dirs) {
                if (t.endsWith(SLASH)) {
                    t = t.substring(0, t.length() - 1);
                }
                if ((fileIni = new File(t + SLASH + fileINI_name)).exists()) {
                    readOk = this.readIni2(fileIni);
                    if (!readOk) continue;
                    fileRead = fileIni;
                    if (!fileIni.canWrite()) continue;
                    fileINInotRO = fileIni;
                    break;
                }
                try {
                    p = new File(t);
                    File tmp = File.createTempFile("datab", ".tmp", p);
                    ok = tmp.exists();
                    if (ok) {
                        tmp.delete();
                    }
                }
                catch (IOException ex) {
                    ok = false;
                }
                if (!ok || fileINInotRO != null) continue;
                fileINInotRO = fileIni;
            }
        }
        if (!readOk) {
            String msg = "Failed to read any INI-file." + nl + "Default program settings will be used.";
            System.out.println("----" + nl + msg + nl + "----");
        }
        if (fileINInotRO != null && fileINInotRO != fileRead) {
            ok = this.saveIni(fileINInotRO);
            fileIni = ok ? fileINInotRO : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readIni2(File f) {
        String msg;
        System.out.flush();
        System.out.println("Reading ini-file: \"" + f.getPath() + "\"");
        Properties propertiesIni = new Properties();
        FileInputStream properties_iniFile = null;
        boolean ok = true;
        try {
            properties_iniFile = new FileInputStream(f);
            propertiesIni.load(properties_iniFile);
        }
        catch (FileNotFoundException e) {
            System.out.println("Warning: file not found: \"" + f.getPath() + "\"" + nl + "using default parameter values.");
            this.checkIniValues();
            ok = false;
        }
        catch (IOException e) {
            Util.exceptn(Util.stack2string(e));
            msg = "Error: \"" + e.toString() + "\"" + nl + "   while loading INI-file:" + nl + "   \"" + f.getPath() + "\"";
            Util.showErrMsg(this, msg, 1);
            ok = false;
        }
        finally {
            try {
                if (properties_iniFile != null) {
                    properties_iniFile.close();
                }
            }
            catch (IOException e) {
                msg = "Error: \"" + e.toString() + "\"" + nl + "   while closing INI-file:" + nl + "   \"" + f.getPath() + "\"";
                Util.showErrMsg(this, msg, 1);
            }
        }
        if (!ok) {
            return ok;
        }
        try {
            this.pd.pathAddData.replace(0, this.pd.pathAddData.length(), propertiesIni.getProperty("pathAddData"));
            int nbr = this.pd.dataBasesList.size();
            if (nbr > 0) {
                this.pd.dataBasesList.clear();
            }
            nbr = Integer.parseInt(propertiesIni.getProperty("DataBases_Nbr"));
            for (int i = 0; i < nbr; ++i) {
                String dbName = propertiesIni.getProperty("DataBase[" + String.valueOf(i + 1).trim() + "]");
                if (dbName == null || dbName.length() <= 0) continue;
                this.pd.dataBasesList.add(dbName);
            }
        }
        catch (NumberFormatException e) {
            Util.exceptn(Util.stack2string(e));
            msg = "Error: \"" + e.toString() + "\"" + nl + "   while reading INI-file:" + nl + "   \"" + f.getPath() + "\"" + nl + nl + "Setting default program parameters.";
            Util.showErrMsg(this, msg, 1);
            ok = false;
        }
        try {
            this.pc.pathDef.replace(0, this.pc.pathDef.length(), propertiesIni.getProperty("defaultPath"));
        }
        catch (NullPointerException ex) {
            this.pc.setPathDef();
        }
        if (this.pc.dbg) {
            System.out.println("Finished reading ini-file");
        }
        System.out.flush();
        this.checkIniValues();
        return ok;
    }

    private void checkIniValues() {
        String dir;
        System.out.flush();
        System.out.println(LINE + nl + "Checking ini-values.");
        File f = new File(this.pc.pathDef.toString());
        if (!f.exists()) {
            this.pc.setPathDef();
        }
        if (this.pd.pathAddData.length() > 0) {
            f = new File(this.pd.pathAddData.toString());
            if (!f.exists()) {
                if (this.pd.pathAddData.length() > 0) {
                    this.pd.pathAddData.delete(0, this.pd.pathAddData.length());
                }
                this.pd.pathAddData.append(this.pc.pathDef.toString());
            }
        } else {
            this.pd.pathAddData.append(this.pc.pathDef.toString());
        }
        if ((dir = this.pc.pathAPP) != null && dir.endsWith(SLASH)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        boolean warn = false;
        int nbr = this.pd.dataBasesList.size();
        String msg = null;
        if (nbr <= 0) {
            msg = "There are no databases selected.";
            warn = true;
            String dbName = dir != null && dir.trim().length() > 0 ? dir + SLASH + DEF_DataBase : DEF_DataBase;
            File db = new File(dbName);
            if (db.exists() && db.canRead()) {
                msg = null;
                this.pd.dataBasesList.add(dbName);
            }
        } else {
            LibDB.checkDataBasesList(this.pd.dataBasesList, true);
            nbr = this.pd.dataBasesList.size();
            if (nbr <= 0) {
                msg = "Error: none of the databases in the \"INI\"-file exist.";
                String dbName = dir != null && dir.trim().length() > 0 ? dir + SLASH + DEF_DataBase : DEF_DataBase;
                if (LibDB.isDBnameOK(dbName, false)) {
                    this.pd.dataBasesList.add(dbName);
                }
            } else {
                msg = null;
            }
        }
        if (msg != null) {
            System.out.println(msg);
            msg = msg + nl + nl + "Please select databases" + nl + "by double-clicking on the empty panel!" + nl + " ";
            int type = 0;
            if (warn) {
                type = 2;
            }
            JOptionPane.showMessageDialog(this, msg, this.pc.progName, type);
        }
    }

    private void iniDefaults() {
        String dbName;
        File db;
        if (this.pc.dbg) {
            System.out.flush();
            System.out.println("Setting default parameter values (\"ini\"-values).");
        }
        this.pc.setPathDef();
        this.pd.pathAddData.replace(0, this.pd.pathAddData.length(), this.pc.pathDef.toString());
        this.pd.dataBasesList.clear();
        String dir = this.pc.pathAPP;
        if (dir != null && dir.endsWith(SLASH)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if ((db = new File(dbName = dir != null && dir.trim().length() > 0 ? dir + SLASH + DEF_DataBase : DEF_DataBase)).exists() && db.canRead()) {
            this.pd.dataBasesList.add(dbName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveIni(File f) {
        if (f == null) {
            return false;
        }
        boolean ok = true;
        SortedProperties propertiesIni = new SortedProperties();
        propertiesIni.setProperty("<program_version>", vers);
        propertiesIni.setProperty("pathAddData", this.pd.pathAddData.toString());
        propertiesIni.setProperty("defaultPath", this.pc.pathDef.toString());
        int nbr = this.pd.dataBasesList.size();
        propertiesIni.setProperty("DataBases_Nbr", String.valueOf(nbr));
        for (int i = 0; i < nbr; ++i) {
            propertiesIni.setProperty("DataBase[" + String.valueOf(i + 1).trim() + "]", this.pd.dataBasesList.get(i));
        }
        System.out.println("Saving ini-file: \"" + f.getPath() + "\"");
        FileOutputStream Properties_iniFile = null;
        try {
            Properties_iniFile = new FileOutputStream(f);
            propertiesIni.store(Properties_iniFile, null);
            if (this.pc.dbg) {
                System.out.println("Written: \"" + f.getPath() + "\"");
            }
        }
        catch (IOException e) {
            String msg = "Error: \"" + e.toString() + "\"" + nl + "   while writing INI-file:" + nl + "   \"" + f.getPath() + "\"";
            Util.showErrMsg(this, msg, 1);
            ok = false;
        }
        finally {
            try {
                if (Properties_iniFile != null) {
                    Properties_iniFile.close();
                }
            }
            catch (IOException e) {}
        }
        return ok;
    }

    private void toBinary(final ArrayList<String[]> eComp) {
        if (this.pd == null || this.pd.dataBasesList == null || this.pd.dataBasesList.size() <= 0) {
            String msg = "There are NO databases to convert to binary!" + nl + " ";
            if (this.dispatchingArgs) {
                msg = msg + nl + "Please run the program again" + nl + "WITHOUT the \"-bin\" command line option," + nl + "select some databases, and THEN" + nl + "run again with the \"-bin\" option." + nl + " ";
            }
            Util.showErrMsg(this, msg, 1);
            return;
        }
        if (this.fileCmplxSaveName == null || this.fileCmplxSaveName.trim().length() <= 0) {
            this.fileCmplxSaveName = DEF_DataBase;
        }
        this.fileCmplxSaveName = Util.getSaveFileName(this, this.pc.progName, "Enter an output binary database name", 4, this.fileCmplxSaveName, this.pc.pathDef.toString());
        if (this.fileCmplxSaveName == null || this.fileCmplxSaveName.trim().length() <= 0) {
            return;
        }
        this.pc.setPathDef(this.fileCmplxSaveName);
        boolean found = false;
        for (int i = 0; i < this.pd.dataBasesList.size(); ++i) {
            if (!this.pd.dataBasesList.get(i).equalsIgnoreCase(this.fileCmplxSaveName)) continue;
            found = true;
            break;
        }
        if (found) {
            String msg = "? Can not create output file:" + nl + "    \"" + this.fileCmplxSaveName + "\"" + nl + "Because it is given in the input database-list.";
            Util.showErrMsg(this, msg, 1);
            return;
        }
        if (this.pd.dataBasesList.size() > 1) {
            System.out.println(LINE + nl + "Merging all files into a single binary database . . .");
        } else {
            System.out.println(LINE + nl + "Converting the text file into a binary database . . .");
        }
        this.setFrameEnabled(false);
        this.working = true;
        if (this.pd.msgFrame != null) {
            this.pd.msgFrame.setVisible(true);
            this.jCheckBoxDebugFrame.setSelected(true);
        }
        new SwingWorker<Void, Integer>(){

            /*
             * Exception decompiling
             */
            @Override
            protected Void doInBackground() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 82[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @Override
            protected void done() {
                DataMaintenance.this.jProgressBar.setVisible(false);
                DataMaintenance.this.setFrameEnabled(true);
                DataMaintenance.this.working = false;
                DataMaintenance.this.bringToFront();
            }

            @Override
            protected void process(List<Integer> chunks) {
                int i = chunks.get(chunks.size() - 1);
                if (!DataMaintenance.this.jProgressBar.isVisible()) {
                    DataMaintenance.this.jProgressBar.setVisible(true);
                }
                DataMaintenance.this.jProgressBar.setValue(i);
            }
        }.execute();
    }

    private void toText() {
        boolean found = false;
        for (int i = 0; i < this.pd.dataBasesList.size(); ++i) {
            String db = this.pd.dataBasesList.get(i);
            if (!Div.getFileNameExtension(db).equalsIgnoreCase("db")) continue;
            found = true;
            break;
        }
        if (!found) {
            String msg = "No binary (*.db) files selected!";
            System.err.println(msg);
            JOptionPane.showMessageDialog(this, msg, this.pc.progName, 0);
            return;
        }
        this.setFrameEnabled(false);
        this.working = true;
        if (this.pd.msgFrame != null) {
            this.pd.msgFrame.setVisible(true);
            this.jCheckBoxDebugFrame.setSelected(true);
        }
        System.out.println("--- Converting binary database files to text format.");
        new SwingWorker<Void, Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected Void doInBackground() throws Exception {
                elemSymbol = new StringBuilder();
                elemFileNameIn = new StringBuilder();
                elemFileNameOut = new StringBuilder();
                dbOut = new StringBuilder();
                this.publish(new Integer[]{0});
                converted = 0;
                try {
                    i = 0;
                    while (i < DataMaintenance.access$2400((DataMaintenance)DataMaintenance.this).dataBasesList.size()) {
                        block68: {
                            block72: {
                                block71: {
                                    block70: {
                                        block69: {
                                            if (!DataMaintenance.access$2700(DataMaintenance.this)) {
                                                var11_14 = null;
                                                return var11_14;
                                            }
                                            db = DataMaintenance.access$2400((DataMaintenance)DataMaintenance.this).dataBasesList.get(i);
                                            if (!Div.getFileNameExtension(db).equalsIgnoreCase("db")) break block68;
                                            fileRead = new File(db);
                                            if (fileRead.exists()) break block69;
                                            msg = "File not found:" + DataMaintenance.access$2900() + "\"" + db + "\"" + DataMaintenance.access$2900();
                                            System.err.println(msg);
                                            JOptionPane.showMessageDialog(DataMaintenance.this, msg, DataMaintenance.access$2300((DataMaintenance)DataMaintenance.this).progName, 0);
                                            break block68;
                                        }
                                        DataMaintenance.access$3202(DataMaintenance.this, fileRead.length());
                                        elemFileNameIn.replace(0, elemFileNameIn.length(), Div.getFileNameWithoutExtension(db));
                                        elemFileNameOut.replace(0, elemFileNameOut.length(), elemFileNameIn.toString());
                                        elemFileNameIn.append(".elb");
                                        fileRead = new File(elemFileNameIn.toString());
                                        if (fileRead.exists()) break block70;
                                        msg = "File not found:" + DataMaintenance.access$2900() + "\"" + elemFileNameIn.toString() + "\"" + DataMaintenance.access$2900();
                                        System.err.println(msg);
                                        JOptionPane.showMessageDialog(DataMaintenance.this, msg, DataMaintenance.access$2300((DataMaintenance)DataMaintenance.this).progName, 0);
                                        break block68;
                                    }
                                    elemFileNameOut.append(".elt");
                                    fileSave = new File(elemFileNameOut.toString());
                                    if (!fileSave.exists()) break block71;
                                    opt = new Object[]{"Yes", "Cancel"};
                                    m = JOptionPane.showOptionDialog(DataMaintenance.this, "Note: the elements-components file" + DataMaintenance.access$2900() + "\"" + elemFileNameOut.toString() + "\"" + DataMaintenance.access$2900() + "already exists.  Overwrite?", DataMaintenance.access$2300((DataMaintenance)DataMaintenance.this).progName, 0, 2, null, opt, opt[1]);
                                    if (m != 0) break block68;
                                }
                                System.err.println("Converting \"" + fileRead.getName() + "\" into \"" + fileSave.getName() + "\"");
                                DataMaintenance.access$3202(DataMaintenance.this, fileRead.length());
                                dis = null;
                                pw = null;
                                try {
                                    dis = new DataInputStream(new FileInputStream(fileRead));
                                    pw = new PrintWriter(new BufferedWriter(new FileWriter(fileSave)));
                                    DataMaintenance.access$3302(DataMaintenance.this, 0L);
lbl55:
                                    // 2 sources

                                    while (true) {
                                        if (DataMaintenance.access$2700(DataMaintenance.this)) ** GOTO lbl-1000
                                        var14_19 = null;
                                        if (dis == null) ** GOTO lbl97
                                        ** GOTO lbl92
                                        break;
                                    }
                                }
                                catch (EOFException ex) {
                                    ++converted;
                                    System.out.println("Finished; file \"" + fileSave.getName() + "\" written.");
                                    if (dis != null) {
                                        try {
                                            dis.close();
                                        }
                                        catch (IOException ex) {
                                            System.err.println("Input-Output error: " + ex.toString());
                                        }
                                    }
                                    if (pw != null) {
                                        pw.flush();
                                        pw.close();
                                    }
                                    this.publish(new Integer[]{0});
                                }
                                catch (IOException ex) {
                                    block64: {
                                        try {
                                            System.err.println("Error: " + ex.toString() + DataMaintenance.access$2900() + "with \"" + elemFileNameIn.toString() + "\"");
                                            if (dis != null) {
                                            }
                                            break block64;
                                        }
                                        catch (Throwable var16_31) {
                                            if (dis != null) {
                                                try {
                                                    dis.close();
                                                }
                                                catch (IOException ex) {
                                                    System.err.println("Input-Output error: " + ex.toString());
                                                }
                                            }
                                            if (pw != null) {
                                                pw.flush();
                                                pw.close();
                                            }
                                            this.publish(new Integer[]{0});
                                            throw var16_31;
                                        }
lbl92:
                                        // 1 sources

                                        try {
                                            dis.close();
                                        }
                                        catch (IOException ex) {
                                            System.err.println("Input-Output error: " + ex.toString());
                                        }
lbl97:
                                        // 3 sources

                                        if (pw != null) {
                                            pw.flush();
                                            pw.close();
                                        }
                                        this.publish(new Integer[]{0});
                                        return var14_19;
lbl-1000:
                                        // 1 sources

                                        {
                                            this.publish(new Integer[]{(int)(100.0 * (double)DataMaintenance.access$3300(DataMaintenance.this) * 38.64 / DataMaintenance.access$3200(DataMaintenance.this))});
                                            elemSymbol.replace(0, elemSymbol.length(), dis.readUTF());
                                            n = dis.readInt();
                                            pw.format("%-2s,%2d ,", new Object[]{elemSymbol.toString(), n});
                                            for (j = 0; j < n; ++j) {
                                                pw.print(dis.readUTF() + "," + dis.readUTF() + ",");
                                            }
                                            pw.println();
                                            pw.flush();
                                            DataMaintenance.access$3308(DataMaintenance.this);
                                            ** continue;
                                        }
                                        try {
                                            dis.close();
                                        }
                                        catch (IOException ex) {
                                            System.err.println("Input-Output error: " + ex.toString());
                                        }
                                    }
                                    if (pw != null) {
                                        pw.flush();
                                        pw.close();
                                    }
                                    this.publish(new Integer[]{0});
                                }
                                if (!DataMaintenance.access$2700(DataMaintenance.this)) {
                                    ex = null;
                                    return ex;
                                }
                                fileRead = new File(db);
                                dbOut.replace(0, dbOut.length(), Div.getFileNameWithoutExtension(db));
                                dbOut.append(".txt");
                                fileSave = new File(dbOut.toString());
                                if (!fileSave.exists()) break block72;
                                opt = new Object[]{"Yes", "Cancel"};
                                m = JOptionPane.showOptionDialog(DataMaintenance.this, "Note: the reactions database file" + DataMaintenance.access$2900() + "\"" + dbOut.toString() + "\"" + DataMaintenance.access$2900() + "already exists.  Overwrite?", DataMaintenance.access$2300((DataMaintenance)DataMaintenance.this).progName, 0, 2, null, opt, opt[1]);
                                if (m != 0) break block68;
                            }
                            System.err.println("Converting \"" + fileRead.getName() + "\" into \"" + fileSave.getName() + "\"");
                            DataMaintenance.access$3202(DataMaintenance.this, fileRead.length());
                            dis = null;
                            pw = null;
                            try {
                                dis = new DataInputStream(new FileInputStream(fileRead));
                                pw = new PrintWriter(new BufferedWriter(new FileWriter(fileSave)));
                                pw.println("COMPLEX;LogK;DH_kJmol;DCp_Jmol;R1;N1;R2;N2;R3;N3;R4;N4;R5;N5;R6;N6;H;Reference / Comment");
                                DataMaintenance.access$3302(DataMaintenance.this, 0L);
lbl151:
                                // 2 sources

                                while (true) {
                                    if (DataMaintenance.access$2700(DataMaintenance.this)) ** GOTO lbl-1000
                                    var15_30 = null;
                                    if (dis == null) ** GOTO lbl179
                                    ** GOTO lbl174
                                    break;
                                }
                            }
                            catch (IOException ex) {
                                block65: {
                                    block66: {
                                        block67: {
                                            try {
                                                System.err.println("Error: " + ex.toString() + DataMaintenance.access$2900() + "with \"" + elemFileNameIn.toString() + "\"");
                                                if (dis != null) {
                                                }
                                                break block65;
                                            }
                                            catch (Throwable var18_34) {
                                                if (dis != null) {
                                                    try {
                                                        dis.close();
                                                    }
                                                    catch (IOException ex) {
                                                        System.err.println("Input-Output error: " + ex.toString());
                                                    }
                                                }
                                                if (pw != null) {
                                                    pw.flush();
                                                    pw.close();
                                                }
                                                this.publish(new Integer[]{0});
                                                throw var18_34;
                                            }
lbl174:
                                            // 1 sources

                                            try {
                                                dis.close();
                                            }
                                            catch (IOException ex) {
                                                System.err.println("Input-Output error: " + ex.toString());
                                            }
lbl179:
                                            // 3 sources

                                            if (pw != null) {
                                                pw.flush();
                                                pw.close();
                                            }
                                            this.publish(new Integer[]{0});
                                            return var15_30;
lbl-1000:
                                            // 1 sources

                                            {
                                                this.publish(new Integer[]{(int)(100.0 * (double)DataMaintenance.access$3300(DataMaintenance.this) * 123.39 / DataMaintenance.access$3200(DataMaintenance.this))});
                                                cmplx = LibDB.getBinComplex((DataInputStream)dis);
                                                if (cmplx == null) {
                                                    ++converted;
                                                    System.out.println("Finished; file \"" + fileSave.getName() + "\" written.");
                                                    if (dis == null) break block66;
                                                    break block67;
                                                }
                                                LibDB.writeTxtComplex(pw, cmplx);
                                                DataMaintenance.access$3308(DataMaintenance.this);
                                                ** continue;
                                            }
                                        }
                                        try {
                                            dis.close();
                                        }
                                        catch (IOException ex) {
                                            System.err.println("Input-Output error: " + ex.toString());
                                        }
                                    }
                                    if (pw != null) {
                                        pw.flush();
                                        pw.close();
                                    }
                                    this.publish(new Integer[]{0});
                                    try {
                                        dis.close();
                                    }
                                    catch (IOException ex) {
                                        System.err.println("Input-Output error: " + ex.toString());
                                    }
                                }
                                if (pw != null) {
                                    pw.flush();
                                    pw.close();
                                }
                                this.publish(new Integer[]{0});
                            }
                            if (!DataMaintenance.access$2700(DataMaintenance.this)) {
                                var14_18 = null;
                                return var14_18;
                            }
                        }
                        ++i;
                    }
                    return null;
                }
                catch (HeadlessException ex) {
                    System.err.println("Error: " + ex.toString());
                    ex.printStackTrace();
                    return null;
                }
                catch (LibDB.ReadBinCmplxException ex) {
                    System.err.println("Error: " + ex.toString());
                    ex.printStackTrace();
                    return null;
                }
                catch (LibDB.WriteTxtCmplxException ex) {
                    System.err.println("Error: " + ex.toString());
                    ex.printStackTrace();
                    return null;
                }
                finally {
                    msg = "---- Converted " + converted + " file";
                    if (converted > 1) {
                        msg = msg + "s";
                    }
                    System.out.println(msg);
                }
            }

            @Override
            protected void done() {
                DataMaintenance.this.setCursorDef();
                DataMaintenance.this.jProgressBar.setVisible(false);
                DataMaintenance.this.setFrameEnabled(true);
                DataMaintenance.this.working = false;
            }

            @Override
            protected void process(List<Integer> chunks) {
                int i = chunks.get(chunks.size() - 1);
                if (!DataMaintenance.this.jProgressBar.isVisible()) {
                    DataMaintenance.this.jProgressBar.setVisible(true);
                }
                DataMaintenance.this.jProgressBar.setValue(i);
            }
        }.execute();
    }

    public void dispatchArg(String arg) {
        if (arg == null || arg.length() <= 0) {
            return;
        }
        System.out.println("Command-line argument: \"" + arg + "\", length = " + arg.length());
        if (arg.equals("-dbg") || arg.equals("/dbg")) {
            this.doNotExit = true;
            return;
        }
        if (arg.equals("-?") || arg.equals("/?") || arg.equals("?")) {
            DataMaintenance.printInstructions();
            msgFrame.setVisible(true);
            this.doNotExit = true;
            return;
        }
        if (arg.length() > 3) {
            String arg0 = arg.substring(0, 4).toLowerCase();
            if ((arg.charAt(0) == '-' || arg.charAt(0) == '/') && arg0.substring(1, 4).equals("bin")) {
                if (arg.charAt(4) == '=' || arg.charAt(4) == ':' && arg.length() > 5) {
                    this.fileCmplxSaveName = arg.substring(5);
                    if (this.fileCmplxSaveName.length() > 2 && this.fileCmplxSaveName.startsWith("\"") && this.fileCmplxSaveName.endsWith("\"")) {
                        this.fileCmplxSaveName = this.fileCmplxSaveName.substring(1, arg.length() - 1);
                    }
                    if (this.fileCmplxSaveName.length() > 3 && this.fileCmplxSaveName.toLowerCase().endsWith(".db")) {
                        File f = new File(this.fileCmplxSaveName);
                        try {
                            this.fileCmplxSaveName = f.getCanonicalPath();
                        }
                        catch (IOException ex) {
                            try {
                                this.fileCmplxSaveName = f.getAbsolutePath();
                            }
                            catch (Exception e) {
                                this.fileCmplxSaveName = f.getPath();
                            }
                        }
                        if (f.exists()) {
                            Object[] opt = new Object[]{"Yes", "Cancel"};
                            int m = JOptionPane.showOptionDialog(this, "Note: the database" + nl + "\"" + this.fileCmplxSaveName + "\"" + nl + " already exists.  Overwrite?", this.pc.progName, 0, 2, null, opt, opt[1]);
                            if (m != 0) {
                                this.fileCmplxSaveName = null;
                            }
                        }
                    } else {
                        this.fileCmplxSaveName = null;
                    }
                }
                this.toBinary(this.pd.elemComp);
                return;
            }
        }
        String msg = "Error: bad format for" + nl + "   command-line argument: \"" + arg + "\"";
        System.out.println(msg);
        DataMaintenance.printInstructions();
        msgFrame.setVisible(true);
        JOptionPane.showMessageDialog(this, msg, this.pc.progName, 0);
        String[] a = new String[]{"SP_Batch_Mode_htm"};
        RunProgr.runProgramInProcess(this, "Chem_Diagr_Help.jar", a, false, this.pc.dbg, this.pc.pathAPP);
        this.doNotExit = true;
    }

    public static void printInstructions() {
        System.out.flush();
        String msg = "Possible commands are:" + nl + "  -dbg  (output debugging information to the messages window)" + nl + "  -bin  (merge all databases to a single binary file;" + nl + "         the input databases are those from last run of the program," + nl + "         a list of names is stored in file 'DataMaintenance.ini')" + nl + "  -bin:out-file-name  (as for \"-bin\", but the name of the output" + nl + "                       database (possibly including a path) is given." + nl + "                       Note: out-file-name must end with \".db\")" + nl + "Enclose file names with double quotes (\"\") it they contain blank space." + nl + "Example:   java -jar DataMaintenance.jar /dbg -bin=\"..\\plt\\db 2.db\"";
        System.out.println(msg);
        System.out.flush();
        System.err.println(LINE);
        System.err.flush();
    }

    public static void main(final String[] args) {
        File fileNameCfg;
        final ProgramConf pc = new ProgramConf("DataMaintenance");
        pc.iniFileToApplicationPath = false;
        boolean dbg = false;
        if (args.length > 0) {
            for (String arg : args) {
                if (arg.equalsIgnoreCase("-dbg") || arg.equalsIgnoreCase("/dbg")) {
                    System.out.println("Command-line argument = \"" + arg + "\"");
                    dbg = true;
                }
                if (!arg.equals("-?") && !arg.equalsIgnoreCase("/?")) continue;
                DataMaintenance.printInstructions();
            }
        }
        if (msgFrame == null) {
            msgFrame = new RedirectedFrame(500, 400, pc);
        }
        boolean windows = System.getProperty("os.name").startsWith("Windows");
        try {
            if (windows) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                System.out.println("--- setLookAndFeel(System);");
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                System.out.println("--- setLookAndFeel(CrossPlatform);");
            }
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        Util.configureOptionPane();
        String dir = pc.pathAPP = Main.getPathApp();
        if (dir != null && dir.trim().length() > 0) {
            if (dir.endsWith(SLASH)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            fileNameCfg = new File(dir + SLASH + "DataMaintenance.cfg");
        } else {
            fileNameCfg = new File("DataMaintenance.cfg");
        }
        ProgramConf.read_cfgFile(fileNameCfg, pc);
        if (!pc.dbg) {
            pc.dbg = dbg;
        }
        msgFrame.setVisible(dbg);
        pc.setPathDef(System.getProperty("user.home"));
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        Date today = new Date();
        String dateOut = dateFormatter.format(today);
        System.out.println("DataMaintenance started: \"" + dateOut + "\"");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataMaintenance m = new DataMaintenance(pc);
                m.start(args);
            }
        });
    }

    static /* synthetic */ boolean access$2700(DataMaintenance x0) {
        return x0.working;
    }

    static /* synthetic */ String access$2800(DataMaintenance x0) {
        return x0.fileCmplxSaveName;
    }

    static /* synthetic */ String access$2900() {
        return nl;
    }

    static /* synthetic */ Set access$3000(DataMaintenance x0) {
        return x0.dataList;
    }

    static /* synthetic */ double access$3202(DataMaintenance x0, double x1) {
        x0.fLength = x1;
        return x0.fLength;
    }

    static /* synthetic */ long access$3302(DataMaintenance x0, long x1) {
        x0.cmplxNbr = x1;
        return x0.cmplxNbr;
    }

    static /* synthetic */ double access$3200(DataMaintenance x0) {
        return x0.fLength;
    }

    static /* synthetic */ long access$3308(DataMaintenance x0) {
        return x0.cmplxNbr++;
    }

    static {
        nl = System.getProperty("line.separator");
        SLASH = File.separator;
    }
}

