/*
 * Decompiled with CFR 0.152.
 */
package lib.huvud;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;

public class JarClassLoader
extends URLClassLoader {
    private final URL url;

    public JarClassLoader(URL url) {
        super(new URL[]{url});
        this.url = url;
    }

    public String getMainClassName() throws IOException {
        String nl = System.getProperty("line.separator");
        URL u = new URL("jar", "", this.url + "!/");
        JarURLConnection uc = (JarURLConnection)u.openConnection();
        Attributes attr = uc.getMainAttributes();
        if (attr == null) {
            return null;
        }
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        String msg = null;
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, this.url);
            method.setAccessible(false);
        }
        catch (NoSuchMethodException ex) {
            msg = ex.toString();
        }
        catch (SecurityException ex) {
            msg = ex.toString();
        }
        catch (IllegalAccessException ex) {
            msg = ex.toString();
        }
        catch (IllegalArgumentException ex) {
            msg = ex.toString();
        }
        catch (InvocationTargetException ex) {
            msg = ex.toString();
        }
        if (msg != null) {
            System.out.println("Warning - Failed to add to URLClassLoader:" + nl + this.url.toString() + nl + msg);
        }
        return attr.getValue(Attributes.Name.MAIN_CLASS);
    }

    public void invokeClass(String name, String[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            c = this.loadClass(name);
        }
        if (args == null) {
            args = new String[]{""};
        }
        Method m = c.getMethod("main", String[].class);
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (m.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException("main");
        }
        try {
            m.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }
}

