/*
 * Decompiled with CFR 0.152.
 */
package lib.huvud;

import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.SwingWorker;
import lib.common.Util;
import lib.huvud.JarClassLoader;

public class RunJar {
    private WorkTask tsk;
    private static final String SLASH = File.separator;
    private static final String nl = System.getProperty("line.separator");
    private JarClassLoader jcl;
    private String jarFileName;
    private String[] argsCopy;
    private String mainClassName;
    private Component parentFrame;
    private boolean dbg;
    private boolean finished = false;

    public void runJarLoadingFile(Component parent, String jar, String[] args, boolean debug, String path) {
        URL url;
        if (jar == null || jar.trim().length() <= 0) {
            Util.showErrMsg(parent, "Programming error detected in \"runJarLoadingFile(jar)\"" + nl + "   jar-file name is either \"null\" or empty.", 1);
            return;
        }
        if (!jar.toLowerCase().endsWith(".jar")) {
            Util.showErrMsg(this.parentFrame, "Programming error detected in" + nl + "   \"runJarLoadingFile(" + jar + ")" + nl + "   The name does not end with \".jar\"", 1);
            return;
        }
        this.dbg = debug;
        this.parentFrame = parent;
        if (args == null) {
            this.argsCopy = new String[0];
        } else {
            ArrayList<String> commandArgs = new ArrayList<String>();
            for (String a1 : args) {
                if (a1 == null || a1.length() <= 0) continue;
                if (a1.length() > 2 && a1.startsWith("\"") && a1.endsWith("\"")) {
                    a1 = a1.substring(1, a1.length() - 1);
                }
                commandArgs.add(a1);
            }
            this.argsCopy = new String[commandArgs.size()];
            this.argsCopy = commandArgs.toArray(this.argsCopy);
        }
        if (this.dbg) {
            System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - - -" + nl + "Loading jar file: \"" + jar + "\" with arguments:");
            for (String argsCopy1 : this.argsCopy) {
                System.out.println("   " + argsCopy1);
            }
            System.out.flush();
        }
        if (jar.contains(SLASH) || path == null || path.length() <= 0) {
            this.jarFileName = jar;
        } else {
            if (path.endsWith(SLASH)) {
                path = path.substring(0, path.length() - 1);
            }
            this.jarFileName = path + SLASH + jar;
        }
        File jarFile = new File(this.jarFileName);
        if (!jarFile.exists()) {
            String msg = "Error: file Not found:" + nl + "   \"" + jarFile.getAbsolutePath() + "\"" + nl + "   Can not \"run\" jar-file.";
            Util.showErrMsg(this.parentFrame, msg, 1);
            return;
        }
        if (this.dbg) {
            System.out.println("jar file: " + jarFile.getAbsolutePath());
        }
        if (this.parentFrame != null) {
            this.parentFrame.setCursor(new Cursor(3));
        }
        try {
            url = jarFile.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            String msg = "Error: \"" + ex.toString() + "\"" + nl + "   while attempting to access file:" + nl + "   \"" + this.jarFileName + "\"";
            System.out.println(msg);
            if (this.parentFrame != null) {
                this.parentFrame.setCursor(new Cursor(0));
            }
            return;
        }
        this.jcl = new JarClassLoader(url);
        try {
            this.mainClassName = this.jcl.getMainClassName();
        }
        catch (IOException ex) {
            String msg = "Error: \"" + ex.toString() + "\"" + nl + "   while attempting to open file:" + nl + "   \"" + this.jarFileName + "\"";
            System.out.println(msg);
            if (this.parentFrame != null) {
                this.parentFrame.setCursor(new Cursor(0));
            }
            return;
        }
        if (this.mainClassName == null) {
            String msg = "Error: the 'Main-Class' manifest attribute" + nl + "   is Not found in jar file:" + nl + "   \"" + this.jarFileName + "\"";
            System.out.println(msg);
            if (this.parentFrame != null) {
                this.parentFrame.setCursor(new Cursor(0));
            }
            return;
        }
        this.finished = false;
        this.tsk = new WorkTask();
        this.tsk.execute();
        if (this.parentFrame != null) {
            this.parentFrame.setCursor(new Cursor(0));
        }
        this.waitForTask();
        if (this.dbg) {
            System.out.println("--- RunJar returns...");
            System.out.flush();
        }
    }

    private synchronized void waitForTask() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    public boolean jarDone() {
        if (this.tsk == null) {
            return true;
        }
        return this.tsk.isDone() || this.tsk.isCancelled();
    }

    private class WorkTask
    extends SwingWorker<Boolean, String> {
        private WorkTask() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            boolean ok;
            String msg = null;
            try {
                RunJar.this.jcl.invokeClass(RunJar.this.mainClassName, RunJar.this.argsCopy);
                ok = true;
            }
            catch (ClassNotFoundException e) {
                msg = "Error: Class not found: \"" + RunJar.this.mainClassName + "\"" + nl + "   in jar file:" + nl + "   \"" + RunJar.this.jarFileName + "\"";
                ok = false;
            }
            catch (NoSuchMethodException e) {
                msg = "Error: Class \"" + RunJar.this.mainClassName + "\"" + nl + "   in jar file:" + nl + "   \"" + RunJar.this.jarFileName + "\"" + nl + "   does not define a 'main' method";
                ok = false;
            }
            catch (InvocationTargetException e) {
                msg = "Error: \"" + e.getTargetException().toString() + "\"" + nl + "   in class \"" + RunJar.this.mainClassName + "\"" + nl + "   in jar file:" + nl + "   \"" + RunJar.this.jarFileName + "\"";
                msg = msg + nl + Util.stack2string(e);
                ok = false;
            }
            if (msg != null) {
                System.out.println(msg);
                System.out.flush();
            }
            return ok;
        }

        @Override
        protected void done() {
            if (RunJar.this.dbg) {
                if (this.isCancelled()) {
                    System.out.println("SwingWorker cancelled.");
                } else {
                    System.out.println("SwingWorker done.");
                }
                System.out.flush();
            }
            RunJar.this.finished = true;
            RunJar.this.notify_All();
        }
    }
}

