/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.vectorClipboard;

import java.awt.Graphics2D;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.qenherkhopeshef.graphics.emf.EMFGraphics2D;
import org.qenherkhopeshef.graphics.generic.RandomAccessByteArray;
import org.qenherkhopeshef.graphics.rtfBasicWriter.SimpleRTFWriter;
import org.qenherkhopeshef.graphics.vectorClipboard.EMFTransferable;
import org.qenherkhopeshef.graphics.vectorClipboard.RTFPicture;

public class EMFPicture
extends RTFPicture {
    int width;
    int height;
    EMFGraphics2D emfGraphics2D;
    private RandomAccessByteArray out;

    public EMFPicture(int width, int height) throws IOException {
        this.width = width;
        this.height = height;
        this.out = new RandomAccessByteArray();
        this.emfGraphics2D = new EMFGraphics2D(this.out, width, height, null, null);
    }

    public Graphics2D getGraphics() {
        return this.emfGraphics2D;
    }

    public void write(SimpleRTFWriter writer) throws IOException {
        writer.writeEmfPicture(this.out.getByteArray(), this.width, this.height);
    }

    public byte[] getAsByteArray() {
        return this.out.getByteArray();
    }

    protected Transferable buildStandAloneTransferable() {
        return new EMFTransferable(this);
    }
}

