/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class WinRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int REG_SUCCESS = 0;
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int KEY_READ = 131097;
    private static final Preferences userRoot = Preferences.userRoot();
    private static final Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static Method regCreateKeyEx = null;
    private static Method regSetValueEx = null;
    private static Method regDeleteKey = null;
    private static Method regDeleteValue = null;

    private WinRegistry() {
    }

    public static void createKey(String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] ret = WinRegistry.createKeyPrivate(key);
        regCloseKey.invoke((Object)userRoot, new Integer(ret[0]));
        if (ret[1] != 0) {
            throw new IllegalArgumentException("Error in \"createKey\", rc=" + ret[1] + ", hkey=HKCU, key=" + key);
        }
    }

    public static void deleteKey(String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = WinRegistry.deleteKeyPrivate(key);
        if (rc != 0) {
            throw new IllegalArgumentException("Error in \"deleteKey\", rc=" + rc + ", hkey=HKCU, key=" + key);
        }
    }

    public static void deleteValue(String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = WinRegistry.deleteValuePrivate(key, value);
        if (rc != 0) {
            throw new IllegalArgumentException("Error in \"deleteValue\", rc=" + rc + ", hkey=HKCU, key=" + key + ", value=" + value);
        }
    }

    public static String readString(String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] handles = (int[])regOpenKey.invoke((Object)userRoot, new Integer(-2147483647), WinRegistry.toCstr(key), new Integer(131097));
        if (handles[1] != 0) {
            return null;
        }
        byte[] valb = (byte[])regQueryValueEx.invoke((Object)userRoot, new Integer(handles[0]), WinRegistry.toCstr(value));
        regCloseKey.invoke((Object)userRoot, new Integer(handles[0]));
        return valb != null ? new String(valb).trim() : null;
    }

    public static List<String> readStringSubKeys(String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        int[] handles = (int[])regOpenKey.invoke((Object)userRoot, new Integer(-2147483647), WinRegistry.toCstr(key), new Integer(131097));
        if (handles[1] != 0) {
            return null;
        }
        int[] info = (int[])regQueryInfoKey.invoke((Object)userRoot, new Integer(handles[0]));
        int count = info[0];
        int maxlen = info[3];
        for (int index = 0; index < count; ++index) {
            byte[] name = (byte[])regEnumKeyEx.invoke((Object)userRoot, new Integer(handles[0]), new Integer(index), new Integer(maxlen + 1));
            if (name == null) continue;
            results.add(new String(name).trim());
        }
        regCloseKey.invoke((Object)userRoot, new Integer(handles[0]));
        return results;
    }

    public static void writeStringValue(String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] handles = (int[])regOpenKey.invoke((Object)userRoot, new Integer(-2147483647), WinRegistry.toCstr(key), new Integer(983103));
        regSetValueEx.invoke((Object)userRoot, new Integer(handles[0]), WinRegistry.toCstr(valueName), WinRegistry.toCstr(value));
        regCloseKey.invoke((Object)userRoot, new Integer(handles[0]));
    }

    public static Map<String, String> readStringValues(String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, String> results = new HashMap<String, String>();
        int[] handles = (int[])regOpenKey.invoke((Object)userRoot, new Integer(-2147483647), WinRegistry.toCstr(key), new Integer(131097));
        if (handles[1] != 0) {
            return null;
        }
        int[] info = (int[])regQueryInfoKey.invoke((Object)userRoot, new Integer(handles[0]));
        int count = info[0];
        int maxlen = info[3];
        for (int index = 0; index < count; ++index) {
            byte[] name = (byte[])regEnumValue.invoke((Object)userRoot, new Integer(handles[0]), new Integer(index), new Integer(maxlen + 1));
            if (name == null) continue;
            String value = WinRegistry.readString(key, new String(name));
            results.put(new String(name).trim(), value);
        }
        regCloseKey.invoke((Object)userRoot, new Integer(handles[0]));
        return results;
    }

    private static int deleteValuePrivate(String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] handles = (int[])regOpenKey.invoke((Object)userRoot, new Integer(-2147483647), WinRegistry.toCstr(key), new Integer(983103));
        if (handles[1] != 0) {
            return handles[1];
        }
        int rc = (Integer)regDeleteValue.invoke((Object)userRoot, new Integer(handles[0]), WinRegistry.toCstr(value));
        regCloseKey.invoke((Object)userRoot, new Integer(handles[0]));
        return rc;
    }

    private static int deleteKeyPrivate(String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = (Integer)regDeleteKey.invoke((Object)userRoot, new Integer(-2147483647), WinRegistry.toCstr(key));
        return rc;
    }

    private static int[] createKeyPrivate(String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (int[])regCreateKeyEx.invoke((Object)userRoot, new Integer(-2147483647), WinRegistry.toCstr(key));
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
            regCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Integer.TYPE, byte[].class);
            regCreateKeyEx.setAccessible(true);
            regSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Integer.TYPE, byte[].class, byte[].class);
            regSetValueEx.setAccessible(true);
            regDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Integer.TYPE, byte[].class);
            regDeleteValue.setAccessible(true);
            regDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", Integer.TYPE, byte[].class);
            regDeleteKey.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            System.out.println(e.getMessage() + " in class WinRegistry");
        }
        catch (SecurityException e) {
            System.out.println(e.getMessage() + " in class WinRegistry");
        }
    }
}

