/*
 * Decompiled with CFR 0.152.
 */
package lib.database;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import lib.common.Util;
import lib.database.CSVparser;

public class Complex
implements Comparable<Complex>,
Cloneable {
    public String name = "";
    public double constant;
    public double deltH;
    public double deltCp;
    public String[] component;
    public double[] numcomp;
    public double proton;
    public String reference;
    public String comment;
    public static final double EMPTY = -999999.9;
    public static final String FILE_FIRST_LINE = "COMPLEX;LogK;DH_kJmol;DCp_Jmol;R1;N1;R2;N2;R3;N3;R4;N4;R5;N5;R6;N6;H;Reference / Comment";
    public static final int NDIM = 6;
    public static final int NDATA = 18;
    private Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private static final String nl = System.getProperty("line.separator");

    public Complex() {
        this.component = new String[6];
        this.numcomp = new double[6];
        for (int i = 0; i < 6; ++i) {
            this.component[i] = "";
            this.numcomp[i] = 0.0;
        }
        this.constant = -999999.9;
        this.deltH = -999999.9;
        this.deltCp = -999999.9;
        this.proton = 0.0;
        this.reference = "";
        this.comment = "";
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        Complex c = new Complex();
        c.name = this.name;
        c.constant = this.constant;
        c.deltH = this.deltH;
        c.deltCp = this.deltCp;
        for (int i = 0; i < 6; ++i) {
            c.component[i] = this.component[i];
            c.numcomp[i] = this.numcomp[i];
        }
        c.proton = this.proton;
        c.reference = this.reference;
        c.comment = this.comment;
        return c;
    }

    @Override
    public int compareTo(Complex other) {
        if (this.name == null) {
            if (other.name != null) {
                return -1;
            }
        } else if (this.name.length() <= 0) {
            if (other.name == null) {
                return 1;
            }
            if (other.name.length() > 0) {
                return -1;
            }
        } else if (other.name == null || other.name.length() <= 0) {
            return 1;
        }
        int k = 0;
        if (this.name != null && other.name != null) {
            k = this.name.compareToIgnoreCase(other.name);
        }
        if (k != 0) {
            return k;
        }
        boolean reactionEqual = true;
        int nComps = 0;
        double sumStoich = 0.0;
        boolean protonGiven = false;
        for (int i = 0; i < 6; ++i) {
            if (this.component[i] == null || this.component[i].length() <= 0) continue;
            if (Math.abs(this.numcomp[i]) >= 0.001) {
                ++nComps;
                sumStoich += this.numcomp[i];
                if (Util.isProton((String)this.component[i])) {
                    protonGiven = true;
                }
            }
            int iOther = -1;
            for (int i2 = 0; i2 < 6; ++i2) {
                if (other.component[i2] == null || other.component[i2].length() <= 0 || !Util.nameCompare((String)this.component[i], (String)other.component[i2])) continue;
                iOther = i2;
                break;
            }
            if (iOther < 0) {
                if (Util.isProton((String)this.component[i])) {
                    if (!(Math.abs(this.numcomp[i] - other.proton) >= 0.001)) continue;
                    reactionEqual = false;
                    continue;
                }
                reactionEqual = false;
                continue;
            }
            if (!(Math.abs(this.numcomp[i] - other.numcomp[iOther]) >= 0.001)) continue;
            reactionEqual = false;
        }
        if (!protonGiven && Math.abs(this.proton) >= 0.001) {
            ++nComps;
            sumStoich += this.proton;
        }
        if (Math.abs(this.proton - other.proton) >= 0.001) {
            reactionEqual = false;
        }
        if (reactionEqual) {
            return 0;
        }
        int nCompsOther = 0;
        double sumStoichOther = 0.0;
        protonGiven = false;
        for (int i = 0; i < 6; ++i) {
            if (other.component[i] == null || other.component[i].length() <= 0 || !(Math.abs(other.numcomp[i]) >= 0.001)) continue;
            ++nCompsOther;
            sumStoichOther += other.numcomp[i];
            if (!Util.isProton((String)other.component[i])) continue;
            protonGiven = true;
        }
        if (!protonGiven && Math.abs(other.proton) >= 0.001) {
            ++nCompsOther;
            sumStoichOther += other.proton;
        }
        if (nComps - nCompsOther != 0) {
            return nComps - nCompsOther;
        }
        if (nComps + nCompsOther == 0) {
            return 0;
        }
        double diff = sumStoich - sumStoichOther;
        if (Math.abs(diff) >= 0.001) {
            if (diff > 0.0) {
                return 1;
            }
            return -1;
        }
        if (Math.abs(sumStoich + sumStoichOther) < 0.001) {
            return 0;
        }
        for (int i = 0; i < 6; ++i) {
            if (this.component[i] == null || this.component[i].length() <= 0) continue;
            if (other.component[i] == null || other.component[i].length() <= 0) {
                return 1;
            }
            k = this.component[i].compareToIgnoreCase(other.component[i]);
            diff = this.numcomp[i] - other.numcomp[i];
            if (k != 0 || Math.abs(diff) >= 0.001) break;
        }
        if (k != 0) {
            return k;
        }
        if (Math.abs(diff) < 0.001) {
            return 0;
        }
        if (diff > 0.0) {
            return 1;
        }
        return -1;
    }

    public boolean isEqualTo(Complex other) {
        int i2;
        int k;
        int i;
        boolean dbg = false;
        if (this == null && other == null) {
            return true;
        }
        if (this == null || other == null) {
            return false;
        }
        if (!Util.nameCompare((String)this.name, (String)other.name)) {
            return false;
        }
        if (!Util.areEqualDoubles((double)this.constant, (double)other.constant)) {
            return false;
        }
        if (!Util.areEqualDoubles((double)this.deltH, (double)other.deltH)) {
            return false;
        }
        if (!Util.areEqualDoubles((double)this.deltCp, (double)other.deltCp)) {
            return false;
        }
        boolean ok = true;
        int thisNComps = 0;
        int otherNComps = 0;
        for (i = 0; i < 6; ++i) {
            if (Math.abs(this.numcomp[i]) >= 0.001) {
                ++thisNComps;
            }
            if (this.component[i] == null || this.component[i].length() <= 0) continue;
            k = -1;
            for (i2 = 0; i2 < 6; ++i2) {
                if (other.component[i2] == null || other.component[i2].length() <= 0 || !Util.nameCompare((String)this.component[i], (String)other.component[i2])) continue;
                k = i2;
                break;
            }
            if (k < 0) {
                return false;
            }
            if (!(Math.abs(this.numcomp[i] - other.numcomp[k]) >= 0.001)) continue;
            return false;
        }
        for (i = 0; i < 6; ++i) {
            if (Math.abs(other.numcomp[i]) >= 0.001) {
                ++otherNComps;
            }
            if (other.component[i] == null || other.component[i].length() <= 0) continue;
            k = -1;
            for (i2 = 0; i2 < 6; ++i2) {
                if (this.component[i2] == null || this.component[i2].length() <= 0 || !Util.stringsEqual((String)other.component[i], (String)this.component[i2])) continue;
                k = i2;
                break;
            }
            if (k < 0) {
                return false;
            }
            if (!(Math.abs(this.numcomp[i] - other.numcomp[k]) >= 0.001)) continue;
            return false;
        }
        if (thisNComps != otherNComps) {
            return false;
        }
        if (!Util.areEqualDoubles((double)this.proton, (double)other.proton)) {
            return false;
        }
        if (!Util.stringsEqual((String)this.reference, (String)other.reference)) {
            return false;
        }
        return Util.stringsEqual((String)this.comment, (String)other.comment);
    }

    public static boolean isRedox(Complex c) {
        if (c == null) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (Double.isNaN(c.numcomp[i]) || Math.abs(c.numcomp[i]) < 0.001 || c.component[i] == null || c.component[i].trim().length() <= 0 || !Util.isElectron((String)c.component[i])) continue;
            return true;
        }
        return false;
    }

    public static void sortReactants(Complex cmplx) {
        Object[] r = new String[6];
        System.arraycopy(cmplx.component, 0, r, 0, 6);
        for (int i = 0; i < 5; ++i) {
            if (r[i] == null) continue;
            r[i] = ((String)r[i]).trim();
        }
        Arrays.sort(r);
        double[] d = new double[6];
        for (int i = 0; i < 6; ++i) {
            if (r[i] == null || ((String)r[i]).length() <= 0) {
                d[i] = 0.0;
                continue;
            }
            for (int j = 0; j < 6; ++j) {
                if (!Util.nameCompare((String)r[i], (String)cmplx.component[j])) continue;
                d[i] = cmplx.numcomp[j];
            }
        }
        if (r[0] == null || ((String)r[0]).length() <= 0) {
            for (int i = 0; i < 5; ++i) {
                Object s = r[0];
                double w = d[0];
                for (int j = 0; j < 5; ++j) {
                    r[j] = r[j + 1];
                    d[j] = d[j + 1];
                }
                r[5] = s;
                d[5] = w;
                if (r[0] != null && ((String)r[0]).length() > 0) break;
            }
        }
        System.arraycopy(r, 0, cmplx.component, 0, 6);
        System.arraycopy(d, 0, cmplx.numcomp, 0, 6);
    }

    public static boolean sameNameAndStoichiometry(Complex cmplx1, Complex cmplx2) {
        int i2;
        int found;
        int i;
        if (cmplx1.name == null) {
            if (cmplx2.name != null) {
                return false;
            }
        } else if (cmplx1.name.length() <= 0) {
            if (cmplx2.name == null || cmplx2.name.length() > 0) {
                return false;
            }
        } else {
            if (cmplx2.name == null || cmplx2.name.length() <= 0) {
                return false;
            }
            if (!Util.nameCompare((String)cmplx1.name, (String)cmplx2.name)) {
                return false;
            }
        }
        if (Math.abs(cmplx1.proton - cmplx2.proton) > 0.001) {
            return false;
        }
        for (i = 0; i < 6; ++i) {
            if (cmplx1.component[i] == null || cmplx1.component[i].length() <= 0) continue;
            found = -1;
            for (i2 = 0; i2 < 6; ++i2) {
                if (cmplx2.component[i] == null || cmplx2.component[i].length() <= 0 || !Util.nameCompare((String)cmplx1.component[i], (String)cmplx2.component[i2])) continue;
                found = i2;
                break;
            }
            if (found > -1) {
                if (!(Math.abs(cmplx1.numcomp[i] - cmplx2.numcomp[found]) > 0.001)) continue;
                return false;
            }
            if (Util.isProton((String)cmplx1.component[i])) {
                if (!(Math.abs(cmplx1.numcomp[i] - cmplx2.proton) > 0.001)) continue;
                return false;
            }
            return false;
        }
        for (i = 0; i < 6; ++i) {
            if (cmplx2.component[i] == null || cmplx2.component[i].length() <= 0) continue;
            found = -1;
            for (i2 = 0; i2 < 6; ++i2) {
                if (cmplx1.component[i] == null || cmplx1.component[i].length() <= 0 || !Util.nameCompare((String)cmplx2.component[i], (String)cmplx1.component[i2])) continue;
                found = i2;
                break;
            }
            if (found > -1) {
                if (!(Math.abs(cmplx2.numcomp[i] - cmplx1.numcomp[found]) > 0.001)) continue;
                return false;
            }
            if (Util.isProton((String)cmplx2.component[i])) {
                if (!(Math.abs(cmplx2.numcomp[i] - cmplx1.proton) > 0.001)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean checkNameSameStoichiometry(Complex cmplx1, Complex cmplx2) {
        int i2;
        int found;
        int i;
        if (Math.abs(cmplx1.proton - cmplx2.proton) > 0.001) {
            return true;
        }
        boolean ok = true;
        for (i = 0; i < 6; ++i) {
            if (cmplx1.component[i] == null || cmplx1.component[i].length() <= 0) continue;
            found = -1;
            for (i2 = 0; i2 < 6; ++i2) {
                if (cmplx2.component[i] == null || cmplx2.component[i].length() <= 0 || !Util.nameCompare((String)cmplx1.component[i], (String)cmplx2.component[i2])) continue;
                found = i2;
                break;
            }
            if (found > -1) {
                if (!(Math.abs(cmplx1.numcomp[i] - cmplx2.numcomp[found]) > 0.001)) continue;
                return true;
            }
            if (Util.isProton((String)cmplx1.component[i])) {
                if (!(Math.abs(cmplx1.numcomp[i] - cmplx2.proton) > 0.001)) continue;
                return true;
            }
            return true;
        }
        for (i = 0; i < 6; ++i) {
            if (cmplx2.component[i] == null || cmplx2.component[i].length() <= 0) continue;
            found = -1;
            for (i2 = 0; i2 < 6; ++i2) {
                if (cmplx1.component[i] == null || cmplx1.component[i].length() <= 0 || !Util.nameCompare((String)cmplx2.component[i], (String)cmplx1.component[i2])) continue;
                found = i2;
                break;
            }
            if (found > -1) {
                if (!(Math.abs(cmplx2.numcomp[i] - cmplx1.numcomp[found]) > 0.001)) continue;
                return true;
            }
            if (Util.isProton((String)cmplx2.component[i])) {
                if (!(Math.abs(cmplx2.numcomp[i] - cmplx1.proton) > 0.001)) continue;
                return true;
            }
            return true;
        }
        if (cmplx1.name == null) {
            if (cmplx2.name != null) {
                return false;
            }
        } else if (cmplx1.name.length() <= 0) {
            if (cmplx2.name == null || cmplx2.name.length() > 0) {
                return false;
            }
        } else {
            if (cmplx2.name == null || cmplx2.name.length() <= 0) {
                return false;
            }
            if (!Util.nameCompare((String)cmplx1.name, (String)cmplx2.name)) {
                return false;
            }
        }
        return true;
    }

    public static Complex fromString(String text) throws ReadComplexException {
        ArrayList<String> aList;
        if (text == null || text.length() <= 0 || text.trim().startsWith("/")) {
            return null;
        }
        if (text.indexOf(59) < 0 && text.indexOf(44) < 0) {
            if (text.startsWith("@")) {
                text = text.trim() + ";";
            } else {
                throw new ReadComplexException("Line \"" + text + "\"" + nl + "contains neither semicolons nor commas" + nl + "in \"Complex.fromString()\"");
            }
        }
        try {
            aList = CSVparser.splitLine_N(text, 18);
        }
        catch (CSVparser.CSVdataException ex) {
            throw new ReadComplexException("CSVdataException: " + ex.getMessage() + nl + "in \"Complex.fromString()\"");
        }
        StringBuilder nowReading = new StringBuilder();
        Complex c = new Complex();
        int n = 0;
        double n_H = 0.0;
        try {
            nowReading.replace(0, nowReading.length(), "name");
            if (n >= aList.size()) {
                return c;
            }
            c.name = aList.get(n);
            if (c.name.equalsIgnoreCase("COMPLEX")) {
                return null;
            }
            if (c.name.length() <= 0) {
                for (int i = 1; i < 17; ++i) {
                    if (aList.get(i) == null || aList.get(i).trim().length() <= 0) continue;
                    throw new ReadComplexException("Empty reaction product in line:" + nl + "   \"" + text + "\"" + nl + "found in \"Complex.fromString()\"");
                }
                return null;
            }
            nowReading.replace(0, nowReading.length(), "logK");
            if (++n < aList.size()) {
                c.constant = aList.get(n).length() > 0 ? Double.parseDouble(aList.get(n)) : -999999.9;
            } else {
                return c;
            }
            nowReading.replace(0, nowReading.length(), "delta-H");
            if (++n < aList.size()) {
                c.deltH = aList.get(n).length() > 0 ? Double.parseDouble(aList.get(n)) : -999999.9;
            } else {
                return c;
            }
            nowReading.replace(0, nowReading.length(), "delta-Cp");
            if (++n < aList.size()) {
                c.deltCp = aList.get(n).length() > 0 ? Double.parseDouble(aList.get(n)) : -999999.9;
            } else {
                return c;
            }
            ++n;
            for (int i = 0; i < 6; ++i) {
                nowReading.replace(0, nowReading.length(), "name of reactant[" + (i + 1) + "]");
                if (n >= aList.size()) {
                    return c;
                }
                c.component[i] = aList.get(n);
                nowReading.replace(0, nowReading.length(), "number for reactant[" + (i + 1) + "]");
                if (++n < aList.size()) {
                    c.numcomp[i] = aList.get(n).length() > 0 ? Double.parseDouble(aList.get(n)) : 0.0;
                } else {
                    return c;
                }
                if (Util.isProton((String)c.component[i])) {
                    n_H = c.numcomp[i];
                }
                ++n;
            }
            nowReading.replace(0, nowReading.length(), "number of H+");
            if (n < aList.size()) {
                c.proton = aList.get(n).length() > 0 ? Double.parseDouble(aList.get(n)) : n_H;
            } else {
                return c;
            }
            nowReading.replace(0, nowReading.length(), "reference");
            if (++n >= aList.size()) {
                return c;
            }
            c.reference = aList.get(n);
            ++n;
            while (n < aList.size()) {
                c.reference = c.reference + "," + aList.get(n);
                ++n;
            }
            while (c.reference.startsWith(";") || c.reference.startsWith(",")) {
                c.reference = c.reference.substring(1).trim();
            }
            c.reference = c.reference.trim();
            if (c.reference.startsWith("/")) {
                c.comment = c.reference.substring(1).trim();
                c.reference = "";
            } else {
                int commentStart = c.reference.length();
                int j = c.reference.indexOf(";/");
                if (j > -1 && j < commentStart) {
                    commentStart = j;
                }
                if ((j = c.reference.indexOf(",/")) > -1 && j < commentStart) {
                    commentStart = j;
                }
                if ((j = c.reference.indexOf(" /")) > -1 && j < commentStart) {
                    commentStart = j;
                }
                if (commentStart >= 0 && commentStart < c.reference.length()) {
                    c.comment = c.reference.substring(commentStart + 2, c.reference.length()).trim();
                    c.reference = c.reference.substring(0, commentStart).trim();
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new ReadComplexException("Error in \"Complex.fromString()\":" + nl + ex.toString() + nl + "in line: " + text + nl + "while reading " + nowReading.toString() + "");
        }
        return c;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(Complex.encloseInQuotes(this.name));
        text.append(";");
        if (this.name.startsWith("@")) {
            return text.toString();
        }
        if (this.constant != -999999.9) {
            text.append(Util.formatDbl3((double)this.constant).trim());
        }
        text.append(";");
        if (this.deltH != -999999.9) {
            text.append(Util.formatDbl3((double)this.deltH).trim());
        }
        text.append(";");
        if (this.deltCp != -999999.9) {
            text.append(Util.formatDbl3((double)this.deltCp).trim());
        }
        text.append(";");
        for (int ic = 0; ic < 6; ++ic) {
            if (this.component[ic] == null || this.component[ic].length() <= 0) {
                text.append(";;");
                continue;
            }
            text.append(Complex.encloseInQuotes(this.component[ic]));
            text.append(";");
            text.append(Util.formatDbl4((double)this.numcomp[ic]).trim());
            text.append(";");
        }
        if (Math.abs(this.proton) >= 0.001) {
            text.append(Util.formatDbl4((double)this.proton).trim());
        }
        text.append(";");
        String t = this.comment != null && this.comment.length() > 0 ? this.reference + " /" + this.comment : this.reference;
        text.append(Complex.encloseInQuotes(t));
        return text.toString();
    }

    public static String encloseInQuotes(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() <= 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        if (sb.charAt(0) == '\"') {
            Complex.duplicateQuote(sb, '\'');
            return "'" + sb.toString() + "'";
        }
        if (sb.charAt(0) == '\'') {
            Complex.duplicateQuote(sb, '\"');
            return "\"" + sb.toString() + "\"";
        }
        if (sb.indexOf(",") > -1 || sb.indexOf(";") > -1) {
            if (sb.indexOf("\"") > -1) {
                Complex.duplicateQuote(sb, '\'');
                return "'" + sb.toString() + "'";
            }
            Complex.duplicateQuote(sb, '\"');
            return "\"" + sb.toString() + "\"";
        }
        return text;
    }

    private static void duplicateQuote(StringBuilder sb, char quote) {
        int l = sb.length();
        for (int pos = 0; pos < l; ++pos) {
            if (sb.charAt(pos) != quote) continue;
            sb.insert(pos, quote);
            ++l;
            ++pos;
        }
    }

    public static String reactionTextWithLogK(Complex c, double temperature) {
        if (c == null) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        text.append(Complex.reactionText(c));
        if (c.constant != -999999.9 && !c.name.startsWith("@")) {
            double lgK = Complex.constCp(c.constant, c.deltH, c.deltCp, temperature);
            text.append(";  logK=");
            text.append(Util.formatDbl3((double)lgK));
        } else if (!c.name.startsWith("@")) {
            text.append(";  logK= ??");
        }
        text.append(" ");
        if (c.comment != null && c.comment.length() > 0) {
            text.append(" (");
            text.append(c.comment);
            text.append(")");
        }
        if (c.reference != null && c.reference.length() > 0) {
            text.append(" [");
            text.append(c.reference);
            text.append("]");
        }
        String t = text.toString().trim();
        text.delete(0, text.length());
        text.append(t);
        if (t.startsWith("=") && t.contains("@")) {
            text.deleteCharAt(0);
        }
        return text.toString();
    }

    public static String reactionText(Complex c) {
        double aX;
        int ic;
        if (c == null) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        StringBuffer stoich = new StringBuffer();
        boolean first = true;
        boolean protonsPresent = false;
        for (ic = 0; ic < 6; ++ic) {
            if (Util.isProton((String)c.component[ic])) {
                protonsPresent = true;
            }
            if (!((aX = c.numcomp[ic]) > 0.0) || c.component[ic] == null || c.component[ic].length() <= 0) continue;
            if (first) {
                stoich.delete(0, stoich.length());
                first = false;
            } else {
                stoich.delete(0, stoich.length());
                stoich.append(" +");
            }
            if (Math.abs(aX - 1.0) > 0.001) {
                stoich.append(Util.formatDbl3((double)aX));
            }
            text.append(stoich.toString());
            text.append(" ");
            text.append(c.component[ic]);
        }
        if (!protonsPresent && c.proton >= 0.001) {
            if (first) {
                stoich.delete(0, stoich.length());
            } else {
                stoich.delete(0, stoich.length());
                stoich.append(" +");
            }
            if (Math.abs(c.proton - 1.0) >= 0.001) {
                stoich.append(Util.formatDbl3((double)c.proton));
            }
            text.append(stoich.toString());
            text.append(" H+");
        }
        text.append(" = ");
        first = true;
        for (ic = 0; ic < 6; ++ic) {
            aX = -c.numcomp[ic];
            if (!(aX > 0.0) || c.component[ic] == null || c.component[ic].length() <= 0) continue;
            if (first) {
                stoich.delete(0, stoich.length());
                first = false;
            } else {
                stoich.delete(0, stoich.length());
                stoich.append(" +");
            }
            if (Math.abs(aX - 1.0) >= 0.001) {
                stoich.append(Util.formatDbl3((double)aX));
            }
            text.append(stoich.toString());
            text.append(" ");
            text.append(c.component[ic]);
        }
        if (!protonsPresent && c.proton < -0.001) {
            if (first) {
                stoich.delete(0, stoich.length());
                first = false;
            } else {
                stoich.delete(0, stoich.length());
                stoich.append(" +");
            }
            if (Math.abs(c.proton - 1.0) >= 0.001) {
                stoich.append(Util.formatDbl3((double)c.proton));
            }
            text.append(stoich.toString());
            text.append(" H+");
        }
        stoich.delete(0, stoich.length());
        if (first) {
            stoich.append(" ");
        } else {
            stoich.append(" + ");
        }
        text.append(stoich);
        text.append(c.name);
        String t = text.toString().trim();
        text.delete(0, text.length());
        text.append(t);
        if (t.startsWith("=") && t.contains("@")) {
            text.deleteCharAt(0);
        }
        return text.toString();
    }

    public static double constCp(double logK0, double deltaH_kJmol, double deltaCp_Jmol, double tC) {
        if (Double.isNaN(logK0) || Double.isNaN(deltaH_kJmol) || Double.isNaN(deltaCp_Jmol) || Double.isNaN(tC)) {
            return Double.NaN;
        }
        if (logK0 == -999999.9 || tC > 24.999 && tC < 25.001) {
            return logK0;
        }
        if (deltaH_kJmol == -999999.9) {
            return logK0;
        }
        double tK = 273.15 + Math.min(100.0, Math.max(0.0, tC));
        double T0 = 298.15;
        double R_LN10 = 19.1448668;
        double logK = logK0 + deltaH_kJmol * 1000.0 / 19.1448668 * (0.0033540164346805303 - 1.0 / tK);
        if (deltaCp_Jmol == -999999.9) {
            return logK;
        }
        return logK += deltaCp_Jmol / 19.1448668 * (298.15 / tK - 1.0 + Math.log(tK / 298.15));
    }

    public static boolean isChargeBalanced(Complex complex) {
        if (complex.name.startsWith("@")) {
            return true;
        }
        double totCharge = Util.chargeOf((String)complex.name);
        boolean hPresent = false;
        for (int i = 0; i < 6; ++i) {
            if (complex.component[i] == null || complex.component[i].length() <= 0 || Math.abs(complex.numcomp[i]) < 0.001) continue;
            totCharge -= complex.numcomp[i] * (double)Util.chargeOf((String)complex.component[i]);
            if (!Util.isProton((String)complex.component[i])) continue;
            hPresent = true;
        }
        if (!hPresent) {
            totCharge -= complex.proton;
        }
        return Math.abs(totCharge) < 0.001;
    }

    public static String checkComplex(Complex rr) {
        StringBuilder sb = new StringBuilder();
        int hPresent = -1;
        for (int i = 0; i < 6; ++i) {
            if ((rr.component[i] == null || rr.component[i].length() <= 0) && Math.abs(rr.numcomp[i]) >= 0.001) {
                sb.append("Complex: \"");
                sb.append(rr.name);
                sb.append("\"");
                sb.append(nl);
                sb.append("Reaction coefficient given with no component.");
            } else if (rr.component[i] != null && rr.component[i].length() > 0) {
                if (Util.isProton((String)rr.component[i])) {
                    hPresent = i;
                }
                if (Math.abs(rr.numcomp[i]) < 0.001) {
                    sb.append("Complex: \"");
                    sb.append(rr.name);
                    sb.append("\"");
                    sb.append(nl);
                    sb.append("No reaction coefficient for component \"");
                    sb.append(rr.component[i]);
                    sb.append("\"");
                }
            }
            if (hPresent <= -1 || !(Math.abs(rr.proton) >= 0.001) || !(Math.abs(rr.numcomp[hPresent] - rr.proton) >= 0.001)) continue;
            if (sb.length() > 0) {
                sb.append(nl);
            }
            sb.append("Complex: \"");
            sb.append(rr.name);
            sb.append("\"");
            sb.append(nl);
            sb.append("conflict between \"H+\" coefficient and nbr of protons.");
        }
        if (!Complex.isChargeBalanced(rr)) {
            if (sb.length() > 0) {
                sb.append(nl);
            }
            sb.append("Complex: \"");
            sb.append(rr.name);
            sb.append("\"");
            sb.append(nl);
            sb.append("Reaction is not charge balanced.");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public static class ReadComplexException
    extends Exception {
        public ReadComplexException() {
        }

        public ReadComplexException(String txt) {
            super(txt);
        }
    }
}

