/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.emf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Properties;
import java.util.logging.Logger;
import org.qenherkhopeshef.graphics.emf.EMFDeviceContext;
import org.qenherkhopeshef.graphics.emf.EMFPen;
import org.qenherkhopeshef.graphics.emf.EMFPoint;
import org.qenherkhopeshef.graphics.generic.BaseGraphics2D;
import org.qenherkhopeshef.graphics.generic.RandomAccessFileAdapter;
import org.qenherkhopeshef.graphics.generic.RandomAccessStream;

public class EMFGraphics2D
extends BaseGraphics2D {
    private EMFDeviceContext deviceContext = null;
    private double deviceScale = 35.3;
    private int level = 0;

    public EMFGraphics2D(File file, Dimension2D dims, String creator, String comment) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        RandomAccessFileAdapter stream = new RandomAccessFileAdapter(new RandomAccessFile(file, "rw"));
        int w = (int)Math.ceil(dims.getWidth());
        int h = (int)Math.ceil(dims.getHeight());
        this.initEMFGraphics2D(stream, w, h, creator, comment);
    }

    public EMFGraphics2D(RandomAccessStream out, Dimension dims, String creator, String comment) throws IOException {
        this(out, dims.width, dims.height, creator, comment);
    }

    public EMFGraphics2D(RandomAccessStream out, long maxx, long maxy, String creator, String comment) throws IOException {
        this.initEMFGraphics2D(out, maxx, maxy, creator, comment);
    }

    public EMFGraphics2D(EMFGraphics2D graphics2D) {
        super(graphics2D);
        this.deviceContext = graphics2D.deviceContext;
        this.deviceScale = graphics2D.deviceScale;
        this.level = graphics2D.level + 1;
    }

    private void initEMFGraphics2D(RandomAccessStream out, long maxx, long maxy, String creator, String comment) throws IOException {
        int w = (int)Math.ceil((double)maxx * this.deviceScale);
        int h = (int)Math.ceil((double)maxy * this.deviceScale);
        this.deviceContext = new EMFDeviceContext(out, w, h, creator, comment);
        this.deviceContext.setWindowOrg(0, 0);
        this.deviceContext.setWindowExt(w, h);
    }

    public void setPictureClip(double minx, double miny, double maxx, double maxy) {
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public Graphics create() {
        return new EMFGraphics2D(this);
    }

    public void dispose() {
        if (this.level == 0) {
            try {
                if (this.deviceContext != null) {
                    this.deviceContext.closeMetafile();
                    this.deviceContext = null;
                    Logger.getLogger("jsesh.graphics").fine("Closing EMF file");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void draw(Shape shape) {
        this.fill(this.getStroke().createStrokedShape(shape));
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void fill(Shape shape) {
        try {
            double[] coords = new double[6];
            Color paintColor = this.getColor();
            if (this.getPaint() instanceof Color) {
                paintColor = (Color)this.getPaint();
            }
            EMFPen pen = this.deviceContext.createFillPen(paintColor.getRGB());
            this.deviceContext.selectPen(pen);
            PathIterator iter = shape.getPathIterator(new AffineTransform());
            this.deviceContext.beginPath();
            EMFPoint lastPoint = this.deviceCoords(0.0, 0.0);
            EMFPoint firstPoint = this.deviceCoords(0.0, 0.0);
            boolean mustClose = false;
            while (!iter.isDone()) {
                int type = iter.currentSegment(coords);
                switch (type) {
                    case 4: {
                        this.deviceContext.closeFigure();
                        mustClose = false;
                        lastPoint = firstPoint;
                        break;
                    }
                    case 3: {
                        EMFPoint[] controls = new EMFPoint[]{this.deviceCoords(coords[0], coords[1]), this.deviceCoords(coords[2], coords[3]), this.deviceCoords(coords[4], coords[5])};
                        this.deviceContext.polyBezierTo(null, controls);
                        lastPoint = controls[2];
                        mustClose = true;
                        break;
                    }
                    case 1: {
                        lastPoint = this.deviceCoords(coords[0], coords[1]);
                        this.deviceContext.lineTo(lastPoint);
                        mustClose = true;
                        break;
                    }
                    case 0: {
                        if (mustClose) {
                            this.deviceContext.closeFigure();
                        }
                        mustClose = false;
                        lastPoint = firstPoint = this.deviceCoords(coords[0], coords[1]);
                        this.deviceContext.moveToEx(firstPoint);
                        break;
                    }
                    case 2: {
                        EMFPoint[] controls = new EMFPoint[3];
                        EMFPoint quadricControl = this.deviceCoords(coords[0], coords[1]);
                        EMFPoint endControl = this.deviceCoords(coords[2], coords[3]);
                        controls[0] = new EMFPoint(lastPoint.getX() + 2L * (quadricControl.getX() - lastPoint.getX()) / 3L, lastPoint.getY() + 2L * (quadricControl.getY() - lastPoint.getY()) / 3L);
                        controls[1] = new EMFPoint(endControl.getX() + 2L * (quadricControl.getX() - endControl.getX()) / 3L, endControl.getY() + 2L * (quadricControl.getY() - endControl.getY()) / 3L);
                        controls[2] = endControl;
                        lastPoint = endControl;
                        this.deviceContext.polyBezierTo(null, controls);
                        mustClose = true;
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected constant in path iterator");
                    }
                }
                iter.next();
            }
            this.deviceContext.endPath();
            this.deviceContext.fillPath();
            this.deviceContext.freePen(pen);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setPaintMode() {
    }

    public void setProperties(Properties properties) {
    }

    public void setXORMode(Color c1) {
    }

    public void setDeviceScale(double deviceScale) {
        this.deviceScale = deviceScale;
    }

    public double getDeviceScale() {
        return this.deviceScale;
    }

    private EMFPoint deviceCoords(double x, double y) {
        return this.deviceCoords(new Point2D.Double(x, y));
    }

    private EMFPoint deviceCoords(Point2D p) {
        Point2D.Double res = new Point2D.Double();
        this.getTransform().transform(p, res);
        return new EMFPoint((short)(((Point2D)res).getX() * this.deviceScale), (short)(((Point2D)res).getY() * this.deviceScale));
    }
}

