/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.wmf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.qenherkhopeshef.graphics.generic.BaseGraphics2D;
import org.qenherkhopeshef.graphics.generic.RandomAccessFileAdapter;
import org.qenherkhopeshef.graphics.generic.RandomAccessStream;
import org.qenherkhopeshef.graphics.generic.SortablePolygon;
import org.qenherkhopeshef.graphics.utils.DoubleDimensions;
import org.qenherkhopeshef.graphics.utils.GeometryUtils;
import org.qenherkhopeshef.graphics.wmf.WMFDeviceContext;
import org.qenherkhopeshef.graphics.wmf.WMFPen;
import org.qenherkhopeshef.graphics.wmf.WMFPoint;

public class WMFGraphics2D
extends BaseGraphics2D {
    private static final int BASE_SCALE = 20;
    private float currentLineWidth;
    WMFPen currentPen;
    private Dimension2D dimensions;
    private double precision = 0.05;
    private WMFDeviceContext wmfOut;
    private boolean closeOnDispose;

    public WMFGraphics2D(File f, Dimension2D dims) throws IOException {
        this(new RandomAccessFileAdapter(new RandomAccessFile(f, "rw")), dims);
    }

    public WMFGraphics2D(String fname, Dimension2D dims) throws IOException {
        this(new File(fname), dims);
    }

    public WMFGraphics2D(RandomAccessStream stream, Dimension2D dims) throws IOException {
        this.closeOnDispose = true;
        this.dimensions = new DoubleDimensions(dims.getWidth() * 20.0, dims.getHeight() * 20.0);
        this.wmfOut = new WMFDeviceContext(stream, this.dimensions);
        this.scale(20.0, 20.0);
        this.setFont(new Font("SansSerif", 0, 12));
        this.writeHeader();
    }

    private WMFGraphics2D(WMFGraphics2D g) {
        super(g);
        this.dimensions = g.dimensions;
        this.wmfOut = g.wmfOut;
        this.closeOnDispose = false;
    }

    public WMFGraphics2D(RandomAccessStream out, int width, int height) throws IOException {
        this(out, (Dimension2D)new Dimension(width, height));
    }

    private WMFPoint deviceCoords(double x, double y) {
        return this.deviceCoords(new Point2D.Double(x, y));
    }

    private WMFPoint deviceCoords(Point2D p) {
        Point2D.Double res = new Point2D.Double();
        this.getTransform().transform(p, res);
        return new WMFPoint((short)((Point2D)res).getX(), (short)((Point2D)res).getY());
    }

    public void draw(Shape shape) {
        try {
            WMFPen p = this.wmfOut.createDrawPen(this.getWMFLineWidth(), WMFDeviceContext.buildColor(this.getColor()));
            this.wmfOut.selectPen(p);
            if (shape instanceof Line2D) {
                Line2D l = (Line2D)shape;
                WMFPoint p1 = this.deviceCoords(l.getP1());
                WMFPoint p2 = this.deviceCoords(l.getP2());
                this.wmfOut.MoveTo(p1.x, p1.y);
                this.wmfOut.LineTo(p2.x, p2.y);
            } else {
                FlatteningPathIterator iter = new FlatteningPathIterator(shape.getPathIterator(null), this.precision);
                WMFPoint first = null;
                while (!iter.isDone()) {
                    double[] coords = new double[6];
                    int type = iter.currentSegment(coords);
                    switch (type) {
                        case 4: {
                            this.wmfOut.LineTo(first);
                            break;
                        }
                        case 3: {
                            this.wmfOut.LineTo(this.deviceCoords(coords[0], coords[1]));
                            this.wmfOut.LineTo(this.deviceCoords(coords[2], coords[3]));
                            this.wmfOut.LineTo(this.deviceCoords(coords[4], coords[5]));
                            break;
                        }
                        case 1: {
                            this.wmfOut.LineTo(this.deviceCoords(coords[0], coords[1]));
                            break;
                        }
                        case 0: {
                            first = this.deviceCoords(coords[0], coords[1]);
                            this.wmfOut.MoveTo(first);
                            break;
                        }
                        case 2: {
                            this.wmfOut.LineTo(this.deviceCoords(coords[0], coords[1]));
                            this.wmfOut.LineTo(this.deviceCoords(coords[2], coords[3]));
                            break;
                        }
                        default: {
                            throw new RuntimeException("unexpected constant in path iterator");
                        }
                    }
                    iter.next();
                }
            }
            this.wmfOut.freePen(p);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void fill(Shape shape) {
        try {
            double[] coords = new double[6];
            Color fillColor = this.getColor();
            if (this.getPaint() instanceof Color) {
                fillColor = (Color)this.getPaint();
            }
            WMFPen fillPen = this.wmfOut.createFillPen(WMFDeviceContext.buildColor(fillColor));
            WMFPen unfillPen = this.wmfOut.createFillPen(WMFDeviceContext.buildColor(this.getBackground()));
            if (shape instanceof Rectangle2D) {
                Rectangle2D r = (Rectangle2D)shape;
                WMFPoint topLeft = this.deviceCoords(r.getMinX(), r.getMinY());
                WMFPoint bottomRight = this.deviceCoords(r.getMaxX(), r.getMaxY());
                this.wmfOut.selectPen(fillPen);
                this.wmfOut.rectangle(topLeft.x, topLeft.y, bottomRight.x, bottomRight.y);
            } else {
                Area shapeAsArea = new Area(shape);
                PathIterator iter = shapeAsArea.getPathIterator(null, this.precision);
                ArrayList<List> polygons = new ArrayList<List>();
                ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
                while (!iter.isDone()) {
                    int type = iter.currentSegment(coords);
                    switch (type) {
                        case 4: {
                            polygons.add(points);
                            points = new ArrayList();
                            break;
                        }
                        case 3: {
                            int i;
                            for (i = 0; i < 6; i += 2) {
                                points.add(new Point2D.Double(coords[i], coords[i + 1]));
                            }
                            break;
                        }
                        case 1: {
                            points.add(new Point2D.Double(coords[0], coords[1]));
                            break;
                        }
                        case 0: {
                            if (!points.isEmpty()) {
                                polygons.add(points);
                                points = new ArrayList();
                            }
                            points.add(new Point2D.Double(coords[0], coords[1]));
                            break;
                        }
                        case 2: {
                            int i;
                            for (i = 0; i < 4; i += 2) {
                                points.add(new Point2D.Double(coords[i], coords[i + 1]));
                            }
                            break;
                        }
                        default: {
                            throw new RuntimeException("unexpected constant in path iterator");
                        }
                    }
                    iter.next();
                }
                if (!points.isEmpty()) {
                    polygons.add(points);
                    points = null;
                }
                if (!polygons.isEmpty()) {
                    List pts;
                    double area = 0.0;
                    Object[] sortablePolygons = new SortablePolygon[polygons.size()];
                    for (int i = 0; i < polygons.size(); ++i) {
                        pts = (List)polygons.get(i);
                        sortablePolygons[i] = new SortablePolygon(pts);
                        area += GeometryUtils.algebricArea(pts);
                    }
                    Arrays.sort(sortablePolygons);
                    for (int k = 0; k < sortablePolygons.length; ++k) {
                        polygons.set(k, ((SortablePolygon)sortablePolygons[k]).points);
                    }
                    if (area < 0.0) {
                        WMFPen p = fillPen;
                        fillPen = unfillPen;
                        unfillPen = p;
                    }
                    Iterator i = polygons.iterator();
                    while (i.hasNext()) {
                        pts = (List)i.next();
                        if (GeometryUtils.algebricArea(pts) > 0.0) {
                            this.wmfFillPolygon(pts, fillPen);
                            continue;
                        }
                        this.wmfFillPolygon(pts, unfillPen);
                    }
                }
            }
            this.wmfOut.freePen(fillPen);
            this.wmfOut.freePen(unfillPen);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double getPrecision() {
        return this.precision;
    }

    public short getWMFLineWidth() {
        return (short)((double)this.currentLineWidth * this.getTransform().getScaleY());
    }

    public void setPrecision(double precision) {
        this.precision = precision;
    }

    public void setStroke(Stroke stroke) {
        super.setStroke(stroke);
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            this.currentLineWidth = bs.getLineWidth();
        }
    }

    private void wmfFillPolygon(List points, WMFPen fill) throws IOException {
        if (points.isEmpty()) {
            return;
        }
        WMFPoint[] pts = new WMFPoint[points.size()];
        for (int i = 0; i < pts.length; ++i) {
            pts[i] = this.deviceCoords((Point2D)points.get(i));
        }
        this.wmfOut.selectPen(fill);
        this.wmfOut.Polygon(pts, (short)pts.length);
    }

    private void writeHeader() throws IOException {
        this.wmfOut.setWindowOrg((short)0, (short)0);
        this.wmfOut.setWindowExt((short)this.dimensions.getWidth(), (short)this.dimensions.getHeight());
        this.wmfOut.SaveDC();
        this.wmfOut.SetROP2(13L);
        this.wmfOut.SetBKColor(0L);
        this.wmfOut.SetBKMode((short)1);
        this.wmfOut.createPenIndirect(0, (short)20, WMFDeviceContext.buildColor(0, 0, 0));
        this.wmfOut.SelectObject((short)0);
        this.wmfOut.createBrushIndirect((short)0, 0L, 0);
        this.wmfOut.SelectObject((short)1);
        this.wmfOut.SetPolyFillMode((short)2);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public Graphics create() {
        return new WMFGraphics2D(this);
    }

    public void dispose() {
        if (this.closeOnDispose && this.wmfOut != null) {
            try {
                this.wmfOut.RestoreDC((short)-1);
                this.wmfOut.close();
                this.wmfOut = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.wmfOut = null;
        }
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }

    public void setProperties(Properties properties) {
    }
}

