/*
 * Decompiled with CFR 0.152.
 */
package lib.huvud;

import java.awt.Component;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import lib.common.Util;

public class RunProgr {
    private static final String nl = System.getProperty("line.separator");
    private static final String SLASH = File.separator;

    public static boolean runProgramInProcess(Component parent, String prgm, String[] a, boolean waitForCompletion, boolean dbg, String path) {
        String prgmFileName;
        if (prgm == null || prgm.trim().length() <= 0) {
            String msg = "Programming Error" + nl + "detected in \"runProgramInProcess\"" + nl;
            msg = prgm == null ? msg + "   program or jar file name is \"null\"." : msg + "   program or jar file name is empty.";
            Util.showErrMsg(parent, msg, 1);
            return false;
        }
        if (parent != null) {
            parent.setCursor(new Cursor(3));
        }
        if (dbg) {
            System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - - -");
        }
        if (prgm.length() > 2 && prgm.startsWith("\"") && prgm.endsWith("\"")) {
            prgm = prgm.substring(1, prgm.length() - 1);
        }
        if (!prgm.contains(SLASH) && path != null && path.trim().length() > 0) {
            String dir = path.endsWith(SLASH) ? path.substring(0, path.length() - 1) : path;
            prgmFileName = dir + SLASH + prgm;
        } else {
            prgmFileName = prgm;
        }
        if (!new File(prgmFileName).exists()) {
            Util.showErrMsg(parent, "Error:  Program or jar file:" + nl + "       " + prgmFileName + nl + "   does NOT exist.", 1);
            return false;
        }
        ArrayList<String> command = new ArrayList<String>();
        if (prgmFileName.toLowerCase().endsWith(".jar")) {
            command.add("java");
            command.add("-jar");
        } else if (prgmFileName.toLowerCase().endsWith(".app") && System.getProperty("os.name").toLowerCase().startsWith("mac os")) {
            command.add("/usr/bin/open");
            command.add("-n");
        }
        command.add(prgmFileName);
        if (a == null) {
            a = new String[]{};
        }
        if (a.length > 0) {
            for (String a1 : a) {
                if (a1 == null || a1.length() <= 0) continue;
                command.add(a1);
            }
        }
        if (dbg) {
            System.out.println("starting process:");
            if (a.length > 0) {
                for (int i = 0; i < command.size(); ++i) {
                    System.out.println("   " + (String)command.get(i));
                }
                System.out.flush();
            }
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        if (path != null && path.trim().length() > 0) {
            if (dbg) {
                System.out.println("   --- setting working directory to: " + path);
                System.out.flush();
            }
            builder = builder.directory(new File(path));
        }
        System.out.flush();
        if (parent != null) {
            parent.setCursor(new Cursor(0));
        }
        if (!waitForCompletion) {
            builder = builder.redirectErrorStream(true);
        }
        try {
            if (dbg) {
                System.out.println("   --- starting the process...");
                System.out.flush();
            }
            Process p = builder.start();
            if (waitForCompletion) {
                String s;
                if (dbg) {
                    System.out.println("   --- waiting for process to terminate...");
                }
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((s = stdInput.readLine()) != null) {
                    System.out.println(s);
                }
                while ((s = stdError.readLine()) != null) {
                    System.err.println(s);
                }
                p.waitFor();
            } else {
                new Thread(new StreamEater(p.getInputStream())).start();
            }
            if (dbg) {
                System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - - -");
            }
        }
        catch (InterruptedException e) {
            Util.showErrMsg(parent, Util.stack2string(e), 1);
            return false;
        }
        catch (IOException e) {
            Util.showErrMsg(parent, Util.stack2string(e), 1);
            return false;
        }
        if (parent != null) {
            parent.setCursor(new Cursor(0));
        }
        return true;
    }

    private static class StreamEater
    implements Runnable {
        private final InputStream stream;

        StreamEater(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            byte[] buf = new byte[32];
            try {
                while (this.stream.read(buf) != -1) {
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

