/*
 * Decompiled with CFR 0.152.
 */
package lib.database;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import lib.common.Util;
import lib.database.Complex;
import lib.database.LibDB;
import lib.database.ProgramDataDB;

public class LibSearch {
    private ProgramDataDB pd;
    private int db;
    private String complxFileName;
    private long cmplxNbr = 0L;
    private DataInputStream dis;
    private BufferedReader br;
    private int binaryOrText = 0;
    private boolean openNextFile = true;
    private boolean noFilesFound = true;
    private static final String nl = System.getProperty("line.separator");

    public LibSearch(ProgramDataDB programData) throws LibSearchException {
        if (programData == null) {
            throw new LibSearchException("Error: programDataDB = null in \"DBSearch\" constructor");
        }
        this.pd = programData;
    }

    public Complex getComplex(boolean firstComplex) throws LibSearchException {
        if (firstComplex) {
            this.openNextFile = true;
            this.db = 0;
        }
        while (this.db < this.pd.dataBasesList.size()) {
            if (this.openNextFile) {
                try {
                    if (this.dis != null) {
                        this.dis.close();
                    } else if (this.br != null) {
                        this.br.close();
                    }
                }
                catch (IOException ioe) {
                    Util.msg((String)ioe.getMessage());
                }
                this.complxFileName = this.pd.dataBasesList.get(this.db);
                if (this.complxFileName == null || this.complxFileName.length() <= 0) continue;
                File dbf = new File(this.complxFileName);
                if (!dbf.exists() || !dbf.canRead()) {
                    String msg = "Can not open file" + nl + "    \"" + this.complxFileName + "\".";
                    if (!dbf.exists()) {
                        msg = msg + nl + "(the file does not exist)." + nl + "Search terminated";
                    }
                    throw new LibSearchException(msg);
                }
                this.cmplxNbr = 0L;
                try {
                    if (this.complxFileName.toLowerCase().endsWith("db")) {
                        this.binaryOrText = 2;
                        this.dis = new DataInputStream(new FileInputStream(dbf));
                    } else {
                        this.binaryOrText = 1;
                        this.br = new BufferedReader(new FileReader(dbf));
                    }
                }
                catch (FileNotFoundException ex) {
                    try {
                        if (this.dis != null) {
                            this.dis.close();
                        } else if (this.br != null) {
                            this.br.close();
                        }
                    }
                    catch (IOException ioe) {
                        Util.msg((String)ioe.getMessage());
                    }
                    String msg = "Error: " + ex.getMessage() + nl + "while trying to open file: \"" + this.complxFileName + "\"." + nl + "Search terminated";
                    throw new LibSearchException(msg);
                }
                this.noFilesFound = false;
                this.openNextFile = false;
            }
            Complex complex = null;
            ++this.cmplxNbr;
            if (this.binaryOrText == 2) {
                try {
                    complex = LibDB.getBinComplex(this.dis);
                }
                catch (LibDB.ReadBinCmplxException ex) {
                    String msg = ex.getMessage() + nl + "reading reaction nbr. = " + this.cmplxNbr + " in \"getComplex\"" + nl + "from file: \"" + this.complxFileName + "\"";
                    throw new LibSearchException(msg);
                }
            }
            if (this.binaryOrText == 1) {
                try {
                    try {
                        complex = LibDB.getTxtComplex(this.br);
                    }
                    catch (LibDB.EndOfFileException ex) {
                        complex = null;
                    }
                }
                catch (LibDB.ReadTxtCmplxException ex) {
                    String msg = ex.getMessage() + nl + "reading reaction nbr. = " + this.cmplxNbr + " in \"getComplex\"" + nl + "from file: \"" + this.complxFileName + "\"";
                    throw new LibSearchException(msg);
                }
            }
            if (complex != null) {
                return complex;
            }
            ++this.db;
            this.openNextFile = true;
        }
        if (this.noFilesFound) {
            Util.exceptn((String)"Error: none of the databases could be found.");
            throw new LibSearchException("None of the databases could be found.");
        }
        try {
            if (this.dis != null) {
                this.dis.close();
            } else if (this.br != null) {
                this.br.close();
            }
        }
        catch (IOException ioe) {
            Util.msg((String)ioe.getMessage());
        }
        this.binaryOrText = 0;
        return null;
    }

    public class LibSearchException
    extends Exception {
        public LibSearchException() {
        }

        public LibSearchException(String txt) {
            super(txt);
        }
    }
}

