/*
 * Decompiled with CFR 0.152.
 */
package spana;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import lib.common.Util;
import lib.huvud.Div;
import lib.huvud.ProgramConf;
import lib.huvud.RunProgr;
import lib.kemi.graph_lib.DiagrPaintUtility;
import lib.kemi.graph_lib.GraphLib;
import org.qenherkhopeshef.graphics.vectorClipboard.SimpleClipGraphics;
import spana.ClipboardCopy_Image;
import spana.DiagrConvert;
import spana.DiagrExport;
import spana.DiagrPrintUtility;
import spana.DiagrWSize;
import spana.ProgramDataSpana;
import spana.SpanaFrame;

public class Disp
extends JFrame {
    private ProgramConf pc;
    private final ProgramDataSpana pd;
    private File plotFile;
    private int icon_type = 1;
    private GraphLib.PltData dd;
    private final DiagrPaintUtility diagrPaintUtil;
    public String diagrName;
    public String diagrFullName;
    public Dimension diagrSize;
    private boolean loading = true;
    private DiagrExport dExp = null;
    private DiagrConvert dConv = null;
    private static final NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private static final DecimalFormat myFormatter = (DecimalFormat)nf;
    private static final String nl = System.getProperty("line.separator");
    private final JPanel jPanelDispPlot;
    private JLabel jLabel_XY;
    private JMenu jMenu;
    private JMenuBar jMenuBar;
    private JMenu jMenuConvert;
    private JMenu jMenuCopyAs;
    private JMenuItem jMenuExport;
    private JMenuItem jMenuHelp;
    private JMenu jMenuHlp;
    private JMenuItem jMenuItemPDF;
    private JMenuItem jMenuItemPS;
    private JMenuItem jMenuMainW;
    private JMenuItem jMenuPrint;
    private JMenuItem jMenuRefresh;
    private JMenuItem jMenuWSize;
    private JMenuItem jMenu_Copy_EMF;
    private JMenuItem jMenu_Copy_EMF_RTF;
    private JMenuItem jMenu_Copy_Image;
    private JMenuItem jMenu_Copy_MacPict;
    private JMenuItem jMenu_Copy_WMF_RTF;
    private JMenuItem jMenu_Exit;
    private JPanel jPanel_XY;
    private JSeparator jSeparator1;
    private JPopupMenu.Separator jSeparator2;

    public Disp(DiagrPaintUtility dPaintUtil, ProgramConf pc0, ProgramDataSpana pd0) {
        this.initComponents();
        this.diagrPaintUtil = dPaintUtil;
        this.pc = pc0;
        this.pd = pd0;
        this.loading = true;
        this.jPanelDispPlot = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D g2D = (Graphics2D)g;
                Disp.this.diagrPaintUtil.paintDiagram(g2D, Disp.this.jPanelDispPlot.getSize(), Disp.this.dd, false);
            }
        };
        this.jPanelDispPlot.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (((Disp)Disp.this).dd.axisInfo) {
                    Disp.this.maybeShowPopup(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (((Disp)Disp.this).dd.axisInfo) {
                    Disp.this.maybeHidePopup(evt);
                }
            }
        });
        this.jPanelDispPlot.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                if (((Disp)Disp.this).dd.axisInfo) {
                    Disp.this.maybeMovePopup(evt);
                }
            }
        });
        this.jPanelDispPlot.setBackground(new Color(255, 255, 255));
        this.jPanelDispPlot.setFont(new Font("Dialog", 0, 11));
        this.add(this.jPanelDispPlot);
        this.jPanelDispPlot.setTransferHandler(SpanaFrame.tHandler);
        this.jMenuBar.setTransferHandler(SpanaFrame.tHandler);
        this.jPanelDispPlot.setLocation(0, 0);
        this.jPanelDispPlot.setSize(this.getContentPane().getSize());
        this.pack();
        SpanaFrame.dispSize.width = Math.max(120, Math.min(SpanaFrame.screenSize.width, SpanaFrame.dispSize.width));
        SpanaFrame.dispSize.height = Math.max(100, Math.min(SpanaFrame.screenSize.height, SpanaFrame.dispSize.height));
        SpanaFrame.dispLocation.x = Math.max(60, Math.min(SpanaFrame.dispLocation.x, SpanaFrame.screenSize.width - SpanaFrame.dispSize.width));
        SpanaFrame.dispLocation.y = Math.max(10, Math.min(SpanaFrame.dispLocation.y, SpanaFrame.screenSize.height - SpanaFrame.dispSize.height));
        this.setLocation(SpanaFrame.dispLocation);
        this.setSize(SpanaFrame.dispSize);
        this.diagrSize = this.getSize();
        this.setDefaultCloseOperation(0);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Disp.this.closeWindow();
            }
        };
        this.getRootPane().getActionMap().put("ALT_Q", escAction);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Disp.this.jMenuHelp.doClick();
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        this.jMenuBar.add(Box.createHorizontalGlue(), 1);
        this.setTitle("Plot file display");
        this.jPanel_XY.setVisible(false);
        this.setAdvancedFeatures(this.pd.advancedVersion);
        this.setVisible(true);
        this.toFront();
        this.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (((Disp)Disp.this).pc.pathAPP != null && ((Disp)Disp.this).pc.pathAPP.trim().length() > 0) {
                    File f = new File(((Disp)Disp.this).pc.pathAPP + File.separator + "PlotPS.jar");
                    if (f.exists()) {
                        Disp.this.jMenuItemPS.setEnabled(true);
                    }
                    if ((f = new File(((Disp)Disp.this).pc.pathAPP + File.separator + "PlotPDF.jar")).exists()) {
                        Disp.this.jMenuItemPDF.setEnabled(true);
                    }
                }
                if (!Disp.this.jMenuItemPS.isEnabled() && !Disp.this.jMenuItemPDF.isEnabled()) {
                    Disp.this.jMenuConvert.setEnabled(false);
                }
            }
        });
    }

    public void startPlotFile(File plotFile0) {
        this.plotFile = plotFile0;
        this.diagrName = null;
        this.diagrFullName = null;
        if (this.plotFile != null) {
            if (this.pc.dbg) {
                System.out.println("Disp(" + this.plotFile.getAbsolutePath() + ")");
            }
            if (!this.readThePlotFile(this.plotFile)) {
                Util.exceptn((String)"Error reading plot file");
            } else {
                this.diagrName = this.plotFile.getName();
                this.diagrFullName = this.plotFile.getAbsolutePath();
            }
        } else {
            Util.exceptn((String)"Error in \"Disp\": plot file is null.");
        }
        if (this.diagrName == null || this.diagrName.trim().length() <= 0) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        this.setTitle(this.dd.pltFile_Name);
        this.loading = false;
        this.jPanelDispPlot.repaint();
    }

    private void initComponents() {
        this.jPanel_XY = new JPanel();
        this.jLabel_XY = new JLabel();
        this.jMenuBar = new JMenuBar();
        this.jMenu = new JMenu();
        this.jMenuCopyAs = new JMenu();
        this.jMenu_Copy_EMF = new JMenuItem();
        this.jMenu_Copy_WMF_RTF = new JMenuItem();
        this.jMenu_Copy_EMF_RTF = new JMenuItem();
        this.jMenu_Copy_MacPict = new JMenuItem();
        this.jMenu_Copy_Image = new JMenuItem();
        this.jMenuExport = new JMenuItem();
        this.jMenuConvert = new JMenu();
        this.jMenuItemPDF = new JMenuItem();
        this.jMenuItemPS = new JMenuItem();
        this.jMenuPrint = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuRefresh = new JMenuItem();
        this.jMenuWSize = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuMainW = new JMenuItem();
        this.jMenu_Exit = new JMenuItem();
        this.jMenuHlp = new JMenu();
        this.jMenuHelp = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                Disp.this.formWindowActivated(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                Disp.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                Disp.this.formComponentMoved(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                Disp.this.formComponentResized(evt);
            }
        });
        this.getContentPane().setLayout(null);
        this.jPanel_XY.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel_XY.setFont(new Font("Dialog", 0, 11));
        this.jLabel_XY.setFont(new Font("Dialog", 0, 11));
        this.jLabel_XY.setText("<html>&nbsp;x:0.00000<br>&nbsp;y:-8.00E+00&nbsp;</html>");
        this.jLabel_XY.setFocusable(false);
        this.jLabel_XY.setPreferredSize(new Dimension(70, 30));
        GroupLayout jPanel_XYLayout = new GroupLayout(this.jPanel_XY);
        this.jPanel_XY.setLayout(jPanel_XYLayout);
        jPanel_XYLayout.setHorizontalGroup(jPanel_XYLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_XYLayout.createSequentialGroup().addComponent(this.jLabel_XY, -2, 65, -2).addContainerGap(23, Short.MAX_VALUE)));
        jPanel_XYLayout.setVerticalGroup(jPanel_XYLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_XYLayout.createSequentialGroup().addComponent(this.jLabel_XY, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add(this.jPanel_XY);
        this.jPanel_XY.setBounds(10, 10, 90, 43);
        this.jMenu.setMnemonic('m');
        this.jMenu.setText("Menu");
        this.jMenuCopyAs.setMnemonic('c');
        this.jMenuCopyAs.setText("Copy as ...");
        this.jMenu_Copy_EMF.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenu_Copy_EMF.setText("EMF (Enhanced MetaFile)");
        this.jMenu_Copy_EMF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenu_Copy_EMFActionPerformed(evt);
            }
        });
        this.jMenuCopyAs.add(this.jMenu_Copy_EMF);
        this.jMenu_Copy_WMF_RTF.setText("WMF (Windows MetaFile) RTF-embedded");
        this.jMenu_Copy_WMF_RTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenu_Copy_WMF_RTFActionPerformed(evt);
            }
        });
        this.jMenuCopyAs.add(this.jMenu_Copy_WMF_RTF);
        this.jMenu_Copy_EMF_RTF.setText("EMF embedded in RTF");
        this.jMenu_Copy_EMF_RTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenu_Copy_EMF_RTFActionPerformed(evt);
            }
        });
        this.jMenuCopyAs.add(this.jMenu_Copy_EMF_RTF);
        this.jMenu_Copy_MacPict.setText("MacPict embedded in RTF");
        this.jMenu_Copy_MacPict.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenu_Copy_MacPictActionPerformed(evt);
            }
        });
        this.jMenuCopyAs.add(this.jMenu_Copy_MacPict);
        this.jMenu_Copy_Image.setText("Image (bitmap)");
        this.jMenu_Copy_Image.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenu_Copy_ImageActionPerformed(evt);
            }
        });
        this.jMenuCopyAs.add(this.jMenu_Copy_Image);
        this.jMenu.add(this.jMenuCopyAs);
        this.jMenuExport.setMnemonic('e');
        this.jMenuExport.setText("Export to bitmap file");
        this.jMenuExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenuExportActionPerformed(evt);
            }
        });
        this.jMenu.add(this.jMenuExport);
        this.jMenuConvert.setMnemonic('n');
        this.jMenuConvert.setText("convert to ...");
        this.jMenuItemPDF.setMnemonic('d');
        this.jMenuItemPDF.setText("PDF");
        this.jMenuItemPDF.setEnabled(false);
        this.jMenuItemPDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenuItemPDFActionPerformed(evt);
            }
        });
        this.jMenuConvert.add(this.jMenuItemPDF);
        this.jMenuItemPS.setMnemonic('s');
        this.jMenuItemPS.setText("PS (or EPS)");
        this.jMenuItemPS.setEnabled(false);
        this.jMenuItemPS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenuItemPSActionPerformed(evt);
            }
        });
        this.jMenuConvert.add(this.jMenuItemPS);
        this.jMenu.add(this.jMenuConvert);
        this.jMenuPrint.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        this.jMenuPrint.setMnemonic('p');
        this.jMenuPrint.setText("Print");
        this.jMenuPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenuPrintActionPerformed(evt);
            }
        });
        this.jMenu.add(this.jMenuPrint);
        this.jMenu.add(this.jSeparator1);
        this.jMenuRefresh.setMnemonic('r');
        this.jMenuRefresh.setText("Refresh");
        this.jMenuRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenuRefreshActionPerformed(evt);
            }
        });
        this.jMenu.add(this.jMenuRefresh);
        this.jMenuWSize.setMnemonic('s');
        this.jMenuWSize.setText("window Size");
        this.jMenuWSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenuWSizeActionPerformed(evt);
            }
        });
        this.jMenu.add(this.jMenuWSize);
        this.jMenu.add(this.jSeparator2);
        this.jMenuMainW.setAccelerator(KeyStroke.getKeyStroke(87, 8));
        this.jMenuMainW.setMnemonic('w');
        this.jMenuMainW.setText("main Window");
        this.jMenuMainW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenuMainWActionPerformed(evt);
            }
        });
        this.jMenu.add(this.jMenuMainW);
        this.jMenu_Exit.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.jMenu_Exit.setMnemonic('x');
        this.jMenu_Exit.setText("eXit");
        this.jMenu_Exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenu_ExitActionPerformed(evt);
            }
        });
        this.jMenu.add(this.jMenu_Exit);
        this.jMenuBar.add(this.jMenu);
        this.jMenuHlp.setMnemonic('H');
        this.jMenuHlp.setText("Help");
        this.jMenuHlp.setToolTipText("Help");
        this.jMenuHelp.setMnemonic('D');
        this.jMenuHelp.setText("Diagram Windows");
        this.jMenuHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Disp.this.jMenuHelpActionPerformed(evt);
            }
        });
        this.jMenuHlp.add(this.jMenuHelp);
        this.jMenuBar.add(this.jMenuHlp);
        this.setJMenuBar(this.jMenuBar);
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.getExtendedState() == 1) {
            return;
        }
        if (this.getExtendedState() != 6) {
            if (this.getHeight() < 100) {
                this.setSize(this.getWidth(), 100);
            }
            if (this.getWidth() < 120) {
                this.setSize(120, this.getHeight());
            }
            this.diagrSize = this.getSize();
            if (!this.loading) {
                SpanaFrame.dispSize = this.diagrSize;
            }
        }
        if (this.isVisible()) {
            this.jPanelDispPlot.setSize(this.getContentPane().getSize());
        }
    }

    private void formWindowActivated(WindowEvent evt) {
        this.setAdvancedFeatures(this.pd.advancedVersion);
        String iconName = this.icon_type == 1 ? "images/PlotLog256_32x32_whiteBckgr.gif" : "images/PlotPred256_32x32_whiteBckgr.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            Util.exceptn((String)("Could not load image = \"" + iconName + "\""));
        }
        this.jPanel_XY.setVisible(false);
    }

    private void jMenuPrintActionPerformed(ActionEvent evt) {
        this.printDiagram(false);
    }

    private void jMenu_Copy_WMF_RTFActionPerformed(ActionEvent evt) {
        this.copyWith_jVectClipboard(2);
    }

    private void jMenu_Copy_EMF_RTFActionPerformed(ActionEvent evt) {
        this.copyWith_jVectClipboard(1);
    }

    private void jMenu_Copy_MacPictActionPerformed(ActionEvent evt) {
        this.copyWith_jVectClipboard(4);
    }

    private void jMenu_Copy_ImageActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        double h0 = Math.max(10, Math.abs(this.dd.userSpaceMax.y - this.dd.userSpaceMin.y));
        double w0 = Math.max(10, Math.abs(this.dd.userSpaceMax.x - this.dd.userSpaceMin.x));
        double h2w = h0 / w0;
        ClipboardCopy_Image.setClipboard_Image(h2w, this.dd, this.diagrPaintUtil);
        this.setCursor(new Cursor(0));
    }

    private void jMenu_ExitActionPerformed(ActionEvent evt) {
        this.closeWindow();
    }

    private void jMenuMainWActionPerformed(ActionEvent evt) {
        if (SpanaFrame.getInstance().getExtendedState() == 1 || SpanaFrame.getInstance().getExtendedState() == 6) {
            SpanaFrame.getInstance().setExtendedState(0);
        }
        SpanaFrame.getInstance().setEnabled(true);
        SpanaFrame.getInstance().requestFocus();
    }

    private void jMenuExportActionPerformed(ActionEvent evt) {
        this.exportImage();
    }

    private void formComponentMoved(ComponentEvent evt) {
        if (!this.loading) {
            SpanaFrame.dispLocation = this.getLocation();
        }
    }

    private void jMenuHelpActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        String[] a = new String[]{"S_Diagram_Window_htm"};
        RunProgr.runProgramInProcess((Component)this, (String)"Chem_Diagr_Help.jar", (String[])a, (boolean)false, (boolean)this.pc.dbg, (String)this.pc.pathAPP);
        this.setCursor(new Cursor(0));
    }

    private void jMenuRefreshActionPerformed(ActionEvent evt) {
        this.reloadPlotFile();
        this.repaint();
    }

    private void jMenuWSizeActionPerformed(ActionEvent evt) {
        DiagrWSize d = new DiagrWSize((Frame)this, true, this);
        d.setVisible(true);
        this.setSize(this.diagrSize);
    }

    private void jMenuItemPDFActionPerformed(ActionEvent evt) {
        this.pltConvertFile(this.plotFile.getAbsolutePath(), "pdf");
    }

    private void jMenuItemPSActionPerformed(ActionEvent evt) {
        String type = this.pd.diagrConvertEPS ? "eps" : "ps";
        this.pltConvertFile(this.plotFile.getAbsolutePath(), type);
    }

    private void jMenu_Copy_EMFActionPerformed(ActionEvent evt) {
        this.copyWith_jVectClipboard(3);
    }

    public void reloadPlotFile() {
        if (this.dd.pltFile_Name == null) {
            return;
        }
        File f = new File(this.dd.pltFile_Name);
        if (!this.readThePlotFile(f)) {
            String t = "Error reading plot file";
            Util.msg((String)t);
            JOptionPane.showMessageDialog(this, t, this.pc.progName, 0);
            this.dispose();
            return;
        }
        String iconName = this.icon_type == 1 ? "images/PlotLog256_32x32_whiteBckgr.gif" : "images/PlotPred256_32x32_whiteBckgr.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            this.setIconImage(new ImageIcon(imgURL).getImage());
        } else {
            Util.exceptn((String)("Could not load image = \"" + iconName + "\""));
        }
    }

    public void printDiagram(boolean defaultPrinter) {
        this.setCursor(new Cursor(3));
        this.jPanel_XY.setVisible(false);
        this.jPanelDispPlot.requestFocus();
        this.jMenuPrint.setEnabled(false);
        this.jMenuCopyAs.setEnabled(false);
        this.jMenuExport.setEnabled(false);
        DiagrPrintUtility.printComponent(this.jPanelDispPlot, this.dd, defaultPrinter, this.diagrPaintUtil, this.pc.progName);
        this.jMenuPrint.setEnabled(true);
        this.jMenuCopyAs.setEnabled(true);
        this.jMenuExport.setEnabled(true);
        this.setCursor(new Cursor(0));
    }

    private void copyWith_jVectClipboard(int i) {
        if (i < 1 || i > 4) {
            return;
        }
        this.setCursor(new Cursor(3));
        SimpleClipGraphics clipGraphics = new SimpleClipGraphics(this.jPanelDispPlot.getWidth(), this.jPanelDispPlot.getHeight());
        if (i == 1) {
            clipGraphics.setPictureFormat(2);
        } else if (i == 2) {
            clipGraphics.setPictureFormat(1);
        } else if (i == 3) {
            clipGraphics.setPictureFormat(4);
        } else if (i == 4) {
            clipGraphics.setPictureFormat(3);
        }
        Graphics2D g = clipGraphics.getGraphics();
        boolean printing = false;
        this.diagrPaintUtil.paintDiagram(g, this.jPanelDispPlot.getSize(), this.dd, printing);
        g.dispose();
        clipGraphics.copyToClipboard();
        this.setCursor(new Cursor(0));
        System.out.println("Copied to clipboard");
    }

    private void closeWindow() {
        if (this.dExp != null) {
            this.dExp.closeWindow();
        }
        if (this.dConv != null) {
            this.dConv.closeWindow();
        }
        if (this.getExtendedState() == 1 || this.getExtendedState() == 6) {
            this.setExtendedState(0);
        }
        SpanaFrame.dispSize.width = this.getWidth();
        SpanaFrame.dispSize.height = this.getHeight();
        SpanaFrame.dispLocation.x = this.getX();
        SpanaFrame.dispLocation.y = this.getY();
        SpanaFrame.getInstance().setEnabled(true);
        SpanaFrame.getInstance().requestFocus();
        this.dispose();
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.getID() == 500 || e.getID() == 501) {
            this.maybeMovePopup(e);
        }
    }

    private void maybeMovePopup(MouseEvent e) {
        this.set_jLabel_XY(e.getX(), e.getY());
        this.jPanel_XY.setLocation(e.getX() + 5, e.getY() - this.jLabel_XY.getHeight() - 5);
    }

    private void maybeHidePopup(MouseEvent e) {
        if (e.getID() == 502) {
            this.jPanel_XY.setVisible(false);
            e.consume();
        }
    }

    private void set_jLabel_XY(int x, int y) {
        Dimension windowSize = this.jPanelDispPlot.getSize();
        float xCoord = this.dd.xAxisMin + (0.01f * (float)(this.dd.userSpaceMin.x + x * (this.dd.userSpaceMax.x - this.dd.userSpaceMin.x) / windowSize.width) - this.dd.xAxis0) * this.dd.xAxisScale;
        float yCoord = this.dd.yAxisMin + (0.01f * (float)(this.dd.userSpaceMax.y - y * (this.dd.userSpaceMax.y - this.dd.userSpaceMin.y) / windowSize.height) - this.dd.yAxis0) * this.dd.yAxisScale;
        if (xCoord > this.dd.xAxisMax_true || xCoord < this.dd.xAxisMin_true) {
            this.jPanel_XY.setVisible(false);
            return;
        }
        if (yCoord > this.dd.yAxisMax_true || yCoord < this.dd.yAxisMin_true) {
            this.jPanel_XY.setVisible(false);
            return;
        }
        this.jPanel_XY.setVisible(true);
        float abs = Math.abs(xCoord);
        String tXformat = abs > 1.0f && (double)abs <= 9999.9 ? "####0.00" : ((double)abs > 0.1 && abs <= 1.0f ? "#0.000" : ((double)abs > 0.01 && (double)abs <= 0.1 ? "#0.0000" : ((double)abs > 0.001 && (double)abs <= 0.01 ? "#0.00000" : "#1.00E00")));
        abs = Math.abs(yCoord);
        String tYformat = abs > 1.0f && (double)abs <= 9999.9 ? "####0.00" : ((double)abs > 0.1 && abs <= 1.0f ? "#0.000" : ((double)abs > 0.01 && (double)abs <= 0.1 ? "#0.0000" : ((double)abs > 0.001 && (double)abs <= 0.01 ? "#0.00000" : "#1.00E00")));
        myFormatter.applyPattern(tXformat);
        String txt = "<html>&nbsp;x:" + myFormatter.format(xCoord);
        myFormatter.applyPattern(tYformat);
        txt = txt + "<br>&nbsp;y:" + myFormatter.format(yCoord) + "</html>";
        this.jLabel_XY.setText(txt);
        this.jPanel_XY.setSize(this.jLabel_XY.getSize().width, 3 + this.jLabel_XY.getSize().height);
    }

    private boolean readThePlotFile(File f) {
        String msg;
        String l;
        BufferedReader bufReader;
        this.dd = new GraphLib.PltData();
        this.dd.pltFile_Name = f.getPath();
        this.dd.fileLastModified = new Date(f.lastModified());
        try {
            bufReader = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException e) {
            String msg2 = "Error: \"" + e.toString() + "\"" + nl + nl + "For plot file:" + f.getPath();
            Util.exceptn((String)msg2);
            JOptionPane.showMessageDialog(this, msg2, this.pc.progName, 0);
            return false;
        }
        this.dd.axisInfo = false;
        this.dd.xAxisL = 0.0f;
        this.dd.yAxisL = 0.0f;
        this.dd.xAxis0 = 0.0f;
        this.dd.yAxis0 = 0.0f;
        boolean readingText = false;
        int align = 0;
        this.icon_type = 1;
        boolean axisInfo1 = false;
        boolean axisInfo2 = false;
        StringBuilder line = new StringBuilder();
        int penColour = 5;
        int currentColour = 1;
        do {
            String comment;
            try {
                l = bufReader.readLine();
            }
            catch (IOException e) {
                msg = "Error: \"" + e.toString() + "\"" + nl + nl + "For plot file:" + f.getPath();
                JOptionPane.showMessageDialog(this, msg, this.pc.progName, 0);
                return false;
            }
            if (line.length() > 0) {
                line.delete(0, line.length());
            }
            if (l == null) continue;
            line.append(l);
            String s0 = line.length() > 0 ? line.substring(0, 1).trim() : "";
            String s1 = line.length() > 4 ? line.substring(1, 5).trim() : "";
            String s2 = line.length() > 8 ? line.substring(5, 9).trim() : "";
            if (line.length() > 9) {
                comment = line.substring(9).trim();
                if (comment.length() > 12 && (comment.substring(0, 12).equals("-- PREDOM DI") || comment.substring(0, 12).equals("-- PREDOM2 D"))) {
                    this.icon_type = 2;
                }
            } else {
                comment = "";
            }
            int i0 = s0.length() > 0 ? Disp.readInt(s0) : -1;
            int i1 = s1.length() > 0 ? Disp.readInt(s1) : 0;
            int i2 = s2.length() > 0 ? Disp.readInt(s2) : 0;
            if (i0 == 0 || i0 == 1) {
                if (i1 < this.dd.userSpaceMin.x) {
                    this.dd.userSpaceMin.x = i1;
                }
                if (i1 > this.dd.userSpaceMax.x) {
                    this.dd.userSpaceMax.x = i1;
                }
                if (i2 < this.dd.userSpaceMin.y) {
                    this.dd.userSpaceMin.y = i2;
                }
                if (i2 > this.dd.userSpaceMax.y) {
                    this.dd.userSpaceMax.y = i2;
                }
                if (!this.diagrPaintUtil.textWithFonts || !readingText) {
                    this.dd.pltFileAList.add(new GraphLib.PltData.PlotStep(i0, i1, i2));
                }
            }
            if (i0 == 5 || i0 == 8) {
                penColour = i0;
                currentColour = i1;
                this.dd.pltFileAList.add(new GraphLib.PltData.PlotStep(i0, i1, i2));
            }
            if (comment.equals("-- AXIS --")) {
                axisInfo1 = true;
            }
            if (axisInfo1 && i0 == 8 && comment.length() > 64 && comment.substring(0, 9).equals("Size, X/Y")) {
                axisInfo2 = true;
                this.dd.xAxisL = Disp.readFloat(comment.substring(34, 42));
                this.dd.yAxisL = Disp.readFloat(comment.substring(42, 50));
                this.dd.xAxis0 = Disp.readFloat(comment.substring(50, 58));
                this.dd.yAxis0 = Disp.readFloat(comment.substring(58, comment.length()));
            }
            if (axisInfo1 && axisInfo2 && i0 == 0 && comment.length() > 60 && comment.substring(0, 9).equals("X/Y low a")) {
                float tmp;
                this.dd.axisInfo = true;
                this.dd.xAxisMin = Disp.readFloat(comment.substring(18, 29));
                this.dd.xAxisMax = Disp.readFloat(comment.substring(29, 40));
                this.dd.yAxisMin = Disp.readFloat(comment.substring(40, 51));
                this.dd.yAxisMax = Disp.readFloat(comment.substring(51, comment.length()));
                this.dd.xAxisMin_true = this.dd.xAxisMin;
                this.dd.xAxisMax_true = this.dd.xAxisMax;
                if (this.dd.xAxisMin_true > this.dd.xAxisMax_true) {
                    tmp = this.dd.xAxisMax_true;
                    this.dd.xAxisMax_true = this.dd.xAxisMin_true;
                    this.dd.xAxisMin_true = tmp;
                }
                this.dd.yAxisMin_true = this.dd.yAxisMin;
                this.dd.yAxisMax_true = this.dd.yAxisMax;
                if (this.dd.yAxisMin_true > this.dd.yAxisMax_true) {
                    tmp = this.dd.yAxisMax_true;
                    this.dd.yAxisMax_true = this.dd.yAxisMin_true;
                    this.dd.yAxisMin_true = tmp;
                }
                float x = Math.abs(this.dd.xAxisMax - this.dd.xAxisMin) * 0.01f;
                this.dd.xAxisMin_true -= x;
                this.dd.xAxisMax_true += x;
                float y = Math.abs(this.dd.yAxisMax - this.dd.yAxisMin) * 0.01f;
                this.dd.yAxisMin_true -= y;
                this.dd.yAxisMax_true += y;
                this.dd.xAxisScale = (this.dd.xAxisMax - this.dd.xAxisMin) / this.dd.xAxisL;
                this.dd.yAxisScale = (this.dd.yAxisMax - this.dd.yAxisMin) / this.dd.yAxisL;
            }
            if (!this.diagrPaintUtil.textWithFonts) continue;
            if (comment.equals("-- HEADING --")) {
                align = -1;
            }
            if (i0 == 0 && comment.length() > 41 && comment.startsWith("TextBegin")) {
                float txtAngle;
                boolean isFormula = comment.substring(9, 10).equals("C");
                float txtSize = Disp.readFloat(comment.substring(17, 24));
                for (txtAngle = Disp.readFloat(comment.substring(35, 42)); txtAngle > 360.0f; txtAngle -= 360.0f) {
                }
                while (txtAngle < -360.0f) {
                    txtAngle += 360.0f;
                }
                if (txtAngle > 180.0f) {
                    txtAngle -= 360.0f;
                }
                if (txtAngle < -180.0f) {
                    txtAngle += 360.0f;
                }
                if (comment.length() > 42) {
                    String t = comment.substring(55, 56);
                    if (t.equalsIgnoreCase("L")) {
                        align = -1;
                    } else if (t.equalsIgnoreCase("R")) {
                        align = 1;
                    } else if (t.equalsIgnoreCase("C")) {
                        align = 0;
                    }
                }
                if (line.length() > 0) {
                    line.delete(0, line.length());
                }
                try {
                    l = bufReader.readLine();
                }
                catch (IOException e) {
                    String msg3 = "Error: \"" + e.toString() + "\"" + nl + nl + "For plot file:" + f.getPath();
                    JOptionPane.showMessageDialog(this, msg3, this.pc.progName, 0);
                    return false;
                }
                if (l != null) {
                    line.append(l);
                } else {
                    line.append("null");
                }
                if (!line.toString().equals("null")) {
                    if (line.length() > 9) {
                        comment = Util.rTrim((String)line.substring(9));
                        if (comment.startsWith(" ")) {
                            comment = comment.substring(1);
                        }
                    } else {
                        comment = "";
                    }
                    Disp.textBoxMinMax(i1, i2, txtSize * 100.0f, txtSize * 100.0f * (float)comment.length(), txtAngle, this.dd);
                    if (isFormula) {
                        comment = Disp.replaceMinusSign(comment);
                    }
                    this.dd.pltTextAList.add(new GraphLib.PltData.PlotText(i1, i2, isFormula, align, txtSize, txtAngle, comment, penColour, currentColour));
                }
                readingText = true;
            }
            if (!comment.equals("TextEnd")) continue;
            readingText = false;
        } while (l != null);
        try {
            bufReader.close();
        }
        catch (IOException ex) {
            msg = "Error: \"" + ex.toString() + "\"" + nl + nl + "For plot file: " + f.getPath();
            JOptionPane.showMessageDialog(this, msg, this.pc.progName, 0);
        }
        if (this.dd.userSpaceMax.x == Integer.MIN_VALUE) {
            this.dd.userSpaceMax.x = 2100;
        }
        if (this.dd.userSpaceMin.x == Integer.MAX_VALUE) {
            this.dd.userSpaceMin.x = 0;
        }
        if (this.dd.userSpaceMax.y == Integer.MIN_VALUE) {
            this.dd.userSpaceMax.y = 1500;
        }
        if (this.dd.userSpaceMin.y == Integer.MAX_VALUE) {
            this.dd.userSpaceMin.y = 0;
        }
        float xtra = 0.02f;
        float userSpace_w = Math.abs(this.dd.userSpaceMax.x - this.dd.userSpaceMin.x);
        int xShift = Math.round(Math.max((100.0f - userSpace_w) / 2.0f, userSpace_w * xtra));
        this.dd.userSpaceMax.x += xShift;
        this.dd.userSpaceMin.x -= xShift;
        userSpace_w = Math.abs(this.dd.userSpaceMax.y - this.dd.userSpaceMin.y);
        int yShift = Math.round(Math.max((100.0f - userSpace_w) / 2.0f, userSpace_w * xtra));
        this.dd.userSpaceMax.y += yShift;
        this.dd.userSpaceMin.y -= yShift;
        return true;
    }

    private static void textBoxMinMax(int i1, int i2, float height, float width, float angle, GraphLib.PltData dd) {
        double DEG_2_RAD = 0.017453292519943;
        double a0 = (double)angle * 0.017453292519943;
        double a1 = (double)(angle + 90.0f) * 0.017453292519943;
        float h = height * 2.0f;
        float w = width;
        Point p0 = new Point();
        Point p1 = new Point();
        p0.x = i1 - (int)(height * (float)Math.cos(a1));
        p0.y = i2 - (int)(height * (float)Math.sin(a1));
        if (p0.x < dd.userSpaceMin.x) {
            dd.userSpaceMin.x = p0.x;
        }
        if (p0.x > dd.userSpaceMax.x) {
            dd.userSpaceMax.x = p0.x;
        }
        if (p0.y < dd.userSpaceMin.y) {
            dd.userSpaceMin.y = p0.y;
        }
        if (p0.y > dd.userSpaceMax.y) {
            dd.userSpaceMax.y = p0.y;
        }
        p0.x = i1 + (int)(w * (float)Math.cos(a0));
        p0.y = i2 + (int)(w * (float)Math.sin(a0));
        if (p0.x < dd.userSpaceMin.x) {
            dd.userSpaceMin.x = p0.x;
        }
        if (p0.x > dd.userSpaceMax.x) {
            dd.userSpaceMax.x = p0.x;
        }
        if (p0.y < dd.userSpaceMin.y) {
            dd.userSpaceMin.y = p0.y;
        }
        if (p0.y > dd.userSpaceMax.y) {
            dd.userSpaceMax.y = p0.y;
        }
        p1.x = p0.x + (int)(h * (float)Math.cos(a1));
        p1.y = p0.y + (int)(h * (float)Math.sin(a1));
        if (p1.x < dd.userSpaceMin.x) {
            dd.userSpaceMin.x = p1.x;
        }
        if (p1.x > dd.userSpaceMax.x) {
            dd.userSpaceMax.x = p1.x;
        }
        if (p1.y < dd.userSpaceMin.y) {
            dd.userSpaceMin.y = p1.y;
        }
        if (p1.y > dd.userSpaceMax.y) {
            dd.userSpaceMax.y = p1.y;
        }
        p0.x = i1 + (int)(h * (float)Math.cos(a1));
        p0.y = i2 + (int)(h * (float)Math.sin(a1));
        if (p0.x < dd.userSpaceMin.x) {
            dd.userSpaceMin.x = p0.x;
        }
        if (p0.x > dd.userSpaceMax.x) {
            dd.userSpaceMax.x = p0.x;
        }
        if (p0.y < dd.userSpaceMin.y) {
            dd.userSpaceMin.y = p0.y;
        }
        if (p0.y > dd.userSpaceMax.y) {
            dd.userSpaceMax.y = p0.y;
        }
    }

    private static int readInt(String t) {
        int i;
        try {
            i = Integer.parseInt(t);
        }
        catch (NumberFormatException ex) {
            Util.exceptn((String)("Error: " + ex.toString() + nl + "   while reading an integer from String: \"" + t + "\""));
            i = 0;
        }
        return i;
    }

    private static float readFloat(String t) {
        float f;
        try {
            f = Float.parseFloat(t);
        }
        catch (NumberFormatException ex) {
            Util.exceptn((String)("Error: " + ex.toString() + nl + "   while reading a \"float\" from String: \"" + t + "\""));
            f = 0.0f;
        }
        return f;
    }

    private static String replaceMinusSign(String t) {
        int M = 8211;
        int tLength = t.length();
        if (tLength <= 1 || t.indexOf(45) < 0) {
            return t;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(t);
        char now = sb.charAt(0);
        if (now == '-') {
            sb.setCharAt(0, '\u2013');
        }
        for (int i = 1; i < tLength; ++i) {
            now = sb.charAt(i);
            if (now != '-') continue;
            char l = sb.charAt(i - 1);
            int n = i <= tLength - 2 ? (int)sb.charAt(i + 1) : 32;
            if ((l >= 'A' && l <= 'Z' || l >= 'a' && l <= 'z') && (n >= 65 && n <= 90 || n >= 97 && n <= 122)) continue;
            sb.setCharAt(i, '\u2013');
        }
        return sb.toString();
    }

    private void pltConvertFile(String pltFile, String type) {
        if (this.dConv != null) {
            Util.exceptn((String)"Error: \"dConv\" is not null.");
            return;
        }
        if (pltFile == null || pltFile.trim().length() <= 0) {
            Util.exceptn((String)"Programming Error in \"pltConvertFile\": empty file name.");
            return;
        }
        String t = null;
        if (type != null) {
            t = type.toLowerCase();
        }
        if (t == null || t.length() < 2 || t.length() > 3 || !t.equals("pdf") && !t.equals("ps") && !t.equals("eps")) {
            Util.exceptn((String)("Programming Error in \"pltConvertFile\"" + nl + "   type = \"" + type + "\"" + nl + "   must be one of: pdf, ps or eps."));
            return;
        }
        this.jMenuConvert.setEnabled(false);
        this.jMenuItemPDF.setEnabled(false);
        this.jMenuItemPS.setEnabled(false);
        this.pc.setPathDef(pltFile);
        final String pltName = pltFile;
        final int typ = t.equals("pdf") ? 1 : (t.equals("ps") ? 2 : (t.equals("eps") ? 3 : -1));
        Thread c = new Thread(){

            @Override
            public void run() {
                Disp.this.dConv = new DiagrConvert(Disp.this.pc, Disp.this.pd, Disp.this.dd);
                Disp.this.dConv.start(typ, pltName);
                Disp.this.dConv.waitFor();
                Disp.this.dConv = null;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Disp.this.jMenuConvert.setEnabled(true);
                        Disp.this.jMenuItemPDF.setEnabled(true);
                        Disp.this.jMenuItemPS.setEnabled(true);
                    }
                });
            }
        };
        c.start();
    }

    private void exportImage() {
        if (this.dExp != null) {
            Util.exceptn((String)"Error: dExp is not null.");
            return;
        }
        this.jMenuExport.setEnabled(false);
        Thread c = new Thread(){

            @Override
            public void run() {
                double h0 = Math.max(10, Math.abs(((Disp)Disp.this).dd.userSpaceMax.y - ((Disp)Disp.this).dd.userSpaceMin.y));
                double w0 = Math.max(10, Math.abs(((Disp)Disp.this).dd.userSpaceMax.x - ((Disp)Disp.this).dd.userSpaceMin.x));
                double h2w = h0 / w0;
                Disp.this.dExp = new DiagrExport(Disp.this.pc, Disp.this.pd, h2w);
                boolean cancel = Disp.this.dExp.start(Disp.this.plotFile.getAbsolutePath()) ? Disp.this.dExp.waitFor() : true;
                Disp.this.dExp = null;
                if (!cancel) {
                    Disp.this.export(((Disp)Disp.this).pd.diagrExportType, true);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Disp.this.jMenuExport.setEnabled(true);
                    }
                });
            }
        };
        c.start();
    }

    public void export(String type, boolean showMsgBox) {
        int h;
        int w;
        double w0;
        double h0;
        String pltFileFullName;
        if (type == null || type.length() <= 0) {
            Util.exceptn((String)"Error in \"export(type)\":  empty type.");
            return;
        }
        boolean fnd = false;
        for (String t : SpanaFrame.FORMAT_NAMES) {
            if (!type.equalsIgnoreCase(t)) continue;
            fnd = true;
            break;
        }
        if (!fnd) {
            String msg = "Error in \"export(\"" + type + "\")\":" + nl + "Type not supported." + nl + "Should be one of:  ";
            for (String t : SpanaFrame.FORMAT_NAMES) {
                msg = "  " + msg + t + ", ";
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = msg + ".";
            Util.exceptn((String)msg);
            return;
        }
        try {
            pltFileFullName = this.plotFile.getCanonicalPath();
        }
        catch (IOException ex) {
            try {
                pltFileFullName = this.plotFile.getAbsolutePath();
            }
            catch (Exception e) {
                pltFileFullName = this.plotFile.getPath();
            }
        }
        String convertedFileFullN = Div.getFileNameWithoutExtension((String)pltFileFullName) + "." + type.toLowerCase();
        File convertedFile = new File(convertedFileFullN);
        if (this.pc.dbg) {
            System.out.println("Exporting file \"" + this.plotFile.getName() + "\" to " + type.toUpperCase() + "-format");
        }
        if ((h0 = (double)Math.max(10, Math.abs(this.dd.userSpaceMax.y - this.dd.userSpaceMin.y))) / (w0 = (double)Math.max(10, Math.abs(this.dd.userSpaceMax.x - this.dd.userSpaceMin.x))) < 1.0) {
            w = this.pd.diagrExportSize;
            h = (int)((double)this.pd.diagrExportSize * (h0 / w0));
        } else {
            h = this.pd.diagrExportSize;
            w = (int)((double)this.pd.diagrExportSize / (h0 / w0));
        }
        int i = 1;
        if (type.equalsIgnoreCase("wbmp")) {
            i = 12;
        }
        BufferedImage bi = new BufferedImage(w, h, i);
        Graphics2D ig2 = bi.createGraphics();
        if (this.diagrPaintUtil.useBackgrndColour) {
            ig2.setColor(this.diagrPaintUtil.backgrnd);
        } else {
            ig2.setColor(Color.WHITE);
        }
        ig2.fillRect(0, 0, w, h);
        this.diagrPaintUtil.paintDiagram(ig2, new Dimension(w, h), this.dd, false);
        long fileDate0 = convertedFile.lastModified();
        try {
            ImageIO.write((RenderedImage)bi, type.toLowerCase(), convertedFile);
        }
        catch (IOException ioe) {
            Util.exceptn((String)(ioe.toString() + nl + Util.stack2string((Exception)ioe)));
        }
        ig2.dispose();
        long fileDate = convertedFile.lastModified();
        if (fileDate > fileDate0) {
            System.out.println("Created " + type + "-file: \"" + convertedFile.getName() + "\"");
            if (showMsgBox) {
                String msg = "<html>Created " + type + "-file:<br>" + "<b>\"" + convertedFile.getName() + "\"</b></html>";
                JOptionPane.showMessageDialog(this, msg, this.pc.progName, 1);
            }
            System.out.flush();
        } else if (showMsgBox) {
            JOptionPane.showMessageDialog(this, "<html>Failed to create file:<br><b>\"" + convertedFile.getName() + "\"</b></html>", this.pc.progName, 0);
        } else {
            System.err.println("---- Failed to create " + type + "-file: \"" + convertedFile.getName() + "\" !");
            System.err.flush();
        }
    }

    final void setAdvancedFeatures(boolean advanced) {
        this.jMenuWSize.setVisible(advanced);
    }
}

