/*
 * Decompiled with CFR 0.152.
 */
package chemicalDiagramsHelp;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import javax.help.JHelpContentViewer;
import javax.help.plaf.basic.BasicContentViewerUI;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.ComponentUI;

public class ExternalLinkContentViewerUI
extends BasicContentViewerUI {
    public ExternalLinkContentViewerUI(JHelpContentViewer x) {
        super(x);
    }

    public static ComponentUI createUI(JComponent x) {
        return new ExternalLinkContentViewerUI((JHelpContentViewer)x);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent he) {
        if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                final URL u = he.getURL();
                if (u != null && (u.getProtocol().equalsIgnoreCase("http") || u.getProtocol().equalsIgnoreCase("ftp"))) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            BareBonesBrowserLaunch.openURL(u.toString());
                        }
                    };
                    t.start();
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.hyperlinkUpdate(he);
    }

    private static class BareBonesBrowserLaunch {
        private static final String nl = System.getProperty("line.separator");
        private static final String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla", "netscape", "chrome"};

        private BareBonesBrowserLaunch() {
        }

        private static void openURL(String url) {
            String osName = System.getProperty("os.name");
            try {
                if (osName.startsWith("Mac OS")) {
                    Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                    Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, url);
                } else if (osName.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url).waitFor();
                } else {
                    boolean found = false;
                    for (String browser : browsers) {
                        if (found) continue;
                        boolean bl = found = Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() == 0;
                        if (!found) continue;
                        Runtime.getRuntime().exec(new String[]{browser, url});
                    }
                    if (!found) {
                        throw new Exception(Arrays.toString(browsers));
                    }
                }
            }
            catch (Exception e) {
                String msg = "Error attempting to launch web browser" + nl + e.toString();
                System.err.println("BareBonesBrowserLaunch - " + msg);
                JOptionPane.showMessageDialog(null, msg, "Chemical Diagrams Help", 0);
            }
        }
    }
}

