/*
 * Decompiled with CFR 0.152.
 */
package lib.kemi.graph_lib;

import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import lib.common.Util;
import lib.kemi.graph_lib.DiagrPaintUtility;

public class GraphLib {
    private static final boolean OUTLINE_DRAW = false;
    private static final boolean CHARACTER_SKETCH = true;
    private boolean sketching;
    private boolean textWithFonts;
    private PltData pd;
    private int screenColour;
    private int plotPen;
    private boolean isFormula;
    private String label;
    private boolean save;
    private PrintWriter outputFile;
    private double xL = 1.0;
    private double yL = 1.0;
    private double xI = 0.0;
    private double yI = 0.0;
    private double sizeSym = 0.0;
    private Rectangle2D.Double clippingArea;
    private int i2Last = Integer.MIN_VALUE;
    private int i3Last = Integer.MIN_VALUE;
    private static Locale engl = Locale.ENGLISH;
    private static final String nl = System.getProperty("line.separator");
    public double stpXI = 0.0;
    public double stpYI = 0.0;
    private int[] ADDRES = new int[]{-1, 0, 5, 17, 25, 32, 38, 43, 53, 59, 65, 71, 76, 79, 84, 88, 97, 104, 115, 124, 136, 140, 146, 149, 154, 158, 163, 167, 175, 182, 189, 196, 205, 212, 223, 229, 239, 249, 255, 260, 268, 274, 283, 290, 297, 303, 315, 322, 328, 331, 336, 340, 345, 349, 358, 363, 371, 384, 388, 397, 408, 412, 428, 440, 442, 446, 452, 454, 460, 466, 470, 474, 478, 485, 492, 497, 512, 520, 528, 535, 547, 549, 559, 569, 572, 575, 583, 595, 516, 607, 619, 502, 736, -1, 750, 615, 617, 631, 650, 669, 679, 692, 707, 622, 622, 725, 731, 731, 440, 440, 502, 611, 611, 512};
    private static final int[] SK = new int[]{10010, 9040, 70, 13060, 23020, 10010, 9010, 9060, 8070, 6070, 5060, 5010, 15060, 4070, 1070, 60, 20010, 18070, 9060, 9020, 8010, 1010, 20, 60, 21070, 10010, 9010, 9050, 7070, 2070, 50, 20010, 10070, 10, 9010, 9070, 15010, 25050, 10010, 9010, 9070, 15010, 25050, 18070, 9060, 9020, 8010, 1010, 20, 60, 1070, 4070, 24050, 19010, 10, 19070, 70, 15010, 25070, 19030, 9050, 19040, 40, 10030, 20050, 19060, 1060, 50, 20, 1010, 22010, 19010, 10, 19060, 5010, 20070, 19010, 10, 20070, 10010, 9010, 5040, 9070, 20070, 10010, 9010, 70, 29070, 10020, 1010, 8010, 9020, 9060, 8070, 1070, 60, 20020, 10010, 9010, 9060, 8070, 6070, 5060, 25010, 10020, 1010, 8010, 9020, 9060, 8070, 1070, 60, 20, 12050, 20070, 10010, 9010, 9060, 8070, 6070, 5060, 5010, 15050, 20070, 11010, 20, 60, 1070, 4070, 5060, 5020, 6010, 8010, 9020, 9060, 28070, 19010, 9070, 19040, 20040, 19010, 1010, 20, 60, 1070, 29070, 19010, 40, 29070, 19010, 10, 4040, 70, 29070, 19010, 70, 10010, 29070, 19010, 5040, 9070, 15040, 20040, 19010, 9070, 10, 20070, 12070, 40, 20, 1010, 5010, 6035, 6070, 20070, 16010, 6060, 5070, 1070, 60, 10, 29910, 15070, 6060, 6020, 5010, 1010, 20, 20070, 16070, 6020, 5010, 1010, 20, 70, 29970, 13010, 3070, 5070, 6060, 6020, 5010, 1010, 20, 20070, 10020, 7520, 9035, 9055, 7570, 14010, 24055, -12010, -3060, -2070, 5070, 6060, 6020, 5010, 2010, 1020, 1060, 22070, 10010, 9910, 16010, 6060, 5070, 20070, 16020, 6035, 35, 10020, 50, 18033, 8037, 8437, 8433, 28033, -12010, -3020, -3040, -2050, 6050, 18550, 9050, 9055, 8555, 28550, 10010, 9010, 13010, 6050, 14530, 20060, 19020, 9035, 35, 10020, 20050, 10010, 6010, 15010, 6040, 40, 15040, 6070, 20070, 10010, 6010, 15010, 6055, 5070, 20070, 15070, 1070, 60, 20, 1010, 5010, 6020, 6060, 25070, -13010, 6010, 6060, 5070, 2070, 1060, 21010, -13070, 6070, 6020, 5010, 2010, 1020, 21070, 10010, 6010, 14510, 6040, 6060, 25070, 11010, 20, 60, 1070, 2070, 3060, 3020, 4010, 5010, 6020, 6060, 25070, 19030, 1030, 45, 55, 1070, 16020, 26060, 16020, 1020, 30, 60, 1070, 26070, 16010, 40, 26070, 16010, 20, 3040, 60, 26070, 10010, 6070, 16010, 20070, -13000, -3010, 6060, 16010, 21030, 16010, 6070, 10, 20070, 10020, 1010, 8010, 9020, 9060, 8070, 1070, 60, 20020, 17030, 9040, 40, 10030, 20050, 18010, 9020, 9060, 8070, 5570, 1510, 10, 20070, 18010, 9020, 9060, 8070, 5570, 4560, 4520, 14560, 3570, 1070, 60, 20, 21010, 10060, 9060, 3010, 23070, 11010, 20, 60, 1070, 4070, 5060, 5010, 9010, 29070, 14010, 5020, 5060, 4070, 1070, 60, 20, 1010, 8010, 9020, 29060, 10020, 9070, 9010, 28010, 15020, 4010, 1010, 20, 60, 1070, 4070, 5060, 5020, 6010, 8010, 9020, 9060, 8070, 6070, 25060, 10020, 10020, 60, 1070, 8070, 9060, 9020, 8010, 5010, 4020, 4060, 25070, 15010, 25070, 12040, 8040, 15010, 25070, 15020, 5060, 13050, 7030, 17050, 23030, 10010, 29070, -11050, 40, 2530, 7030, 9540, 30550, -11030, 40, 2550, 7050, 9540, 30530, 19950, 9930, -1030, -21050, -11030, -1050, 9950, 29930, 11520, 1565, 15520, 25565, -11050, 40, 4040, 5030, 6040, 9940, 31050, -11030, 40, 4040, 5050, 6040, 9940, 31030, 10030, 40, 1040, 1030, 20030, -11525, 1040, 1030, 30, -21525, -11010, 2020, 6020, 12020, 1030, 1060, 2070, 6070, 12070, 21080, 19960, 7240, 9950, 29960, 19920, 7240, 9930, 29920, 19970, 7260, 9960, 9970, 19940, 7030, 9930, 29940, 19033, 3033, 10030, 35, 535, 530, 20030, 18010, 9020, 9060, 8070, 6070, 4040, 3040, 10040, 45, 545, 540, 20040, -12000, -22099, 10030, 40, 1040, 1030, 30, 14030, 4040, 5040, 5030, 24030, -11525, 1040, 1030, 30, -1525, 14030, 4040, 5040, 5030, 24030, 17070, 4010, 21070, 11010, 4070, 27010, 13020, 3060, 15060, 5020, 17030, 1030, 11050, 27050, 16010, 8010, 8030, 6030, 6010, 10010, 9070, 13070, 1070, 1050, 3050, 23070, 14074, 550, 27, 1818, 4030, 6057, 7060, 8054, 8040, 7032, 6232, 20080, 17020, 8530, 7060, 28570, 10080, 10, 9060, 20080, 19010, 20070, 19033, 20033, 17030, 9045, 27060, 16030, 6040, 7050, 8050, 9040, 9030, 8020, 7020, 26030, 10020, 1010, 7010, 8020, 8060, 7070, 1070, 60, 20, 19230, 9220, 9920, 9930, 9230, 19260, 9250, 9950, 9960, 29260, 11010, 5010, 6020, 6060, 5070, 1070, 60, 20, 1010, 17525, 7520, 8020, 8025, 7525, 17560, 7555, 8055, 8060, 27560, 10010, 9040, 70, 13060, 3020, 19247, 9233, 9933, 9947, 29247, 12070, 40, 20, 1010, 5010, 6035, 6070, 70, 17552, 9052, 9038, 7538, 27552, 10010, 9040, 70, 13060, 3020, 19230, 9220, 9920, 9930, 9230, 19260, 9250, 9950, 9960, 29260, 12070, 40, 20, 1010, 5010, 6035, 6070, 70, 17525, 7520, 8020, 8025, 7525, 17560, 7555, 8055, 8060, 27560, 13040, 7040, 15020, 5060, 11020, 21060, 14040, 4050, 5050, 5040, 24040, 11010, 20, 60, 1070, 4070, 5060, 5020, 6010, 8010, 9020, 9060, 8070, -11040, 29940, 12070, 40, 30, 1020, 5020, 6035, 6070, 10080, 1070, 6570, 7560, 7520, 6005, 1005, -1020, -21040};
    private int lineStyle = 0;
    private int nDash = 0;
    private double[] xDash = new double[100];
    private double[] yDash = new double[100];
    private double[] dash = new double[]{0.0, 0.0, 0.0, 0.0};

    public void GraphLib() {
        this.save = false;
        this.xL = 1.0;
        this.yL = 1.0;
        this.xI = 0.0;
        this.yI = 0.0;
        this.sizeSym = 0.0;
        this.screenColour = 1;
        this.plotPen = 1;
        this.isFormula = false;
        this.textWithFonts = true;
        this.sketching = false;
    }

    public void start(PltData pD, File plotFile, boolean txtWithFonts) throws openPlotFileException {
        if (pD == null) {
            return;
        }
        this.pd = pD;
        this.textWithFonts = txtWithFonts;
        String msg = null;
        if (plotFile != null && plotFile.getName().length() > 0) {
            this.outputFile = null;
            try {
                this.outputFile = new PrintWriter(new BufferedWriter(new FileWriter(plotFile)));
                this.pd.pltFile_Name = plotFile.getPath();
                this.save = true;
            }
            catch (IOException ex) {
                msg = "Error: \"" + ex.toString() + "\"," + nl + "   in Graphics Library," + nl + "   while opening output file" + nl + "   \"" + plotFile.getPath() + "\"";
                this.pd.pltFile_Name = null;
                this.save = false;
            }
        } else {
            this.pd.pltFile_Name = null;
            this.save = false;
        }
        if (msg != null) {
            throw new openPlotFileException(msg);
        }
    }

    public void end() {
        if (this.pd.userSpaceMax.x == Integer.MIN_VALUE) {
            this.pd.userSpaceMax.x = 2100;
        }
        if (this.pd.userSpaceMin.x == Integer.MAX_VALUE) {
            this.pd.userSpaceMin.x = 0;
        }
        if (this.pd.userSpaceMax.y == Integer.MIN_VALUE) {
            this.pd.userSpaceMax.y = 1500;
        }
        if (this.pd.userSpaceMin.y == Integer.MAX_VALUE) {
            this.pd.userSpaceMin.y = 0;
        }
        float xtra = 0.02f;
        float userSpace_w = Math.abs(this.pd.userSpaceMax.x - this.pd.userSpaceMin.x);
        int xShift = Math.round(Math.max((100.0f - userSpace_w) / 2.0f, userSpace_w * xtra));
        this.pd.userSpaceMax.x += xShift;
        this.pd.userSpaceMin.x -= xShift;
        userSpace_w = Math.abs(this.pd.userSpaceMax.y - this.pd.userSpaceMin.y);
        int yShift = Math.round(Math.max((100.0f - userSpace_w) / 2.0f, userSpace_w * xtra));
        this.pd.userSpaceMax.y += yShift;
        this.pd.userSpaceMin.y -= yShift;
        if (this.label != null && this.save) {
            this.outputFile.println("0   0   0 " + this.label);
        }
        if (this.outputFile != null) {
            this.save = false;
            this.outputFile.flush();
            this.outputFile.close();
        }
    }

    public void setLabel(String txt) {
        if (this.label != null && this.save) {
            this.outputFile.println("0   0   0 " + this.label);
        }
        this.label = txt;
    }

    public void setPen(int pen) {
        int i;
        int n;
        if (pen >= 0) {
            n = 8;
            i = this.plotPen = Math.min(pen, 9999);
        } else {
            n = 5;
            i = this.screenColour = Math.min(-pen, 9999);
        }
        this.pd.pltFileAList.add(new PltData.PlotStep(n, i, 0));
        if (this.save) {
            if (this.label != null) {
                this.outputFile.format("%1d%4d     %s%n", n, i, this.label);
                this.label = null;
            } else {
                this.outputFile.format("%1d%4d%n", n, i);
            }
            this.outputFile.flush();
        }
    }

    public void setIsFormula(boolean b) {
        this.isFormula = b;
    }

    public void sym(float xP, float yP, float tHeight, String t, float angle, int alignment, boolean axesCoord) {
        this.sym((double)xP, (double)yP, (double)tHeight, t, (double)angle, alignment, axesCoord);
    }

    public void sym(double xP, double yP, double tHeight, String t, double angle, int alignment, boolean axesCoord) {
        int i;
        double angleDegr;
        if (t == null) {
            return;
        }
        if (t.trim().length() < 1) {
            return;
        }
        if (Math.abs(tHeight) < 0.05) {
            return;
        }
        int align = Math.max(-1, Math.min(alignment, 1));
        this.sizeSym = Math.min(99.0, Math.abs(tHeight));
        for (angleDegr = angle; angleDegr > 360.0; angleDegr -= 360.0) {
        }
        while (angleDegr < -360.0) {
            angleDegr += 360.0;
        }
        if (angleDegr > 180.0) {
            angleDegr -= 360.0;
        }
        if (angleDegr < -180.0) {
            angleDegr += 360.0;
        }
        double angleR = Math.toRadians(angleDegr);
        double sCos = this.sizeSym * Math.cos(angleR);
        double sSin = this.sizeSym * Math.sin(angleR);
        double x0 = xP;
        double y0 = yP;
        if (axesCoord) {
            if (this.xL == 0.0) {
                this.xL = 1.0;
            }
            if (this.yL == 0.0) {
                this.yL = 1.0;
            }
            x0 = x0 * this.xL + this.xI;
            y0 = y0 * this.yL + this.yI;
        }
        int len = t.length();
        for (i = 0; i < len && Character.isWhitespace(t.charAt(i)); ++i) {
        }
        if ((i = Math.min(i, len - 1)) > 0) {
            t = t.substring(i);
            len = t.length();
            x0 += (double)i * sCos;
            y0 += (double)i * sSin;
        }
        int isFormulaLen = len;
        if (this.isFormula) {
            isFormulaLen = GraphLib.isFormulaLength(t);
        }
        float diff = (float)(len - isFormulaLen) + 1.0E-5f;
        if (align != -1 && this.isFormula && (double)diff > 0.1) {
            if (align == 0) {
                diff /= 2.0f;
            }
            x0 += (double)diff * sCos;
            y0 += (double)diff * sSin;
        }
        if (this.save) {
            String c = this.isFormula ? "C" : " ";
            String al = align == -1 ? "L" : (align == 1 ? "R" : "C");
            String txt = String.format(engl, "TextBegin" + c + " size=%7.2f cm, angle=%8.2f, alignment: " + al, this.sizeSym, angleDegr);
            this.setLabel(txt);
        }
        this.moveToDrawTo(x0, y0, 0);
        if (this.save) {
            this.setLabel(t);
        }
        if (this.isFormula) {
            int l = isFormulaLen;
        } else {
            int l = len;
        }
        this.sketch(x0, y0, t, angleDegr);
        if (this.save) {
            this.setLabel("TextEnd");
            this.moveToDrawTo(0.0f, 0.0f, 0);
        }
        int i2 = Math.round((float)(x0 * 100.0));
        int i3 = Math.round((float)(y0 * 100.0));
        i2 = Math.max(-999, Math.min(i2, 9999));
        i3 = Math.max(-999, Math.min(i3, 9999));
        this.pd.pltTextAList.add(new PltData.PlotText(i2, i3, this.isFormula, align, (float)this.sizeSym, (float)angleDegr, t, this.plotPen, this.screenColour));
    }

    private void sketch(double x0, double y0, String txt, double angleDegr) {
        int i;
        float[] d;
        char[] CHR = new char[]{' ', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+', '*', '/', '(', ')', '[', ']', '=', '{', '}', '.', ',', '\'', '\"', '!', '?', '_', ':', ';', '<', '>', '#', '%', '&', '`', '~', '^', '\u03bc', '$', ' ', '@', '\\', '|', '\u00d6', '\u00f6', '\u00c5', '\u00e5', '\u00c4', '\u00e4', '\u00ba', '\u00b0', '\u00b1', '\u00b7', '\u2022', '\u2013', '\u2212', '\u00b5', '\u0394', '\u2206', '\u00b4'};
        int nRecn = CHR.length;
        int bcksp = 2;
        CHR[93] = (char)bcksp;
        this.ADDRES[89] = 607;
        this.ADDRES[90] = 619;
        this.ADDRES[92] = 736;
        if (this.isFormula) {
            this.ADDRES[89] = 622;
            this.ADDRES[90] = 611;
            this.ADDRES[92] = 502;
        }
        this.sketching = this.textWithFonts;
        boolean isFormulaOld = this.isFormula;
        int n = txt.length();
        if (this.isFormula) {
            DiagrPaintUtility.ChemFormula cf = new DiagrPaintUtility.ChemFormula(txt, new float[1]);
            DiagrPaintUtility.chemF(cf);
            txt = cf.t.toString();
            n = txt.length();
            d = new float[n];
            System.arraycopy(cf.d, 0, d, 0, n);
            this.isFormula = false;
            for (i = 0; i < n; ++i) {
                if (!(Math.abs(d[i]) > 0.01f)) continue;
                this.isFormula = true;
            }
        } else {
            d = new float[n];
            for (i = 0; i < n; ++i) {
                d[i] = 0.0f;
            }
        }
        int iNow = -1;
        double x = 0.0;
        double y = 0.0;
        double height = this.sizeSym;
        do {
            int j;
            ++iNow;
            int iCHR = 0;
            for (j = 0; j < nRecn; ++j) {
                if (txt.charAt(iNow) != CHR[j]) continue;
                iCHR = j;
                break;
            }
            if (this.isFormula && Math.abs(d[iNow]) > 0.01f) {
                height = 0.8 * this.sizeSym;
            }
            double xPrev = x;
            double yPrev = y;
            boolean stopIt = false;
            if (iCHR == 93) {
                x = -1.0;
                y = 0.0;
            } else if (iCHR == 0 || this.ADDRES[iCHR] <= -1) {
                x = 1.0;
                y = 0.0;
            } else {
                int iP = this.ADDRES[iCHR] - 1;
                block4: for (j = 0; j < 3001; ++j) {
                    x = (double)SK[++iP] / 100.0;
                    int action = 1;
                    if (Math.abs(x) > 99.999) {
                        action = 2;
                    }
                    if (Math.abs(x) > 199.999) {
                        action = 3;
                    }
                    if (action == 2) {
                        if (x > 0.0) {
                            x -= 100.0;
                        }
                        if (x < 0.0) {
                            x += 100.0;
                        }
                    } else if (action == 3) {
                        if (x > 0.0) {
                            x -= 200.0;
                        }
                        if (x < 0.0) {
                            x += 200.0;
                        }
                    }
                    y = (int)x;
                    x = Math.abs(x - y);
                    y /= 100.0;
                    x = x * height + xPrev;
                    y = y * height + yPrev + (double)d[iNow] * this.sizeSym;
                    while (true) {
                        double radius;
                        double xPlt = x;
                        double yPlt = y;
                        if (Math.abs(angleDegr) > 0.001 && (radius = x * x + y * y) > 0.0) {
                            radius = Math.sqrt(radius);
                            double angle = Math.asin(y / radius) + Math.toRadians(angleDegr);
                            xPlt = radius * Math.cos(angle);
                            yPlt = radius * Math.sin(angle);
                        }
                        xPlt += x0;
                        yPlt += y0;
                        if (stopIt) break block4;
                        int i2 = 1;
                        if (action == 2) {
                            i2 = 0;
                        }
                        this.moveToDrawTo(xPlt, yPlt, i2);
                        if (action != 3) continue block4;
                        x = 1.0;
                        y = 0.0;
                        x = x * height + xPrev;
                        y = y * height + yPrev;
                        stopIt = true;
                    }
                }
            }
            if (iCHR != 93 && iCHR != 0 && this.ADDRES[iCHR] > -1) continue;
            x = x * this.sizeSym + xPrev;
            y = y * this.sizeSym + yPrev;
            if (!(Math.abs(angleDegr) > 0.001)) continue;
        } while (iNow < n - 1);
        this.isFormula = isFormulaOld;
        this.sketching = false;
    }

    public void moveToDrawTo(float x, float y, int flag) {
        this.moveToDrawTo((double)x, (double)y, flag);
    }

    public void moveToDrawTo(double x, double y, int flag) {
        int i0 = flag != 1 ? 0 : 1;
        x = Math.min(99.999, Math.max(-9.999, x));
        y = Math.min(99.999, Math.max(-9.999, y));
        int i1 = Math.round((float)(x * 100.0));
        int i2 = Math.round((float)(y * 100.0));
        i1 = Math.max(-999, Math.min(i1, 9999));
        i2 = Math.max(-999, Math.min(i2, 9999));
        if (i1 == this.i2Last && i2 == this.i3Last && this.label == null) {
            return;
        }
        this.i2Last = i1;
        this.i3Last = i2;
        if (this.save) {
            if (this.label != null) {
                this.outputFile.format("%1d%4d%4d %s%n", i0, i1, i2, this.label);
                this.label = null;
            } else {
                this.outputFile.format("%1d%4d%4d%n", i0, i1, i2);
            }
            this.outputFile.flush();
        }
        if (!this.sketching) {
            this.pd.pltFileAList.add(new PltData.PlotStep(i0, i1, i2));
        }
        if (i1 < this.pd.userSpaceMin.x) {
            this.pd.userSpaceMin.x = i1;
        }
        if (i1 > this.pd.userSpaceMax.x) {
            this.pd.userSpaceMax.x = i1;
        }
        if (i2 < this.pd.userSpaceMin.y) {
            this.pd.userSpaceMin.y = i2;
        }
        if (i2 > this.pd.userSpaceMax.y) {
            this.pd.userSpaceMax.y = i2;
        }
    }

    public void axes(float xMinI, float xMaxI, float yMinI, float yMaxI, float xOr, float yOr, float xAxL, float yAxL, float size, boolean logX, boolean logY, boolean frame) throws AxesDataException {
        this.axes((double)xMinI, (double)xMaxI, (double)yMinI, (double)yMaxI, (double)xOr, (double)yOr, (double)xAxL, (double)yAxL, (double)size, logX, logY, frame);
    }

    public void axes(double xMinI, double xMaxI, double yMinI, double yMaxI, double xOr, double yOr, double xAxL, double yAxL, double size, boolean logX, boolean logY, boolean frame) throws AxesDataException {
        String txt;
        int k;
        double v;
        double xPl;
        int j;
        int iStep;
        boolean xAxis;
        double yPl;
        boolean b;
        double wMn;
        double wMx;
        double anglX = 0.0;
        double anglY = 0.0;
        double o = 5.0E-6;
        if (Math.abs(this.stpXI - 2.0) > 1.0E-6 && Math.abs(this.stpXI - 1.0) > 1.0E-6 && Math.abs(this.stpXI - 0.5) > 5.0E-7 && Math.abs(this.stpXI - 0.2) > 2.0E-7) {
            this.stpXI = 0.0;
        }
        if (Math.abs(this.stpYI - 2.0) > 1.0E-6 && Math.abs(this.stpYI - 1.0) > 1.0E-6 && Math.abs(this.stpYI - 0.5) > 1.0E-6 && Math.abs(this.stpYI - 0.2) > 1.0E-6) {
            this.stpYI = 0.0;
        }
        xAxL = Math.max(2.0, Math.min(xAxL, 50.0));
        yAxL = Math.max(2.0, Math.min(yAxL, 50.0));
        double shift = Math.max(0.1, Math.min(size, 0.6));
        this.setLabel("-- AXIS --");
        this.setPen(Math.min(-1, this.screenColour));
        double x_Mx = xOr + xAxL;
        double y_Mx = yOr + yAxL;
        String t = String.format(engl, "Size, X/Y length & origo: %7.3f %7.3f %7.3f %7.3f %7.3f", size, xAxL, yAxL, xOr, yOr);
        this.setLabel(t);
        this.setPen(Math.max(1, this.plotPen));
        t = String.format(engl, "X/Y low and high:%11.4g%11.4g%11.4g%11.4g", xMinI, xMaxI, yMinI, yMaxI);
        this.setLabel(t);
        this.moveToDrawTo(xOr, y_Mx, 0);
        this.moveToDrawTo(xOr, yOr, 1);
        this.moveToDrawTo(x_Mx, yOr, 1);
        if (frame) {
            this.moveToDrawTo(x_Mx, y_Mx, 1);
            this.moveToDrawTo(xOr, y_Mx, 1);
        }
        double Xmx_i = Math.min(Math.abs(xMaxI), 1.0E35) * Math.signum(xMaxI);
        double Xmn_i = Math.min(Math.abs(xMinI), 1.0E35) * Math.signum(xMinI);
        double Ymx_i = Math.min(Math.abs(yMaxI), 1.0E35) * Math.signum(yMaxI);
        double Ymn_i = Math.min(Math.abs(yMinI), 1.0E35) * Math.signum(yMinI);
        double scaleMaxX = -1.0;
        double[] logSt = new double[]{0.301, 0.301, 0.1761, 0.2219};
        double[] logS = new double[]{0.30103, 0.176091, 0.124939, 0.09691, 0.079181, 0.066947, 0.057992, 0.051153, 0.045757};
        boolean isFormulaOld = this.isFormula;
        this.setIsFormula(true);
        boolean xAxisErr = false;
        String errTxtX = null;
        double w = Math.abs(Xmx_i - Xmn_i);
        if (logX) {
            if (w <= 0.5) {
                Xmx_i = Xmx_i < Xmn_i ? (Xmx_i -= 0.5 + o - w) : (Xmx_i += 0.5 + o - w);
            }
        } else if (w < 1.0E-30) {
            Xmx_i = Xmx_i < Xmn_i ? (Xmx_i -= Math.max(Xmx_i * 5.01E-4, 1.000001E-30)) : (Xmx_i += Math.max(Xmx_i * 5.01E-4, 1.000001E-30));
        }
        w = Math.abs(Xmx_i - Xmn_i);
        if (logX) {
            if (w < 0.5) {
                xAxisErr = true;
                errTxtX = "abs(xMax-xMin) must be > 0.5";
            }
        } else {
            if (w < 1.0E-30) {
                xAxisErr = true;
                errTxtX = "abs(xMax-xMin) must be > 1E-30";
            }
            if (!xAxisErr && (w /= Math.max(Math.abs(Xmx_i), Math.abs(Xmn_i))) <= 4.999999E-4) {
                xAxisErr = true;
                errTxtX = "abs(xMax-xMin)/max(xMax,xMin) must be > 5E-4";
            }
        }
        if (!xAxisErr) {
            String formX;
            double xMi;
            double xMa;
            double potX;
            boolean reverseX = false;
            if (xMinI > xMaxI) {
                reverseX = true;
            }
            this.xL = xAxL / (Xmx_i - Xmn_i);
            this.xI = this.xL * Xmn_i - xOr;
            long expX = 2L + Math.round(Math.log10(Math.abs(Xmx_i - Xmn_i)));
            while (!(Math.abs((wMx = Xmx_i / (potX = Math.pow(10.0, --expX))) - (wMn = Xmn_i / potX)) >= 0.999999)) {
            }
            long lowX = Math.round((Math.abs(wMn) + o) * Math.signum(Xmn_i));
            if (logX) {
                lowX = Math.round((double)((long)((double)lowX * potX)) / potX);
            }
            if (lowX < 0L && (double)lowX < wMn - o) {
                ++lowX;
            }
            double stpX = 1.0;
            w = Math.abs(wMx - wMn);
            if (w > 7.0) {
                stpX = 2.0;
            }
            if (logX) {
                if (w <= 1.050001) {
                    stpX = 0.2;
                }
                if (expX == 1L && w <= 2.000001) {
                    stpX = 0.2;
                }
            } else {
                if (w <= 3.000001) {
                    stpX = 0.5;
                }
                if (w <= 1.400001) {
                    stpX = 0.2;
                }
            }
            if (this.stpXI > 0.0) {
                stpX = this.stpXI;
            }
            double spanX = 0.0;
            if (logX) {
                spanX = potX * stpX;
            }
            w = 3.0 * o * potX;
            if (!reverseX) {
                xMa = Xmx_i + w;
                xMi = Xmn_i - w;
            } else {
                xMa = Xmx_i - w;
                xMi = Xmn_i + w;
            }
            if (logX) {
                formX = "    %8.4f";
            } else {
                formX = " %8.1f";
                if (expX == -1L && stpX < 1.0 || expX == -2L && stpX >= 1.0) {
                    formX = "  %8.2f";
                }
                if (expX == -2L && stpX < 1.0 || expX == -3L && stpX >= 1.0) {
                    formX = "   %8.3f";
                }
                if (expX == -3L && stpX < 1.0) {
                    formX = "    %8.4f";
                }
            }
            b = Math.abs(xMa) < 100000.0 & Math.abs(xMi) < 100000.0;
            yPl = yOr - (2.2 - shift) * size;
            xAxis = true;
            iStep = 0;
            j = 1;
            if (expX == -1L) {
                j = 10;
            }
            w = -20.0 * stpX;
            while (true) {
                double xPlTxt;
                if (logX && spanX < 1.0) {
                    w += logSt[iStep] * (double)j;
                    if (++iStep > logSt.length - 1) {
                        iStep = 0;
                    }
                } else {
                    w += stpX;
                }
                xPl = (xPl = !reverseX ? (double)lowX + w : (logX && spanX < 1.0 && w > 1.0E-4 && w < 0.9999 ? (double)lowX - (1.0 - w) : (double)lowX - w)) >= -1.0E-6 ? (xPl += o) : (xPl -= o);
                v = xPl;
                xPl *= potX;
                if (!reverseX) {
                    if (xPl > xMa) break;
                    if (xPl < xMi) {
                        continue;
                    }
                } else {
                    if (xPl < xMa) break;
                    if (xPl > xMi) continue;
                }
                k = expX >= 1L && expX <= 4L && b ? (int)xPl : (int)v;
                if (!((expX >= 0L || expX < -3L) && stpX > 0.5 || expX >= 1L && expX <= 4L && b)) {
                    if (expX < 0L && expX >= -3L) {
                        v = xPl;
                    }
                    txt = String.format(engl, formX, v);
                    xPlTxt = xPl * this.xL - this.xI - 7.4 * size;
                } else {
                    txt = String.format(" %8d", k);
                    int kAbs = Math.abs(k);
                    int kLength = kAbs < 10 ? 1 : (kAbs > 9 && kAbs < 100 ? 2 : (kAbs > 99 && kAbs < 1000 ? 3 : (kAbs > 999 && kAbs < 10000 ? 4 : 5)));
                    xPlTxt = xPl * this.xL - this.xI - (8.9 - (double)kLength / 2.0) * size;
                }
                double rtl = Util.rTrim(txt).length();
                if (logX) {
                    txt = this.logTxt(txt, xAxis);
                    rtl = Util.rTrim(txt).length();
                    int p = txt.indexOf(".");
                    if (p > -1) {
                        xPlTxt = xPl * this.xL - this.xI - ((double)p - 0.5) * size;
                    } else {
                        double tl = txt.trim().length();
                        xPlTxt = xPl * this.xL - this.xI - (rtl - tl + tl / 2.0) * size;
                    }
                }
                this.sym(xPlTxt, yPl, size, txt, anglX, 0, false);
                scaleMaxX = Math.max(scaleMaxX, xPl * this.xL - this.xI + rtl * size);
            }
            b = Math.abs(xMa) < 100000.0 & Math.abs(xMi) < 100000.0;
            if (!(expX >= 1L && expX <= 4L && b || expX <= 0L && expX >= -3L)) {
                yPl = yOr - (2.2 - shift) * size;
                xPl = Math.max(x_Mx, scaleMaxX) + 2.0 * size;
                txt = String.format("%4d", expX);
                txt = "*10'" + txt.trim() + "`";
                this.sym(xPl, yPl, size, txt, anglX, -1, false);
            }
            b = false;
            if (logX) {
                b = spanX <= 2.000001 & expX <= 0L;
            }
            iStep = 0;
            if (reverseX) {
                iStep = logS.length - 1;
            }
            w = -40.0 * stpX;
            while (true) {
                if (!b) {
                    w += stpX / 2.0;
                } else {
                    w += logS[iStep] / potX;
                    iStep = !reverseX ? ++iStep : --iStep;
                    if (iStep > logS.length - 1) {
                        iStep = 0;
                    }
                    if (iStep < 0) {
                        iStep = logS.length - 1;
                    }
                }
                if (!reverseX) {
                    xPl = ((double)lowX + w) * potX;
                    if (xPl > xMa) break;
                    if (xPl < xMi) {
                        continue;
                    }
                } else {
                    xPl = ((double)lowX - w) * potX;
                    if (xPl < xMa) break;
                    if (xPl > xMi) continue;
                }
                xPl = xPl * this.xL - this.xI;
                v = 0.5;
                if (!reverseX && b && iStep == 0 || reverseX && b && iStep == logS.length - 1) {
                    v = 0.8;
                }
                this.moveToDrawTo(xPl, yOr, 0);
                this.moveToDrawTo(xPl, yOr + v * size, 1);
                if (!frame) continue;
                this.moveToDrawTo(xPl, y_Mx, 0);
                this.moveToDrawTo(xPl, y_Mx - v * size, 1);
            }
        }
        boolean yAxisErr = false;
        String errTxtY = null;
        w = Math.abs(Ymx_i - Ymn_i);
        if (logY) {
            if (w <= 0.5) {
                Ymx_i = Ymx_i < Ymn_i ? (Ymx_i -= 0.5 + o - w) : (Ymx_i += 0.5 + o - w);
            }
        } else if (w < 1.0E-30) {
            Ymx_i = Ymx_i < Ymn_i ? (Ymx_i -= Math.max(Ymx_i * 5.01E-4, 1.000001E-30)) : (Ymx_i += Math.max(Ymx_i * 5.01E-4, 1.000001E-30));
        }
        w = Math.abs(Ymx_i - Ymn_i);
        if (logY) {
            if (w < 0.5) {
                yAxisErr = true;
                errTxtY = "abs(yMax-yMin) must be > 0.5";
            }
        } else {
            if (w < 1.0E-30) {
                yAxisErr = true;
                errTxtY = "abs(yMax-yMin) must be > 1E-30";
            }
            if (!yAxisErr && (w /= Math.max(Math.abs(Ymx_i), Math.abs(Ymn_i))) <= 4.999999E-4) {
                xAxisErr = true;
                errTxtY = "abs(yMax-yMin)/max(yMax,yMin) must be > 5E-4";
            }
        }
        if (!yAxisErr) {
            String formY;
            double yMi;
            double yMa;
            double potY;
            boolean reverseY = false;
            if (yMinI > yMaxI) {
                reverseY = true;
            }
            this.yL = yAxL / (Ymx_i - Ymn_i);
            this.yI = this.yL * Ymx_i - y_Mx;
            long expY = 2L + Math.round(Math.log10(Math.abs(Ymx_i - Ymn_i)));
            while (!(Math.abs((wMx = Ymx_i / (potY = Math.pow(10.0, --expY))) - (wMn = Ymn_i / potY)) >= 0.999999)) {
            }
            long lowY = Math.round((Math.abs(wMn) + o) * Math.signum(Ymn_i));
            if (logY) {
                lowY = Math.round((double)((long)((double)lowY * potY)) / potY);
            }
            if (lowY < 0L && (double)lowY < wMn - o) {
                ++lowY;
            }
            double stpY = 1.0;
            w = Math.abs(wMx - wMn);
            if (w > 7.0) {
                stpY = 2.0;
            }
            if (logY) {
                if (w <= 1.050001) {
                    stpY = 0.2;
                }
                if (expY == 1L && w <= 2.000001) {
                    stpY = 0.2;
                }
            } else {
                if (w <= 3.000001) {
                    stpY = 0.5;
                }
                if (w <= 1.400001) {
                    stpY = 0.2;
                }
            }
            if (this.stpYI > 0.0) {
                stpY = this.stpYI;
            }
            double spanY = 0.0;
            if (logY) {
                spanY = potY * stpY;
            }
            w = 3.0 * o * potY;
            if (!reverseY) {
                yMa = Ymx_i + w;
                yMi = Ymn_i - w;
            } else {
                yMa = Ymx_i - w;
                yMi = Ymn_i + w;
            }
            if (logY) {
                formY = "    %8.4f";
            } else {
                formY = " %8.1f";
                if (expY == -1L && stpY < 1.0 || expY == -2L && stpY >= 0.999999) {
                    formY = "  %8.2f";
                }
                if (expY == -2L && stpY < 1.0 || expY == -3L && stpY >= 0.999999) {
                    formY = "   %8.3f";
                }
                if (expY == -3L && stpY < 1.0) {
                    formY = "    %8.4f";
                }
            }
            b = Math.abs(yMa) < 100000.0 & Math.abs(yMi) < 100000.0;
            xAxis = false;
            iStep = 0;
            j = 1;
            if (expY == -1L) {
                j = 10;
            }
            w = -20.0 * stpY;
            while (true) {
                if (logY && spanY < 1.0) {
                    w += logSt[iStep] * (double)j;
                    if (++iStep > logSt.length - 1) {
                        iStep = 0;
                    }
                } else {
                    w += stpY;
                }
                yPl = (yPl = !reverseY ? (double)lowY + w : (logY && spanY < 1.0 && w > 1.0E-4 && w < 0.9999 ? (double)lowY - (1.0 - w) : (double)lowY - w)) >= -1.0E-6 ? (yPl += o) : (yPl -= o);
                v = yPl;
                yPl *= potY;
                if (!reverseY) {
                    if (yPl > yMa) break;
                    if (yPl < yMi) {
                        continue;
                    }
                } else {
                    if (yPl < yMa) break;
                    if (yPl > yMi) continue;
                }
                k = expY >= 1L && expY <= 4L && b ? (int)yPl : (int)v;
                if (!((expY >= 0L || expY < -3L) && stpY > 0.5 || expY >= 1L && expY <= 4L && b)) {
                    if (expY < 0L && expY >= -3L) {
                        v = yPl;
                    }
                    txt = String.format(engl, formY, v);
                } else {
                    txt = String.format(" %8d", k);
                }
                if (logY) {
                    txt = this.logTxt(txt, xAxis);
                }
                if ((yPl = yPl * this.yL - this.yI - size / 2.0) < yOr) {
                    yPl += 0.6 * size;
                }
                xPl = xOr - ((double)(Util.rTrim(txt).length() + 1) - shift) * size;
                this.sym(xPl, yPl, size, txt, anglY, 1, false);
            }
            b = Math.abs(yMa) < 100000.0 & Math.abs(yMi) < 100000.0;
            if (!(expY >= 1L && expY <= 4L && b || expY <= 0L && expY >= -3L)) {
                xPl = xOr;
                yPl = y_Mx + 0.8 * size;
                txt = String.format("%4d", expY);
                txt = "*10'" + txt.trim() + "`";
                this.sym(xPl, yPl, size, txt, anglY, -1, false);
            }
            b = false;
            if (logY) {
                b = spanY <= 2.000001 & expY <= 0L;
            }
            iStep = 0;
            if (reverseY) {
                iStep = logS.length - 1;
            }
            w = -40.0 * stpY;
            while (true) {
                if (!b) {
                    w += stpY / 2.0;
                } else {
                    w += logS[iStep] / potY;
                    iStep = reverseY ? --iStep : ++iStep;
                    if (iStep > logS.length - 1) {
                        iStep = 0;
                    }
                    if (iStep < 0) {
                        iStep = logS.length - 1;
                    }
                }
                if (!reverseY) {
                    yPl = ((double)lowY + w) * potY;
                    if (yPl > yMa) break;
                    if (yPl < yMi) {
                        continue;
                    }
                } else {
                    yPl = ((double)lowY - w) * potY;
                    if (yPl < yMa) break;
                    if (yPl > yMi) continue;
                }
                yPl = yPl * this.yL - this.yI;
                v = 0.5;
                if (!reverseY && b && iStep == 0 || reverseY && b && iStep == logS.length - 1) {
                    v = 0.8;
                }
                this.moveToDrawTo(xOr, yPl, 0);
                this.moveToDrawTo(xOr + v * size, yPl, 1);
                if (!frame) continue;
                this.moveToDrawTo(x_Mx, yPl, 0);
                this.moveToDrawTo(x_Mx - v * size, yPl, 1);
            }
        }
        if (xAxisErr) {
            throw new AxesDataException("Error: can Not draw X-axis - range too narrow" + nl + errTxtX);
        }
        if (yAxisErr) {
            throw new AxesDataException("Error: can Not draw Y-axis - range too narrow" + nl + errTxtY);
        }
        this.setIsFormula(isFormulaOld);
        double x = Math.min(Xmn_i, Xmx_i);
        double y = Math.min(Ymn_i, Ymx_i);
        double width = Math.max(Xmx_i, Xmn_i) - x;
        double height = Math.max(Ymx_i, Ymn_i) - y;
        this.clippingArea = new Rectangle2D.Double(x, y, width, height);
    }

    private String logTxt(String cDum, boolean xAxis) {
        int exponent;
        double w;
        long k;
        int n;
        String[] numb = new String[]{"0", "1", "2", "3", "4", "5", "6"};
        StringBuilder form = new StringBuilder("     %1d'.`10'%1d`");
        boolean integr = true;
        int coef = 1;
        for (n = 0; n < cDum.length(); ++n) {
            if (cDum.charAt(n) != '.') continue;
            integr = false;
            break;
        }
        if (integr) {
            k = Long.parseLong(cDum.trim());
            w = k;
        } else {
            w = Double.parseDouble(cDum.trim());
            k = (long)w;
        }
        if (!integr) {
            int width = 1;
            if (w > 9.99999 || w < -9.1) {
                width = 2;
            }
            if (w > 99.99999 || w < -99.1) {
                width = 3;
            }
            if (w < 0.0) {
                ++width;
            }
            form.replace(15, 16, numb[width]);
            if (!xAxis) {
                form.delete(0, width);
            }
            if ((w -= (double)(exponent = w > 0.0 ? (int)(w + 1.0E-5) : (int)(w - 1.0E-5))) < -3.0E-5) {
                w += 1.0;
                --exponent;
            }
            if (w <= 3.0E-5) {
                cDum = String.format("   %8d", exponent);
            } else {
                coef = -1;
                if (Math.abs(w - 0.301) <= Math.max(Math.abs(w), Math.abs(0.301)) * 1.0E-4) {
                    coef = 2;
                }
                if (Math.abs(w - 0.602) <= Math.max(Math.abs(w), Math.abs(0.602)) * 1.0E-4) {
                    coef = 4;
                }
                if (Math.abs(w - 0.7781) <= Math.max(Math.abs(w), Math.abs(0.7781)) * 1.0E-4) {
                    coef = 6;
                }
                if (coef <= 0) {
                    coef = 2;
                }
                if (coef > 0 && Math.abs(exponent) > 3) {
                    cDum = String.format(form.toString(), coef, exponent);
                    return cDum;
                }
            }
        } else {
            exponent = (int)k;
        }
        if (Math.abs(exponent) > 3 | coef < 0) {
            int len;
            for (n = 0; n < cDum.length() && cDum.charAt(n) == ' '; ++n) {
            }
            cDum = n < 3 ? "10'" + cDum.substring(n) : cDum.substring(0, n - 3) + "10'" + cDum.substring(n);
            for (len = cDum.length() - 1; len >= 0 && cDum.charAt(len) == ' '; --len) {
            }
            if (len < 0) {
                len = 0;
            }
            cDum = cDum.substring(0, len + 1) + "`";
            return cDum;
        }
        String cDum1 = " ";
        if (exponent == -3) {
            cDum1 = "0.001";
        } else if (exponent == -2) {
            cDum1 = " 0.01";
        } else if (exponent == -1) {
            cDum1 = "  0.1";
        } else if (exponent == 0) {
            cDum1 = "    1";
        } else if (exponent == 1) {
            cDum1 = "   10";
        } else if (exponent == 2) {
            cDum1 = "  100";
        } else if (exponent == 3) {
            cDum1 = " 1000";
        }
        if (xAxis) {
            if (integr) {
                if (exponent == -3 || exponent == -2) {
                    cDum = "      " + cDum1;
                }
                if (exponent == 0 || exponent == 1) {
                    cDum = "    " + cDum1;
                }
                if (exponent == -1 || exponent == 2 || exponent == 3) {
                    cDum = "     " + cDum1;
                }
                return cDum;
            }
            if (exponent == -3 || exponent == -2) {
                cDum = "     " + cDum1;
            }
            if (exponent == 0 || exponent == 1) {
                cDum = "   " + cDum1;
            }
            if (exponent == -1 || exponent == 2 || exponent == 3) {
                cDum = "    " + cDum1;
            }
        } else {
            cDum = "    " + cDum1;
        }
        if (integr) {
            return cDum;
        }
        for (int n2 = 0; n2 < cDum.length(); ++n2) {
            if (cDum.charAt(n2) != '1') continue;
            cDum = cDum.substring(0, n2) + numb[coef] + cDum.substring(n2 + 1);
            break;
        }
        return cDum;
    }

    public static int isFormulaLength(String cDum) {
        int len = (cDum = cDum.trim()).length();
        if (len <= 0) {
            return 0;
        }
        int nbr = 0;
        int i = Math.max(cDum.indexOf("+"), Math.max(cDum.indexOf("-"), Math.max(cDum.indexOf(8211), cDum.indexOf(8722))));
        if (i >= len - 3 && i > 1) {
            if (i == len - 1 && len > 2) {
                if (Character.isWhitespace(cDum.charAt(i - 1))) {
                    ++nbr;
                } else if (len > 3 && cDum.charAt(i - 1) >= '2' && cDum.charAt(i - 1) <= '9' && Character.isWhitespace(cDum.charAt(i - 2))) {
                    ++nbr;
                }
                if (len > 4 && cDum.charAt(i - 1) >= '0' && cDum.charAt(i - 1) <= '9' && cDum.charAt(i - 2) >= '1' && cDum.charAt(i - 2) <= '9' && Character.isWhitespace(cDum.charAt(i - 3))) {
                    ++nbr;
                }
            } else if (len > 3 && i == len - 2 && Character.isWhitespace(cDum.charAt(i - 1)) && cDum.charAt(i + 1) >= '2' && cDum.charAt(i + 1) <= '9') {
                ++nbr;
            } else if (len > 4 && i == len - 3 && Character.isWhitespace(cDum.charAt(i - 1)) && cDum.charAt(i + 1) >= '1' && cDum.charAt(i + 1) <= '9' && cDum.charAt(i + 2) >= '0' && cDum.charAt(i + 2) <= '9') {
                ++nbr;
            }
        }
        int start = 0;
        while ((i = cDum.indexOf("'", start)) >= 0) {
            ++nbr;
            start = i + 1;
            if (start <= len) continue;
        }
        start = 0;
        while ((i = cDum.indexOf("\u00b4", start)) >= 0) {
            ++nbr;
            start = i + 1;
            if (start <= len) continue;
        }
        start = 0;
        while ((i = cDum.indexOf("`", start)) >= 0) {
            ++nbr;
            start = i + 1;
            if (start <= len) continue;
        }
        return len -= nbr;
    }

    public void lineType(int lineStyle) {
        this.lineStyle = Math.max(0, Math.min(5, lineStyle));
        if (this.nDash != 0) {
            this.dashIt();
        }
        this.nDash = 0;
        if (lineStyle == 1) {
            this.dash[0] = 0.35;
            this.dash[1] = 0.25;
            this.dash[2] = 0.0;
            this.dash[3] = 0.0;
        } else if (lineStyle == 2) {
            this.dash[0] = 0.2;
            this.dash[1] = 0.3;
            this.dash[2] = 0.0;
            this.dash[3] = 0.0;
        } else if (lineStyle == 3) {
            this.dash[0] = 0.3;
            this.dash[1] = 0.1;
            this.dash[2] = 0.0;
            this.dash[3] = 0.0;
        } else if (lineStyle == 4) {
            this.dash[0] = 0.3;
            this.dash[1] = 0.2;
            this.dash[2] = 0.07;
            this.dash[3] = 0.2;
        } else if (lineStyle == 5) {
            this.dash[0] = 0.07;
            this.dash[1] = 0.2;
            this.dash[2] = 0.0;
            this.dash[3] = 0.0;
        } else {
            this.dash[0] = 0.0;
            this.dash[1] = 0.0;
            this.dash[2] = 0.0;
            this.dash[3] = 0.0;
        }
    }

    public void line(double[] x, double[] y) {
        int n = Math.min(x.length, y.length);
        if (n <= 1) {
            return;
        }
        double oldX = Double.NEGATIVE_INFINITY;
        double oldY = Double.NEGATIVE_INFINITY;
        double x2 = Double.NaN;
        double y2 = Double.NaN;
        for (int j = 1; j < n; ++j) {
            double x1 = x[j - 1];
            double y1 = y[j - 1];
            x2 = x[j];
            y2 = y[j];
            Line2D lineToClip = new Line2D.Double(x1, y1, x2, y2);
            if ((lineToClip = this.myClip(lineToClip, this.clippingArea)) == null) continue;
            x1 = lineToClip.getX1();
            y1 = lineToClip.getY1();
            x2 = lineToClip.getX2();
            y2 = lineToClip.getY2();
            if (oldX != x1 || oldY != y1) {
                x1 = x1 * this.xL - this.xI;
                y1 = y1 * this.yL - this.yI;
                this.lineMoveToDrawTo(x1, y1, 0);
            }
            oldX = x2;
            oldY = y2;
            x2 = x2 * this.xL - this.xI;
            y2 = y2 * this.yL - this.yI;
            this.lineMoveToDrawTo(x2, y2, 1);
        }
        if (!Double.isNaN(x2) && !Double.isNaN(y2)) {
            this.lineMoveToDrawTo(x2, y2, 0);
        }
    }

    private void lineMoveToDrawTo(double x, double y, int n) {
        if (this.lineStyle == 0) {
            this.moveToDrawTo(x, y, n);
            return;
        }
        if (n == 0 && this.nDash > 0) {
            this.dashIt();
        }
        ++this.nDash;
        this.xDash[this.nDash - 1] = x;
        this.yDash[this.nDash - 1] = y;
        if (this.nDash >= this.xDash.length - 1) {
            this.dashIt();
        }
    }

    private void dashIt() {
        double y;
        double x;
        int k;
        if (this.nDash <= 1) {
            this.nDash = 0;
            return;
        }
        double xP = this.xDash[0];
        double yP = this.yDash[0];
        double xOld = xP;
        double yOld = yP;
        double cuLength = 0.0;
        for (k = 0; k < this.nDash - 1; ++k) {
            x = this.xDash[k + 1] - this.xDash[k];
            y = this.yDash[k + 1] - this.yDash[k];
            cuLength += Math.sqrt(x * x + y * y);
        }
        double dLength = this.dash[0] + this.dash[1] + this.dash[2] + this.dash[3];
        int noDash = (int)((cuLength - this.dash[0]) / dLength);
        if (noDash <= 0) {
            for (k = 0; k < this.nDash - 1; ++k) {
                xP = this.xDash[k + 1];
                yP = this.yDash[k + 1];
                this.moveToDrawTo(xOld, yOld, 0);
                this.moveToDrawTo(xP, yP, 1);
                xOld = xP;
                yOld = yP;
            }
            this.nDash = 0;
            return;
        }
        double f = (double)noDash * dLength / (cuLength - this.dash[0]);
        double[] dash2 = new double[]{0.0, 0.0, 0.0, 0.0};
        dash2[0] = this.dash[0] / f;
        dash2[1] = this.dash[1] / f;
        dash2[2] = this.dash[2] / f;
        dash2[3] = this.dash[3] / f;
        k = 0;
        boolean down = true;
        while (down) {
            for (int i = 0; i < 4; ++i) {
                double del;
                double left = del = dash2[i];
                double lenP = 0.0;
                while (lenP < del && k < this.nDash - 1) {
                    x = this.xDash[k + 1] - xP;
                    y = this.yDash[k + 1] - yP;
                    double incr = Math.sqrt(x * x + y * y);
                    if (!((lenP += incr) < del)) continue;
                    xP = this.xDash[++k];
                    yP = this.yDash[k];
                    if (down) {
                        this.moveToDrawTo(xOld, yOld, 0);
                        this.moveToDrawTo(xP, yP, 1);
                    }
                    xOld = xP;
                    yOld = yP;
                    left -= incr;
                }
                if (del < lenP) {
                    double l = lenP - del;
                    double d22 = left / (left + l);
                    xP += d22 * (this.xDash[k + 1] - xP);
                    yP += d22 * (this.yDash[k + 1] - yP);
                    if (down) {
                        this.moveToDrawTo(xOld, yOld, 0);
                        this.moveToDrawTo(xP, yP, 1);
                    }
                    xOld = xP;
                    yOld = yP;
                }
                boolean bl = down = !down;
                if (k < this.nDash - 1) continue;
                this.nDash = 0;
                return;
            }
        }
        this.nDash = 0;
    }

    private Line2D myClip(Line2D lineToClip, Rectangle2D clippingArea) {
        double x1 = lineToClip.getX1();
        double y1 = lineToClip.getY1();
        double x2 = lineToClip.getX2();
        double y2 = lineToClip.getY2();
        CodeData cd1 = new CodeData();
        CodeData cd2 = new CodeData();
        cd1 = this.code(x1, y1, cd1, clippingArea);
        cd2 = this.code(x2, y2, cd2, clippingArea);
        while (true) {
            if (cd1.c == 0 && cd2.c == 0) {
                lineToClip = new Line2D.Double(x1, y1, x2, y2);
                return lineToClip;
            }
            if (this.bitMultipl(cd1.i1, cd2.i1, cd1.i2, cd2.i2, cd1.i3, cd2.i3, cd1.i4, cd2.i4) != 0) {
                return null;
            }
            int c = cd1.c;
            if (c == 0) {
                c = cd2.c;
            }
            double x = x1;
            double y = y1;
            if (c >= 1000) {
                x = x1 + (x2 - x1) * (clippingArea.getMaxY() - y1) / (y2 - y1);
                y = clippingArea.getMaxY();
            }
            if (c < 1000 && c >= 100) {
                x = x1 + (x2 - x1) * (clippingArea.getMinY() - y1) / (y2 - y1);
                y = clippingArea.getMinY();
            }
            if (c < 100 && c >= 10) {
                y = y1 + (y2 - y1) * (clippingArea.getMaxX() - x1) / (x2 - x1);
                x = clippingArea.getMaxX();
            }
            if (c < 10) {
                y = y1 + (y2 - y1) * (clippingArea.getMinX() - x1) / (x2 - x1);
                x = clippingArea.getMinX();
            }
            if (c != cd2.c) {
                x1 = x;
                y1 = y;
                cd1 = this.code(x1, y1, cd1, clippingArea);
                continue;
            }
            x2 = x;
            y2 = y;
            cd2 = this.code(x2, y2, cd2, clippingArea);
        }
    }

    private CodeData code(double x, double y, CodeData cd, Rectangle2D clippingArea) {
        cd.c = 0;
        cd.i1 = 0;
        cd.i2 = 0;
        cd.i3 = 0;
        cd.i4 = 0;
        if (x < clippingArea.getMinX()) {
            cd.c = 1;
            cd.i1 = 1;
        }
        if (x > clippingArea.getMaxX()) {
            cd.c = 10;
            cd.i2 = 1;
        }
        if (y < clippingArea.getMinY()) {
            cd.c += 100;
            cd.i3 = 1;
        }
        if (y > clippingArea.getMaxY()) {
            cd.c += 1000;
            cd.i4 = 1;
        }
        return cd;
    }

    private int bitMultipl(int i1_1, int i1_2, int i2_1, int i2_2, int i3_1, int i3_2, int i4_1, int i4_2) {
        int bitMult = 0;
        if (i1_1 != 0 && i1_2 != 0 || i2_1 != 0 && i2_2 != 0 || i3_1 != 0 && i3_2 != 0 || i4_1 != 0 && i4_2 != 0) {
            bitMult = 1;
        }
        return bitMult;
    }

    private class CodeData {
        int c = 0;
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        int i4 = 0;

        CodeData(int c, int i1, int i2, int i3, int i4) {
            this.c = c;
            this.i1 = i1;
            this.i2 = i2;
            this.i3 = i3;
            this.i4 = i4;
        }

        CodeData() {
        }
    }

    public class AxesDataException
    extends Exception {
        public AxesDataException() {
        }

        public AxesDataException(String txt) {
            super(txt);
        }
    }

    public static class openPlotFileException
    extends Exception {
        public openPlotFileException() {
        }

        public openPlotFileException(String txt) {
            super(txt);
        }
    }

    public static class PltData {
        public String pltFile_Name;
        public Date fileLastModified;
        public ArrayList<PlotStep> pltFileAList = new ArrayList();
        public ArrayList<PlotText> pltTextAList = new ArrayList();
        public Point userSpaceMax = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        public Point userSpaceMin = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        public boolean axisInfo = false;
        public float xAxisL;
        public float yAxisL;
        public float xAxis0;
        public float yAxis0;
        public float xAxisMin;
        public float yAxisMin;
        public float xAxisMax;
        public float yAxisMax;
        public float xAxisMin_true;
        public float xAxisMax_true;
        public float yAxisMin_true;
        public float yAxisMax_true;
        public float xAxisScale;
        public float yAxisScale;

        public static class PlotText {
            public int i1 = 0;
            public int i2 = 0;
            public boolean isFormula = false;
            public int alignment = 0;
            public float txtSize = 0.4f;
            public float txtAngle = 0.0f;
            public String txtLine;
            public int pen = 5;
            public int color = 1;

            public PlotText(int i1, int i2, boolean isFormula, int align, float txtSize, float txtAngle, String txtLine, int pen, int clr) {
                this.i1 = i1;
                this.i2 = i2;
                this.isFormula = isFormula;
                this.alignment = Math.max(-1, Math.min(align, 1));
                this.txtSize = txtSize;
                this.txtAngle = txtAngle;
                this.txtLine = txtLine;
                this.pen = pen;
                this.color = clr;
            }
        }

        public static class PlotStep {
            public int i0 = 0;
            public int i1 = 0;
            public int i2 = 0;

            public PlotStep(int i0, int i1, int i2) {
                this.i0 = i0;
                this.i1 = i1;
                this.i2 = i2;
            }
        }
    }
}

