/*
 * Decompiled with CFR 0.152.
 */
package simpleEquilibriumDiagrams;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import lib.common.Util;
import lib.kemi.chem.Chem;
import lib.kemi.graph_lib.DiagrPaintUtility;
import lib.kemi.graph_lib.GraphLib;
import lib.kemi.haltaFall.Factor;
import lib.kemi.haltaFall.HaltaFall;
import lib.kemi.interpolate.Interpolate;
import lib.kemi.readDataLib.ReadDataLib;
import lib.kemi.readWriteDataFiles.ReadChemSyst;
import simpleEquilibriumDiagrams.Debugging;
import simpleEquilibriumDiagrams.HelpAboutF;
import simpleEquilibriumDiagrams.Main;
import simpleEquilibriumDiagrams.Plot;
import simpleEquilibriumDiagrams.Table;

public class SED
extends JFrame {
    static final String VERS = "2015-May-22";
    static final String progName = "SED";
    private static SED sedFrame;
    private static final boolean DBG_DEFAULT = false;
    boolean dbg = false;
    private boolean doNotExit = false;
    private boolean doNotStop = false;
    private boolean reversedConcs = false;
    private static String pathApp;
    StringBuffer pathDef = new StringBuffer();
    private File inputDataFile = null;
    private File outputPltFile = null;
    private boolean inputDataFileInCommandLine;
    private boolean finishedCalculations = true;
    private boolean programEnded = false;
    private HaltaTask tsk = null;
    private long calculationStart = 0L;
    private long calculationTime = 0L;
    static Dimension screenSize;
    private final Dimension originalSize;
    private Chem ch = null;
    private Chem.ChemSystem cs = null;
    private Chem.ChemSystem.ChemConcs csC = null;
    private Chem.ChemSystem.NamesEtc namn = null;
    private Chem.DiagrConcs dgrC = null;
    private Chem.Diagr diag = null;
    private Factor factor;
    private HaltaFall h;
    private ReadDataLib rd;
    private Plot plot = null;
    GraphLib.PltData dd;
    private HelpAboutF helpAboutFrame = null;
    private final JFileChooser fc;
    private final FileNameExtensionFilter filterDat;
    private boolean eraseTextArea = false;
    private PrintStream err;
    private PrintStream out;
    private static final int NSTP_MAX = 300;
    private static final int NSTP_MIN = 4;
    private static final int NSTP_DEF = 50;
    int nSteps = 50;
    private int nStepX;
    double[][] bt;
    private final double ln10 = Math.log(10.0);
    boolean calcActCoeffs = false;
    private final int actCoeffsModelDefault = 2;
    private double ionicStrength = Double.NaN;
    double temperature_InCommandLine = Double.NaN;
    private int actCoeffsModel_InCommandLine = -1;
    private final double TEMPERATURE_DEFAULT = 25.0;
    private double tolHalta = 1.0E-4;
    double peEh = Double.NaN;
    double tHeight;
    float threshold = 0.03f;
    private boolean tableOutput = false;
    private Table table = null;
    String tblExtension = "csv";
    String tblFieldSeparator = ";";
    String tblCommentStart = "\"";
    String tblCommentEnd = "\"";
    private final int DBGHALTA_DEF = 1;
    int dbgHalta = 1;
    private boolean[] pos;
    private boolean[] neg;
    private final DiagrPaintUtility diagrPaintUtil;
    private final PrintStream errPrintStream = new PrintStream(new errFilteredStreamSED(new ByteArrayOutputStream()), true);
    private final PrintStream outPrintStream = new PrintStream(new outFilteredStreamSED(new ByteArrayOutputStream()), true);
    boolean consoleOutput = true;
    private static final String nl;
    private static final Locale engl;
    static final String LINE = "-------------------------------------";
    private static final String SLASH;
    private ButtonGroup buttonGroupDebug;
    private JButton jButtonDoIt;
    private JCheckBox jCheckActCoeff;
    private JCheckBoxMenuItem jCheckBoxMenuSEDdebug;
    private JCheckBox jCheckReverse;
    private JCheckBox jCheckTable;
    private JComboBox jComboBoxModel;
    private JComboBox jComboBoxTol;
    private JLabel jLabelData;
    private JLabel jLabelHD;
    private JLabel jLabelHeight;
    private JLabel jLabelIonicStr;
    private JLabel jLabelIonicStrM;
    private JLabel jLabelModel;
    private JLabel jLabelNbrPText;
    private JLabel jLabelPltFile;
    private JLabel jLabelPointsNbr;
    private JLabel jLabelProgress;
    private JLabel jLabelStatus;
    private JLabel jLabelT;
    private JLabel jLabelTC;
    private JLabel jLabelTol;
    private JMenuBar jMenuBar;
    private JMenuItem jMenuCancel;
    private JMenu jMenuDebug;
    private JMenu jMenuFile;
    private JMenuItem jMenuFileMakeD;
    private JMenuItem jMenuFileOpen;
    private JMenuItem jMenuFileXit;
    private JMenuItem jMenuHF_dbg;
    private JMenu jMenuHelp;
    private JMenuItem jMenuHelpAbout;
    private JMenuItem jMenuSave;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanelActC;
    private JPanel jPanelDiagram;
    private JPanel jPanelFiles;
    private JPanel jPanelParameters;
    private JPanel jPanelStatusBar;
    private JPanel jPanelT;
    private JScrollBar jScrollBarHeight;
    private JScrollBar jScrollBarNbrPoints;
    private JScrollPane jScrollPaneMessg;
    private JTabbedPane jTabbedPane;
    private JTextArea jTextAreaA;
    private JTextField jTextFieldDataFile;
    private JTextField jTextFieldIonicStgr;
    private JTextField jTextFieldPltFile;
    private JTextField jTextFieldT;

    public SED(boolean doNotExit0, boolean doNotStop0, boolean dbg0) {
        this.initComponents();
        this.dbg = dbg0;
        this.doNotStop = doNotStop0;
        this.doNotExit = doNotExit0;
        this.out = this.outPrintStream;
        this.err = this.errPrintStream;
        this.setPathDef();
        this.fc = new JFileChooser(".");
        this.filterDat = new FileNameExtensionFilter("*.dat", "DAT");
        this.setDefaultCloseOperation(0);
        KeyStroke f1KeyStroke = KeyStroke.getKeyStroke(112, 0, false);
        this.getRootPane().getInputMap(2).put(f1KeyStroke, "F1");
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SED.this.jMenuHelpAbout.isEnabled()) {
                    SED.this.jMenuHelpAbout.doClick();
                }
            }
        };
        this.getRootPane().getActionMap().put("F1", f1Action);
        KeyStroke altXKeyStroke = KeyStroke.getKeyStroke(88, 8, false);
        this.getRootPane().getInputMap(2).put(altXKeyStroke, "ALT_X");
        AbstractAction altXAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SED.this.jMenuFileXit.isEnabled()) {
                    SED.this.jMenuFileXit.doClick();
                }
            }
        };
        this.getRootPane().getActionMap().put("ALT_X", altXAction);
        KeyStroke altQKeyStroke = KeyStroke.getKeyStroke(81, 8, false);
        this.getRootPane().getInputMap(2).put(altQKeyStroke, "ALT_Q");
        this.getRootPane().getActionMap().put("ALT_Q", altXAction);
        KeyStroke altEnterKeyStroke = KeyStroke.getKeyStroke(10, 8, false);
        this.getRootPane().getInputMap(2).put(altEnterKeyStroke, "ALT_Enter");
        AbstractAction altEnterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SED.this.jMenuFileMakeD.isEnabled()) {
                    SED.this.jMenuFileMakeD.doClick();
                }
            }
        };
        this.getRootPane().getActionMap().put("ALT_Enter", altEnterAction);
        KeyStroke altCKeyStroke = KeyStroke.getKeyStroke(67, 8, false);
        this.getRootPane().getInputMap(2).put(altCKeyStroke, "ALT_C");
        AbstractAction altCAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SED.this.jTabbedPane.getSelectedIndex() == 0 && SED.this.jComboBoxModel.isEnabled()) {
                    SED.this.jComboBoxModel.requestFocusInWindow();
                }
            }
        };
        this.getRootPane().getActionMap().put("ALT_C", altCAction);
        KeyStroke altDKeyStroke = KeyStroke.getKeyStroke(68, 8, false);
        this.getRootPane().getInputMap(2).put(altDKeyStroke, "ALT_D");
        AbstractAction altDAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SED.this.jTabbedPane.getSelectedIndex() == 0 && SED.this.jMenuFileMakeD.isEnabled() && SED.this.jButtonDoIt.isEnabled()) {
                    SED.this.jButtonDoIt.doClick();
                } else if (SED.this.jTabbedPane.getSelectedIndex() != 2 && SED.this.jTabbedPane.isEnabledAt(2)) {
                    SED.this.jTabbedPane.setSelectedIndex(2);
                }
            }
        };
        this.getRootPane().getActionMap().put("ALT_D", altDAction);
        KeyStroke altEKeyStroke = KeyStroke.getKeyStroke(69, 8, false);
        AbstractAction altEAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SED.this.jTabbedPane.getSelectedIndex() == 0) {
                    SED.this.jScrollBarHeight.requestFocusInWindow();
                }
            }
        };
        this.getRootPane().getInputMap(2).put(altEKeyStroke, "ALT_E");
        this.getRootPane().getActionMap().put("ALT_E", altEAction);
        KeyStroke altLKeyStroke = KeyStroke.getKeyStroke(76, 8, false);
        this.getRootPane().getInputMap(2).put(altLKeyStroke, "ALT_L");
        AbstractAction altLAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SED.this.jTabbedPane.getSelectedIndex() == 0) {
                    SED.this.jTextFieldPltFile.requestFocusInWindow();
                }
            }
        };
        this.getRootPane().getActionMap().put("ALT_L", altLAction);
        KeyStroke altMKeyStroke = KeyStroke.getKeyStroke(77, 8, false);
        this.getRootPane().getInputMap(2).put(altMKeyStroke, "ALT_M");
        AbstractAction altMAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SED.this.jTabbedPane.getSelectedIndex() != 1 && SED.this.jTabbedPane.isEnabledAt(1)) {
                    SED.this.jTabbedPane.setSelectedComponent(SED.this.jScrollPaneMessg);
                }
            }
        };
        this.getRootPane().getActionMap().put("ALT_M", altMAction);
        KeyStroke altNKeyStroke = KeyStroke.getKeyStroke(78, 8, false);
        this.getRootPane().getInputMap(2).put(altNKeyStroke, "ALT_N");
        AbstractAction altNAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SED.this.jTabbedPane.getSelectedIndex() == 0) {
                    SED.this.jScrollBarNbrPoints.requestFocusInWindow();
                }
            }
        };
        this.getRootPane().getActionMap().put("ALT_N", altNAction);
        KeyStroke altPKeyStroke = KeyStroke.getKeyStroke(80, 8, false);
        this.getRootPane().getInputMap(2).put(altPKeyStroke, "ALT_P");
        AbstractAction altPAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SED.this.jTabbedPane.getSelectedIndex() != 0) {
                    SED.this.jTabbedPane.setSelectedIndex(0);
                }
            }
        };
        this.getRootPane().getActionMap().put("ALT_P", altPAction);
        KeyStroke altSKeyStroke = KeyStroke.getKeyStroke(83, 8, false);
        this.getRootPane().getInputMap(2).put(altSKeyStroke, "ALT_S");
        AbstractAction altSAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SED.this.jTabbedPane.getSelectedIndex() == 0 && SED.this.jTextFieldIonicStgr.isEnabled()) {
                    SED.this.jTextFieldIonicStgr.requestFocusInWindow();
                }
            }
        };
        this.getRootPane().getActionMap().put("ALT_S", altSAction);
        KeyStroke altTKeyStroke = KeyStroke.getKeyStroke(84, 8, false);
        this.getRootPane().getInputMap(2).put(altTKeyStroke, "ALT_T");
        AbstractAction altTAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SED.this.jTabbedPane.getSelectedIndex() == 0 && SED.this.jTextFieldT.isEnabled()) {
                    SED.this.jTextFieldT.requestFocusInWindow();
                }
            }
        };
        this.getRootPane().getActionMap().put("ALT_T", altTAction);
        this.setTitle("Simple Equilibrium Diagrams");
        this.jMenuBar.add(Box.createHorizontalGlue(), 2);
        this.originalSize = this.getSize();
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int left = Math.max(55, (SED.screenSize.width - this.originalSize.width) / 2);
        int top = Math.max(10, (SED.screenSize.height - this.originalSize.height) / 2);
        this.setLocation(Math.min(SED.screenSize.width - 100, left), Math.min(SED.screenSize.height - 100, top));
        String iconName = "images/PlotLog256_32x32_blackBckgr.gif";
        URL imgURL = this.getClass().getResource(iconName);
        if (imgURL != null) {
            Image icon = new ImageIcon(imgURL).getImage();
            this.setIconImage(icon);
            if (System.getProperty("os.name").startsWith("Mac OS")) {
                try {
                    Class<?> c = Class.forName("com.apple.eawt.Application");
                    Method m = c.getDeclaredMethod("setDockIconImage", Image.class);
                    Object i = c.newInstance();
                    Object[] paramsObj = new Object[]{icon};
                    m.invoke(i, paramsObj);
                }
                catch (Exception e) {
                    Util.exceptn("Error: " + e.getMessage());
                }
            }
        } else {
            Util.exceptn("Error: Could not load image = \"" + iconName + "\"");
        }
        this.jMenuFileMakeD.setEnabled(false);
        this.jButtonDoIt.setText("make the Diagram");
        this.jButtonDoIt.setEnabled(false);
        Font f = new Font("Monospaced", 0, 12);
        this.jTextAreaA.setFont(f);
        this.jTextAreaA.setText(null);
        this.jTabbedPane.setEnabledAt(1, false);
        this.jTabbedPane.setEnabledAt(2, false);
        this.jScrollBarNbrPoints.setFocusable(true);
        this.jScrollBarNbrPoints.setValue(this.nSteps);
        this.jScrollBarHeight.setFocusable(true);
        this.tHeight = 1.0;
        this.jScrollBarHeight.setValue(Math.round((float)(10.0 * this.tHeight)));
        this.jLabelPltFile.setText("plot file name");
        this.jLabelPltFile.setEnabled(false);
        this.jTextFieldPltFile.setText(null);
        this.jTextFieldPltFile.setEnabled(false);
        this.jLabelStatus.setText("waiting...");
        this.jLabelProgress.setText(" ");
        this.jTextFieldT.setText(String.valueOf(25.0));
        this.jComboBoxModel.setSelectedIndex(2);
        this.diagrPaintUtil = new DiagrPaintUtility();
    }

    private void start(boolean reversedConcs0, boolean help0, String[] args) {
        this.setVisible(true);
        this.inputDataFileInCommandLine = false;
        this.reversedConcs = reversedConcs0;
        boolean argErr = false;
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if (this.dispatchArg(arg)) continue;
                argErr = true;
            }
        }
        if (argErr && !this.doNotExit) {
            this.end_program();
            return;
        }
        this.out.println("Finished reading command-line arguments.");
        this.consoleOutput = this.inputDataFileInCommandLine & !this.doNotExit;
        if (!Double.isNaN(this.ionicStrength) && Math.abs(this.ionicStrength) > 1.0E-10 && Double.isNaN(this.temperature_InCommandLine)) {
            String msg = "Warning: ionic strength given as command line argument, I=" + (float)this.ionicStrength + nl + "    but no temperature is given on the command line.";
            this.out.println(msg);
        }
        if (!this.calcActCoeffs) {
            this.ionicStrength = 0.0;
        }
        this.jCheckReverse.setSelected(this.reversedConcs);
        this.jCheckTable.setSelected(this.tableOutput);
        this.jCheckActCoeff.setSelected(this.calcActCoeffs);
        this.jTextFieldIonicStgr.setText(String.valueOf(this.ionicStrength));
        this.showActivityCoefficientControls(this.calcActCoeffs);
        this.set_tol_inComboBox();
        this.showTemperature();
        if (help0) {
            this.jTextAreaA.setCaretPosition(0);
            this.jTabbedPane.setSelectedComponent(this.jScrollPaneMessg);
        }
        if (this.inputDataFileInCommandLine) {
            if (this.outputPltFile == null) {
                String txt = this.inputDataFile.getPath();
                String plotFileN = txt.substring(0, txt.length() - 3).concat("plt");
                this.outputPltFile = new File(plotFileN);
            }
            try {
                this.doCalculations();
            }
            catch (Exception ex) {
                this.showErrMsgBx(ex);
            }
        }
        this.programEnded = false;
    }

    private void initComponents() {
        this.buttonGroupDebug = new ButtonGroup();
        this.jTabbedPane = new JTabbedPane();
        this.jPanelParameters = new JPanel();
        this.jPanelFiles = new JPanel();
        this.jLabelData = new JLabel();
        this.jTextFieldDataFile = new JTextField();
        this.jLabelPltFile = new JLabel();
        this.jTextFieldPltFile = new JTextField();
        this.jPanel3 = new JPanel();
        this.jCheckReverse = new JCheckBox();
        this.jCheckTable = new JCheckBox();
        this.jPanelActC = new JPanel();
        this.jCheckActCoeff = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabelIonicStr = new JLabel();
        this.jTextFieldIonicStgr = new JTextField();
        this.jLabelIonicStrM = new JLabel();
        this.jPanelT = new JPanel();
        this.jLabelT = new JLabel();
        this.jTextFieldT = new JTextField();
        this.jLabelTC = new JLabel();
        this.jPanel5 = new JPanel();
        this.jLabelModel = new JLabel();
        this.jComboBoxModel = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jLabelTol = new JLabel();
        this.jComboBoxTol = new JComboBox();
        this.jPanel6 = new JPanel();
        this.jButtonDoIt = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabelNbrPText = new JLabel();
        this.jLabelPointsNbr = new JLabel();
        this.jScrollBarNbrPoints = new JScrollBar();
        this.jLabelHeight = new JLabel();
        this.jLabelHD = new JLabel();
        this.jScrollBarHeight = new JScrollBar();
        this.jScrollPaneMessg = new JScrollPane();
        this.jTextAreaA = new JTextArea();
        this.jPanelDiagram = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                SED.this.paintDiagrPanel(g);
            }
        };
        this.jPanelStatusBar = new JPanel();
        this.jLabelStatus = new JLabel();
        this.jLabelProgress = new JLabel();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuFileOpen = new JMenuItem();
        this.jMenuFileMakeD = new JMenuItem();
        this.jMenuFileXit = new JMenuItem();
        this.jMenuDebug = new JMenu();
        this.jCheckBoxMenuSEDdebug = new JCheckBoxMenuItem();
        this.jMenuSave = new JMenuItem();
        this.jMenuHF_dbg = new JMenuItem();
        this.jMenuCancel = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuHelpAbout = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                SED.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SED.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SED.this.formComponentResized(evt);
            }
        });
        this.jTabbedPane.setTabLayoutPolicy(1);
        this.jTabbedPane.setAlignmentX(0.0f);
        this.jTabbedPane.setFont(new Font("Dialog", 0, 11));
        this.jPanelParameters.setFont(new Font("Dialog", 0, 11));
        this.jPanelFiles.setFont(new Font("Dialog", 0, 11));
        this.jLabelData.setFont(new Font("Dialog", 0, 11));
        this.jLabelData.setHorizontalAlignment(4);
        this.jLabelData.setLabelFor(this.jTextFieldDataFile);
        this.jLabelData.setText("input data file:");
        this.jTextFieldDataFile.setBackground(new Color(204, 204, 204));
        this.jTextFieldDataFile.setFont(new Font("Dialog", 0, 11));
        this.jTextFieldDataFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SED.this.jTextFieldDataFileMouseClicked(evt);
            }
        });
        this.jTextFieldDataFile.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SED.this.jTextFieldDataFileKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                SED.this.jTextFieldDataFileKeyTyped(evt);
            }
        });
        this.jLabelPltFile.setFont(new Font("Dialog", 0, 11));
        this.jLabelPltFile.setHorizontalAlignment(4);
        this.jLabelPltFile.setLabelFor(this.jTextFieldPltFile);
        this.jLabelPltFile.setText("<html>p<u>l</u>ot file name:</html>");
        this.jTextFieldPltFile.setFont(new Font("Dialog", 0, 11));
        GroupLayout jPanelFilesLayout = new GroupLayout(this.jPanelFiles);
        this.jPanelFiles.setLayout(jPanelFilesLayout);
        jPanelFilesLayout.setHorizontalGroup(jPanelFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilesLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelData, GroupLayout.Alignment.TRAILING, -2, 81, -2).addComponent(this.jLabelPltFile, GroupLayout.Alignment.TRAILING, -2, 82, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldDataFile).addComponent(this.jTextFieldPltFile)).addContainerGap()));
        jPanelFilesLayout.setVerticalGroup(jPanelFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilesLayout.createSequentialGroup().addGroup(jPanelFilesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelData).addComponent(this.jTextFieldDataFile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelFilesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPltFile, -2, -1, -2).addComponent(this.jLabelPltFile, -2, -1, -2)).addGap(120, 120, 120)));
        this.jPanel3.setFont(new Font("Dialog", 0, 11));
        this.jCheckReverse.setFont(new Font("Dialog", 0, 11));
        this.jCheckReverse.setMnemonic(82);
        this.jCheckReverse.setText("<html>allow <u>R</u>eversed min. and max. axes limits</html>");
        this.jCheckReverse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jCheckReverseActionPerformed(evt);
            }
        });
        this.jCheckTable.setFont(new Font("Dialog", 0, 11));
        this.jCheckTable.setMnemonic(79);
        this.jCheckTable.setText("<html>table <u>O</u>utput</html>");
        this.jCheckTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jCheckTableActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jCheckReverse, -2, -1, -2).addGap(53, 53, 53).addComponent(this.jCheckTable, -2, -1, -2).addContainerGap(189, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckTable, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jCheckReverse, GroupLayout.Alignment.TRAILING, -2, -1, -2))));
        this.jPanelActC.setFont(new Font("Dialog", 0, 11));
        this.jCheckActCoeff.setFont(new Font("Dialog", 0, 11));
        this.jCheckActCoeff.setMnemonic(65);
        this.jCheckActCoeff.setText("<html><u>A</u>ctivity coefficient calculations</html>");
        this.jCheckActCoeff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jCheckActCoeffActionPerformed(evt);
            }
        });
        this.jPanel1.setFont(new Font("Dialog", 0, 11));
        this.jLabelIonicStr.setFont(new Font("Dialog", 0, 11));
        this.jLabelIonicStr.setLabelFor(this.jTextFieldIonicStgr);
        this.jLabelIonicStr.setText("<html>ionic <u>S</u>trength</html>");
        this.jLabelIonicStr.setEnabled(false);
        this.jTextFieldIonicStgr.setFont(new Font("Dialog", 0, 11));
        this.jTextFieldIonicStgr.setHorizontalAlignment(4);
        this.jTextFieldIonicStgr.setEnabled(false);
        this.jTextFieldIonicStgr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jTextFieldIonicStgrActionPerformed(evt);
            }
        });
        this.jTextFieldIonicStgr.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SED.this.jTextFieldIonicStgrFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SED.this.jTextFieldIonicStgrFocusLost(evt);
            }
        });
        this.jTextFieldIonicStgr.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SED.this.jTextFieldIonicStgrKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                SED.this.jTextFieldIonicStgrKeyTyped(evt);
            }
        });
        this.jLabelIonicStrM.setFont(new Font("Dialog", 0, 11));
        this.jLabelIonicStrM.setText("<html>mol/(kg H<sub>2</sub>O)</html>");
        this.jLabelIonicStrM.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabelIonicStr, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldIonicStgr, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelIonicStrM, -2, -1, -2).addGap(7, 7, 7)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelIonicStr, -2, -1, -2).addComponent(this.jTextFieldIonicStgr, -2, -1, -2).addComponent(this.jLabelIonicStrM, -2, -1, -2)));
        this.jPanelT.setFont(new Font("Dialog", 0, 11));
        this.jLabelT.setFont(new Font("Dialog", 0, 11));
        this.jLabelT.setLabelFor(this.jTextFieldT);
        this.jLabelT.setText("<html><u>T</u>emperature</html>");
        this.jLabelT.setEnabled(false);
        this.jLabelT.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SED.this.jLabelTMouseClicked(evt);
            }
        });
        this.jTextFieldT.setFont(new Font("Dialog", 0, 11));
        this.jTextFieldT.setHorizontalAlignment(4);
        this.jTextFieldT.setToolTipText("<html>\nThe temperature is needed either to calculate Debye-H\u00fcckel constants<br>\nin activity coefficient models, or to calculate Eh values<br>\nfrom pe: Eh = pe*(ln(10)*R*T)/F<br>\nValue must be between 0 and 300 (in Celsius)</html>");
        this.jTextFieldT.setEnabled(false);
        this.jTextFieldT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jTextFieldTActionPerformed(evt);
            }
        });
        this.jTextFieldT.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SED.this.jTextFieldTFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SED.this.jTextFieldTFocusLost(evt);
            }
        });
        this.jTextFieldT.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SED.this.jTextFieldTKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                SED.this.jTextFieldTKeyTyped(evt);
            }
        });
        this.jLabelTC.setFont(new Font("Dialog", 0, 11));
        this.jLabelTC.setText("\u00b0C");
        this.jLabelTC.setEnabled(false);
        GroupLayout jPanelTLayout = new GroupLayout(this.jPanelT);
        this.jPanelT.setLayout(jPanelTLayout);
        jPanelTLayout.setHorizontalGroup(jPanelTLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabelT, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldT, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelTC).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelTLayout.setVerticalGroup(jPanelTLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldT, -2, -1, -2).addComponent(this.jLabelT, -2, -1, -2).addComponent(this.jLabelTC)));
        this.jPanel5.setFont(new Font("Dialog", 0, 11));
        this.jLabelModel.setFont(new Font("Dialog", 0, 11));
        this.jLabelModel.setLabelFor(this.jComboBoxModel);
        this.jLabelModel.setText("<html>activity <u>C</u>officient model:<html>");
        this.jComboBoxModel.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxModel.setModel(new DefaultComboBoxModel<String>(new String[]{"Davies eqn.", "SIT (Specific Ion interaction 'Theory')", "simplified HKF (Helgeson, Kirkham & Flowers)"}));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxModel, -2, -1, -2).addComponent(this.jLabelModel, -2, -1, -2)).addContainerGap(28, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabelModel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxModel, -2, -1, -2).addContainerGap(29, Short.MAX_VALUE)));
        GroupLayout jPanelActCLayout = new GroupLayout(this.jPanelActC);
        this.jPanelActC.setLayout(jPanelActCLayout);
        jPanelActCLayout.setHorizontalGroup(jPanelActCLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActCLayout.createSequentialGroup().addGroup(jPanelActCLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActCLayout.createSequentialGroup().addGroup(jPanelActCLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActCLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2)).addComponent(this.jPanelT, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanel5, -2, -1, -2)).addComponent(this.jCheckActCoeff, -2, -1, -2)).addContainerGap(20, Short.MAX_VALUE)));
        jPanelActCLayout.setVerticalGroup(jPanelActCLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActCLayout.createSequentialGroup().addGroup(jPanelActCLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelActCLayout.createSequentialGroup().addComponent(this.jCheckActCoeff, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addGap(29, 29, 29).addComponent(this.jPanelT, -2, -1, -2).addGap(0, 4, Short.MAX_VALUE)).addGroup(jPanelActCLayout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        this.jPanel4.setFont(new Font("Dialog", 0, 11));
        this.jLabelTol.setFont(new Font("Dialog", 0, 11));
        this.jLabelTol.setLabelFor(this.jComboBoxTol);
        this.jLabelTol.setText("tolerance (for calculations in HaltaFall):");
        this.jComboBoxTol.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxTol.setModel(new DefaultComboBoxModel<String>(new String[]{"1E-2", "1E-3", "1E-4", "1E-5", "1E-6", "1E-7", "1E-8"}));
        this.jComboBoxTol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jComboBoxTolActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabelTol).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxTol, -2, 92, -2).addContainerGap(265, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTol).addComponent(this.jComboBoxTol, -2, -1, -2)));
        this.jPanel6.setFont(new Font("Dialog", 0, 11));
        this.jButtonDoIt.setFont(new Font("Dialog", 0, 11));
        this.jButtonDoIt.setMnemonic('M');
        this.jButtonDoIt.setText("make the Diagram");
        this.jButtonDoIt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jButtonDoItActionPerformed(evt);
            }
        });
        this.jPanel2.setFont(new Font("Dialog", 0, 11));
        this.jLabelNbrPText.setFont(new Font("Dialog", 0, 11));
        this.jLabelNbrPText.setLabelFor(this.jLabelPointsNbr);
        this.jLabelNbrPText.setText("<html><u>N</u>br of calc. steps:</html>");
        this.jLabelPointsNbr.setFont(new Font("Dialog", 0, 11));
        this.jLabelPointsNbr.setHorizontalAlignment(4);
        this.jLabelPointsNbr.setText("50");
        this.jLabelPointsNbr.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SED.this.jLabelPointsNbrMouseClicked(evt);
            }
        });
        this.jScrollBarNbrPoints.setMaximum(301);
        this.jScrollBarNbrPoints.setMinimum(4);
        this.jScrollBarNbrPoints.setOrientation(0);
        this.jScrollBarNbrPoints.setVisibleAmount(1);
        this.jScrollBarNbrPoints.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                SED.this.jScrollBarNbrPointsAdjustmentValueChanged(evt);
            }
        });
        this.jScrollBarNbrPoints.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SED.this.jScrollBarNbrPointsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SED.this.jScrollBarNbrPointsFocusLost(evt);
            }
        });
        this.jLabelHeight.setFont(new Font("Dialog", 0, 11));
        this.jLabelHeight.setText("<html>h<u>e</u>ight of text in diagram:</html>");
        this.jLabelHD.setFont(new Font("Dialog", 0, 11));
        this.jLabelHD.setHorizontalAlignment(4);
        this.jLabelHD.setText("1.0");
        this.jLabelHD.setMaximumSize(new Dimension(15, 14));
        this.jLabelHD.setMinimumSize(new Dimension(15, 14));
        this.jLabelHD.setPreferredSize(new Dimension(15, 14));
        this.jLabelHD.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SED.this.jLabelHDMouseClicked(evt);
            }
        });
        this.jScrollBarHeight.setMaximum(101);
        this.jScrollBarHeight.setMinimum(3);
        this.jScrollBarHeight.setOrientation(0);
        this.jScrollBarHeight.setValue(10);
        this.jScrollBarHeight.setVisibleAmount(1);
        this.jScrollBarHeight.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                SED.this.jScrollBarHeightAdjustmentValueChanged(evt);
            }
        });
        this.jScrollBarHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SED.this.jScrollBarHeightFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SED.this.jScrollBarHeightFocusLost(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelNbrPText, -2, -1, -2).addComponent(this.jLabelHeight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelPointsNbr, -2, 31, -2).addComponent(this.jLabelHD, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollBarHeight, -1, 75, Short.MAX_VALUE).addComponent(this.jScrollBarNbrPoints, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNbrPText, -2, -1, -2).addComponent(this.jLabelPointsNbr)).addComponent(this.jScrollBarNbrPoints, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelHeight, -2, -1, -2).addComponent(this.jLabelHD, -2, -1, -2)).addComponent(this.jScrollBarHeight, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jButtonDoIt, -2, 150, -2).addContainerGap(121, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDoIt).addComponent(this.jPanel2, -2, -1, -2)).addContainerGap()));
        GroupLayout jPanelParametersLayout = new GroupLayout(this.jPanelParameters);
        this.jPanelParameters.setLayout(jPanelParametersLayout);
        jPanelParametersLayout.setHorizontalGroup(jPanelParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelParametersLayout.createSequentialGroup().addContainerGap().addGroup(jPanelParametersLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelFiles, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanelParametersLayout.createSequentialGroup().addGroup(jPanelParametersLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel6, GroupLayout.Alignment.LEADING, -2, -1, -2).addComponent(this.jPanelActC, GroupLayout.Alignment.LEADING, -2, -1, -2).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -2, -1, -2).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -2, -1, -2)).addGap(0, 25, Short.MAX_VALUE))).addContainerGap()));
        jPanelParametersLayout.setVerticalGroup(jPanelParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelParametersLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelFiles, -2, 59, -2).addGap(18, 18, 18).addComponent(this.jPanel6, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelActC, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap(41, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("<html><u>P</u>arameters</html>", this.jPanelParameters);
        this.jScrollPaneMessg.setHorizontalScrollBarPolicy(32);
        this.jScrollPaneMessg.setVerticalScrollBarPolicy(22);
        this.jScrollPaneMessg.setFont(new Font("Monospaced", 0, 13));
        this.jTextAreaA.setBackground(new Color(255, 255, 204));
        this.jTextAreaA.setText("Use the PrintStreams \"err\" and \"out\" to\nsend messages to this pane, for example;\n   out.println(\"message\");\n   err.println(\"Error\");\netc.\nSystem.out and System.err will send\noutput to the console, which might\nnot be available to the user.");
        this.jTextAreaA.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SED.this.jTextAreaAKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                SED.this.jTextAreaAKeyTyped(evt);
            }
        });
        this.jScrollPaneMessg.setViewportView(this.jTextAreaA);
        this.jTabbedPane.addTab("Messages", this.jScrollPaneMessg);
        this.jPanelDiagram.setBackground(new Color(255, 255, 255));
        this.jPanelDiagram.setFont(new Font("Dialog", 0, 11));
        GroupLayout jPanelDiagramLayout = new GroupLayout(this.jPanelDiagram);
        this.jPanelDiagram.setLayout(jPanelDiagramLayout);
        jPanelDiagramLayout.setHorizontalGroup(jPanelDiagramLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 594, Short.MAX_VALUE));
        jPanelDiagramLayout.setVerticalGroup(jPanelDiagramLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 370, Short.MAX_VALUE));
        this.jTabbedPane.addTab("Diagram", this.jPanelDiagram);
        this.jPanelStatusBar.setBackground(new Color(204, 255, 255));
        this.jPanelStatusBar.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelStatusBar.setFont(new Font("Dialog", 0, 11));
        this.jLabelStatus.setFont(new Font("Dialog", 0, 11));
        this.jLabelStatus.setText("# # # #");
        this.jLabelProgress.setFont(new Font("Dialog", 0, 11));
        this.jLabelProgress.setText("text");
        GroupLayout jPanelStatusBarLayout = new GroupLayout(this.jPanelStatusBar);
        this.jPanelStatusBar.setLayout(jPanelStatusBarLayout);
        jPanelStatusBarLayout.setHorizontalGroup(jPanelStatusBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStatusBarLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelStatus).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelProgress, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanelStatusBarLayout.setVerticalGroup(jPanelStatusBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStatusBarLayout.createSequentialGroup().addGroup(jPanelStatusBarLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelProgress).addComponent(this.jLabelStatus)).addContainerGap()));
        this.jMenuFile.setMnemonic('F');
        this.jMenuFile.setText("File");
        this.jMenuFileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        this.jMenuFileOpen.setMnemonic('O');
        this.jMenuFileOpen.setText("Open input file");
        this.jMenuFileOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jMenuFileOpenActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuFileOpen);
        this.jMenuFileMakeD.setMnemonic('D');
        this.jMenuFileMakeD.setText("make the Diagram");
        this.jMenuFileMakeD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jMenuFileMakeDActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuFileMakeD);
        this.jMenuFileXit.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.jMenuFileXit.setMnemonic('x');
        this.jMenuFileXit.setText("Exit");
        this.jMenuFileXit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jMenuFileXitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuFileXit);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuDebug.setMnemonic('b');
        this.jMenuDebug.setText("debug");
        this.jCheckBoxMenuSEDdebug.setMnemonic('W');
        this.jCheckBoxMenuSEDdebug.setText("Write messages");
        this.jCheckBoxMenuSEDdebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jCheckBoxMenuSEDdebugActionPerformed(evt);
            }
        });
        this.jMenuDebug.add(this.jCheckBoxMenuSEDdebug);
        this.jMenuSave.setMnemonic('v');
        this.jMenuSave.setText("save messages to file");
        this.jMenuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jMenuSaveActionPerformed(evt);
            }
        });
        this.jMenuDebug.add(this.jMenuSave);
        this.jMenuHF_dbg.setMnemonic('H');
        this.jMenuHF_dbg.setText("debugging in HaltaFall...");
        this.jMenuHF_dbg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jMenuHF_dbgActionPerformed(evt);
            }
        });
        this.jMenuDebug.add(this.jMenuHF_dbg);
        this.jMenuCancel.setMnemonic('S');
        this.jMenuCancel.setText("STOP the Calculations");
        this.jMenuCancel.setEnabled(false);
        this.jMenuCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jMenuCancelActionPerformed(evt);
            }
        });
        this.jMenuDebug.add(this.jMenuCancel);
        this.jMenuBar.add(this.jMenuDebug);
        this.jMenuHelp.setMnemonic('H');
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setMnemonic('a');
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SED.this.jMenuHelpAboutActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelStatusBar, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jTabbedPane, -1, 396, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelStatusBar, -2, 18, -2)));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.end_program();
    }

    private void jMenuHelpAboutActionPerformed(ActionEvent evt) {
        this.jMenuHelpAbout.setEnabled(false);
        Thread hlp = new Thread(){

            @Override
            public void run() {
                SED.this.helpAboutFrame = new HelpAboutF(SED.VERS, pathApp, SED.this.err);
                SED.this.helpAboutFrame.setVisible(true);
                SED.this.helpAboutFrame.waitFor();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SED.this.helpAboutFrame = null;
                        SED.this.jMenuHelpAbout.setEnabled(true);
                    }
                });
            }
        };
        hlp.start();
    }

    private void jMenuFileXitActionPerformed(ActionEvent evt) {
        this.end_program();
    }

    private void jMenuFileOpenActionPerformed(ActionEvent evt) {
        this.eraseTextArea = true;
        this.getTheInputFileName();
        this.jTabbedPane.requestFocusInWindow();
    }

    private void jMenuFileMakeDActionPerformed(ActionEvent evt) {
        this.jButtonDoIt.doClick();
    }

    private void jCheckActCoeffActionPerformed(ActionEvent evt) {
        if (this.jCheckActCoeff.isSelected()) {
            this.calcActCoeffs = true;
            this.showActivityCoefficientControls(true);
            this.ionicStrength = this.readIonStrength();
            this.showTemperature();
        } else {
            this.calcActCoeffs = false;
            this.showActivityCoefficientControls(false);
            this.showTemperature();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        int width = Math.round((float)this.originalSize.getWidth());
        int height = Math.round((float)this.originalSize.getHeight());
        if (this.getHeight() < height) {
            this.setSize(this.getWidth(), height);
        }
        if (this.getWidth() < width) {
            this.setSize(width, this.getHeight());
        }
        if (this.jTabbedPane.getWidth() > this.getWidth()) {
            this.jTabbedPane.setSize(this.getWidth(), this.jTabbedPane.getWidth());
        }
    }

    private void jTextAreaAKeyTyped(KeyEvent evt) {
        evt.consume();
    }

    private void jTextAreaAKeyPressed(KeyEvent evt) {
        if (!Util.isKeyPressedOK(evt)) {
            evt.consume();
        }
    }

    private void jScrollBarNbrPointsAdjustmentValueChanged(AdjustmentEvent evt) {
        this.jLabelPointsNbr.setText(String.valueOf(this.jScrollBarNbrPoints.getValue()).trim());
    }

    private void jScrollBarNbrPointsFocusGained(FocusEvent evt) {
        this.jScrollBarNbrPoints.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
    }

    private void jScrollBarNbrPointsFocusLost(FocusEvent evt) {
        this.jScrollBarNbrPoints.setBorder(null);
    }

    private void jScrollBarHeightAdjustmentValueChanged(AdjustmentEvent evt) {
        this.jLabelHD.setText(String.valueOf((float)this.jScrollBarHeight.getValue() / 10.0f).trim());
    }

    private void jScrollBarHeightFocusGained(FocusEvent evt) {
        this.jScrollBarHeight.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
    }

    private void jScrollBarHeightFocusLost(FocusEvent evt) {
        this.jScrollBarHeight.setBorder(null);
    }

    private void jTextFieldIonicStgrKeyTyped(KeyEvent evt) {
        char key = evt.getKeyChar();
        if (!this.isCharOKforNumberInput(key)) {
            evt.consume();
        }
    }

    private void jTextFieldIonicStgrFocusLost(FocusEvent evt) {
        this.validateIonicStrength();
    }

    private void jTextFieldIonicStgrKeyPressed(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.validateIonicStrength();
        }
    }

    private void jTextFieldTKeyPressed(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.validateTemperature();
        }
    }

    private void jTextFieldTFocusLost(FocusEvent evt) {
        this.validateTemperature();
    }

    private void jTextFieldTKeyTyped(KeyEvent evt) {
        char key = evt.getKeyChar();
        if (!this.isCharOKforNumberInput(key)) {
            evt.consume();
        }
    }

    private void jTextFieldDataFileKeyTyped(KeyEvent evt) {
        char c = Character.toUpperCase(evt.getKeyChar());
        if (evt.getKeyChar() != '\u001b' && (!evt.isAltDown() || c != 'F' && c != 'I' && c != 'X' && c != 'H' && c != 'A' && c != 'N' && c != 'D' && c != 'R' && c != 'O' && c != 'T' && c != 'A' && c != 'S')) {
            evt.consume();
            this.getTheInputFileName();
        }
    }

    private void jTextFieldDataFileKeyPressed(KeyEvent evt) {
        if (!Util.isKeyPressedOK(evt)) {
            evt.consume();
        }
    }

    private void jCheckReverseActionPerformed(ActionEvent evt) {
        this.reversedConcs = this.jCheckReverse.isSelected();
    }

    private void jCheckTableActionPerformed(ActionEvent evt) {
        this.tableOutput = this.jCheckTable.isSelected();
    }

    private void jButtonDoItActionPerformed(ActionEvent evt) {
        if (this.outputPltFile == null) {
            String dir = this.pathDef.toString();
            if (dir.endsWith(SLASH)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            this.outputPltFile = new File(dir + SLASH + this.jTextFieldPltFile.getText());
        }
        this.doCalculations();
    }

    private void jTextFieldDataFileMouseClicked(MouseEvent evt) {
        this.eraseTextArea = true;
        this.getTheInputFileName();
    }

    private void jTextFieldTActionPerformed(ActionEvent evt) {
        this.validateTemperature();
    }

    private void jLabelTMouseClicked(MouseEvent evt) {
        if (this.jTextFieldT.isEnabled()) {
            this.jTextFieldT.setText(String.valueOf(25.0));
        }
    }

    private void jTextFieldIonicStgrActionPerformed(ActionEvent evt) {
        this.validateIonicStrength();
    }

    private void jTextFieldIonicStgrFocusGained(FocusEvent evt) {
        this.jTextFieldIonicStgr.selectAll();
    }

    private void jTextFieldTFocusGained(FocusEvent evt) {
        this.jTextFieldT.selectAll();
    }

    private void jCheckBoxMenuSEDdebugActionPerformed(ActionEvent evt) {
        this.dbg = this.jCheckBoxMenuSEDdebug.isSelected();
    }

    private void jComboBoxTolActionPerformed(ActionEvent evt) {
        int i = this.jComboBoxTol.getSelectedIndex();
        this.tolHalta = 0.01 / Math.pow(10.0, i);
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        if (this.helpAboutFrame != null) {
            this.helpAboutFrame.bringToFront();
        }
    }

    private void jLabelPointsNbrMouseClicked(MouseEvent evt) {
        this.jScrollBarNbrPoints.setValue(50);
    }

    private void jLabelHDMouseClicked(MouseEvent evt) {
        this.jScrollBarHeight.setValue(10);
    }

    private void jMenuHF_dbgActionPerformed(ActionEvent evt) {
        Debugging debugging = new Debugging((Frame)this, true, this, this.err);
        debugging.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuSaveActionPerformed(ActionEvent evt) {
        this.jTextFieldDataFile.setCursor(new Cursor(3));
        this.setCursorWait();
        if (this.pathDef == null) {
            this.setPathDef();
        }
        String txtfn = Util.getSaveFileName(this, progName, "Choose an output file name:", 7, "messages.txt", this.pathDef.toString());
        this.jTextFieldDataFile.setCursor(new Cursor(0));
        this.setCursorDef();
        if (txtfn == null || txtfn.trim().equals("")) {
            return;
        }
        File outputTxtFile = new File(txtfn);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputTxtFile.toString())));
            pw.print(this.jTextAreaA.getText());
            pw.flush();
            JOptionPane.showMessageDialog(this, "File:" + nl + "    " + outputTxtFile.toString() + nl + "has been written.", progName, 1);
        }
        catch (HeadlessException ex) {
            this.showErrMsgBx(ex.toString(), 1);
        }
        catch (IOException ex) {
            this.showErrMsgBx(ex.toString(), 1);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        this.jTabbedPane.setSelectedComponent(this.jScrollPaneMessg);
        this.jTabbedPane.requestFocusInWindow();
    }

    private void jMenuCancelActionPerformed(ActionEvent evt) {
        this.quitConfirm(this);
    }

    private boolean checkInput() {
        int js;
        int j;
        int i;
        if (this.cs == null) {
            this.err.println("? Programming error in \"SED.checkInput\": cs=null.");
            return false;
        }
        if (this.dbg) {
            this.out.println("--- checkInput()");
        }
        int mg = this.cs.Ms - this.cs.mSol;
        for (i = 0; i < this.cs.Na; ++i) {
            this.namn.iel[i] = i;
        }
        for (i = 0; i < this.cs.Na; ++i) {
            if (!this.namn.identC[i].startsWith("*")) continue;
            this.namn.identC[i] = this.namn.identC[i].substring(1);
            this.namn.ident[i] = this.namn.identC[i];
            this.cs.noll[i] = true;
        }
        i = this.cs.Na;
        while (i < this.cs.Ms) {
            if (this.namn.ident[i].startsWith("*")) {
                if (i < mg) {
                    --mg;
                } else {
                    --this.cs.mSol;
                }
                --this.cs.Ms;
                if (i >= this.cs.Ms) break;
                for (j = i; j < this.cs.Ms; ++j) {
                    js = j - this.cs.Na;
                    this.cs.lBeta[js] = this.cs.lBeta[js + 1];
                    System.arraycopy(this.cs.a[js + 1], 0, this.cs.a[js], 0, this.cs.Na);
                    this.namn.ident[j] = this.namn.ident[j + 1];
                    this.cs.noll[j] = this.cs.noll[j + 1];
                }
                continue;
            }
            ++i;
        }
        this.diag.aquSystem = false;
        for (i = 0; i < this.cs.Ms; ++i) {
            this.namn.nameLength[i] = SED.getNameLength(this.namn.ident[i]);
            if (Util.isElectron(this.namn.ident[i]) || Util.isWater(this.namn.ident[i])) {
                this.cs.noll[i] = true;
                this.diag.aquSystem = true;
            }
            if (i >= mg) continue;
            this.namn.z[i] = 0;
            this.csC.logf[i] = 0.0;
            if (this.namn.ident[i].length() > 4 && this.namn.ident[i].toUpperCase().endsWith("(AQ)")) {
                this.diag.aquSystem = true;
                continue;
            }
            this.namn.z[i] = Util.chargeOf(this.namn.ident[i]);
            if (this.namn.z[i] == 0) continue;
            this.diag.aquSystem = true;
        }
        this.namn.z[mg] = 1;
        this.namn.z[mg + 1] = -1;
        if (this.diag.aquSystem) {
            for (i = 0; i < mg; ++i) {
                if (!Util.isGas(this.namn.ident[i]) && !Util.isLiquid(this.namn.ident[i]) && !Util.isWater(this.namn.ident[i])) continue;
                this.cs.noll[i] = true;
            }
        }
        if (this.diag.aquSystem) {
            for (i = this.cs.Na; i < this.cs.Ms; ++i) {
                if (!Util.isWater(this.namn.ident[i])) continue;
                if (i < mg) {
                    --mg;
                } else {
                    --this.cs.mSol;
                }
                --this.cs.Ms;
                if (i >= this.cs.Ms) break;
                for (j = i; j < this.cs.Ms; ++j) {
                    js = j - this.cs.Na;
                    this.cs.lBeta[js] = this.cs.lBeta[js + 1];
                    System.arraycopy(this.cs.a[js + 1], 0, this.cs.a[js], 0, this.cs.Na);
                    this.namn.ident[j] = this.namn.ident[j + 1];
                    this.cs.noll[j] = this.cs.noll[j + 1];
                }
            }
        }
        if (this.dbg) {
            ReadChemSyst.printChemSystem(this.out, this.cs);
        }
        if (this.calcActCoeffs) {
            boolean ok = true;
            for (i = this.cs.Na; i < mg; ++i) {
                int ix = i - this.cs.Na;
                double zSum = -this.namn.z[i];
                for (j = 0; j < this.cs.Na; ++j) {
                    zSum += this.cs.a[ix][j] * (double)this.namn.z[j];
                }
                if (!(Math.abs(zSum) > 5.0E-4)) continue;
                ok = false;
                this.err.format(engl, "--- Warning: %s, z=%3d, charge imbalance:%9.4f", this.namn.ident[i], this.namn.z[i], zSum);
            }
            if (!ok && !this.doNotStop) {
                this.showErrMsgBx("There are charge imbalanced reactions in the input file.", 1);
            }
        }
        boolean foundOne = false;
        for (i = 0; i < mg; ++i) {
            if (this.cs.noll[i]) continue;
            foundOne = true;
            break;
        }
        if (!foundOne) {
            String t = "Error: There are no fluid species active ";
            if (this.cs.mSol > 0) {
                t = t.concat("(Only solids)");
            }
            t = t + nl + "This program can not handle such chemical systems.";
            this.showErrMsgBx(t, 1);
            return false;
        }
        this.diag.pInX = 0;
        this.diag.pInY = 0;
        if (Util.isElectron(this.namn.identC[this.diag.compX])) {
            this.diag.pInX = this.diag.Eh ? 3 : 2;
        } else if (Util.isProton(this.namn.identC[this.diag.compX])) {
            this.diag.pInX = 1;
        }
        for (int ia = 0; ia < this.cs.Na; ++ia) {
            double w;
            if (this.dgrC.hur[ia] == 1 && ia == this.diag.compX) {
                this.showErrMsgBx("Error: the concentration for component \"" + this.namn.identC[ia] + "\" " + "must vary, as it belongs to the X-axis!", 1);
                return false;
            }
            if (this.dgrC.hur[ia] > 0 && this.dgrC.hur[ia] <= 3 && Util.isWater(this.namn.identC[ia])) {
                this.showErrMsgBx("Error: The calculations are made for 1kg H2O" + nl + "Give log(H2O-activity) instead of a total conc. for water.", 1);
                return false;
            }
            if ((this.dgrC.hur[ia] == 2 || this.dgrC.hur[ia] == 3 || this.dgrC.hur[ia] == 5) && ia != this.diag.compX) {
                String t = this.dgrC.hur[ia] == 5 ? "log(activity)" : "total conc.";
                String msg = "Warning: The " + t + " is varied for \"" + this.namn.identC[ia] + "\"" + nl + "   but the component in the X-axis is " + this.namn.identC[this.diag.compX];
                this.showErrMsgBx(msg, 2);
            }
            if ((this.dgrC.hur[ia] == 1 || this.dgrC.hur[ia] == 4) && ia == this.diag.compX) {
                String t = this.dgrC.hur[ia] == 4 ? "log(activity)" : "total conc.";
                this.showErrMsgBx("Error: The " + t + " of \"" + this.namn.identC[ia] + "\"" + nl + "can NOT be a fixed value because this component belongs to the X-axis !", 1);
                return false;
            }
            if (this.dgrC.hur[ia] == 1 && Math.abs(this.dgrC.cLow[ia]) > 100.0) {
                String t = String.format(engl, "Error:  For component: " + this.namn.identC[ia] + nl + "   Tot.Conc.=%12.4g mol/kg.  This is not a reasonable value!", this.dgrC.cLow[ia]);
                this.showErrMsgBx(t, 1);
                return false;
            }
            if (this.dgrC.hur[ia] == 4 && Util.isProton(this.namn.identC[ia]) && (this.dgrC.cLow[ia] < -14.0 || this.dgrC.cLow[ia] > 2.0)) {
                String msg = String.format(engl, "Warning: In the input, you give  pH =%8.2f%nThis value could be due to an input error.", -this.dgrC.cLow[ia]);
                this.showErrMsgBx(msg, 2);
            }
            if (this.dgrC.hur[ia] == 1 || this.dgrC.hur[ia] == 4) continue;
            if (this.dgrC.cLow[ia] == this.dgrC.cHigh[ia] || Math.max(Math.abs(this.dgrC.cLow[ia]), Math.abs(this.dgrC.cHigh[ia])) < 1.0E-15) {
                this.showErrMsgBx("Error:  Min-value = Max-value for component \"" + this.namn.identC[ia] + "\"", 1);
                return false;
            }
            if (this.dgrC.cLow[ia] > this.dgrC.cHigh[ia] && !this.reversedConcs) {
                w = this.dgrC.cLow[ia];
                this.dgrC.cLow[ia] = this.dgrC.cHigh[ia];
                this.dgrC.cHigh[ia] = w;
            }
            if (!this.reversedConcs && this.dgrC.hur[ia] == 5 && (Util.isProton(this.namn.identC[ia]) || Util.isElectron(this.namn.identC[ia]))) {
                w = this.dgrC.cLow[ia];
                this.dgrC.cLow[ia] = this.dgrC.cHigh[ia];
                this.dgrC.cHigh[ia] = w;
            }
            if (this.dgrC.hur[ia] == 5 && Util.isProton(this.namn.identC[ia]) && (this.dgrC.cLow[ia] < -14.00001 || this.dgrC.cLow[ia] > 2.00001 || this.dgrC.cHigh[ia] < -14.00001 || this.dgrC.cHigh[ia] > 2.00001)) {
                String msg = String.format(engl, "Warning: In the input, you give  pH =%8.2f to %7.2f%nThese values could be due to an input error.", -this.dgrC.cLow[ia], -this.dgrC.cHigh[ia]);
                this.showErrMsgBx(msg, 2);
            }
            if (this.dgrC.hur[ia] == 2 && Math.max(Math.abs(this.dgrC.cHigh[ia]), Math.abs(this.dgrC.cLow[ia])) > 100.0) {
                this.showErrMsgBx("Error:  You give  ABS(TOT.CONC.) > 100  for component: " + this.namn.identC[ia] + nl + "This value is too high and perhaps an input error." + nl + "Set the maximum ABS(TOT.CONC.) value to 100.", 1);
                return false;
            }
            if (this.dgrC.hur[ia] != 3) continue;
            if (Math.min(this.dgrC.cLow[ia], this.dgrC.cHigh[ia]) < -7.0001 && Util.isProton(this.namn.identC[ia])) {
                String msg = "Warning: You give a  LOG (TOT.CONC.) < -7  for component: " + this.namn.identC[ia] + nl + "This value is rather low and could be due to an input error." + nl + "Maybe you meant to set  LOG (ACTIVITY) < -7 ??";
                this.showErrMsgBx(msg, 2);
            }
            if (!(Math.max(this.dgrC.cLow[ia], this.dgrC.cHigh[ia]) > 2.0001)) continue;
            this.showErrMsgBx("Error: You give a  LOG (TOT.CONC.) > 2  for component: " + this.namn.identC[ia] + nl + "This value is too high and it could be due to an input error." + nl + "Set the maximum LOG (TOT.CONC.) value to 2.", 1);
            return false;
        }
        this.pos = new boolean[this.cs.Na];
        this.neg = new boolean[this.cs.Na];
        for (i = 0; i < this.cs.Na; ++i) {
            this.pos[i] = false;
            this.neg[i] = false;
            if (!this.cs.noll[i]) {
                this.pos[i] = true;
            }
            for (j = this.cs.Na; j < this.cs.Ms; ++j) {
                if (this.cs.noll[j]) continue;
                if (this.cs.a[j - this.cs.Na][i] > 0.0) {
                    this.pos[i] = true;
                }
                if (!(this.cs.a[j - this.cs.Na][i] < 0.0)) continue;
                this.neg[i] = true;
            }
        }
        for (i = 0; i < this.cs.Na; ++i) {
            if (this.csC.kh[i] == 2) continue;
            if (!this.pos[i] && !this.neg[i]) {
                String msg = "Error: for component \"" + this.namn.identC[i] + "\" give Log(Activity)";
                if (this.dgrC.hur[i] != 1) {
                    msg = msg + " to vary";
                }
                this.showErrMsgBx(msg, 1);
                return false;
            }
            if (this.pos[i] && this.neg[i] || this.pos[i] && (this.dgrC.hur[i] == 3 || this.dgrC.cLow[i] > 0.0 && (Double.isNaN(this.dgrC.cHigh[i]) || this.dgrC.cHigh[i] > 0.0)) || this.neg[i] && this.dgrC.hur[i] != 3 && this.dgrC.cLow[i] < 0.0 && (Double.isNaN(this.dgrC.cHigh[i]) || this.dgrC.cHigh[i] < 0.0) || !this.pos[i] && !this.neg[i]) continue;
            String msg = "Error: Component \"%s\" may not have %s Tot.Conc. values.%sGive either  Tot.Conc. %s=0.0  or  Log(Activity)%s";
            if (this.neg[i] && (this.dgrC.hur[i] == 3 || this.dgrC.cLow[i] > 0.0 || !Double.isNaN(this.dgrC.cHigh[i]) && this.dgrC.cHigh[i] > 0.0)) {
                this.showErrMsgBx(String.format(msg, this.namn.identC[i], "positive", nl, "<", nl), 1);
                return false;
            }
            if (!this.pos[i] || this.dgrC.hur[i] == 3 || !(this.dgrC.cLow[i] < 0.0) && (Double.isNaN(this.dgrC.cHigh[i]) || !(this.dgrC.cHigh[i] < 0.0))) continue;
            this.showErrMsgBx(String.format(msg, this.namn.identC[i], "negative", nl, ">", nl), 1);
            return false;
        }
        this.cs.nx = mg - this.cs.Na;
        return true;
    }

    private static int getNameLength(String species) {
        int nameL = Math.max(1, Util.rTrim(species).length());
        if (nameL < 3) {
            return nameL;
        }
        int sign = -1;
        for (int ik = nameL - 1; ik >= 2; --ik) {
            char c = species.charAt(ik);
            if (c != '+' && c != '-' && c != '\u2013' && c != '\u2212') continue;
            sign = ik;
            break;
        }
        if (sign < 2) {
            return nameL;
        }
        if (sign < nameL - 1 && Character.isLetterOrDigit(species.charAt(sign + 1))) {
            return nameL;
        }
        if (species.charAt(sign - 1) == ' ') {
            return --nameL;
        }
        if (nameL >= 4 && species.charAt(sign - 1) >= '2' && species.charAt(sign - 1) <= '9' && species.charAt(sign - 2) == ' ') {
            return --nameL;
        }
        if (nameL >= 5 && species.charAt(sign - 1) >= '0' && species.charAt(sign - 1) <= '9' && species.charAt(sign - 2) >= '1' && species.charAt(sign - 2) <= '9' && species.charAt(sign - 3) == ' ') {
            --nameL;
        }
        return nameL;
    }

    /*
     * Unable to fully structure code
     */
    private boolean dispatchArg(String arg) {
        block89: {
            block84: {
                block91: {
                    block86: {
                        block90: {
                            block88: {
                                block87: {
                                    block85: {
                                        if (arg == null) {
                                            return true;
                                        }
                                        this.out.println("Command-line argument = \"" + arg + "\"");
                                        if (arg.equals("-?") || arg.equals("/?") || arg.equals("?")) {
                                            this.out.println("Usage:   SED  [data-file-name]  [-command=value]");
                                            SED.printInstructions(this.out);
                                            if (this.isVisible()) {
                                                this.jTabbedPane.setSelectedComponent(this.jScrollPaneMessg);
                                            }
                                            return true;
                                        }
                                        msg = null;
                                        if (arg.length() <= 3) break block84;
                                        arg0 = arg.substring(0, 2).toLowerCase();
                                        if (!arg0.startsWith("-d") && !arg0.startsWith("/d")) break block85;
                                        if (arg.charAt(2) == '=' || arg.charAt(2) == ':') {
                                            f = arg.substring(3);
                                            if (f.startsWith("\"") && f.endsWith("\"")) {
                                                f = f.substring(1, f.length() - 1);
                                            }
                                            if (!f.toLowerCase().endsWith(".dat")) {
                                                f = f.concat(".dat");
                                            }
                                            this.inputDataFile = new File(f);
                                            this.setPathDef(this.inputDataFile);
                                            try {
                                                fil = this.inputDataFile.getCanonicalPath();
                                            }
                                            catch (IOException e) {
                                                try {
                                                    fil = this.inputDataFile.getAbsolutePath();
                                                }
                                                catch (Exception e1) {
                                                    fil = this.inputDataFile.getPath();
                                                }
                                            }
                                            this.inputDataFile = new File(fil);
                                            if (this.dbg) {
                                                this.out.println("Data file: " + this.inputDataFile.getPath());
                                            }
                                            if (!this.doNotExit) {
                                                this.consoleOutput = true;
                                            }
                                            if (!this.readDataFile(this.inputDataFile)) {
                                                if (this.isVisible()) {
                                                    this.jTabbedPane.setSelectedComponent(this.jScrollPaneMessg);
                                                }
                                                this.inputDataFileInCommandLine = false;
                                                return false;
                                            }
                                            this.showTheInputFileName(this.inputDataFile);
                                            this.inputDataFileInCommandLine = true;
                                            return true;
                                        }
                                        break block86;
                                    }
                                    if (!arg0.startsWith("-p") && !arg0.startsWith("/p")) break block87;
                                    if (arg.charAt(2) == '=' || arg.charAt(2) == ':') {
                                        f = arg.substring(3);
                                        if (f.startsWith("\"") && f.endsWith("\"")) {
                                            f = f.substring(1, f.length() - 1);
                                        }
                                        if (!f.toLowerCase().endsWith(".plt")) {
                                            f = f.concat(".plt");
                                        }
                                        this.outputPltFile = new File(f);
                                        if (this.dbg) {
                                            this.out.println("Plot file: " + this.outputPltFile.getPath());
                                        }
                                        this.jTextFieldPltFile.setText(this.outputPltFile.getName());
                                        return true;
                                    }
                                    break block86;
                                }
                                if (!arg0.startsWith("-i") && !arg0.startsWith("/i")) break block88;
                                if (arg.charAt(2) != '=' && arg.charAt(2) != ':') break block86;
                                t = arg.substring(3);
                                try {
                                    this.ionicStrength = Double.parseDouble(t);
                                    this.ionicStrength = Math.max(-1.0, Math.min(1000.0, this.ionicStrength));
                                    if (this.ionicStrength < 0.0) {
                                        this.ionicStrength = -1.0;
                                    }
                                    this.jTextFieldIonicStgr.setText(String.valueOf(this.ionicStrength));
                                    if (Math.abs(this.ionicStrength) > 1.0E-10) {
                                        this.calcActCoeffs = true;
                                    }
                                    if (this.dbg) {
                                        this.out.println("Ionic strength = " + this.ionicStrength);
                                    }
                                    return true;
                                }
                                catch (NumberFormatException nfe) {
                                    msg = "Wrong numeric format for ionic strength in text \"" + t + "\"";
                                    this.ionicStrength = 0.0;
                                    this.jTextFieldIonicStgr.setText(String.valueOf(this.ionicStrength));
                                }
                                break block89;
                            }
                            if (!arg0.startsWith("-t") && !arg0.startsWith("/t")) break block90;
                            if (arg.charAt(2) != '=' && arg.charAt(2) != ':') break block86;
                            t = arg.substring(3);
                            try {
                                this.temperature_InCommandLine = Double.parseDouble(t);
                                this.temperature_InCommandLine = Math.min(1000.0, Math.max(this.temperature_InCommandLine, -10.0));
                                this.jTextFieldT.setText(String.valueOf(this.temperature_InCommandLine));
                                if (this.dbg) {
                                    this.out.println("Temperature = " + this.temperature_InCommandLine);
                                }
                                return true;
                            }
                            catch (NumberFormatException nfe) {
                                msg = "Error: Wrong numeric format for temperature in text \"" + t + "\"";
                                this.temperature_InCommandLine = NaN;
                                this.jTextFieldT.setText(String.valueOf(25.0));
                            }
                            break block89;
                        }
                        if ((arg0.startsWith("-h") || arg0.startsWith("/h")) && (arg.charAt(2) == '=' || arg.charAt(2) == ':')) {
                            t = arg.substring(3);
                            try {
                                this.tHeight = Double.parseDouble(t);
                                this.tHeight = Math.min(10.0, Math.max(this.tHeight, 0.3));
                                this.jScrollBarHeight.setValue(Math.round((float)(10.0 * this.tHeight)));
                                if (this.dbg) {
                                    this.out.println("Height factor for texts in diagrams = " + this.tHeight);
                                }
                                return true;
                            }
                            catch (NumberFormatException nfe) {
                                msg = "Wrong numeric format for text height in \"" + t + "\"";
                                this.tHeight = 1.0;
                                this.jScrollBarHeight.setValue(Math.round((float)(10.0 * this.tHeight)));
                            }
                        }
                        break block86;
                        break block89;
                    }
                    if (!arg0.startsWith("-m") && !arg0.startsWith("/m")) break block91;
                    if (arg.charAt(2) != '=' && arg.charAt(2) != ':') break block84;
                    t = arg.substring(3);
                    try {
                        this.actCoeffsModel_InCommandLine = Integer.parseInt(t);
                        this.actCoeffsModel_InCommandLine = Math.min(this.jComboBoxModel.getItemCount() - 1, Math.max(0, this.actCoeffsModel_InCommandLine));
                        this.jComboBoxModel.setSelectedIndex(this.actCoeffsModel_InCommandLine);
                        if (this.dbg) {
                            this.out.println("Activity coeffs. method = " + this.actCoeffsModel_InCommandLine);
                        }
                        return true;
                    }
                    catch (NumberFormatException nfe) {
                        msg = "Wrong numeric format for activity coeff. model in \"" + t + "\"";
                        this.actCoeffsModel_InCommandLine = 2;
                        this.jComboBoxModel.setSelectedIndex(2);
                    }
                    break block89;
                }
                if ((arg0.startsWith("-n") || arg0.startsWith("/n")) && (arg.charAt(2) == '=' || arg.charAt(2) == ':')) {
                    t = arg.substring(3);
                    try {
                        this.nSteps = Integer.parseInt(t);
                        this.nSteps = Math.min(300, this.nSteps);
                        if (!this.dbg) {
                            this.nSteps = Math.max(this.nSteps, 4);
                        }
                        this.jScrollBarNbrPoints.setValue(this.nSteps);
                        if (this.dbg) {
                            this.out.println("Nbr calc. steps in diagram = " + this.nSteps + " (nbr. points = " + (this.nSteps + 1) + ")");
                        }
                        return true;
                    }
                    catch (NumberFormatException nfe) {
                        msg = "Wrong numeric format for number of calculation steps in \"" + t + "\"";
                        this.nSteps = 50;
                        this.jScrollBarNbrPoints.setValue(this.nSteps);
                    }
                }
            }
            if (arg.length() <= 5) ** GOTO lbl-1000
            arg0 = arg.substring(0, 5).toLowerCase();
            if ((arg0.startsWith("-tol") || arg0.startsWith("/tol")) && (arg.charAt(4) == '=' || arg.charAt(4) == ':')) {
                t = arg.substring(5);
                try {
                    w = Double.parseDouble(t);
                    this.tolHalta = Math.min(0.01, Math.max(w, 1.0E-8));
                    this.set_tol_inComboBox();
                    if (this.dbg) {
                        this.out.println("Max tolerance in HaltaFall = " + this.tolHalta);
                    }
                    return true;
                }
                catch (NumberFormatException nfe) {
                    msg = "Wrong numeric format for tolerance in \"" + t + "\"";
                    this.tolHalta = 1.0E-4;
                    this.set_tol_inComboBox();
                }
            } else if ((arg0.startsWith("-thr") || arg0.startsWith("/thr")) && (arg.charAt(4) == '=' || arg.charAt(4) == ':')) {
                t = arg.substring(5);
                try {
                    this.threshold = Float.parseFloat(t);
                    this.threshold = Math.min(0.1f, Math.max(this.threshold, 0.001f));
                    if (this.dbg) {
                        this.out.println("Threshold for fraction diagrams = " + this.threshold);
                    }
                    return true;
                }
                catch (NumberFormatException nfe) {
                    msg = "Wrong numeric format for fraction threshold in \"" + t + "\"";
                    this.threshold = 0.03f;
                }
            } else lbl-1000:
            // 2 sources

            {
                if (arg.length() >= 6) {
                    arg0 = arg.substring(0, 5).toLowerCase();
                    if (arg0.startsWith("-tble") || arg0.startsWith("/tble")) {
                        if (arg.charAt(5) == '=' || arg.charAt(5) == ':') {
                            t = arg.substring(6);
                            if (t.length() <= 0) {
                                t = "";
                            }
                            this.tblExtension = t;
                            this.tableOutput = true;
                            if (this.dbg) {
                                this.out.println("Table output: file name extension = \"" + t + "\"");
                            }
                            return true;
                        }
                    } else if ((arg0.startsWith("-tbls") || arg0.startsWith("/tbls")) && (arg.charAt(5) == '=' || arg.charAt(5) == ':')) {
                        t = arg.substring(6);
                        if (t.length() <= 0) {
                            t = " ";
                        }
                        this.tblFieldSeparator = t;
                        if (this.tblFieldSeparator.equalsIgnoreCase("\\t")) {
                            this.tblFieldSeparator = "\t";
                        }
                        this.tableOutput = true;
                        if (this.dbg) {
                            this.out.println("Table output: field separator = \"" + t + "\"");
                        }
                        return true;
                    }
                }
                if (arg.length() >= 7) {
                    arg0 = arg.substring(0, 6).toLowerCase();
                    if (arg0.startsWith("-tblcs") || arg0.startsWith("/tblcs")) {
                        if (arg.charAt(6) == '=' || arg.charAt(6) == ':') {
                            t = arg.substring(7);
                            if (t.length() <= 0) {
                                t = "";
                            }
                            this.tblCommentStart = t;
                            this.tableOutput = true;
                            if (this.dbg) {
                                this.out.println("Table output: comment-line start = \"" + t + "\"");
                            }
                            return true;
                        }
                    } else if ((arg0.startsWith("-tblce") || arg0.startsWith("/tblce")) && (arg.charAt(6) == '=' || arg.charAt(6) == ':')) {
                        t = arg.substring(7);
                        if (t.length() <= 0) {
                            t = "";
                        }
                        this.tblCommentEnd = t;
                        this.tableOutput = true;
                        if (this.dbg) {
                            this.out.println("Table output: comment-line end = \"" + t + "\"");
                        }
                        return true;
                    }
                }
                if (arg.length() > 6 && ((arg0 = arg.substring(0, 5).toLowerCase()).startsWith("-dbgh") || arg0.startsWith("/dbgh")) && (arg.charAt(5) == '=' || arg.charAt(5) == ':')) {
                    t = arg.substring(6);
                    try {
                        this.dbgHalta = Integer.parseInt(t);
                        this.dbgHalta = Math.min(6, Math.max(this.dbgHalta, 0));
                        if (this.dbg) {
                            this.out.println("Debug printout level in HaltaFall = " + this.dbgHalta);
                        }
                        return true;
                    }
                    catch (NumberFormatException nfe) {
                        msg = "Wrong numeric format for HaltaFall debug level \"" + t + "\"";
                        this.dbgHalta = 1;
                    }
                } else {
                    if (arg.equalsIgnoreCase("-tbl") || arg.equalsIgnoreCase("/tbl")) {
                        this.tableOutput = true;
                        if (this.dbg) {
                            this.out.println("Table output = true");
                        }
                        return true;
                    }
                    if (arg.equalsIgnoreCase("-dbg") || arg.equalsIgnoreCase("/dbg")) {
                        this.dbg = true;
                        this.jCheckBoxMenuSEDdebug.setSelected(this.dbg);
                        this.out.println("Debug printout = true");
                        return true;
                    }
                    if (arg.equalsIgnoreCase("-rev") || arg.equalsIgnoreCase("/rev")) {
                        this.reversedConcs = true;
                        if (this.dbg) {
                            this.out.println("Allow reversed ranges in axes");
                        }
                        return true;
                    }
                    if (arg.equalsIgnoreCase("-keep") || arg.equalsIgnoreCase("/keep")) {
                        this.out = this.outPrintStream;
                        this.err = this.errPrintStream;
                        this.doNotExit = true;
                        if (this.dbg) {
                            this.out.println("Do not close window after calculations");
                        }
                        return true;
                    }
                    if (arg.equalsIgnoreCase("-nostop") || arg.equalsIgnoreCase("/nostop")) {
                        this.doNotStop = true;
                        if (this.dbg) {
                            this.out.println("Do not show message boxes");
                        }
                        return true;
                    }
                }
            }
        }
        msg = msg == null ? "Error: can not understand command-line argument:" + SED.nl + "  \"" + arg + "\"" + SED.nl + "For a list of possible commands type:  SED  -?" : "Command-line argument \"" + arg + "\":" + SED.nl + msg;
        this.out.flush();
        this.err.println(msg);
        this.err.flush();
        SED.printInstructions(this.out);
        if (!this.doNotStop) {
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            JOptionPane.showMessageDialog(this, msg, "SED", 0);
        }
        if (this.isVisible()) {
            this.jTabbedPane.setSelectedComponent(this.jScrollPaneMessg);
        }
        return false;
    }

    private void showActivityCoefficientControls(boolean show) {
        if (show) {
            this.jTextFieldIonicStgr.setEnabled(true);
            this.jLabelIonicStr.setEnabled(true);
            this.jLabelIonicStr.setText("<html>ionic <u>S</u>trength</html>");
            this.jLabelIonicStrM.setEnabled(true);
            this.jLabelModel.setEnabled(true);
            this.jLabelModel.setText("<html>activity <u>C</u>officient model:<html>");
            this.jComboBoxModel.setEnabled(true);
        } else {
            this.jLabelIonicStr.setEnabled(false);
            this.jLabelIonicStr.setText("ionic Strength");
            this.jLabelIonicStrM.setEnabled(false);
            this.jTextFieldIonicStgr.setEnabled(false);
            this.jLabelModel.setText("activity cofficient model:");
            this.jLabelModel.setEnabled(false);
            this.jComboBoxModel.setEnabled(false);
        }
    }

    private void disableMenus() {
        this.jMenuFileOpen.setEnabled(false);
        this.jMenuFileMakeD.setEnabled(false);
        this.jMenuDebug.setEnabled(true);
        this.jCheckBoxMenuSEDdebug.setEnabled(false);
        this.jMenuSave.setEnabled(false);
        this.jMenuHF_dbg.setEnabled(false);
        this.jMenuCancel.setEnabled(true);
        this.jTabbedPane.setSelectedComponent(this.jScrollPaneMessg);
        this.jLabelData.setText("input data file:");
        this.jLabelData.setEnabled(false);
        this.jTextFieldDataFile.setEnabled(false);
        this.jLabelPltFile.setText("plot file name:");
        this.jLabelPltFile.setEnabled(false);
        this.jTextFieldPltFile.setEnabled(false);
        this.jLabelNbrPText.setText("Nbr of calc. steps:");
        this.jLabelNbrPText.setEnabled(false);
        this.jLabelPointsNbr.setEnabled(false);
        this.jScrollBarNbrPoints.setEnabled(false);
        this.jLabelHeight.setText("height of text in diagram:");
        this.jLabelHeight.setEnabled(false);
        this.jLabelHD.setEnabled(false);
        this.jScrollBarHeight.setEnabled(false);
        this.jCheckTable.setText("table Output");
        this.jCheckTable.setEnabled(false);
        this.jCheckActCoeff.setText("Activity coefficient calculations");
        this.jCheckActCoeff.setEnabled(false);
        this.showActivityCoefficientControls(false);
        this.showTemperature();
        this.jLabelTol.setEnabled(false);
        this.jComboBoxTol.setEnabled(false);
        this.jCheckReverse.setText("allow Reversed min. and max. axes limits");
        this.jCheckReverse.setEnabled(false);
        this.jButtonDoIt.setText("make the Diagram");
        this.jButtonDoIt.setEnabled(false);
    }

    private void restoreMenus() {
        this.jMenuFileOpen.setEnabled(true);
        this.jMenuFileMakeD.setEnabled(false);
        this.jMenuDebug.setEnabled(true);
        this.jCheckBoxMenuSEDdebug.setEnabled(true);
        this.jMenuSave.setEnabled(true);
        this.jMenuHF_dbg.setEnabled(true);
        this.jMenuCancel.setEnabled(false);
        this.jLabelData.setEnabled(true);
        this.jTextFieldDataFile.setEnabled(true);
        this.jLabelPltFile.setText("<html>p<u>l</u>ot file name:</html>");
        this.jLabelPltFile.setEnabled(true);
        this.jTextFieldPltFile.setEnabled(true);
        this.jLabelNbrPText.setText("<html><u>N</u>br of calc. steps:</html>");
        this.jLabelNbrPText.setEnabled(true);
        this.jLabelPointsNbr.setEnabled(true);
        this.jScrollBarNbrPoints.setEnabled(true);
        this.jLabelHeight.setText("<html>h<u>e</u>ight of text in diagram:</html>");
        this.jLabelHeight.setEnabled(true);
        this.jLabelHD.setEnabled(true);
        this.jScrollBarHeight.setEnabled(true);
        this.jCheckTable.setText("<html>table <u>O</u>utput</html>");
        this.jCheckTable.setEnabled(true);
        this.jCheckActCoeff.setText("<html><u>A</u>ctivity coefficient calculations</html>");
        this.jCheckActCoeff.setEnabled(true);
        this.showActivityCoefficientControls(this.jCheckActCoeff.isSelected());
        this.showTemperature();
        this.jLabelPltFile.setText("plot file name");
        this.jLabelPltFile.setEnabled(false);
        this.jTextFieldPltFile.setText(null);
        this.jTextFieldPltFile.setEnabled(false);
        this.jTextFieldDataFile.setText("");
        this.jLabelTol.setEnabled(true);
        this.jComboBoxTol.setEnabled(true);
        this.jButtonDoIt.setText("make the Diagram");
        this.jButtonDoIt.setEnabled(false);
        this.jCheckReverse.setText("<html>allow <u>R</u>eversed min. and max. axes limits</html>");
        this.jCheckReverse.setEnabled(true);
        this.jLabelStatus.setText("waiting...");
        this.jLabelProgress.setText(" ");
    }

    private void readDataFile_hadError() {
        if (this.isVisible()) {
            this.jTabbedPane.setTitleAt(2, "Diagram");
            this.jTabbedPane.setEnabledAt(2, false);
            this.restoreMenus();
            this.jTabbedPane.setSelectedComponent(this.jScrollPaneMessg);
        }
    }

    private void set_tol_inComboBox() {
        int listItem = 0;
        int listCount = this.jComboBoxTol.getItemCount();
        for (int i = 1; i < listCount; ++i) {
            double w0 = Double.parseDouble(this.jComboBoxTol.getItemAt(i - 1).toString());
            double w1 = Double.parseDouble(this.jComboBoxTol.getItemAt(i).toString());
            if (this.tolHalta >= w0 && i == 1) {
                listItem = 0;
                break;
            }
            if (this.tolHalta <= w1 && i == listCount - 1) {
                listItem = listCount - 1;
                break;
            }
            if (!(this.tolHalta < w0) || !(this.tolHalta >= w1)) continue;
            if (Math.abs(this.tolHalta - w0) < Math.abs(this.tolHalta - w1)) {
                listItem = i - 1;
                break;
            }
            listItem = i;
            break;
        }
        this.jComboBoxTol.setSelectedIndex(listItem);
    }

    private void end_program() {
        if (this.dbg) {
            this.out.println("--- end_program()");
        }
        if (!this.finishedCalculations && !this.quitConfirm(this)) {
            return;
        }
        this.programEnded = true;
        this.notify_All();
        this.dispose();
        if (this.helpAboutFrame != null) {
            this.helpAboutFrame.closeWindow();
            this.helpAboutFrame = null;
        }
    }

    private synchronized void notify_All() {
        this.notifyAll();
    }

    private synchronized void synchWaitCalcs() {
        while (!this.finishedCalculations) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void synchWaitProgramEnded() {
        while (!this.programEnded) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean isCharOKforNumberInput(char key) {
        return Character.isDigit(key) || key == '-' || key == '+' || key == '.' || key == 'E' || key == 'e';
    }

    private boolean quitConfirm(JFrame c) {
        boolean q = true;
        if (!this.doNotStop) {
            Object[] options = new Object[]{"Cancel", "STOP"};
            int n = JOptionPane.showOptionDialog(c, "Do you really want to stop the calculations?", progName, 0, 0, null, options, null);
            boolean bl = q = n == 1;
        }
        if (q) {
            if (this.h != null) {
                this.h.haltaCancel();
            }
            if (this.tsk != null) {
                this.tsk.cancel(true);
            }
            this.finishedCalculations = true;
            this.notify_All();
        }
        return q;
    }

    private void showTheInputFileName(File dataFile) {
        this.showTemperature();
        this.jTextFieldDataFile.setText(dataFile.getPath());
        this.jLabelPltFile.setEnabled(true);
        this.jLabelPltFile.setText("<html>p<u>l</u>ot file name:</html>");
        this.jTextFieldPltFile.setEnabled(true);
        this.jMenuFileMakeD.setEnabled(true);
        this.jButtonDoIt.setEnabled(true);
        this.jButtonDoIt.setText("<html>make the <u>D</u>iagram</html>");
        this.jButtonDoIt.requestFocusInWindow();
    }

    private void setPathDef(File f) {
        URI uri;
        if (this.pathDef == null) {
            this.pathDef = new StringBuffer();
        }
        if (f != null) {
            if (!f.getPath().contains(SLASH) && this.pathDef.length() > 0) {
                return;
            }
            try {
                uri = f.toURI();
            }
            catch (Exception ex) {
                uri = null;
            }
        } else {
            uri = null;
        }
        if (this.pathDef.length() > 0) {
            this.pathDef.delete(0, this.pathDef.length());
        }
        if (uri != null) {
            if (f != null && f.isDirectory()) {
                this.pathDef.append(new File(uri.getPath()).toString());
            } else {
                this.pathDef.append(new File(uri.getPath()).getParent().toString());
            }
        } else {
            File currDir = new File("");
            try {
                this.pathDef.append(currDir.getCanonicalPath());
            }
            catch (IOException e) {
                try {
                    this.pathDef.append(System.getProperty("user.dir"));
                }
                catch (Exception e1) {
                    this.pathDef.append(".");
                }
            }
        }
    }

    private void setPathDef(String fName) {
        File f = new File(fName);
        this.setPathDef(f);
    }

    private void setPathDef() {
        String t = System.getProperty("user.home");
        this.setPathDef(t);
    }

    public static String millisToShortDHMS(long duration) {
        int millis = (int)(duration % 1000L);
        int seconds = (int)((duration /= 1000L) % 60L);
        int minutes = (int)((duration /= 60L) % 60L);
        int hours = (int)((duration /= 60L) % 24L);
        int days = (int)(duration / 24L);
        String res = days == 0 ? String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, millis) : String.format("%dd%02d:%02d:%02d", days, hours, minutes, seconds);
        return res;
    }

    private void setCursorWait() {
        this.setCursor(new Cursor(3));
        this.jTextAreaA.setCursor(new Cursor(3));
    }

    private void setCursorDef() {
        this.setCursor(new Cursor(0));
        this.jTextAreaA.setCursor(new Cursor(0));
    }

    private void getTheInputFileName() {
        this.jTextFieldDataFile.setCursor(new Cursor(3));
        this.setCursorWait();
        if (this.pathDef == null) {
            this.setPathDef();
        }
        this.fc.setMultiSelectionEnabled(false);
        this.fc.setCurrentDirectory(new File(this.pathDef.toString()));
        this.fc.setDialogTitle("Select a data file:");
        this.fc.setFileSelectionMode(0);
        this.fc.setAcceptAllFileFilterUsed(true);
        LookAndFeel defLaF = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.fc.updateUI();
        this.jTextFieldDataFile.setCursor(new Cursor(0));
        this.setCursorDef();
        this.fc.setFileFilter(this.filterDat);
        int returnVal = this.fc.showOpenDialog(this);
        try {
            UIManager.setLookAndFeel(defLaF);
        }
        catch (UnsupportedLookAndFeelException ex) {
            // empty catch block
        }
        Util.configureOptionPane();
        if (returnVal == 0) {
            if (this.eraseTextArea) {
                this.jTextAreaA.selectAll();
                this.jTextAreaA.replaceRange("", 0, this.jTextAreaA.getSelectionEnd());
            }
            this.inputDataFile = this.fc.getSelectedFile();
            this.setPathDef(this.fc.getCurrentDirectory());
            if (this.readDataFile(this.inputDataFile)) {
                this.showTheInputFileName(this.inputDataFile);
                this.outputPltFile = null;
                String txt = this.inputDataFile.getName();
                String plotFileN = txt.substring(0, txt.length() - 3).concat("plt");
                this.jTextFieldPltFile.setText(plotFileN);
                this.jTabbedPane.setSelectedComponent(this.jPanelParameters);
                this.jTabbedPane.setTitleAt(2, "Diagram");
                this.jTabbedPane.setEnabledAt(2, false);
                this.jMenuFileOpen.setEnabled(true);
                this.jMenuFileMakeD.setEnabled(true);
                this.jButtonDoIt.setEnabled(true);
                this.jButtonDoIt.setText("<html>make the <u>D</u>iagram</html>");
                this.jButtonDoIt.requestFocusInWindow();
            } else {
                return;
            }
        }
        this.jTabbedPane.setSelectedComponent(this.jPanelParameters);
        this.jTabbedPane.requestFocusInWindow();
        this.jButtonDoIt.requestFocusInWindow();
        this.jCheckReverse.setText("allow Reversed min. and max. axes limits");
        this.jCheckReverse.setEnabled(false);
    }

    private void paintDiagrPanel(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        if (this.dd != null) {
            this.diagrPaintUtil.paintDiagram(g2D, this.jPanelDiagram.getSize(), this.dd, false);
        }
    }

    private static void printInstructions(PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        out.flush();
        out.println("Possible commands are:" + nl + "  -d=data-file-name  (input file name)" + nl + "  -dbg     (output debug information)" + nl + "  -dbgH=n  (output level for debug from HaltaFall)" + nl + "  -h=nbr   (height factor for labels in the plot)" + nl + "  -i=nbr   (ionic strength: the equil. constants are" + nl + "            assumed for I=0. Requires a temperature." + nl + "            Enter \"-i=-1\" to calculate I at each point)" + nl + "  -keep    (window open to see the diagram after the calculations)" + nl + "  -m=nbr   (model to calculate activity coefficients:" + nl + "            0 = Davies eqn; 1 = SIT; 2 = simplified HKF; default is 2)" + nl + "  -n=nbr   (calculation steps along the X-axis; " + 4 + " to " + 300 + ")" + nl + "  -nostop  (do not stop for warnings)" + nl + "  -p=output-plot-file-name" + nl + "  -rev     (do not reverse the input min. and max. limits in x-axis)" + nl + "  -t=nbr   (temperature in degrees C, ignored if not needed)" + nl + "  -tbl     (output both a diagram and a table file with comma-" + nl + "            separated values and extension \"csv\")" + nl + "  -tbls=;  (character(s) to separate fields in the output table file;" + nl + "            for example comma(,) semicolon(;) or tab (\\t))" + nl + "  -tble=csv (name extension for output table file)" + nl + "  -tblcs=\"  (character(s) to insert at the start of comment lines)" + nl + "  -tblce=\"  (character(s) to append to the end of comment lines)" + nl + "  -tol=nbr (tolerance when solving mass-balance equations in Haltafall," + nl + "            0.01 >= nbr >= 1e-8)" + nl + "  -thr=nbr (threshold to display curves in a fraction diagram," + nl + "            0.001 to 0.1 (equivalent to 0.1 ro 10%); ignored if not needed)" + nl + "Enclose file names with double quotes (\"\") it they contain blank space." + nl + "Example:   java -jar SED.jar \"/d=Fe 25\" -t:25 -i=-1 \"-p:plt\\Fe 25\" -n=200");
    }

    private boolean readDataFile(File dataFile) {
        double w;
        if (this.dbg) {
            this.out.println("--- readDataFile(" + dataFile.getAbsolutePath() + ")");
        }
        if (!dataFile.getName().toLowerCase().endsWith(".dat")) {
            String msg = "File: \"" + dataFile.getName() + "\"" + nl + "Error: data file name must end with \".dat\"";
            this.showErrMsgBx(msg, 1);
            return false;
        }
        if (dataFile.getName().length() <= 4) {
            String msg = "File: \"" + dataFile.getName() + "\"" + nl + "Error: file name must have at least one character";
            this.showErrMsgBx(msg, 1);
            return false;
        }
        String dataFileN = null;
        try {
            dataFileN = dataFile.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (dataFileN == null) {
            try {
                dataFileN = dataFile.getAbsolutePath();
            }
            catch (Exception ex) {
                dataFileN = dataFile.getPath();
            }
        }
        dataFile = new File(dataFileN);
        try {
            this.rd = new ReadDataLib(dataFile);
        }
        catch (ReadDataLib.DataFileException ex) {
            this.showErrMsgBx(ex.getMessage(), 1);
            if (this.rd != null) {
                try {
                    this.rd.close();
                }
                catch (ReadDataLib.ReadDataLibException ex2) {
                    this.showErrMsgBx(ex2);
                }
            }
            return false;
        }
        String msg = LINE + nl + "Reading input data file \"" + dataFile + "\"";
        this.out.println(msg);
        if (this.consoleOutput) {
            System.out.println(msg);
        }
        boolean warn = false;
        try {
            this.ch = null;
            this.ch = ReadChemSyst.readChemSystAndPlotInfo(this.rd, this.dbg, warn, this.out);
        }
        catch (ReadChemSyst.ConcDataException ex) {
            this.ch = null;
            this.showErrMsgBx(ex.getMessage(), 1);
        }
        catch (ReadChemSyst.DataLimitsException ex) {
            this.ch = null;
            this.showErrMsgBx(ex.getMessage(), 1);
        }
        catch (ReadChemSyst.PlotDataException ex) {
            this.ch = null;
            this.showErrMsgBx(ex.getMessage(), 1);
        }
        catch (ReadChemSyst.ReadDataFileException ex) {
            this.ch = null;
            this.showErrMsgBx(ex.getMessage(), 1);
        }
        if (this.ch == null) {
            msg = "Error while reading data file \"" + dataFile.getName() + "\"";
            this.showMsg(msg, 1);
            try {
                this.rd.close();
            }
            catch (ReadDataLib.ReadDataLibException ex) {
                this.showMsg(ex);
            }
            this.readDataFile_hadError();
            return false;
        }
        if (this.ch.diag.plotType <= 0 || this.ch.diag.plotType > 8) {
            msg = "Error: data file \"" + dataFile.getName() + "\"" + nl;
            msg = this.ch.diag.plotType == 0 ? msg + "contains information for a Predominance Area Diagram." + nl + "Run program PREDOM instead." : msg + "contains erroneous plot information.";
            this.showErrMsgBx(msg, 1);
            try {
                this.rd.close();
            }
            catch (ReadDataLib.ReadDataLibException ex) {
                this.showMsg(ex);
            }
            this.readDataFile_hadError();
            return false;
        }
        try {
            w = this.rd.getTemperature();
        }
        catch (ReadDataLib.DataReadException ex) {
            this.showErrMsgBx(ex);
            w = Double.NaN;
        }
        if (!Double.isNaN(w)) {
            double t_d = w;
            if (!Double.isNaN(this.temperature_InCommandLine) && Math.abs(t_d - this.temperature_InCommandLine) > 0.001) {
                msg = String.format(engl, "Warning: temperature in data file =%6.2f,%s", t_d, nl);
                msg = msg + String.format(engl, "   but in the command line t=%6.2f!%s", this.temperature_InCommandLine, nl);
                msg = msg + String.format(engl, "t=%6.2f will be used.", this.temperature_InCommandLine);
                this.showErrMsgBx(msg, 2);
                t_d = this.temperature_InCommandLine;
            }
            this.jTextFieldT.setText(String.valueOf(t_d));
        }
        try {
            this.rd.close();
        }
        catch (ReadDataLib.ReadDataLibException ex) {
            this.showMsg(ex);
        }
        msg = "Finished reading the input data file.";
        this.out.println(msg);
        if (this.consoleOutput) {
            System.out.println(msg);
        }
        this.cs = this.ch.chemSystem;
        this.csC = this.cs.chemConcs;
        this.namn = this.cs.namn;
        this.dgrC = this.ch.diagrConcs;
        this.diag = this.ch.diag;
        for (int j = 0; j < this.cs.Na; ++j) {
            this.csC.kh[j] = this.dgrC.hur[j] > 3 ? 2 : 1;
        }
        if (!this.checkInput()) {
            this.ch = null;
            this.cs = null;
            this.csC = null;
            this.namn = null;
            this.dgrC = null;
            this.diag = null;
            this.readDataFile_hadError();
            return false;
        }
        if (this.cs.jWater >= 0 && this.dbg) {
            this.out.println("Water (H2O) is included: all concentrations are in \"mol/(1 kg H2O)\".");
        }
        return true;
    }

    private void showTemperature() {
        if (!(this.jCheckActCoeff.isEnabled() && (this.calcActCoeffs && this.ionicStrength != 0.0 || this.diag != null && (this.diag == null || this.diag.pInX == 3 || this.diag.Eh)))) {
            this.jLabelT.setText("Temperature");
            this.jLabelT.setEnabled(false);
            this.jLabelTC.setEnabled(false);
            this.jTextFieldT.setEnabled(false);
        } else {
            this.jLabelT.setText("<html><u>T</u>emperature</html>");
            this.jLabelT.setEnabled(true);
            this.jLabelTC.setEnabled(true);
            this.jTextFieldT.setEnabled(true);
        }
    }

    private void validateIonicStrength() {
        if (this.jTextFieldIonicStgr.getText().length() <= 0) {
            return;
        }
        try {
            this.ionicStrength = this.readIonStrength();
            this.ionicStrength = Math.min(1000.0, Math.max(this.ionicStrength, -1000.0));
            if (this.ionicStrength < 0.0) {
                this.ionicStrength = -1.0;
            }
            this.jTextFieldIonicStgr.setText(String.valueOf(this.ionicStrength));
            this.showTemperature();
        }
        catch (NumberFormatException nfe) {
            String msg = "Wrong numeric format" + nl + nl + "Please enter a floating point number.";
            this.showErrMsgBx(msg, 1);
            this.jTextFieldIonicStgr.setText(String.valueOf(this.ionicStrength));
            this.jTextFieldIonicStgr.requestFocusInWindow();
        }
    }

    private void validateTemperature() {
        if (this.jTextFieldT.getText().length() <= 0) {
            return;
        }
        double t = this.readTemperature();
        this.jTextFieldT.setText(String.valueOf(t));
    }

    private double readIonStrength() {
        double w;
        if (this.jTextFieldIonicStgr.getText().length() <= 0) {
            return 0.0;
        }
        try {
            w = Double.parseDouble(this.jTextFieldIonicStgr.getText());
            w = Math.min(1000.0, Math.max(w, -1.0));
            if (w < 0.0) {
                w = -1.0;
            }
        }
        catch (NumberFormatException nfe) {
            this.out.println("Error reading Ionic Strength:" + nl + "   " + nfe.toString());
            w = 0.0;
        }
        return w;
    }

    private double readTemperature() {
        double w;
        if (this.jTextFieldT.getText().length() <= 0) {
            return 25.0;
        }
        try {
            w = Double.parseDouble(this.jTextFieldT.getText());
            w = Math.min(1000.0, Math.max(w, -50.0));
        }
        catch (NumberFormatException nfe) {
            this.out.println("Error reading Temperature:" + nl + "   " + nfe.toString());
            w = 25.0;
        }
        return w;
    }

    void showErrMsgBx(String msg, int type) {
        if (msg == null || msg.trim().length() <= 0) {
            return;
        }
        this.showMsg(msg, type);
        if (!this.doNotStop) {
            if (sedFrame == null) {
                Main.ErrMsgBx mb = new Main.ErrMsgBx(msg, progName);
            } else {
                int j = type <= 1 ? 0 : (type == 2 ? 1 : 2);
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
                JOptionPane.showMessageDialog(this, msg, progName, j);
            }
        }
    }

    void showErrMsgBx(Exception ex) {
        if (ex == null) {
            return;
        }
        this.showMsg(ex);
        String msg = ex.toString();
        if (!this.doNotStop) {
            if (sedFrame == null) {
                Main.ErrMsgBx mb = new Main.ErrMsgBx(msg, progName);
            } else {
                int j = 0;
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
                JOptionPane.showMessageDialog(this, msg, progName, j);
            }
        }
    }

    void showMsg(String msg, int type) {
        if (msg == null || msg.trim().length() <= 0) {
            return;
        }
        String flag = type == 2 ? "Warning" : (type == 3 ? "Message" : "Error");
        if (type == 1 || type == 2 || type == 3) {
            this.out.println("- - - - " + flag + ":" + nl + msg + nl + "- - - -");
            System.out.println("- - - - " + flag + ":" + nl + msg + nl + "- - - -");
            this.out.flush();
            System.out.flush();
        } else {
            this.err.println("- - - - " + flag + ":" + nl + msg + nl + "- - - -");
            System.err.println("- - - - " + flag + ":" + nl + msg + nl + "- - - -");
            this.err.flush();
            System.err.flush();
        }
    }

    void showMsg(Exception ex) {
        if (ex == null) {
            return;
        }
        String msg = "- - - - Error:" + nl + ex.toString() + nl + nl + Util.stack2string(ex) + nl + "- - - -";
        this.err.println(msg);
        System.err.println(msg);
        this.err.flush();
        System.err.flush();
    }

    private void doCalculations() {
        int n;
        int j;
        String msg;
        this.setCursorWait();
        if (this.dbg) {
            this.out.println("--- doCalculations()");
        }
        this.jLabelStatus.setText("Starting the calculations");
        this.jLabelProgress.setText(" ");
        this.disableMenus();
        this.diag.fractionThreshold = this.threshold;
        this.diag.temperature = this.readTemperature();
        if (this.diag.Eh || this.diag.pInX == 3) {
            this.peEh = this.ln10 * 8.3144126 * (this.diag.temperature + 273.15) / 96484.56;
        }
        if (!this.dbg) {
            this.nSteps = Math.max(4, this.nSteps);
            this.nSteps = this.jScrollBarNbrPoints.getValue();
        }
        int nSteps1 = this.nSteps + 1;
        this.jLabelNbrPText.setText("Nbr of calc. steps:");
        this.jScrollBarNbrPoints.setEnabled(false);
        this.jLabelNbrPText.setEnabled(false);
        if (this.dbg) {
            this.out.println(" " + nSteps1 + " caculation points" + nl + "ionic strength = " + this.ionicStrength + nl + "temperature = " + (float)this.diag.temperature + nl + "max relative mass-balance tolerance = " + (float)this.tolHalta);
        }
        this.plot = new Plot(this, this.err, this.out);
        this.plot.preparePlot(this.ch);
        this.diag.ionicStrength = this.ionicStrength;
        if (!this.diag.aquSystem && this.diag.ionicStrength != 0.0) {
            msg = "Warning: This does not appear to be an aqueous system," + nl + "and yet you give a value for the ionic strength?";
            this.showErrMsgBx(msg, 2);
        }
        if (this.calcActCoeffs) {
            this.diag.activityCoeffsModel = this.jComboBoxModel.getSelectedIndex();
            this.diag.activityCoeffsModel = Math.min(this.jComboBoxModel.getItemCount() - 1, Math.max(0, this.diag.activityCoeffsModel));
            this.csC.actCoefCalc = true;
        } else {
            this.diag.activityCoeffsModel = -1;
            this.csC.actCoefCalc = false;
        }
        this.tHeight = this.jScrollBarHeight.getValue() / 10;
        this.tHeight = Math.min(10.0, Math.max(this.tHeight, 0.3));
        if (this.tableOutput) {
            this.table = new Table(this, this.err, this.out);
            if (!this.table.tableHeader(this.ch, this.tblExtension)) {
                this.table = null;
                this.tableOutput = false;
            }
        }
        this.calculationStart = System.nanoTime();
        this.bt = new double[this.cs.Na][nSteps1];
        for (j = 0; j < this.cs.Na; ++j) {
            int n2;
            if (this.dgrC.hur[j] == 1 || this.dgrC.hur[j] == 4) {
                for (n = 0; n < this.bt[0].length; ++n) {
                    this.bt[j][n] = this.dgrC.cLow[j];
                }
                continue;
            }
            double stepX = (this.dgrC.cHigh[j] - this.dgrC.cLow[j]) / (double)this.nSteps;
            this.bt[j][0] = this.dgrC.cLow[j];
            for (n2 = 1; n2 < this.bt[0].length - 1; ++n2) {
                this.bt[j][n2] = this.bt[j][n2 - 1] + stepX;
            }
            this.bt[j][this.nSteps] = this.dgrC.cHigh[j];
            if (this.dgrC.hur[j] != 3) continue;
            for (n2 = 0; n2 < this.bt[0].length; ++n2) {
                this.bt[j][n2] = Math.exp(this.ln10 * this.bt[j][n2]);
            }
        }
        for (j = 0; j < this.cs.Na; ++j) {
            if (this.csC.kh[j] == 2 || this.pos[j] && this.neg[j] || !this.pos[j] && !this.neg[j] || this.dgrC.hur[j] == 3 || this.dgrC.cLow[j] != 0.0 || !Double.isNaN(this.dgrC.cHigh[j]) && this.dgrC.cHigh[j] != 0.0) continue;
            for (n = 0; n < this.bt[0].length; ++n) {
                this.bt[j][n] = -9999.0;
            }
            this.csC.kh[j] = 2;
            if (!this.dbg) continue;
            this.out.println("Can not calculate mass-balance for for component \"" + this.namn.identC[j] + "\"" + nl + "   its log(activity) will be set to -9999.");
        }
        msg = "Starting the calculations...";
        this.out.println(msg);
        if (this.consoleOutput) {
            System.out.println(msg);
        }
        String userHome = System.getProperty("user.home");
        this.factor = new Factor(this.ch, pathApp, userHome, this.pathDef.toString(), this.out);
        this.out.flush();
        try {
            this.factor.factorPrint(this.dbg);
        }
        catch (Factor.SITdataException ex) {
            this.showErrMsgBx(ex.getMessage(), 1);
            this.factor = null;
        }
        catch (Interpolate.RationalInterpolationException ex) {
            this.showErrMsgBx(ex);
            this.factor = null;
        }
        catch (ReadDataLib.ReadDataLibException ex) {
            this.showErrMsgBx(ex.getMessage(), 1);
            this.factor = null;
        }
        if (this.factor == null) {
            this.restoreMenus();
            this.setCursorDef();
            return;
        }
        this.csC.dbg = this.dbgHalta;
        this.csC.cont = false;
        for (j = 0; j < this.cs.Na; ++j) {
            this.csC.tol = this.tolHalta;
            if (this.csC.kh[j] == 1) {
                this.csC.tot[j] = this.bt[j][0];
                this.csC.logA[j] = -10.0;
                if (!(this.csC.tot[j] > 0.0)) continue;
                this.csC.logA[j] = Math.log10(this.csC.tot[j]) - 3.0;
                continue;
            }
            this.csC.logA[j] = this.bt[j][0];
        }
        this.jLabelStatus.setText("Please wait --");
        this.finishedCalculations = false;
        this.tsk = new HaltaTask();
        this.tsk.execute();
    }

    public static void main(final String[] args) {
        System.out.println(LINE + nl + progName + " (Simple Equilibrium Diagrams),  version: " + VERS);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        Util.configureOptionPane();
        if (args.length <= 0) {
            System.out.println("Usage:   SED  [-command=value]" + nl + "For a list of possible commands type:  SED  -?");
        }
        pathApp = Main.getPathApp();
        boolean ok = true;
        String errMsg = "SED construction did not complete successfully" + nl;
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    boolean doNotExit0 = false;
                    boolean doNotStop0 = false;
                    boolean dbg0 = false;
                    boolean rev0 = false;
                    boolean h = false;
                    if (args.length > 0) {
                        for (String arg : args) {
                            if (arg.equalsIgnoreCase("-dbg") || arg.equalsIgnoreCase("/dbg")) {
                                dbg0 = true;
                                continue;
                            }
                            if (arg.equalsIgnoreCase("-keep") || arg.equalsIgnoreCase("/keep")) {
                                doNotExit0 = true;
                                continue;
                            }
                            if (arg.equalsIgnoreCase("-nostop") || arg.equalsIgnoreCase("/nostop")) {
                                doNotStop0 = true;
                                continue;
                            }
                            if (arg.equalsIgnoreCase("-rev") || arg.equalsIgnoreCase("/rev")) {
                                rev0 = true;
                                continue;
                            }
                            if (!arg.equals("-?") && !arg.equals("/?") && !arg.equals("?")) continue;
                            h = true;
                            SED.printInstructions(System.out);
                        }
                        if (h && !doNotExit0) {
                            return;
                        }
                    }
                    sedFrame = new SED(doNotExit0, doNotStop0, dbg0);
                    sedFrame.start(rev0, h, args);
                }
            });
        }
        catch (InterruptedException ex) {
            ok = false;
            errMsg = errMsg + Util.stack2string(ex);
        }
        catch (InvocationTargetException ex) {
            ok = false;
            errMsg = errMsg + Util.stack2string(ex);
        }
        if (!ok) {
            System.err.println(errMsg);
            Main.ErrMsgBx mb = new Main.ErrMsgBx(errMsg, progName);
        }
        if (sedFrame != null) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    if (sedFrame.inputDataFileInCommandLine) {
                        sedFrame.synchWaitCalcs();
                        if (!sedFrame.doNotExit) {
                            sedFrame.end_program();
                        } else {
                            sedFrame.synchWaitProgramEnded();
                        }
                    } else {
                        sedFrame.synchWaitProgramEnded();
                    }
                }
            };
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (SED.sedFrame.dbg) {
                System.out.println("SED - finished.");
            }
        }
    }

    static {
        nl = System.getProperty("line.separator");
        engl = Locale.ENGLISH;
        SLASH = File.separator;
    }

    public class HaltaTask
    extends SwingWorker<Boolean, Integer> {
        private boolean getHaltaInstanceOK = true;
        private boolean haltaError = false;
        private int nbrTooLargeConcs = 0;
        private int nbrHaltaErrors = 0;
        private int nbrHaltaUncertain = 0;
        private final StringBuilder failuresMsg = new StringBuilder();

        @Override
        protected Boolean doInBackground() throws Exception {
            SED.this.h = null;
            try {
                SED.this.h = new HaltaFall(SED.this.cs, SED.this.factor, SED.this.out);
            }
            catch (Chem.ChemicalParameterException ex) {
                SED.this.showErrMsgBx(ex);
                this.getHaltaInstanceOK = false;
            }
            if (!this.getHaltaInstanceOK) {
                this.cancel(true);
                return false;
            }
            String f = "Calculation failed in \"HaltaFall.haltaCalc\" at point=%d, x=%7.5f" + nl + "%s";
            SED.this.nStepX = -1;
            do {
                int nStepX1;
                block15: {
                    SED.this.nStepX++;
                    nStepX1 = SED.this.nStepX + 1;
                    this.publish(nStepX1);
                    ((SED)SED.this).csC.dbg = SED.this.nStepX <= 0 ? SED.this.dbgHalta : 1;
                    if (SED.this.dbg || ((SED)SED.this).csC.dbg > 1) {
                        SED.this.out.println("Starting calculation point: " + nStepX1 + " (of " + (SED.this.nSteps + 1) + "), x=" + (float)SED.this.bt[((SED)SED.this).diag.compX][SED.this.nStepX]);
                    }
                    for (int j = 0; j < ((SED)SED.this).cs.Na; ++j) {
                        if (((SED)SED.this).dgrC.hur[j] <= 1 || ((SED)SED.this).dgrC.hur[j] == 4) continue;
                        if (((SED)SED.this).csC.kh[j] == 1) {
                            ((SED)SED.this).csC.tot[j] = SED.this.bt[j][SED.this.nStepX];
                            continue;
                        }
                        ((SED)SED.this).csC.logA[j] = SED.this.bt[j][SED.this.nStepX];
                    }
                    try {
                        SED.this.h.haltaCalc();
                        if (!SED.this.csC.isErrFlagsSet(3)) break block15;
                        ((SED)SED.this).csC.cont = false;
                        SED.this.h.haltaCalc();
                    }
                    catch (Chem.ChemicalParameterException ex) {
                        String ms = "Error in \"HaltaFall.haltaCalc\", " + ex.getMessage() + nl + "   at point: " + nStepX1 + "  x=" + SED.this.bt[((SED)SED.this).diag.compX][SED.this.nStepX] + nl + Util.stack2string(ex);
                        SED.this.showErrMsgBx(ms, 1);
                        this.haltaError = true;
                        break;
                    }
                }
                if (SED.this.finishedCalculations) break;
                SED.this.out.flush();
                if (SED.this.csC.isErrFlagsSet(5)) {
                    ++this.nbrTooLargeConcs;
                } else if (SED.this.csC.isErrFlagsSet(1)) {
                    ++this.nbrHaltaUncertain;
                }
                if (SED.this.csC.isErrFlagsSet(2) || SED.this.csC.isErrFlagsSet(3) || SED.this.csC.isErrFlagsSet(4) || SED.this.csC.isErrFlagsSet(6)) {
                    ++this.nbrHaltaErrors;
                    if (this.failuresMsg.length() > 0) {
                        this.failuresMsg.append(nl);
                    }
                    this.failuresMsg.append(String.format(engl, f, nStepX1, Float.valueOf((float)SED.this.bt[((SED)SED.this).diag.compX][SED.this.nStepX]), SED.this.csC.errFlagsGetMessages()));
                }
                if (SED.this.dbg) {
                    SED.this.h.printConcs();
                    SED.this.factor.printActivityCoeffs(SED.this.out);
                }
                if (SED.this.finishedCalculations) break;
                SED.this.plot.storePlotData(SED.this.nStepX, SED.this.ch);
            } while (SED.this.nStepX < SED.this.nSteps);
            return true;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                if (SED.this.dbg) {
                    System.out.println("SwingWorker cancelled.");
                }
            } else {
                if (!this.haltaError) {
                    int percent;
                    SED.this.calculationTime = (System.nanoTime() - SED.this.calculationStart) / 1000000L;
                    String msg = "--- Calculated " + (SED.this.nStepX + 1) + " points, time=" + SED.millisToShortDHMS(SED.this.calculationTime);
                    SED.this.out.println(msg);
                    System.out.println(msg);
                    if (this.nbrTooLargeConcs > 0 && (percent = this.nbrTooLargeConcs * 100 / (SED.this.nSteps + 1)) > 0) {
                        msg = percent + " % of the calculated points had some" + nl + "concentrations > 50 (molal); impossible in reality." + nl + nl;
                        msg = SED.this.calcActCoeffs ? msg + "The activity coefficients are then WRONG" + nl + "and the results unrealistic." : msg + "These results are unrealistic.";
                        SED.this.showErrMsgBx(msg, 1);
                    }
                    msg = "";
                    if (this.nbrHaltaErrors > 0) {
                        msg = String.format("%d", this.nbrHaltaErrors).trim() + " calculation failure(s)";
                    }
                    if (this.nbrHaltaUncertain > 1) {
                        if (msg.length() > 0) {
                            msg = msg + ", ";
                        }
                        msg = msg + String.format("%d", this.nbrHaltaUncertain).trim() + " uncertain point(s)";
                    }
                    if (this.failuresMsg != null && this.failuresMsg.length() > 0) {
                        SED.this.out.println(this.failuresMsg);
                    }
                    if (msg.length() > 0) {
                        SED.this.showErrMsgBx(msg, 1);
                    }
                    SED.this.plot.drawPlot(SED.this.outputPltFile, SED.this.ch);
                    if (SED.this.outputPltFile != null && SED.this.outputPltFile.getName().length() > 0) {
                        String msg3 = "Saved plot file: \"" + SED.this.outputPltFile.getAbsolutePath() + "\"";
                        SED.this.out.println(msg3);
                        System.out.println(msg3);
                    }
                    if (SED.this.table != null) {
                        SED.this.table.tableBody(SED.this.ch);
                    }
                }
                if (this.getHaltaInstanceOK && !this.haltaError) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SED.this.jTabbedPane.setTitleAt(2, "<html><u>D</u>iagram</html>");
                            SED.this.jTabbedPane.setEnabledAt(2, true);
                            SED.this.jTabbedPane.setSelectedComponent(SED.this.jPanelDiagram);
                            SED.this.jTabbedPane.requestFocusInWindow();
                            SED.this.restoreMenus();
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SED.this.jTabbedPane.setSelectedComponent(SED.this.jScrollPaneMessg);
                            SED.this.jTabbedPane.requestFocusInWindow();
                            SED.this.restoreMenus();
                        }
                    });
                }
                if (SED.this.dbg) {
                    System.out.println("SwingWorker done.");
                }
            }
            SED.this.out.println(SED.LINE);
            System.out.println(SED.LINE);
            SED.this.finishedCalculations = true;
            sedFrame.notify_All();
            SED.this.setCursorDef();
        }

        @Override
        protected void process(List<Integer> chunks) {
            final int i = chunks.get(chunks.size() - 1);
            int nn = (int)Math.floor(Math.log10(SED.this.nSteps + 1)) + 1;
            final String f = "now calculating loop: %" + String.format("%3d", nn).trim() + "d (out of %" + String.format("%3d", nn).trim() + "d)";
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SED.this.jLabelProgress.setText(String.format(f, i, SED.this.nSteps + 1));
                }
            });
        }
    }

    private class outFilteredStreamSED
    extends FilterOutputStream {
        public outFilteredStreamSED(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
            String aString = new String(b);
            SED.this.jTabbedPane.setTitleAt(1, "<html><u>M</u>essages</html>");
            SED.this.jTabbedPane.setEnabledAt(1, true);
            SED.this.jTextAreaA.append(aString);
            SED.this.jTextAreaA.setSelectionStart(Integer.MAX_VALUE);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            SED.this.jTabbedPane.setTitleAt(1, "<html><u>M</u>essages</html>");
            SED.this.jTabbedPane.setEnabledAt(1, true);
            SED.this.jTextAreaA.append(aString);
            SED.this.jTextAreaA.setSelectionStart(Integer.MAX_VALUE);
        }
    }

    private class errFilteredStreamSED
    extends FilterOutputStream {
        public errFilteredStreamSED(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
            String aString = new String(b);
            SED.this.jTabbedPane.setTitleAt(1, "<html><u>M</u>essages</html>");
            SED.this.jTabbedPane.setEnabledAt(1, true);
            SED.this.jTabbedPane.setSelectedComponent(SED.this.jScrollPaneMessg);
            SED.this.jTextAreaA.append(aString);
            SED.this.jTextAreaA.setSelectionStart(Integer.MAX_VALUE);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            SED.this.jTabbedPane.setTitleAt(1, "<html><u>M</u>essages</html>");
            SED.this.jTabbedPane.setEnabledAt(1, true);
            SED.this.jTabbedPane.setSelectedComponent(SED.this.jScrollPaneMessg);
            SED.this.jTextAreaA.append(aString);
            SED.this.jTextAreaA.setSelectionStart(Integer.MAX_VALUE);
        }
    }
}

