/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.FrameDBmain;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class OneInstance {
    private static OneInstance one = null;
    private static final String knockKnock = "Ett skepp kommer lastad";
    private boolean dbg;
    private String progName;
    private int port;
    private ServerSocket serverSocket = null;
    private Socket socket;
    private BufferedReader socketIn;
    private PrintWriter socketOut;
    private String whosThere;
    private static final String nl = System.getProperty("line.separator");

    public boolean findOtherInstance(String[] args, int portDef, String prgName, boolean debg) {
        if (one != null) {
            String msg = prgName != null && prgName.trim().length() > 0 ? prgName : "OneInstance";
            if (debg) {
                System.out.println(msg + "- findOtherInstance already running.");
            }
            return false;
        }
        one = this;
        this.dbg = debg;
        this.progName = prgName != null && prgName.trim().length() > 0 ? prgName : "OneInstance";
        this.whosThere = this.progName;
        this.port = portDef;
        int portNbrMax = portDef + 5;
        InetAddress address = null;
        do {
            try {
                this.serverSocket = new ServerSocket(this.port);
                if (this.dbg) {
                    System.out.println(this.progName + "- socket " + this.port + " is not used.");
                }
                this.serverSocket.close();
                this.serverSocket = null;
                ++this.port;
            }
            catch (BindException ex) {
                if (this.dbg) {
                    System.out.println(this.progName + "- socket " + this.port + " busy. Another instance already running?");
                }
                if (address == null) {
                    try {
                        address = InetAddress.getLocalHost();
                        if (this.dbg) {
                            System.out.println(this.progName + "- Local machine address: " + address.toString());
                        }
                    }
                    catch (UnknownHostException e) {
                        System.out.println(this.progName + "- " + e.toString() + "  using getLocalHost().");
                        address = null;
                    }
                }
                if (!this.isOtherInstance(address, this.port)) {
                    if (this.socketOut != null) {
                        this.socketOut.close();
                        this.socketOut = null;
                    }
                    if (this.socketIn != null) {
                        try {
                            this.socketIn.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        this.socketIn = null;
                    }
                    this.socket = null;
                    ++this.port;
                    continue;
                }
                this.sendArgsToOtherInstance(args);
                return true;
            }
            catch (IOException ex) {
                System.err.println(this.progName + "- " + ex.toString() + nl + "   while creating a stream Socket.");
                break;
            }
        } while (this.port < portNbrMax);
        if (this.socketOut != null) {
            this.socketOut.close();
            this.socketOut = null;
        }
        if (this.socketIn != null) {
            try {
                this.socketIn.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.socketIn = null;
        }
        this.socket = null;
        this.port = portDef;
        do {
            try {
                this.serverSocket = new ServerSocket(this.port);
                if (!this.dbg) break;
                System.out.println(this.progName + "- Created server socket on port " + this.port);
                break;
            }
            catch (BindException ex) {
                if (this.dbg) {
                    System.out.println(this.progName + "- socket " + this.port + " is busy.");
                }
                ++this.port;
            }
            catch (IOException ex) {
                System.err.println(this.progName + "- " + ex.toString() + nl + "   while creating a Server Socket.");
                break;
            }
        } while (this.port < portNbrMax);
        if (this.port == portNbrMax) {
            System.out.println(this.progName + "- Error: could not create a server socket.");
            return false;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Socket client;
                    try {
                        if (OneInstance.this.dbg) {
                            System.out.println(OneInstance.this.progName + "- waiting for a connection to serverSocket(" + OneInstance.this.port + ").");
                        }
                        client = OneInstance.this.serverSocket.accept();
                    }
                    catch (SocketException ex) {
                        break;
                    }
                    catch (IOException ex) {
                        System.err.println(OneInstance.this.progName + "- " + ex.toString() + nl + "   Accept failed on server port: " + OneInstance.this.port);
                        break;
                    }
                    if (OneInstance.this.dbg) {
                        System.out.println(OneInstance.this.progName + "- connection made to serverSocket in port " + OneInstance.this.port);
                    }
                    Thread t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            boolean clientNewInstance = false;
                            boolean connected = true;
                            BufferedReader in = null;
                            PrintWriter out = null;
                            try {
                                client.setSoTimeout(3000);
                                in = new BufferedReader(new InputStreamReader(client.getInputStream()));
                                out = new PrintWriter(client.getOutputStream(), true);
                                if (OneInstance.this.dbg) {
                                    System.out.println(OneInstance.this.progName + "- while (connected)");
                                }
                                while (connected) {
                                    String line;
                                    if (OneInstance.this.dbg) {
                                        System.out.println(OneInstance.this.progName + "- (waiting for line from client)");
                                    }
                                    if ((line = in.readLine()) == null) break;
                                    if (OneInstance.this.dbg) {
                                        System.out.println(OneInstance.this.progName + "- got line from client (in port " + OneInstance.this.port + "): " + line);
                                    }
                                    if (line.toLowerCase().equals(OneInstance.knockKnock.toLowerCase())) {
                                        if (FrameDBmain.getInstance() != null) {
                                            FrameDBmain.getInstance().bringToFront();
                                        }
                                        if (OneInstance.this.dbg) {
                                            System.out.println(OneInstance.this.progName + "- sending line to client (at port " + OneInstance.this.port + "): " + OneInstance.this.whosThere);
                                        }
                                        out.println(OneInstance.this.whosThere);
                                        clientNewInstance = true;
                                        continue;
                                    }
                                    if (clientNewInstance) {
                                        if (FrameDBmain.getInstance() == null) continue;
                                        FrameDBmain.getInstance().dispatchArg(line);
                                        continue;
                                    }
                                    if (OneInstance.this.dbg) {
                                        System.err.println(OneInstance.this.progName + "- Warning: got garbage in port " + OneInstance.this.port + " from another application; line = \"" + line + "\"");
                                    }
                                    connected = false;
                                }
                                out.close();
                                out = null;
                                in.close();
                                in = null;
                                client.close();
                            }
                            catch (IOException ioe) {
                                System.err.println(OneInstance.this.progName + "- Note: " + ioe.toString() + nl + "   Closing socket connection in port " + OneInstance.this.port);
                            }
                            finally {
                                if (OneInstance.this.dbg) {
                                    System.out.println(OneInstance.this.progName + "- Connection to serverSocket(" + OneInstance.this.port + ") closed ");
                                }
                                if (out != null) {
                                    out.close();
                                }
                                try {
                                    if (in != null) {
                                        in.close();
                                    }
                                    client.close();
                                }
                                catch (IOException ioe) {}
                            }
                        }
                    };
                    t.start();
                }
            }
        };
        t.start();
        return false;
    }

    private boolean isOtherInstance(InetAddress address, int port) {
        boolean ok;
        if (port <= 0) {
            return false;
        }
        if (this.dbg) {
            System.out.println(this.progName + "- isOtherInstance(" + port + ") ?");
        }
        try {
            String line;
            this.socket = new Socket(address, port);
            this.socket.setSoTimeout(1000);
            this.socketOut = new PrintWriter(this.socket.getOutputStream(), true);
            this.socketIn = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            if (this.dbg) {
                System.out.println(this.progName + "- Sending text:\"" + knockKnock + "\" to port " + port);
            }
            this.socketOut.println(knockKnock);
            if (this.dbg) {
                System.out.println(this.progName + "- Reading answer from socket " + port);
            }
            try {
                line = this.socketIn.readLine();
                if (this.dbg) {
                    System.out.println(this.progName + "- Text received: \"" + line + "\" from port " + port);
                }
            }
            catch (IOException ex) {
                line = null;
                System.err.println(this.progName + "- Note: " + ex.toString() + nl + "    in socket(" + port + ").readLine()");
            }
            if (line != null && line.toLowerCase().startsWith(this.whosThere.toLowerCase())) {
                if (this.dbg) {
                    System.out.println(this.progName + "- isOtherInstance(" + port + ") = true");
                }
                ok = true;
            } else {
                if (this.dbg) {
                    System.out.println(this.progName + "- isOtherInstance(" + port + ") = false");
                }
                ok = false;
            }
        }
        catch (IOException ex) {
            System.out.println(this.progName + "- " + ex.toString() + ", isOtherInstance(" + port + ") = false");
            ok = false;
        }
        return ok;
    }

    private void sendArgsToOtherInstance(String[] args) {
        if (this.socketOut == null) {
            return;
        }
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if (this.dbg) {
                    System.out.println(this.progName + "- sending command-line arg to other instance: \"" + arg + "\"");
                }
                this.socketOut.println(arg);
            }
        }
        try {
            if (this.socketIn != null) {
                this.socketIn.close();
                this.socketIn = null;
            }
            if (this.socketOut != null) {
                this.socketOut.close();
                this.socketOut = null;
            }
            this.socket = null;
        }
        catch (IOException ex) {
            System.out.println(this.progName + "- " + ex.toString() + ", while closing streams.");
        }
    }

    public static OneInstance getInstance() {
        return one;
    }

    public static void endCheckOtherInstances() {
        if (one != null) {
            try {
                OneInstance.one.serverSocket.close();
                OneInstance.one.serverSocket = null;
                one = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

